/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.cancel;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.CancelTripRS;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.OrderStatus;
import java.math.BigDecimal;

public class CancelTripRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        CancelTripRS response = (CancelTripRS)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_RESPONSE);
        Integer returnedPrice = response.getResult().getPrice();
        OrderStatus orderStatus = response.getResult().getStatus();
        BookingHelper.getProductsStream((BookingFile)((BookingFile)bookingCtr.getEntity()), Transfer.class).forEach(transfer -> {
            if (transfer.getStatus() == ProductStatus.REFUND) {
                Transfer sell = transfer.getPreviousProduct();
                if (orderStatus.equals((Object)OrderStatus.REFUND_WITH_PENALTY)) {
                    BigDecimal additionalServicesPrice = BigDecimal.ZERO;
                    for (AdditionalService additionalServices : transfer.getAdditionalServices()) {
                        additionalServicesPrice = additionalServicesPrice.add(additionalServices.getPrice());
                    }
                    BigDecimal previousPrice = sell.getEquivalentFare() != null ? sell.getEquivalentFare().getValue() : null;
                    previousPrice = previousPrice != null ? previousPrice.add(additionalServicesPrice) : null;
                    BigDecimal penalty = previousPrice != null ? previousPrice.subtract(BigDecimal.valueOf(returnedPrice.intValue())).negate() : null;
                    transfer.setPenalty(penalty);
                    GeneralProductHelper.updateFops((BaseProduct)transfer);
                }
            }
        });
    }
}

