/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.checkTime;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.transfers.PlaceType;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.CheckTimeRQ;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.IwayNgOperation;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.IwayNgRequestParams;

public class CheckTimeRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CheckTimeRQ request = new CheckTimeRQ();
        TransferReservationCreationParameters parameters = (TransferReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        request.setPickupTime(IwayAPIHelper.patternDateTime.format(parameters.getTripDetails().getStart().getTime()));
        this.setConnectionTime(request, parameters);
        request.setPriceId(parameters.getTripDetails().getSearchGdsResponse().getGdsTripId());
        if (parameters.getTransferType().equals((Object)TransferType.RENT)) {
            request.setIsRent(true);
            request.setDuration(parameters.getTripDetails().getDuration());
        }
        IwayNgRequestParams requestParams = new IwayNgRequestParams();
        requestParams.setOperation(IwayNgOperation.CheckTime);
        if (TextUtil.nonBlank((String)parameters.getLang())) {
            requestParams.getUrlParameters().put("lang", new String[]{parameters.getLang()});
            request.setLang(parameters.getLang());
        }
        requestParams.setRequest(request);
        ctx.putObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_REQUEST_PARAMS, (Object)requestParams);
    }

    private void setConnectionTime(CheckTimeRQ request, TransferReservationCreationParameters parameters) {
        if (parameters.getTripDetails().getSearchGdsResponse().getEndPlace().getType() == PlaceType.AIRPORT || parameters.getTripDetails().getSearchGdsResponse().getEndPlace().getType() == PlaceType.RAILWAY_STATION) {
            request.setDepartureTime(IwayAPIHelper.patternDateTime.format(parameters.getTripDetails().getEnd().getTime()));
        }
    }
}

