/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.helpers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.transfers.PlaceType;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.transfers.IwayGdsAccount;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.transfers.ContactPerson;
import com.gridnine.xtrip.common.transfers.GdsPlaceInfo;
import com.gridnine.xtrip.common.transfers.Subaddress;
import com.gridnine.xtrip.common.transfers.TripDetails;
import com.gridnine.xtrip.common.transfers.TripPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.GetTransferPriceListRS;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.IwayNgRequestParams;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.AdditionalServiceForIwayRest;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.Location;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.Passenger;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.Trip;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.FastDateFormat;

public class IwayAPIHelper {
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public static final FastDateFormat patternDateTime;

    public static void validateIwayGdsAccount(EntityContainer<IwayGdsAccount> gdsAccountContainer) {
        if (gdsAccountContainer == null) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0443\u0447\u0435\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c Iway", (Object[])new Object[0]);
        }
        if (TextUtil.isBlank((String)((IwayGdsAccount)gdsAccountContainer.getEntity()).getServiceUrl())) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d URL \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f Iway", (Object[])new Object[0]);
        }
        if (TextUtil.isBlank((String)((IwayGdsAccount)gdsAccountContainer.getEntity()).getUserId())) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043b\u043e\u0433\u0438\u043d \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 Iway", (Object[])new Object[0]);
        }
        if (TextUtil.isBlank((String)((IwayGdsAccount)gdsAccountContainer.getEntity()).getPassword())) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u043e\u043b\u044c \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 Iway", (Object[])new Object[0]);
        }
    }

    public static String buildUrl(IwayNgRequestParams requestParams, IwayGdsAccount gdsAccount) {
        String result = gdsAccount.getServiceUrl() + requestParams.getOperation().getUrlSuffix();
        if (TextUtil.nonBlank((String)requestParams.getPathVariable())) {
            result = result + "/" + requestParams.getPathVariable();
        }
        return result;
    }

    public static PlaceType getPlaceTypeById(int id) {
        switch (id) {
            case 1: {
                return PlaceType.WITHIN_CITY;
            }
            case 2: {
                return PlaceType.AIRPORT;
            }
            case 3: {
                return PlaceType.RAILWAY_STATION;
            }
            case 4: {
                return PlaceType.NEAR_CITY;
            }
            case 5: {
                return PlaceType.TOWN;
            }
            case 6: {
                return PlaceType.OTHER;
            }
            case 7: {
                return PlaceType.WITHIN_MKAD;
            }
            case 8: {
                return PlaceType.WITHIN_KAD;
            }
            case 9: {
                return PlaceType.CITY_CENTER;
            }
            case 10: {
                return PlaceType.HOTEL;
            }
        }
        return null;
    }

    public static TransferType getTransferTypeById(int id) {
        if (id == 2) {
            return TransferType.RENT;
        }
        return TransferType.TRANSFER;
    }

    public static GdsPlaceInfo convertPriceListRest2PlaceInfo(GetTransferPriceListRS.Result.Place place) {
        GdsPlaceInfo result = new GdsPlaceInfo();
        result.setId(place.getPlaceId());
        result.setType(IwayAPIHelper.getPlaceTypeById(place.getType()));
        result.getTerminal().addAll(place.getTerminal());
        return result;
    }

    public static Trip convertTripDetails2Rest(TransferReservationCreationParameters parameters, IwayGdsAccount gdsAccount) {
        TripDetails tripDetails = parameters.getTripDetails();
        Trip result = new Trip();
        SearchGdsResponse searchGdsResponse = tripDetails.getSearchGdsResponse();
        result.setStartLocation(IwayAPIHelper.convertTripPoint2Rest(tripDetails.getStart()));
        if (TextUtil.nonBlank((String)tripDetails.getEnd().getLocation())) {
            result.setFinishLocation(IwayAPIHelper.convertTripPoint2Rest(tripDetails.getEnd()));
        }
        result.setAdditionalLocations(tripDetails.getSubAddresses().stream().map(IwayAPIHelper::convertSubAddress2Rest).collect(Collectors.toList()));
        result.setPriceId(searchGdsResponse.getGdsTripId());
        result.setAdditionalServices(tripDetails.getAdditionalServices().stream().filter(service -> service.getId() != null).map(service -> {
            AdditionalServiceForIwayRest orderService = new AdditionalServiceForIwayRest();
            orderService.setId(service.getId());
            return orderService;
        }).collect(Collectors.toList()));
        result.setDuration(tripDetails.getDuration());
        result.setPlatform(gdsAccount.getPlatformOrderId());
        if (tripDetails.getAdditionalServices().stream().anyMatch(as -> as.getType() == AdditionalServiceType.TABLE)) {
            if (parameters.getTableCaption() == null || parameters.getTableCaption().trim().isEmpty()) {
                result.setTextTablet(((ContactPerson)parameters.getPassengers().get(0)).getName());
            } else {
                result.setTextTablet(parameters.getTableCaption());
            }
        }
        return result;
    }

    public static Passenger convertContactPerson2Rest(ContactPerson person) {
        Communication comm;
        Passenger result = new Passenger();
        if (TextUtil.nonBlank((String)person.getName())) {
            result.setName(person.getName());
        }
        if (TextUtil.nonBlank((String)person.getEmail())) {
            result.setEmail(person.getEmail());
        }
        if (TextUtil.nonBlank((String)(comm = person.getPhone()).getSense())) {
            result.setPhone("+" + MiscUtil.guarded((String)comm.getCountryCode()) + MiscUtil.guarded((String)comm.getCityCode()) + MiscUtil.guarded((String)comm.getSense()));
        }
        return result;
    }

    public static String getAgentId(EntityReference<Person> agentRef) {
        EntityContainer agentCtr = EntityStorage.get().resolve(agentRef);
        if (agentCtr == null) {
            return null;
        }
        List iwayReferences = ((Person)agentCtr.getEntity()).getGdsReferences().stream().filter(ref -> GdsName.IWAY == ref.getGdsName()).filter(ref -> !(ref.getOpened() != null && !new Date().after(ref.getOpened()) || ref.getClosed() != null && !new Date().before(ref.getClosed()))).collect(Collectors.toList());
        if (iwayReferences.size() == 1) {
            return ((GdsReference)iwayReferences.get(0)).getReference();
        }
        return null;
    }

    public static AdditionalService convertRest2AdditionalService(com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.AdditionalService additionalService) {
        AdditionalService result = new AdditionalService();
        AdditionalServiceType type = null;
        switch (additionalService.getType()) {
            case "table": {
                type = AdditionalServiceType.TABLE;
                break;
            }
            case "infant_seat": {
                type = AdditionalServiceType.INFANT_SEAT;
                break;
            }
            case "seat": {
                type = AdditionalServiceType.SEAT;
                break;
            }
            case "booster": {
                type = AdditionalServiceType.BOOSTER;
                break;
            }
            case "tollroad": {
                type = AdditionalServiceType.TOLLROAD;
            }
        }
        result.setType(type);
        result.setId(additionalService.getId());
        if (additionalService.getPrice() != null) {
            result.setPrice(BigDecimal.valueOf(additionalService.getPrice()).setScale(0, RoundingMode.UP));
        }
        result.setCurrency(additionalService.getCurrency());
        result.setDefaultInclude(additionalService.getDefaultInclude() != null ? additionalService.getDefaultInclude() : false);
        return result;
    }

    private static Location convertTripPoint2Rest(TripPoint tripPoint) {
        Location result = new Location();
        result.setLocation(tripPoint.getLocation());
        result.setAddress(tripPoint.getAddress());
        result.setFilghtNumber(tripPoint.getFlightNumber());
        result.setTerminalNumber(tripPoint.getTerminalNumber());
        result.setTrainNumber(tripPoint.getTrainNumber());
        result.setTrainCarriageNumber(tripPoint.getTrainCarriageNumber());
        result.setTime(tripPoint.getTime() != null ? patternDateTime.format(tripPoint.getTime()) : null);
        return result;
    }

    private static Location convertSubAddress2Rest(Subaddress subaddress) {
        Location result = new Location();
        result.setAddress(subaddress.getAddress());
        result.setLocation(subaddress.getLocation());
        return result;
    }

    static {
        MAPPER.setTimeZone(TimeZone.getDefault());
        patternDateTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm");
    }
}

