/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.helpers;

import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferProvider;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.CarClassReference;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.transfers.IwayGdsAccount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.IwayOrder;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.PayableStatus;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;

public class IwayHelper {
    private static final CodeTranslator CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.TRANSFERS_IWAY.name()});

    public static DictionaryReference<GeoLocation> resolveCityCode(String code) {
        return CODE_TRANSLATOR.resolveNativeCode(GeoLocation.class, code, LocationType.CITY, false);
    }

    public static String getOrderId(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.IWAY_ORDER_ID);
    }

    public static String getTransactionId(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.IWAY_TRANSACTION);
    }

    public static Transfer searchProduct(Reservation reservation, String productNumber, ProductStatus status) {
        for (BaseProduct product : reservation.getProducts()) {
            Transfer transfer;
            if (!(product instanceof Transfer) || !TextUtil.isSame((String)(transfer = (Transfer)product).getSystemNumber(), (String)productNumber, (boolean)true) || transfer.getStatus() != status) continue;
            return transfer;
        }
        return null;
    }

    public static Transfer createProduct(Reservation reservation, String productNumber, ProductStatus status) {
        Transfer sellProduct = new Transfer();
        sellProduct.setStatus(status);
        sellProduct.setSystemNumber(productNumber);
        sellProduct.setProvider(TransferProvider.IWAY);
        sellProduct.setReservation(reservation);
        reservation.getProducts().add(sellProduct);
        return sellProduct;
    }

    public static Transfer createRefundProduct(Reservation reservation, Transfer sellProduct, String productNumber) {
        Transfer refundProduct = new Transfer();
        refundProduct.setStatus(ProductStatus.REFUND);
        refundProduct.setSystemNumber(productNumber);
        refundProduct.setProvider(TransferProvider.IWAY);
        sellProduct.setNextProduct(refundProduct);
        refundProduct.setPreviousProduct(sellProduct);
        refundProduct.setReservation(reservation);
        reservation.getProducts().add(refundProduct);
        return refundProduct;
    }

    public static IwaySalesContextData getSalesContextData(String agentCode, Date date) {
        List gdsReferenceIndexes;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.gdsName.name(), (Object)GdsName.IWAY));
        query.getCriteria().getCriterions().add(SearchCriterion.ieq((String)GdsReferenceIndex.Property.reference.name(), (String)agentCode));
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)GdsReferenceIndex.Property.opened.name(), (Object)date), SearchCriterion.eq((String)GdsReferenceIndex.Property.opened.name(), null)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)GdsReferenceIndex.Property.closed.name(), (Object)date), SearchCriterion.eq((String)GdsReferenceIndex.Property.closed.name(), null)}));
        }
        if ((gdsReferenceIndexes = EntityStorage.get().search(GdsReferenceIndex.class, query).getData()).size() == 1) {
            IwaySalesContextData data = new IwaySalesContextData();
            data.setAgent((EntityReference<Person>)((GdsReferenceIndex)gdsReferenceIndexes.get(0)).getSource());
            data.setAgency((EntityReference<Organization>)((GdsReferenceIndex)gdsReferenceIndexes.get(0)).getAgency());
            data.setSubagency((EntityReference<Organization>)((GdsReferenceIndex)gdsReferenceIndexes.get(0)).getSubagency());
            data.setSalesPoint((EntityReference<SalesPoint>)((GdsReferenceIndex)gdsReferenceIndexes.get(0)).getSalesPoint());
            return data;
        }
        return null;
    }

    public static String getImageUrl(EntityContainer<IwayGdsAccount> accountCtr) {
        String imageUrl = ((IwayGdsAccount)accountCtr.getEntity()).getImageUrl();
        return TextUtil.isBlank((String)imageUrl) ? "https://iwayex.com/images/cars/" : imageUrl;
    }

    public static CarClassReference getDictionaryCarClassRef(int carClassId) throws Exception {
        CarClass carClass = DictHelper.findCarsClassByCodeVariant((String)Integer.toString(carClassId), (CodeSystem)CodeSystem.TRANSFERS_IWAY);
        if (carClass == null) {
            String exceptionMessage = "Car class with id " + carClassId + " gds " + GdsName.IWAY.name();
            throw new Exception(exceptionMessage);
        }
        return carClass.toReference();
    }

    public static void setCityWithCountry(Integer code, Consumer<DictionaryReference<GeoLocation>> citySetter, Consumer<DictionaryReference<Country>> countrySetter) {
        if (code == null) {
            return;
        }
        DictionaryReference<GeoLocation> cityRef = IwayHelper.resolveCityCode(String.valueOf(code));
        if (cityRef != null) {
            citySetter.accept(cityRef);
            GeoLocation startCity = (GeoLocation)DictHelper.resolve(cityRef);
            if (startCity != null) {
                countrySetter.accept((DictionaryReference<Country>)startCity.getCountry());
            }
        }
    }

    public static ProductStatus getProductStatus(IwayOrder iwayOrder) {
        if (iwayOrder.getPayableStatus() == PayableStatus.NOT_PAYED) {
            return ProductStatus.BOOKING;
        }
        switch (iwayOrder.getOrderStatus()) {
            case WAIT_FOR_PROCESSING: 
            case PROCESSING: 
            case ACCEPTED: 
            case DONE: 
            case NOT_PAYED: 
            case CHANGED: {
                return ProductStatus.SELL;
            }
            case REFUND_WITH_PENALTY: 
            case REFUND_NO_PENALTY: {
                return ProductStatus.REFUND;
            }
        }
        return null;
    }

    public static class IwaySalesContextData {
        private EntityReference<Person> agent;
        private EntityReference<Organization> agency;
        private EntityReference<Organization> subagency;
        private EntityReference<SalesPoint> salesPoint;

        public EntityReference<Person> getAgent() {
            return this.agent;
        }

        public void setAgent(EntityReference<Person> agent) {
            this.agent = agent;
        }

        public EntityReference<Organization> getAgency() {
            return this.agency;
        }

        public void setAgency(EntityReference<Organization> agency) {
            this.agency = agency;
        }

        public EntityReference<Organization> getSubagency() {
            return this.subagency;
        }

        public void setSubagency(EntityReference<Organization> subagency) {
            this.subagency = subagency;
        }

        public EntityReference<SalesPoint> getSalesPoint() {
            return this.salesPoint;
        }

        public void setSalesPoint(EntityReference<SalesPoint> salesPoint) {
            this.salesPoint = salesPoint;
        }
    }
}

