/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.orders;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.model.transfers.IwayGdsAccount;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.CreateOrderRQ;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.IwayNgOperation;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.IwayNgRequestParams;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.Trip;
import java.util.Collections;
import java.util.stream.Collectors;

public class CreateOrderRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        TransferReservationCreationParameters parameters = (TransferReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        CreateOrderRQ request = new CreateOrderRQ();
        Trip trip = IwayAPIHelper.convertTripDetails2Rest(parameters, (IwayGdsAccount)gdsAccountCtr.getEntity());
        trip.setPassengers(parameters.getPassengers().stream().map(IwayAPIHelper::convertContactPerson2Rest).collect(Collectors.toList()));
        trip.setCustomer(IwayAPIHelper.convertContactPerson2Rest(parameters.getCustomer()));
        trip.setRent(TransferType.RENT == parameters.getTransferType());
        trip.setComment(parameters.getNotes());
        trip.setUserId(Integer.parseInt(((IwayGdsAccount)gdsAccountCtr.getEntity()).getUserId()));
        trip.setPassengersNumber(parameters.getPassengersCount());
        trip.setAdultsAmount(parameters.getTripDetails().getAdultCount());
        trip.setChildrenAmount(parameters.getTripDetails().getChildCount());
        trip.setCurrency("RUB");
        trip.setFlexibleTariff(parameters.getTripDetails().isFlexibleTariff());
        trip.setFlexibleTariffAgreement(parameters.getTripDetails().isFlexibleTariffAgreement());
        request.setTrips(Collections.singletonList(trip));
        if (TextUtil.nonBlank((String)parameters.getLang())) {
            request.setLang(parameters.getLang());
        }
        request.setCurrency("RUB");
        request.setUserId(Integer.parseInt(((IwayGdsAccount)gdsAccountCtr.getEntity()).getUserId()));
        IwayNgRequestParams requestParams = new IwayNgRequestParams();
        requestParams.setOperation(IwayNgOperation.CreateOrder);
        requestParams.setRequest(request);
        ctx.putObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_REQUEST_PARAMS, (Object)requestParams);
    }
}

