/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.prices;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.CarClassReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.transfers.IwayGdsAccount;
import com.gridnine.xtrip.common.model.transfers.RentParams;
import com.gridnine.xtrip.common.transfers.GdsPlaceInfo;
import com.gridnine.xtrip.common.transfers.model.BaseTransferGdsAccount;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import com.gridnine.xtrip.server.transfers.ibus.TransfersHelper;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.GetRentPriceListRS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetRentPriceListRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GetRentPriceListRS response = (GetRentPriceListRS)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_RESPONSE);
        Collection resultItems = (Collection)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_GDS_SEARCH_RESPONSE);
        for (GetRentPriceListRS.Result result : response.getResult()) {
            try {
                resultItems.add(this.convert(result, (EntityContainer<IwayGdsAccount>)accountCtr, (EntityReference<SalesPoint>)salesContext.getSalesPoint()));
            }
            catch (Throwable t) {
                this.log.error("error in parsing i'way search response", t);
            }
        }
    }

    private SearchGdsResponse convert(GetRentPriceListRS.Result result, EntityContainer<IwayGdsAccount> accountCtr, EntityReference<SalesPoint> salesPoint) throws Exception {
        CarClassReference carClass = IwayHelper.getDictionaryCarClassRef(result.getCarClass().getCarClassId());
        return this.createResultItem(result, carClass, accountCtr, salesPoint);
    }

    private SearchGdsResponse createResultItem(final GetRentPriceListRS.Result result, final CarClassReference carClassRef, final EntityContainer<IwayGdsAccount> accountCtr, final EntityReference<SalesPoint> salesPoint) {
        return TransfersHelper.createSearchResponseItem((TransfersHelper.GetSearchResponseProvider)new TransfersHelper.GetSearchResponseProvider(){

            public EntityReference<SalesPoint> getSalesPoint() {
                return salesPoint;
            }

            public EntityReference<? extends BaseTransferGdsAccount> getGdsAccount() {
                return accountCtr.toReference();
            }

            public int getCancellationNoPenaltyHours() {
                return result.getCancellationTime();
            }

            public GdsPlaceInfo getStartPlace() {
                return IwayAPIHelper.convertPriceListRest2PlaceInfo(result.getStartPlace());
            }

            public GdsPlaceInfo getEndPlace() {
                return IwayAPIHelper.convertPriceListRest2PlaceInfo(result.getFinishPlace());
            }

            public DictionaryReference<CarClass> getCarClassRef() {
                return carClassRef;
            }

            public int getCapacity() {
                return result.getCarClass().getCapacity();
            }

            public String getModels() {
                return String.join((CharSequence)", ", result.getCarClass().getModels());
            }

            public BigDecimal getPrice() {
                return BigDecimal.valueOf(result.getPrice());
            }

            public int getAllowableSubaddressesCount() {
                return 0;
            }

            public BigDecimal getSubaddressPrice() {
                return BigDecimal.valueOf(result.getPriceSubaddress().intValue());
            }

            public Integer getGdsTripId() {
                return result.getPriceId();
            }

            public String getImageUrl() {
                return IwayHelper.getImageUrl((EntityContainer<IwayGdsAccount>)accountCtr) + result.getCarClass().getPhoto();
            }

            public EntityReference<Organization> getBlankOwner() {
                return ((IwayGdsAccount)accountCtr.getEntity()).getBlankOwner();
            }

            public List<AdditionalService> getAvailableAdditionalServices() {
                return new ArrayList<AdditionalService>();
            }

            public RentParams getRentParams() {
                RentParams params = new RentParams();
                params.setMinimumDuration(Double.valueOf(result.getMinimumDuration().intValue()));
                params.setPricePerHour(result.getPricePerHour());
                params.setCarDeliveranceFee(result.getCarDeliveranceFee());
                return params;
            }

            public boolean isFlexibleTariff() {
                return false;
            }

            public boolean isFlexibleTariffAgreement() {
                return false;
            }

            public String getCurrency() {
                return result.getCurrency();
            }
        });
    }
}

