/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.prices;

import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.model.transfers.IwayGdsAccount;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.SearchGdsRequest;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.IwayNgOperation;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.IwayNgRequestParams;

public class GetTransferPriceListRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchGdsRequest searchRequest = (SearchGdsRequest)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_GDS_SEARCH_REQUEST);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        IwayAPIHelper.validateIwayGdsAccount((EntityContainer<IwayGdsAccount>)gdsAccountCtr);
        IwayNgRequestParams requestParams = new IwayNgRequestParams();
        if (TextUtil.nonBlank((String)searchRequest.getLang())) {
            requestParams.getUrlParameters().put("lang", new String[]{searchRequest.getLang()});
        }
        requestParams.getUrlParameters().put("start_place_point", new String[]{searchRequest.getStartPlaceCoordinates()});
        requestParams.getUrlParameters().put("user_id", new String[]{((IwayGdsAccount)gdsAccountCtr.getEntity()).getUserId()});
        if (TransferType.TRANSFER == searchRequest.getTransferType()) {
            requestParams.getUrlParameters().put("finish_place_point", new String[]{searchRequest.getEndPlaceCoordinates()});
            requestParams.setOperation(IwayNgOperation.GetTransferPriceList);
        } else if (TransferType.RENT == searchRequest.getTransferType()) {
            requestParams.getUrlParameters().put("duration", new String[]{String.valueOf(searchRequest.getDuration())});
            requestParams.setOperation(IwayNgOperation.GetRentPriceList);
        } else {
            throw Xeption.forDeveloper((String)("unsupported i'way transfer type: " + searchRequest.getTransferType()), (Object[])new Object[0]);
        }
        if (((IwayGdsAccount)gdsAccountCtr.getEntity()).getPlatformOrderId() != null) {
            requestParams.getUrlParameters().put("platform", new String[]{String.valueOf(((IwayGdsAccount)gdsAccountCtr.getEntity()).getPlatformOrderId())});
        } else {
            this.log.warn("Platform Id is not set in Iway GDS Account");
        }
        ctx.putObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_REQUEST_PARAMS, (Object)requestParams);
    }
}

