/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.prices;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalServiceType;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.CarClassReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.transfers.IwayGdsAccount;
import com.gridnine.xtrip.common.model.transfers.RentParams;
import com.gridnine.xtrip.common.transfers.GdsPlaceInfo;
import com.gridnine.xtrip.common.transfers.model.BaseTransferGdsAccount;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import com.gridnine.xtrip.server.transfers.ibus.TransfersHelper;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.GetTransferPriceListRS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GetTransferPriceListRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GetTransferPriceListRS response = (GetTransferPriceListRS)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_RESPONSE);
        ArrayList<SearchGdsResponse> resultItems = new ArrayList<SearchGdsResponse>();
        ctx.putObject((Enum)IBusTransfersContextKeys.TRANSFERS_GDS_SEARCH_RESPONSE, resultItems);
        if (response.getResult() == null) {
            return;
        }
        for (int i = 0; i < response.getResult().size(); ++i) {
            GetTransferPriceListRS.Result result = response.getResult().get(i);
            try {
                resultItems.add(this.convert(result, (EntityContainer<IwayGdsAccount>)accountCtr, (EntityReference<SalesPoint>)salesContext.getSalesPoint()));
                continue;
            }
            catch (Throwable t) {
                this.log.error("error in parsing i'way search response", t);
            }
        }
    }

    private SearchGdsResponse convert(GetTransferPriceListRS.Result result, EntityContainer<IwayGdsAccount> accountCtr, EntityReference<SalesPoint> salesPoint) throws Exception {
        CarClassReference carClass = IwayHelper.getDictionaryCarClassRef(result.getCarClass().getCarClassId());
        return this.createResultItem(result, carClass, accountCtr, salesPoint);
    }

    private SearchGdsResponse createResultItem(final GetTransferPriceListRS.Result result, final CarClassReference carClassRef, final EntityContainer<IwayGdsAccount> accountCtr, final EntityReference<SalesPoint> salesPoint) {
        return TransfersHelper.createSearchResponseItem((TransfersHelper.GetSearchResponseProvider)new TransfersHelper.GetSearchResponseProvider(){

            public EntityReference<SalesPoint> getSalesPoint() {
                return salesPoint;
            }

            public EntityReference<? extends BaseTransferGdsAccount> getGdsAccount() {
                return accountCtr.toReference();
            }

            public int getCancellationNoPenaltyHours() {
                return result.getCancellationTime();
            }

            public GdsPlaceInfo getStartPlace() {
                return IwayAPIHelper.convertPriceListRest2PlaceInfo(result.getStartPlace());
            }

            public GdsPlaceInfo getEndPlace() {
                return IwayAPIHelper.convertPriceListRest2PlaceInfo(result.getFinishPlace());
            }

            public DictionaryReference<CarClass> getCarClassRef() {
                return carClassRef;
            }

            public int getCapacity() {
                return result.getCarClass().getCapacity();
            }

            public String getModels() {
                return String.join((CharSequence)", ", result.getCarClass().getModels());
            }

            public BigDecimal getPrice() {
                return BigDecimal.valueOf(result.getPrice());
            }

            public int getAllowableSubaddressesCount() {
                return result.getAllowableSubaddress();
            }

            public BigDecimal getSubaddressPrice() {
                return BigDecimal.valueOf(result.getPriceSubaddress().intValue());
            }

            public Integer getGdsTripId() {
                return result.getPriceId();
            }

            public String getImageUrl() {
                return IwayHelper.getImageUrl((EntityContainer<IwayGdsAccount>)accountCtr) + result.getCarClass().getPhoto();
            }

            public EntityReference<Organization> getBlankOwner() {
                return ((IwayGdsAccount)accountCtr.getEntity()).getBlankOwner();
            }

            public List<AdditionalService> getAvailableAdditionalServices() {
                List<AdditionalService> additionalServices = result.getAdditionalServices().stream().map(IwayAPIHelper::convertRest2AdditionalService).collect(Collectors.toList());
                AdditionalService freeTableService = new AdditionalService();
                if (3 >= result.getCarClass().getCapacity()) {
                    if (!result.getFlexibleTariff().booleanValue()) {
                        if (2 == result.getStartPlace().getType() || 3 == result.getStartPlace().getType() || 10 == result.getStartPlace().getType()) {
                            if (additionalServices.stream().anyMatch(as -> as.getType() == AdditionalServiceType.TABLE)) {
                                freeTableService.setId(additionalServices.stream().filter(as -> as.getType() == AdditionalServiceType.TABLE).findFirst().get().getId());
                                additionalServices.removeIf(as -> as.getType() == AdditionalServiceType.TABLE);
                            }
                            freeTableService.setFixed(true);
                            freeTableService.setDefaultInclude(true);
                            freeTableService.setType(AdditionalServiceType.TABLE);
                            freeTableService.setPrice(BigDecimal.ZERO);
                            freeTableService.setCurrency(result.getCurrency());
                            additionalServices.add(freeTableService);
                        }
                    } else if (!(result.getFlexibleTariffAgreement().booleanValue() || 2 != result.getStartPlace().getType() && 3 != result.getStartPlace().getType())) {
                        if (additionalServices.stream().anyMatch(as -> as.getType() == AdditionalServiceType.TABLE)) {
                            freeTableService.setId(additionalServices.stream().filter(as -> as.getType() == AdditionalServiceType.TABLE).findFirst().get().getId());
                            additionalServices.removeIf(as -> as.getType() == AdditionalServiceType.TABLE);
                        }
                        freeTableService.setFixed(true);
                        freeTableService.setDefaultInclude(true);
                        freeTableService.setType(AdditionalServiceType.TABLE);
                        freeTableService.setPrice(BigDecimal.ZERO);
                        freeTableService.setCurrency(result.getCurrency());
                        additionalServices.add(freeTableService);
                    }
                }
                return additionalServices;
            }

            public RentParams getRentParams() {
                return null;
            }

            public boolean isFlexibleTariff() {
                return result.getFlexibleTariff();
            }

            public boolean isFlexibleTariffAgreement() {
                return result.getFlexibleTariffAgreement();
            }

            public String getCurrency() {
                return result.getCurrency();
            }
        });
    }
}

