/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.servlets;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IwayJsonExchangeDocument;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.parsers.ExchangeProcessor;
import com.gridnine.xtrip.server.parsers.ExchangeProcessorRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IwayServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(IwayServlet.class);
    public static final String RESPONSE_SUCCESSFUL_CODE = "OK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            boolean authorize = false;
            try {
                LogicalStorage.get().authorizeAsSystem();
                authorize = true;
            }
            catch (Exception e) {
                log.error("unable to authorize on iway callback request", (Throwable)e);
            }
            if (authorize) {
                this.processRequest(req, resp);
            }
        }
        finally {
            this.processResponse(resp);
            LogicalStorage.reset();
        }
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) {
        String request = null;
        try {
            request = this.readRequest((InputStream)req.getInputStream());
        }
        catch (IOException e) {
            log.error("unable to process iway callback request", (Throwable)e);
        }
        if (request == null) {
            resp.setStatus(500);
            return;
        }
        log.info("received request: " + request);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        try {
            JSONArray jsonArray = new JSONArray(request);
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonObjects.add(jsonArray.getJSONObject(i));
            }
        }
        catch (Throwable t) {
            log.error("unable to get json objects from iway callback ", t);
        }
        if (jsonObjects.isEmpty()) {
            resp.setStatus(500);
            return;
        }
        resp.setStatus(200);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        for (JSONObject jsonObject : jsonObjects) {
            Date date = new Date();
            String content = jsonObject.toString();
            String nameValue = "";
            try {
                nameValue = nameValue + jsonObject.getInt("order_id");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            nameValue = nameValue + "_" + format.format(date);
            String name = String.format("iway_callback_%s.json", nameValue);
            ExchangeFile exchangeFile = new ExchangeFile();
            exchangeFile.setType(IwayJsonExchangeDocument.class.getName());
            exchangeFile.setCreated(new Date());
            exchangeFile.setLocation(name);
            exchangeFile.setContent(content.getBytes(StandardCharsets.UTF_8));
            try {
                log.debug(String.format("iway callback exchange file %s register process start", name));
                ExchangeProcessor processor = ((ExchangeProcessorRegistry)Environment.getPublished(ExchangeProcessorRegistry.class)).get(IwayJsonExchangeDocument.class.getName());
                processor.registerExchangeFile(exchangeFile);
                log.debug(String.format("iway callback exchange file %s register process end", name));
            }
            catch (Exception e) {
                log.error(String.format("unable to register iway callback exchange file %s", name), (Throwable)e);
            }
        }
    }

    private String readRequest(InputStream inputStream) throws IOException, UnsupportedCharsetException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IoUtil.copyStream((InputStream)inputStream, (OutputStream)outputStream, (int)256);
        return outputStream.toString(StandardCharsets.UTF_8.name());
    }

    private void processResponse(HttpServletResponse response) throws IOException {
        log.debug("iway callback response process start");
        PrintWriter writer = response.getWriter();
        writer.write(RESPONSE_SUCCESSFUL_CODE);
        writer.flush();
        log.debug("iway callback response process end");
    }
}

