/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.nextgen.transportNodes;

import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.LocationInfo;
import com.gridnine.xtrip.server.transfers.SearchLocationResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.GetTransportNodesRS;
import java.util.Arrays;
import java.util.List;

public class GetTransportNodesRSParser
extends BaseProcessor {
    private static final List<String> typeTriggers = Arrays.asList("street_address", "establishment", "airport", "premise");

    public void process(MessageContext ctx) throws Exception {
        GetTransportNodesRS response = (GetTransportNodesRS)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_NG_RESPONSE);
        SearchLocationResponse gdsResponse = new SearchLocationResponse();
        for (GetTransportNodesRS.Result result : response.getResults()) {
            if (result.getGeometry() == null || result.getGeometry().getLocation() == null) continue;
            LocationInfo locationInfo = new LocationInfo();
            locationInfo.setFormattedAddress(result.getFormattedAddress());
            locationInfo.setLat(result.getGeometry().getLocation().getLat());
            locationInfo.setLon(result.getGeometry().getLocation().getLng());
            locationInfo.setAccurate(result.getTypes().stream().anyMatch(typeTriggers::contains));
            gdsResponse.getLocations().add(locationInfo);
        }
        ctx.putObject((Enum)IBusTransfersContextKeys.TRANSFERS_LOCATION_SEARCH_RESPONSE, (Object)gdsResponse);
    }
}

