/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.parsers.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.IwayOrder;

public class GetOrCreateBookingProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_RESERVATION);
        IwayOrder order = (IwayOrder)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_ORDER);
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_BOOKING_FILE);
        Transfer sellProduct = IwayHelper.searchProduct(reservation, order.getOrderId(), ProductStatus.SELL);
        if (sellProduct != null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.BaseTicketTransactionDataProcessor_importExchangeFileNoChangeOrder, (Object[])new Object[]{((BookingFile)bfCtr.getEntity()).getNumber()}));
            return;
        }
        Transfer bookingProduct = IwayHelper.searchProduct(reservation, order.getOrderId(), ProductStatus.BOOKING);
        if (bookingProduct == null) {
            bookingProduct = IwayHelper.createProduct(reservation, order.getOrderId(), ProductStatus.BOOKING);
        }
        ctx.putObject((Enum)IBusGdsIwayContextKeys.IWAY_BOOKING_PRODUCT, (Object)bookingProduct);
    }
}

