/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.parsers.process;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.IwayOrder;

public class GetOrCreateReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation;
        IwayOrder order = (IwayOrder)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_ORDER);
        EntityContainer bookingFileContainer = EntityStorage.get().resolve(this.findBookingFileByIwayOrderId(order.getOrderId()));
        if (bookingFileContainer == null) {
            BookingFile bookingFile = new BookingFile();
            bookingFile.setCreateDate(order.getDate());
            reservation = new Reservation();
            reservation.setBookingFile(bookingFile);
            reservation.setResDate(order.getDate());
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.IWAY, (RecordLocatorType)RecordLocatorType.IWAY_ORDER_ID, (String)order.getOrderId());
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.IWAY, (RecordLocatorType)RecordLocatorType.IWAY_TRANSACTION, (String)String.valueOf(order.getTransaction()));
            bookingFile.getReservations().add(reservation);
            bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
        } else {
            reservation = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().filter(res -> TextUtil.equals((String)CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)res, (GdsName)GdsName.IWAY, (RecordLocatorType)RecordLocatorType.IWAY_ORDER_ID), (String)order.getOrderId(), (boolean)false)).findFirst().get();
        }
        ctx.putObject((Enum)IBusGdsIwayContextKeys.IWAY_BOOKING_FILE, (Object)bookingFileContainer);
        ctx.putObject((Enum)IBusGdsIwayContextKeys.IWAY_RESERVATION, (Object)reservation);
    }

    private EntityReference<BookingFile> findBookingFileByIwayOrderId(String orderId) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)orderId));
        SearchResult searchResult = EntityStorage.get().search(BookingFileIndex.class, query);
        if (searchResult.getData().isEmpty()) {
            return null;
        }
        return ((BookingFileIndex)searchResult.getData().get(0)).getSource();
    }
}

