/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.parsers.process;

import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.IwayJsonExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class IwayHandleProcessExchangeDocumentAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        IwayJsonExchangeDocument exchangeDocument = (IwayJsonExchangeDocument)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        exchangeDocument.getMessages().clear();
    }

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        if (ExceptionUtil.isInterruptedError((Throwable)e)) {
            this.log.warn("interrupted exception occurred", e);
            return true;
        }
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"IwayExchangeProcessor_processingError", (Throwable)e, (Object[])new Object[]{e.getMessage()}));
        return true;
    }

    public void after(MessageContext ctx) throws Exception {
        IwayJsonExchangeDocument exchangeDocument = (IwayJsonExchangeDocument)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        Collection messages = ctx.getMessagesReadOnly();
        if (MessageHelper.hasMessages((Collection)messages, (MessageType)MessageType.ERROR)) {
            exchangeDocument.setStatus(ProcessingStatus.ERROR);
        } else if (MessageHelper.hasMessages((Collection)messages, (MessageType)MessageType.WARNING)) {
            exchangeDocument.setStatus(ProcessingStatus.WARNING);
        } else {
            exchangeDocument.setStatus(ProcessingStatus.OK);
        }
        exchangeDocument.getMessages().addAll(messages);
    }
}

