/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.parsers.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.transfers.IwayConfig;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferProvider;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.FopPaymentInfo;
import com.gridnine.xtrip.common.model.profile.IwaySupplierSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.transfers.CommonTransfersHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.transfers.iway.IBusGdsIwayContextKeys;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.IwayOrder;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.OrderStatus;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.Passenger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IwayUpdateCommonProductProcessor
extends BaseProcessor {
    private Set<String> productKeys = new HashSet<String>();

    public void configure(Map<String, String> parameters) {
        this.productKeys.addAll(parameters.values());
    }

    public void process(MessageContext ctx) throws Exception {
        IwayOrder order = (IwayOrder)ctx.getMandatoryObject((Enum)IBusGdsIwayContextKeys.IWAY_ORDER);
        IwayConfig config = (IwayConfig)ctx.getObject((Enum)IBusGdsIwayContextKeys.IWAY_SETTINGS);
        if (config == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"IwayExchangeProcessor_iwaySettingsNotFound", (Object[])new Object[0]));
        }
        for (String productKey : this.productKeys) {
            Transfer product = (Transfer)ctx.getMandatoryObject(productKey);
            if (product.getProvider() != null) {
                product.setProvider(TransferProvider.IWAY);
            }
            if (product.getIssueDate() == null) {
                product.setIssueDate(order.getDate());
            }
            product.setStartDate(order.getDateArrival());
            product.setEndDate(order.getDateDeparture());
            product.setTicketType(TicketType.OWN);
            product.setIwayBookerNumber(order.getBookerNumber());
            product.setTransferType(IwayAPIHelper.getTransferTypeById(order.getServiceId()));
            String agentId = null;
            if (order.getUserId() != null) {
                agentId = String.valueOf(order.getUserId());
            }
            if (config != null) {
                EntityReference supplier = config.getSupplierSettings().stream().filter(s -> MiscUtil.isBetween((Date)MiscUtil.clearTime((Date)s.getOpened()), (Date)MiscUtil.setDayEndTime((Date)s.getClosed()), (Date)order.getDate())).map(IwaySupplierSettings::getSupplier).filter(Objects::nonNull).findFirst().orElse(null);
                TransferHelper.setSupplier((Transfer)product, (EntityReference)supplier);
                product.setBlankOwner(supplier);
            }
            EntityReference<Organization> agency = null;
            EntityReference<Person> agent = null;
            EntityReference<Organization> subagency = null;
            EntityReference<SalesPoint> salesPoint = null;
            IwayHelper.IwaySalesContextData salesContextData = IwayHelper.getSalesContextData(agentId, order.getDate());
            if (salesContextData == null) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"IwayExchangeProcessor_agentNotFound", (Object[])new Object[]{agentId}));
            } else {
                agency = salesContextData.getAgency();
                agent = salesContextData.getAgent();
                subagency = salesContextData.getSubagency();
                salesPoint = salesContextData.getSalesPoint();
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                TransferHelper.setSubagency((Transfer)product, subagency);
                TransferHelper.setAgency((Transfer)product, agency);
                if (product.getReservation() != null) {
                    Reservation reservation = product.getReservation();
                    reservation.setBookingAgent(agent);
                    reservation.setSubagency(subagency);
                    reservation.setSalesPoint(salesPoint);
                    if (reservation.getBookingFile() != null) {
                        BookingFile file = reservation.getBookingFile();
                        file.setAgency(agency);
                    }
                }
            }
            BigDecimal equivalentFare = null;
            String equivCurrency = DictHelper.getLocalCurrency();
            String baseCurrency = order.getCurrency();
            BigDecimal price = order.getPrice() != null && order.getPrice().getPrice() != null ? BigDecimal.valueOf(order.getPrice().getPrice().intValue()) : BigDecimal.ZERO;
            boolean equivalentFareChanged = false;
            BigDecimal additionalFare = BigDecimal.ZERO;
            if (order.getAdditionalServices() != null) {
                for (com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.AdditionalService as2 : order.getAdditionalServices()) {
                    AdditionalService additionalService = IwayAPIHelper.convertRest2AdditionalService(as2);
                    if (TextUtil.isBlank((String)additionalService.getCurrency())) {
                        additionalService.setCurrency(baseCurrency);
                    }
                    additionalFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{additionalFare, additionalService.getPrice()});
                    product.getAdditionalServices().removeIf(pas -> pas.getType() == additionalService.getType());
                    if (!product.getAdditionalServices().stream().noneMatch(pas -> MiscUtil.equals((Object)pas.getId(), (Object)additionalService.getId(), (boolean)true))) continue;
                    product.getAdditionalServices().add(additionalService);
                }
            }
            BigDecimal baseFare = MiscUtil.sub((BigDecimal)price, (BigDecimal[])new BigDecimal[]{additionalFare});
            Money fare = MoneyHelper.buildMoney((BigDecimal)baseFare, (String)baseCurrency);
            product.setFare(fare);
            if (TextUtil.isSame((String)baseCurrency, (String)equivCurrency)) {
                equivalentFare = baseFare;
                equivalentFareChanged = product.getEquivalentFare() == null || !MiscUtil.equals((Object)product.getEquivalentFare().getValue(), (Object)equivalentFare);
                product.setEquivalentFare(MoneyHelper.buildMoney((BigDecimal)equivalentFare, (String)baseCurrency));
            } else {
                BigDecimal currencyRateValue = new BigDecimal(String.valueOf(order.getValue()));
                BigDecimal currencyRateCoef = new BigDecimal(String.valueOf(order.getNominal()));
                BigDecimal currencyRate = MiscUtil.mul((BigDecimal)currencyRateValue, (BigDecimal)currencyRateCoef);
                BigDecimal ruFare = MiscUtil.mul((BigDecimal)baseFare, (BigDecimal)currencyRate);
                equivalentFare = TextUtil.isSame((String)"RUB", (String)equivCurrency) ? ruFare : FinanceHelper.exchange((BigDecimal)ruFare, (String)"RUB", (String)equivCurrency, (TariffType)TariffType.REGULAR, (Date)order.getDate());
                baseCurrency = equivCurrency;
                equivalentFareChanged = product.getEquivalentFare() == null || !MiscUtil.equals((Object)product.getEquivalentFare().getValue(), (Object)equivalentFare);
                product.setEquivalentFare(MoneyHelper.buildMoney((BigDecimal)equivalentFare, (String)baseCurrency));
            }
            equivalentFareChanged |= !MiscUtil.equals((Object)CommonTransfersHelper.getAdditionalServiceSum((Transfer)product), (Object)additionalFare);
            equivalentFare = equivalentFare.add(additionalFare);
            if (product.getStatus() == ProductStatus.REFUND && OrderStatus.REFUND_WITH_PENALTY == order.getOrderStatus()) {
                product.setPenalty(equivalentFare);
            }
            BigDecimal equivalentCommission = null;
            Money amountCommission = null;
            if (order.getReward() != 0.0) {
                BigDecimal percentageCommission = new BigDecimal(String.valueOf(order.getReward()));
                BigDecimal coef = new BigDecimal("0.01");
                equivalentCommission = MiscUtil.mul((BigDecimal)equivalentFare, (BigDecimal)MiscUtil.mul((BigDecimal)percentageCommission, (BigDecimal)coef));
                amountCommission = MoneyHelper.buildMoney((BigDecimal)equivalentCommission, (String)baseCurrency);
            }
            GeneralProductCommission vendorCommission = null;
            if (!MiscUtil.isZero(equivalentCommission, (boolean)true)) {
                EntityContainer commissionsPropertyCont;
                vendorCommission = new GeneralProductCommission();
                vendorCommission.setContractType(ContractType.VENDOR);
                vendorCommission.setPercentage(order.getReward());
                vendorCommission.setAmount(amountCommission);
                vendorCommission.setEquivalentAmount(equivalentCommission);
                if (config != null && (commissionsPropertyCont = EntityStorage.get().resolve(config.getCommissionProperties())) != null) {
                    vendorCommission.setCommissionProperties(commissionsPropertyCont.toReference());
                }
            }
            if (product.getEquivalentFare() != null) {
                ArrayList<GeneralProductFop> vendorFOPs = new ArrayList<GeneralProductFop>();
                PaymentType pt = PaymentType.INVOICE;
                GeneralProductFop fop = new GeneralProductFop();
                fop.setType(pt);
                fop.setEquivalentAmount(equivalentFare);
                if (OrderStatus.NOT_PAYED != order.getOrderStatus()) {
                    fop.setOperationDate(product.getIssueDate());
                    if (salesContextData != null) {
                        fop.setAgent(agent);
                    }
                }
                vendorFOPs.add(fop);
                if (equivalentFareChanged) {
                    ArrayList<GeneralProductFop> subagentFOPs = new ArrayList<GeneralProductFop>();
                    boolean hasSubagentRelatedShipment = ShipmentHelper.hasRelatedShipment((BaseProduct)product, (Collection)GeneralProductHelper.getSubagentFops((BaseProduct)product));
                    if (agency != null && subagency != null && !agency.equals(subagency) && !hasSubagentRelatedShipment) {
                        GeneralProductFop fop2 = new GeneralProductFop();
                        fop2.setType(pt);
                        fop2.setEquivalentAmount(equivalentFare);
                        if (OrderStatus.NOT_PAYED != order.getOrderStatus()) {
                            fop2.setOperationDate(product.getIssueDate());
                            fop2.setAgent(agent);
                        }
                        subagentFOPs.add(fop2);
                    }
                    ArrayList<GeneralProductFop> clientFOPs = new ArrayList<GeneralProductFop>();
                    boolean hasClientRelatedShipment = ShipmentHelper.hasRelatedShipment((BaseProduct)product, (Collection)GeneralProductHelper.getClientFops((BaseProduct)product));
                    if (!hasClientRelatedShipment) {
                        GeneralProductFop fop3 = new GeneralProductFop();
                        fop3.setType(pt);
                        fop3.setEquivalentAmount(equivalentFare);
                        FopPaymentInfo fopPaymentInfo = ProfileHelper.getFopPaymentInfo(salesPoint, (PaymentType)pt, (boolean)false);
                        if (fopPaymentInfo == null || fopPaymentInfo.isCreatePaymentDate()) {
                            fop3.setOperationDate(product.getIssueDate());
                            if (salesContextData != null) {
                                fop3.setAgent(agent);
                            }
                        }
                        clientFOPs.add(fop3);
                    }
                    for (GeneralProductContractRelationData item : TransferHelper.getContractRelations((Transfer)product)) {
                        switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                            case VENDOR: {
                                item.getFops().clear();
                                item.getFops().addAll(vendorFOPs);
                                if (vendorCommission == null) break;
                                GeneralProductCommission finalVendorCommission = vendorCommission;
                                item.getCommissions().removeIf(commission -> commission.getCommissionProperties().equals((Object)finalVendorCommission.getCommissionProperties()));
                                item.getCommissions().add(vendorCommission);
                                break;
                            }
                            case SUBAGENCY: {
                                if (hasSubagentRelatedShipment) break;
                                item.getFops().clear();
                                item.getFops().addAll(subagentFOPs);
                                break;
                            }
                            case CLIENT: {
                                if (hasClientRelatedShipment) break;
                                item.getFops().clear();
                                item.getFops().addAll(clientFOPs);
                            }
                        }
                    }
                }
            }
            if (order.getCarData() != null && order.getCarData().getCarClassId() != null) {
                try {
                    product.setCarClass((DictionaryReference)IwayHelper.getDictionaryCarClassRef(order.getCarData().getCarClassId()));
                }
                catch (Throwable e) {
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"IwayExchangeProcessor_carClassNotFound", (Object[])new Object[]{order.getCarClass(), order.getCarData().getCarClassId()}));
                }
            }
            if (order.getPassengers() != null) {
                BookingFile bookingFile = product.getReservation().getBookingFile();
                for (Passenger passenger : order.getPassengers()) {
                    Traveller productTraveller;
                    if (!TextUtil.nonBlank((String)passenger.getName())) continue;
                    Traveller bookingTraveller = this.findTraveller(bookingFile.getTravellers(), passenger.getName());
                    if (bookingTraveller == null) {
                        bookingTraveller = new Traveller();
                        bookingTraveller.setName(passenger.getName());
                        bookingFile.getTravellers().add(bookingTraveller);
                    }
                    if ((productTraveller = this.findTraveller(product.getTravellers(), passenger.getName())) != null) continue;
                    product.getTravellers().add(bookingTraveller);
                }
            }
            if (order.getCoordinator() != null) {
                product.setContactPerson(order.getCoordinator().getName());
            }
            product.setPassengersCount(order.getPassengersNumber());
            if (TextUtil.nonBlank((String)order.getNotes())) {
                product.setComments(order.getNotes());
            }
            if (order.getInternalNumber() != null) {
                product.setComments(TextUtil.nonBlank((String)product.getComments()) ? String.format("%s,\n%s", product.getComments(), order.getInternalNumber()) : String.valueOf(order.getInternalNumber()));
            }
            if (TextUtil.nonBlank((String)order.getTable())) {
                product.setNotes("\u041d\u0430\u0434\u043f\u0438\u0441\u044c \u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0447\u043a\u0435: " + order.getTable());
            }
            String startTitle = null;
            if (order.getStartPlace() != null) {
                product.setStartPlaceId(String.valueOf(order.getStartPlace().getPlaceID()));
                startTitle = this.removeNotDefinedString(order.getStartPlace().getTitle());
                product.setStartType(IwayAPIHelper.getPlaceTypeById(order.getStartPlace().getType()));
                IwayHelper.setCityWithCountry(order.getStartPlace().getCityID(), arg_0 -> ((Transfer)product).setStartCity(arg_0), arg_0 -> ((Transfer)product).setStartCountry(arg_0));
            }
            if (TextUtil.nonBlank(startTitle)) {
                if (TextUtil.nonBlank((String)order.getLocationAddress())) {
                    product.setStartAddress(String.format("%s %s", startTitle, order.getLocationAddress().trim()));
                } else {
                    product.setStartAddress(startTitle);
                }
            } else if (TextUtil.nonBlank((String)order.getLocationAddress())) {
                product.setStartAddress(order.getLocationAddress().trim());
            } else {
                product.setStartAddress(null);
            }
            if (!TextUtil.isBlank((String)order.getArrivalNumber())) {
                product.setStartAddress(TextUtil.isBlank((String)product.getStartAddress()) ? String.format("\u0432\u0441\u0442\u0440\u0435\u0447\u0430 \u0440\u0435\u0439\u0441\u0430 %s", order.getArrivalNumber()) : String.format("%s \u0432\u0441\u0442\u0440\u0435\u0447\u0430 \u0440\u0435\u0439\u0441\u0430 %s", product.getStartAddress(), order.getArrivalNumber()));
            }
            if (order.getSubaddress() != null) {
                product.getSubAddresses().addAll(order.getSubaddress());
            }
            String finishTitle = null;
            if (order.getFinishPlace() != null) {
                product.setEndPlaceId(String.valueOf(order.getFinishPlace().getPlaceID()));
                finishTitle = this.removeNotDefinedString(order.getFinishPlace().getTitle());
                IwayHelper.setCityWithCountry(order.getFinishPlace().getCityID(), arg_0 -> ((Transfer)product).setEndCity(arg_0), arg_0 -> ((Transfer)product).setEndCountry(arg_0));
                product.setEndType(IwayAPIHelper.getPlaceTypeById(order.getFinishPlace().getType()));
            }
            if (TextUtil.nonBlank(finishTitle)) {
                if (TextUtil.nonBlank((String)order.getDestinationAddress())) {
                    product.setEndAddress(String.format("%s %s", finishTitle, order.getDestinationAddress().trim()));
                } else {
                    product.setEndAddress(finishTitle);
                }
            } else if (TextUtil.nonBlank((String)order.getDestinationAddress())) {
                product.setEndAddress(order.getDestinationAddress().trim());
            } else {
                product.setEndAddress(null);
            }
            if (!TextUtil.isBlank((String)order.getDepartureNumber())) {
                product.setEndAddress(TextUtil.isBlank((String)product.getEndAddress()) ? String.format("\u043a \u0440\u0435\u0439\u0441\u0443 %s", order.getDepartureNumber()) : String.format("%s \u043a \u0440\u0435\u0439\u0441\u0443 %s", product.getEndAddress(), order.getDepartureNumber()));
            }
            if (!product.getAdditionalServices().stream().noneMatch(as -> AdditionalServiceType.TABLE == as.getType()) || !TextUtil.nonBlank((String)order.getTable())) continue;
            AdditionalService freeTable = new AdditionalService();
            freeTable.setPrice(BigDecimal.ZERO);
            freeTable.setCurrency(order.getCurrency());
            freeTable.setType(AdditionalServiceType.TABLE);
            freeTable.setFixed(true);
            freeTable.setDefaultInclude(true);
            product.getAdditionalServices().add(freeTable);
        }
    }

    private String removeNotDefinedString(String string) {
        return string == null ? null : string.replace("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e", "").trim();
    }

    private Traveller findTraveller(List<Traveller> travellers, String name) {
        List<String> names = this.getNames(name);
        for (Traveller tr : travellers) {
            List<String> trNames;
            if (!TextUtil.nonBlank((String)tr.getName()) || !CollectionUtil.equals(names, trNames = this.getNames(tr.getName()), (boolean)true)) continue;
            return tr;
        }
        return null;
    }

    private List<String> getNames(String name) {
        return Arrays.stream(name.split("\\s")).filter(TextUtil::nonBlank).map(n -> n.trim().toLowerCase()).collect(Collectors.toList());
    }
}

