/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.transfers.iway.parsers.registration;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.IwayJsonExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayAPIHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.helpers.IwayHelper;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.IwayOrder;
import com.gridnine.xtrip.server.transfers.iway.nextgen.model.common.Passenger;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;

public class IwayCreateExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        byte[] content = (byte[])ctx.getObject((Enum)IBusParsersContextKeys.DOCUMENT_CONTENT);
        IwayJsonExchangeDocument document = new IwayJsonExchangeDocument();
        document.setStatus(ProcessingStatus.UNPROCESSED);
        document.setContentType(ContentType.JSON);
        document.setCreated(new Date());
        document.setDescription("Iway order info");
        document.setTitle("Iway order info");
        document.setContent(content);
        IwayOrder iwayOrder = null;
        try {
            iwayOrder = (IwayOrder)IwayAPIHelper.MAPPER.readValue(content, IwayOrder.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iwayOrder != null) {
            document.setSystemNumber(iwayOrder.getOrderId());
            document.setBookerNumber(iwayOrder.getBookerNumber());
            ProductStatus productStatus = IwayHelper.getProductStatus(iwayOrder);
            if (productStatus == ProductStatus.BOOKING) {
                document.setTransactionType(TransactionType.BOOKING);
            }
            if (productStatus == ProductStatus.SELL) {
                document.setTransactionType(TransactionType.SELL);
            }
            if (productStatus == ProductStatus.REFUND) {
                document.setTransactionType(TransactionType.REFUND);
            }
            document.setIssueDate(iwayOrder.getDate());
            if (iwayOrder.getPassengers() != null) {
                document.getTravellers().addAll(iwayOrder.getPassengers().stream().map(Passenger::getName).collect(Collectors.toSet()));
            }
        }
        ctx.putObject((Enum)IBusParsersContextKeys.CHECK_SUM, (Object)MiscUtil.getCheckSum((byte[])content));
        ctx.putObject((Enum)IBusParsersContextKeys.REGISTRING_DOCUMENTS_LIST, Collections.singletonList(document));
    }
}

