/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ukraine.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.export.xml.XMLEntityExportHelper;
import com.gridnine.xtrip.common.model.export.xml.XMLFilterHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class BookingFileExportInterceptor
implements EntityInterceptor {
    protected static final Logger log = LoggerFactory.getLogger(BookingFileExportInterceptor.class);
    private static final String ENABLED_PROPERTY_NAME = "ukraine.booking.file.xml.exporter.enabled";
    private static final String PATH_PROPERTY_NAME = "ukraine.booking.file.xml.exporter.path";
    private static final String FILTER_FILE_PROPERTY_NAME = "ukraine.booking.file.xml.exporter.filter.file";
    private static final String FILTER_EXCLUSIVE_PROPERTY_NAME = "ukraine.booking.file.xml.exporter.filter.exclusive";

    public double getPriority() {
        return 2.147483647E9;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        boolean enabled;
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> container = data;
        EntityReference bookingFileReference = container.toReference();
        if (TextUtil.isSame((String)container.getModifiedBy(), (String)"system")) {
            return;
        }
        BookingFile bookingFile = (BookingFile)container.getEntity();
        ExtendedProperties serverProperties = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        String enabledString = serverProperties.getProperty(ENABLED_PROPERTY_NAME, null);
        boolean bl = enabled = !TextUtil.isBlank((String)enabledString) && enabledString.equalsIgnoreCase("true");
        if (enabled) {
            Date issueDate = null;
            for (Reservation reservation : bookingFile.getReservations()) {
                for (BaseProduct baseProduct : reservation.getProducts()) {
                    Date baseProductIssueDate = null;
                    ProductHandler handler = ((HandlersRegistry)Environment.getPublished(HandlersRegistry.class)).findProductHandler(baseProduct.getClass());
                    if (handler != null) {
                        baseProductIssueDate = handler.findIssueDate(baseProduct);
                    }
                    if (baseProductIssueDate == null || issueDate != null && MiscUtil.compare((Date)issueDate, (Date)baseProductIssueDate) >= 0) continue;
                    issueDate = baseProductIssueDate;
                }
            }
            if (issueDate != null) {
                Calendar currentDateCalendar = Calendar.getInstance();
                Calendar issueDateCalendar = Calendar.getInstance();
                issueDateCalendar.setTime(issueDate);
                if (issueDateCalendar.get(5) == currentDateCalendar.get(5)) {
                    ArrayList<Message> messages;
                    Document document;
                    String filterFile = serverProperties.getProperty(FILTER_FILE_PROPERTY_NAME, null);
                    String filterExclusiveString = serverProperties.getProperty(FILTER_EXCLUSIVE_PROPERTY_NAME, null);
                    boolean filterExclusive = TextUtil.isBlank((String)filterExclusiveString) || !filterExclusiveString.equalsIgnoreCase("false");
                    List filters = XMLFilterHelper.getFilters();
                    if (!TextUtil.isBlank((String)filterFile)) {
                        try {
                            if (filterExclusive) {
                                filters.add(XMLFilterHelper.createExclusiveFilter((String)filterFile));
                            } else {
                                filters.add(XMLFilterHelper.createInclusiveFilter((String)filterFile));
                            }
                        }
                        catch (IOException e) {
                            log.warn(String.format("filter file \"%s\" was not found", filterFile), (Throwable)e);
                        }
                    }
                    if ((document = XMLEntityExportHelper.export((BaseEntity)bookingFile, (List)filters, messages = new ArrayList<Message>())) == null || this.hasErrors(messages)) {
                        log.error(String.format("unable to export booking file \"%s\"", bookingFile.getNumber()));
                        return;
                    }
                    String exportPath = serverProperties.getProperty(PATH_PROPERTY_NAME, null);
                    File folder = !TextUtil.isBlank((String)exportPath) ? new File(exportPath) : new File(Environment.getDataFolder(), "export/booking-files");
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                    String currentDateString = dateFormat.format(new Date());
                    String exportFileName = String.format("bookings_%s.xml", currentDateString);
                    if (!folder.isDirectory()) {
                        folder.mkdirs();
                    }
                    File file = new File(folder, exportFileName);
                    try (FileOutputStream outputStream = null;){
                        outputStream = new FileOutputStream(file);
                        Transformer transformer = XUtil.newTransformer();
                        transformer.setOutputProperty("omit-xml-declaration", "no");
                        transformer.setOutputProperty("method", "xml");
                        transformer.setOutputProperty("encoding", "UTF-8");
                        transformer.transform(new DOMSource(document), new StreamResult(outputStream));
                        outputStream.flush();
                        log.info(String.format("booking file \"%s\" was exported successfully to the file \"%s\"", bookingFile.getNumber(), file.getName()));
                        SysLogHelper.audit((EntityReference)bookingFileReference, (String)"entity-modification", (Message[])new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)String.format("\u0437\u0430\u043a\u0430\u0437 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0444\u0430\u0439\u043b \"%s\"", file.getName()), (Object[])new Object[0])});
                    }
                }
                log.debug(String.format("booking file \"%s\" would be not exported since it has expired date \"%s\"", bookingFile.getNumber(), issueDate));
            } else {
                log.debug(String.format("booking file \"%s\" would be not exported since it has no any products with issue date specicifed", bookingFile.getNumber()));
            }
        }
    }

    private boolean hasErrors(List<Message> messages) {
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }
}

