/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ukraine.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;

public class UkraineMulticurrencyBookingFileInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 0.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!"true".equals(ServerConfiguration.get().getConfiguration().getProperty("ukraine.enable-multicurrency-interceptor"))) {
            return;
        }
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> container = data;
        for (Reservation res : ((BookingFile)container.getEntity()).getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof Product)) continue;
                Product product = (Product)bp;
                for (AirProductContractRelationData cr : AirProductHelper.getContractRelations((Product)product)) {
                    for (ProductFop fop : cr.getFops()) {
                        if (fop.getAmount() == null || fop.getAmount().getCurrency() == null || fop.getAmount().getCurrency().equals("UAH")) continue;
                        fop.getAmount().setCurrency("UAH");
                    }
                }
                String currency = null;
                for (ProductFop fop : AirProductHelper.getClientFops((Product)product)) {
                    if (fop.getPaymentAmount() == null || fop.getPaymentAmount().getCurrency() == null) continue;
                    currency = fop.getPaymentAmount().getCurrency();
                }
                if (currency == null || "UAH".equals(currency)) continue;
                for (ProductFop fop : AirProductHelper.getSubagentFops((Product)product, (boolean)false)) {
                    if (fop.getPaymentAmount() == null || fop.getPaymentAmount().getCurrency() != null) continue;
                    fop.getPaymentAmount().setCurrency(currency);
                }
            }
        }
    }
}

