/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ukraine.model.interceptors;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;

public class UkraineProductModificationInterceptor
implements EntityInterceptor {
    private final Consumer<BaseProduct> consumer = baseProduct -> baseProduct.setModified(new Date());
    private final List<Class> ignoredClasses = Arrays.asList(Reservation.class, BaseProduct.class, Traveller.class);

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (BookingFile.class.equals((Object)data.getEntityType())) {
            BookingFile booking = (BookingFile)data.getEntity();
            EntityContainer oldBookingCtr = LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getOldCtr();
            if (oldBookingCtr == null) {
                BookingHelper.getProducts((BookingFile)booking).forEach(this.consumer);
                return;
            }
            if (!MiscUtil.equals((Object)booking.getCustomerProfile(), (Object)((BookingFile)oldBookingCtr.getEntity()).getCustomerProfile())) {
                BookingHelper.getProducts((BookingFile)booking).forEach(this.consumer);
                return;
            }
            if (!MiscUtil.equals((Object)booking.getAgency(), (Object)((BookingFile)oldBookingCtr.getEntity()).getAgency())) {
                BookingHelper.getProducts((BookingFile)booking).forEach(this.consumer);
                return;
            }
            if (!MiscUtil.equals((Object)booking.getNumber(), (Object)((BookingFile)oldBookingCtr.getEntity()).getNumber())) {
                BookingHelper.getProducts((BookingFile)booking).forEach(this.consumer);
                return;
            }
            for (Reservation reservation : booking.getReservations()) {
                Reservation oldReservation = (Reservation)CollectionUtil.find((Iterable)((BookingFile)oldBookingCtr.getEntity()).getReservations(), (String)reservation.getUid());
                if (oldReservation == null) {
                    reservation.getProducts().forEach(this.consumer);
                    continue;
                }
                if (!MiscUtil.equals((Object)reservation.getType(), (Object)oldReservation.getType())) {
                    reservation.getProducts().forEach(this.consumer);
                    continue;
                }
                if (!MiscUtil.equals((Object)reservation.getBookingAgent(), (Object)oldReservation.getBookingAgent())) {
                    reservation.getProducts().forEach(this.consumer);
                    continue;
                }
                if (!MiscUtil.equals((Object)reservation.getResDate(), (Object)oldReservation.getResDate())) {
                    reservation.getProducts().forEach(this.consumer);
                    continue;
                }
                for (BaseProduct product : reservation.getProducts()) {
                    Set<EntityReference<Person>> oldProfiles;
                    Set<EntityReference<Person>> profiles;
                    if (product.getModified() == null) {
                        this.consumer.accept(product);
                        continue;
                    }
                    BaseProduct oldProduct = (BaseProduct)CollectionUtil.find((Iterable)oldReservation.getProducts(), (String)product.getUid());
                    if (oldProduct == null) {
                        this.consumer.accept(product);
                        continue;
                    }
                    if (!this.equals(product, oldProduct)) {
                        this.consumer.accept(product);
                    }
                    if (CollectionUtil.equals(profiles = this.getProfiles(product), oldProfiles = this.getProfiles(oldProduct), (boolean)true)) continue;
                    this.consumer.accept(product);
                }
            }
        }
    }

    private Set<EntityReference<Person>> getProfiles(BaseProduct product) {
        HashSet<EntityReference<Person>> result = new HashSet<EntityReference<Person>>();
        Collection travellers = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers(product);
        for (Traveller traveller : travellers) {
            if (traveller.getPassenger() == null) continue;
            result.add((EntityReference<Person>)traveller.getPassenger());
        }
        return result;
    }

    private boolean equals(BaseProduct product, BaseProduct oldProduct) {
        HashMap<String, String> uidContext = new HashMap<String, String>();
        return this.equals(product, oldProduct, uidContext);
    }

    private boolean equals(Object obj1, Object obj2, Map<String, String> uidContext) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        if (obj1 instanceof Set && obj2 instanceof Set) {
            Set set1 = (Set)obj1;
            Set set2 = (Set)obj2;
            return CollectionUtil.equals((Collection)set1, (Collection)set2, (c1, c2) -> this.equals(c1, c2, uidContext), (boolean)false);
        }
        if (obj1 instanceof List && obj2 instanceof List) {
            List list1 = (List)obj1;
            List list2 = (List)obj2;
            return CollectionUtil.equals((Collection)list1, (Collection)list2, (c1, c2) -> this.equals(c1, c2, uidContext), (boolean)true);
        }
        if (obj1 instanceof Map && obj2 instanceof Map) {
            Map map1 = (Map)obj1;
            Map map2 = (Map)obj2;
            return CollectionUtil.equals(map1.entrySet(), map2.entrySet(), (e1, e2) -> this.equals(((Map.Entry)e1).getKey(), ((Map.Entry)e2).getKey(), uidContext) && this.equals(((Map.Entry)e1).getValue(), ((Map.Entry)e2).getValue(), uidContext), (boolean)false);
        }
        if (obj1 instanceof BaseEntity && obj2 instanceof BaseEntity && obj1.getClass().getName().equals(obj2.getClass().getName())) {
            if (!uidContext.isEmpty()) {
                for (Class cls : this.ignoredClasses) {
                    if (!cls.isAssignableFrom(obj1.getClass())) continue;
                    return true;
                }
            }
            EntityType entityType = MetaRegistryHelper.getEntityType((String)obj1.getClass().getName());
            BaseEntity be1 = (BaseEntity)obj1;
            BaseEntity be2 = (BaseEntity)obj2;
            if (uidContext.containsKey(be1.getUid())) {
                return be2.getUid().equals(uidContext.get(be1.getUid()));
            }
            uidContext.put(be1.getUid(), be2.getUid());
            for (Property property : MetaRegistryHelper.getAllProperties((EntityType)entityType).values()) {
                if (this.equals(be1.getValue(property.getId()), be2.getValue(property.getId()), uidContext)) continue;
                return false;
            }
            for (EntityCollection collection : MetaRegistryHelper.getAllCollections((BaseClassType)entityType).values()) {
                if (this.equals(be1.getValue(collection.getId()), be2.getValue(collection.getId()), uidContext)) continue;
                return false;
            }
            return true;
        }
        if (this.isObjectEqualsApplicable(obj1) && this.isObjectEqualsApplicable(obj2)) {
            return obj1.equals(obj2);
        }
        if (obj1 instanceof byte[] && obj2 instanceof byte[]) {
            byte[] ba1 = (byte[])obj1;
            byte[] ba2 = (byte[])obj2;
            return Arrays.equals(ba1, ba2);
        }
        if (obj1 instanceof HistoricalValue && obj2 instanceof HistoricalValue) {
            HistoricalValue hv1 = (HistoricalValue)obj1;
            HistoricalValue hv2 = (HistoricalValue)obj2;
            return MiscUtil.equals((Object)hv1.getDate(), (Object)hv2.getDate()) && this.equals(hv1.getValue(), hv2.getValue(), uidContext);
        }
        return true;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    private boolean isObjectEqualsApplicable(Object obj) {
        if (obj instanceof MiscUtil.Pair) {
            MiscUtil.Pair pair = (MiscUtil.Pair)obj;
            return !(pair.getFirst() != null && !this.isObjectEqualsApplicable(pair.getFirst()) || pair.getSecond() != null && !this.isObjectEqualsApplicable(pair.getSecond()));
        }
        return obj instanceof Enum || obj instanceof DictionaryReference || obj instanceof String || obj instanceof LocalDateTime || obj instanceof LocalDate || obj instanceof Byte || obj instanceof Date || obj instanceof Locale || obj instanceof Long || obj instanceof Boolean || obj instanceof Double || obj instanceof org.joda.time.LocalDateTime || obj instanceof DateTime || obj instanceof BigDecimal || obj instanceof java.time.LocalTime || obj instanceof org.joda.time.LocalDate || obj instanceof Integer || obj instanceof URL || obj instanceof Float || obj instanceof LocalTime || obj instanceof EntityReference || obj instanceof VatAmount || obj instanceof L10nMessage || obj instanceof L10nString || obj instanceof SearchCriterion;
    }

    public double getPriority() {
        return 1.0E7;
    }
}

