/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ukraine.utils.c1;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.ukraine.model.rules.standard.StandardRuleEnvironment;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.ukraine.utils.c1.XMLImportTestUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Obriy1CImportTest
extends ModelTestBase {
    private static final boolean DETAILED_MESSAGE = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1CImport() throws Exception {
        Node node;
        System.out.println("testing 1C import!");
        Document sourceDocument = XMLImportTestUtil.getSourceDocument(new File("C:/import/source/microsoft.xml"));
        ArrayList<Message> messages = new ArrayList<Message>();
        List<Document> convertDocuments = XMLImportTestUtil.convert(sourceDocument, messages);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("= MESSAGES ====================================");
        stringBuilder.append("\n");
        for (Message message : messages) {
            if (message.getType() != MessageType.MESSAGE) continue;
            stringBuilder.append(message.getMessage().toString());
            stringBuilder.append("\n");
            stringBuilder.append(message.getDetails());
            stringBuilder.append("\n");
            if (!message.getMessage().getParameters().isEmpty()) {
                node = (Node)message.getMessage().getParameters().get(0);
                stringBuilder.append(XMLImportTestUtil.toString(node));
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("= WARNINGS ====================================");
        stringBuilder.append("\n");
        for (Message message : messages) {
            if (message.getType() != MessageType.WARNING && message.getType() != MessageType.ERROR) continue;
            stringBuilder.append(message.getMessage().toString());
            stringBuilder.append("\n");
            stringBuilder.append(message.getDetails());
            stringBuilder.append("\n");
            if (!message.getMessage().getParameters().isEmpty()) {
                node = (Node)message.getMessage().getParameters().get(0);
                stringBuilder.append(XMLImportTestUtil.toString(node));
            }
            stringBuilder.append("\n");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File("C://import/import.log"))), "utf-8");
        try {
            outputStreamWriter.write(stringBuilder.toString());
        }
        finally {
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(new File("C://import/import.zip"))));){
            zipOutputStream.setComment("1C to Mid Office Manager convert");
            int count = 0;
            for (Document convertDocument : convertDocuments) {
                zipOutputStream.putNextEntry(new ZipEntry(String.format("%08d.xml", count + 1)));
                Transformer transformer = XUtil.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                try {
                    transformer.transform(new DOMSource(convertDocument), new StreamResult(zipOutputStream));
                    ++count;
                }
                finally {
                    zipOutputStream.closeEntry();
                }
            }
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        RulesEnvironment rulesEnvironment = (RulesEnvironment)Environment.getPublished(RulesEnvironment.class);
        new StandardRuleEnvironment().environmentInitialized(rulesEnvironment);
    }

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("dictionaries.xml");
    }
}

