/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ukraine.utils.c1;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BusinessType;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.CostCodeCategoryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.dict.ProfileCategory;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PaymentConditionItem;
import com.gridnine.xtrip.common.model.profile.PeriodicityOfPayment;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationAdditionalTargets;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.MetadataKeyCategory;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptor;
import com.gridnine.xtrip.common.model.system.MetadataValueType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.ukraine.model.rules.standard.Properties;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.MaskFormatter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLImportTestUtil {
    private static final int MAX_ENTRIES_PER_DOCUMENT = 600;
    private static final String IMPORTER = "importer";
    private static final String EMPTY_UID = "00000000-0000-0000-0000-000000000000";
    private static final String EMPTY_DATE = "0001-01-01T00:00:00";
    private static final String ORGANIZATION_BUSINESS_TYPE_KEY_DESCRIPTOR_CODE = "KEY_ORGANIZATION_BUSINESS_TYPE";
    private static final String ORGANIZATION_PROFILE_CATEGORY_KEY_DESCRIPTOR_CODE = "KEY_ORGANIZATION_PROFILE_CATEGORY";
    private static final String AIR_SELL_FEE_FIXED_COMMISSION_CATEGORY_CODE = "COMMISSION_CATEGORY_AIR_SELL_FEE_FIXED";
    private static final String AIR_SELL_FEE_PERCENT_COMMISSION_CATEGORY_CODE = "COMMISSION_CATEGORY_AIR_SELL_FEE_PERCENT";
    private static final String AIR_REFUND_FEE_FIXED_COMMISSION_CATEGORY_CODE = "COMMISSION_CATEGORY_AIR_REFUND_FEE_FIXED";
    private static final String AIR_REFUND_FEE_PERCENT_COMMISSION_CATEGORY_CODE = "COMMISSION_CATEGORY_AIR_REFUND_FEE_PERCENT";
    private static final String AIR_SELL_FEE_FIXED_COMMISSION_PROPERTIES_UID = "COMMISSION_PROPERTIES_AIR_SELL_FEE_FIXED";
    private static final String AIR_SELL_FEE_PERCENT_COMMISSION_PROPERTIES_UID = "COMMISSION_PROPERTIES_AIR_SELL_FEE_PERCENT";
    private static final String AIR_REFUND_FEE_FIXED_COMMISSION_PROPERTIES_UID = "COMMISSION_PROPERTIES_AIR_REFUND_FEE_FIXED";
    private static final String AIR_REFUND_FEE_PERCENT_COMMISSION_PROPERTIES_UID = "COMMISSION_PROPERTIES_AIR_REFUND_FEE_PERCENT";
    private static final String SERVICE_ANY_ID = "ANY";
    private static EntityReference<Organization> agencyReference;
    private static final Map<String, EntityContainer<? extends BaseEntity>> entityContainers;
    private static final Map<String, Object> objects;
    private static final Map<String, BaseDictionary> dictionaryContainers;
    private static final DateFormat C1_DATE_FORMAT;
    private static final DateFormat DATE_FORMAT;
    private static final RuleSettingRestrictionsEqualator ruleSettingRestrictionsEqualator;
    private static final RuleSettingsPeriodComparator ruleSettingsPeriodComparator;
    private static final RuleSettingsPriorityComparator ruleSettingsPriorityComparator;
    private static final Map<String, String> personPositions;
    private static final Map<String, String> profileGroupsNameToUid;
    private static final Map<String, String> profileGroupsUidToUid;

    public static List<Document> convert(Document sourceDocument, List<Message> messages) throws Exception {
        Calendar startCalendar = Calendar.getInstance();
        XMLImportTestUtil.createRequiredDictionaries(sourceDocument, messages);
        XMLImportTestUtil.createRequiredEntities(sourceDocument, messages);
        Calendar endCalendar = Calendar.getInstance();
        System.out.println(String.format(" -> STARTED -> %s", DATE_FORMAT.format(startCalendar.getTime())));
        System.out.println(String.format(" -> FINISHED -> %s", DATE_FORMAT.format(endCalendar.getTime())));
        long estimatedTime = endCalendar.getTimeInMillis() - startCalendar.getTimeInMillis();
        String hours = String.format("%02d", estimatedTime / 1000L / 3600L);
        String minutes = String.format("%02d", estimatedTime / 1000L / 60L);
        String seconds = String.format("%02d", estimatedTime / 1000L % 60L);
        System.out.println(String.format(" -> ESTIMATED TIME -> %s:%s:%s", hours, minutes, seconds));
        ArrayList<Document> convertDocuments = new ArrayList<Document>();
        Document convertDocument = null;
        Node element = null;
        int count = 0;
        for (EntityContainer<? extends BaseEntity> entityContainer : entityContainers.values()) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                convertDocuments.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element entityElement = XMLImportTestUtil.createEntityContainerElement(convertDocument, entityContainer);
            element.appendChild(entityElement);
            element.setAttribute("totalCount", String.valueOf(count + 1));
            ++count;
        }
        for (BaseDictionary dictionaryContainer : dictionaryContainers.values()) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                convertDocuments.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element dictionaryElement = XMLImportTestUtil.createDictionatyContainerElement(convertDocument, dictionaryContainer);
            element.appendChild(dictionaryElement);
            element.setAttribute("totalCount", String.valueOf(count + 1));
            ++count;
        }
        return convertDocuments;
    }

    public static void convertCurrencies(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceCurrencyNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0412\u0430\u043b\u044e\u0442\u044b");
        for (int i = 0; i < sourceCurrencyNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> CURRENCY FROM CURRENCY -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceCurrencyNodeList.getLength())));
            Element sourceCurrencyElement = (Element)sourceCurrencyNodeList.item(i);
            XMLImportTestUtil.createCurrency(sourceDocument, sourceCurrencyElement, messages);
        }
    }

    public static void convertGroups(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourcePersonNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430");
        for (int i = 0; i < sourcePersonNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> PROFILE GROUP FROM PERSON -> %s of %s", String.valueOf(i + 1), String.valueOf(sourcePersonNodeList.getLength())));
            Element sourceUserElement = (Element)sourcePersonNodeList.item(i);
            XMLImportTestUtil.createProfileGroupFromPerson(sourceDocument, sourceUserElement, messages);
        }
        NodeList sourceUserNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438");
        for (int i = 0; i < sourceUserNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> PROFILE GROUP FROM USER -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceUserNodeList.getLength())));
            Element sourceUserElement = (Element)sourceUserNodeList.item(i);
            XMLImportTestUtil.createProfileGroupFromUser(sourceDocument, sourceUserElement, messages);
        }
    }

    public static void convertBusinessTypes(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceBusinessTypeNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0412\u0438\u0434\u044b\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432");
        for (int i = 0; i < sourceBusinessTypeNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> BUSINESS TYPE FROM BUSINESS TYPE -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceBusinessTypeNodeList.getLength())));
            Element sourceBusinessTypeElement = (Element)sourceBusinessTypeNodeList.item(i);
            XMLImportTestUtil.createBusinessType(sourceDocument, sourceBusinessTypeElement, messages);
        }
    }

    public static void convertOrganizationRoles(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceOrganizationRolesNodeList = sourceDocument.getElementsByTagName("CatalogObject.CRM_\u0422\u0438\u043f\u044b\u041e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439\u0421\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430\u043c\u0438");
        for (int i = 0; i < sourceOrganizationRolesNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> ORGANIZATION ROLES FROM CONTRAGENT RELATIONSHIP TYPES -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceOrganizationRolesNodeList.getLength())));
            Element sourceOrganizationRolesElement = (Element)sourceOrganizationRolesNodeList.item(i);
            XMLImportTestUtil.createOrganizationRole(sourceDocument, sourceOrganizationRolesElement, messages);
        }
    }

    public static void convertOrganizations(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceAgencyNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438");
        for (int i = 0; i < sourceAgencyNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> ORGANIZATION FROM AGENCY -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceAgencyNodeList.getLength())));
            Element sourceAgencyElement = (Element)sourceAgencyNodeList.item(i);
            XMLImportTestUtil.createOrganizationContainerFromAgency(sourceDocument, sourceAgencyElement, messages);
        }
        NodeList sourceContragentNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b");
        for (int i = 0; i < sourceContragentNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> ORGANIZATION FROM CONTRAGENT -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceContragentNodeList.getLength())));
            Element sourceContragentElement = (Element)sourceContragentNodeList.item(i);
            XMLImportTestUtil.createOrganizationContainerFromContragent(sourceDocument, sourceContragentElement, messages);
        }
    }

    public static void convertVatPayers(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceVATPayerNodeList = sourceDocument.getElementsByTagName("InformationRegisterRecordSet.Fort_\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0438\u041d\u0414\u0421");
        for (int i = 0; i < sourceVATPayerNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> VAT PAYER FROM VAT PAYER -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceVATPayerNodeList.getLength())));
            Element sourceVATPayerElement = (Element)sourceVATPayerNodeList.item(i);
            XMLImportTestUtil.createVATPayer(sourceDocument, sourceVATPayerElement, messages);
        }
    }

    public static void convertBanks(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceBankNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0411\u0430\u043d\u043a\u0438");
        for (int i = 0; i < sourceBankNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> BANK FROM BANK -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceBankNodeList.getLength())));
            Element sourceBankElement = (Element)sourceBankNodeList.item(i);
            XMLImportTestUtil.createBank(sourceDocument, sourceBankElement, messages);
        }
    }

    public static void convertBankAccounts(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceBankAccountNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430");
        for (int i = 0; i < sourceBankAccountNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> BANK ACCOUNT FROM BANK ACCOUNT -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceBankAccountNodeList.getLength())));
            Element sourceBankAccountElement = (Element)sourceBankAccountNodeList.item(i);
            XMLImportTestUtil.createBankAccount(sourceDocument, sourceBankAccountElement, messages);
        }
    }

    public static void convertCostCodes(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceCostCodeCategoryNodeList = sourceDocument.getElementsByTagName("CatalogObject.Fort_\u041a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0422\u0438\u043f\u043e\u0432\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432");
        for (int i = 0; i < sourceCostCodeCategoryNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> COST CODE CATEGORY FROM COST CODE CLASSIFIER -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceCostCodeCategoryNodeList.getLength())));
            Element costCodeCategoryElement = (Element)sourceCostCodeCategoryNodeList.item(i);
            XMLImportTestUtil.createCostCodeCategoryContainer(sourceDocument, costCodeCategoryElement, messages);
        }
        NodeList sourceCostCodePropertiesNodeList = sourceDocument.getElementsByTagName("CatalogObject.Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432");
        for (int i = 0; i < sourceCostCodePropertiesNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> COST CODE PROPERTIES FROM CONTRAGENT COST CODE TYPE -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceCostCodePropertiesNodeList.getLength())));
            Element costCodePropertiesElement = (Element)sourceCostCodePropertiesNodeList.item(i);
            XMLImportTestUtil.createCostCodeProperties(sourceDocument, costCodePropertiesElement, messages);
        }
        NodeList sourceCostCodeNodeList = sourceDocument.getElementsByTagName("CatalogObject.Fort_\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u044b\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435");
        for (int i = 0; i < sourceCostCodeNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> COST CODE FROM COST CODE -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceCostCodeNodeList.getLength())));
            Element costCodeElement = (Element)sourceCostCodeNodeList.item(i);
            XMLImportTestUtil.createCostCode(sourceDocument, costCodeElement, messages);
        }
    }

    public static void convertCostCodes2(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceCostCodeCategoryNodeList = sourceDocument.getElementsByTagName("CatalogObject.Fort_\u041a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0422\u0438\u043f\u043e\u0432\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432");
        for (int i = 0; i < sourceCostCodeCategoryNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> COST CODE CATEGORY FROM COST CODE CLASSIFIER -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceCostCodeCategoryNodeList.getLength())));
            Element costCodeCategoryElement = (Element)sourceCostCodeCategoryNodeList.item(i);
            XMLImportTestUtil.createCostCodeCategoryContainer(sourceDocument, costCodeCategoryElement, messages);
        }
        NodeList sourceCostCodePropertiesNodeList = sourceDocument.getElementsByTagName("CatalogObject.Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432");
        for (int i = 0; i < sourceCostCodePropertiesNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> COST CODE PROPERTIES FROM CONTRAGENT COST CODE TYPE -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceCostCodePropertiesNodeList.getLength())));
            Element costCodePropertiesElement = (Element)sourceCostCodePropertiesNodeList.item(i);
            XMLImportTestUtil.createCostCodeProperties2(sourceDocument, costCodePropertiesElement, messages);
        }
    }

    public static void convertReasonCodes(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceReasonCodeNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u041e\u0422_\u0420\u0438\u0437\u043e\u043d\u041a\u043e\u0434\u0430");
        for (int i = 0; i < sourceReasonCodeNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> REASON CODE FROM REASON CODE -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceReasonCodeNodeList.getLength())));
            Element sourceReasonCodeElement = (Element)sourceReasonCodeNodeList.item(i);
            XMLImportTestUtil.createReasonCode(sourceDocument, sourceReasonCodeElement, messages);
        }
    }

    public static void convertPersonPositions(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourcePersonPositionNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u0438\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0439");
        for (int i = 0; i < sourcePersonPositionNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> PERSON POSITION FROM POSITION -> %s of %s", String.valueOf(i + 1), String.valueOf(sourcePersonPositionNodeList.getLength())));
            Element sourcePersonPositionElement = (Element)sourcePersonPositionNodeList.item(i);
            XMLImportTestUtil.createPersonPositionFromPosition(sourceDocument, sourcePersonPositionElement, messages);
        }
    }

    public static void convertPersons(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourcePersonNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430");
        for (int i = 0; i < sourcePersonNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> MANAGER FROM PERSON -> %s of %s", String.valueOf(i + 1), String.valueOf(sourcePersonNodeList.getLength())));
            Element sourcePersonElement = (Element)sourcePersonNodeList.item(i);
            XMLImportTestUtil.createManagerContainerFromPerson(sourceDocument, sourcePersonElement, messages);
        }
        NodeList sourceUserNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438");
        for (int i = 0; i < sourceUserNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> AGENT FROM USER -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceUserNodeList.getLength())));
            Element sourceUserElement = (Element)sourceUserNodeList.item(i);
            XMLImportTestUtil.createAgentContainerFromUser(sourceDocument, sourceUserElement, messages);
        }
        NodeList sourceContactNameNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430");
        for (int i = 0; i < sourceContactNameNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> MANAGER FROM CONTACT NAME -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceContactNameNodeList.getLength())));
            Element sourceContractNameElement = (Element)sourceContactNameNodeList.item(i);
            XMLImportTestUtil.createManagerContainerFromContactName(sourceDocument, sourceContractNameElement, messages);
        }
        NodeList sourceContragentContactNameNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432");
        for (int i = 0; i < sourceContragentContactNameNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> PASSENGER FROM CONTRAGENT CONTACT NAME -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceContragentContactNameNodeList.getLength())));
            Element sourceContragentContractNameElement = (Element)sourceContragentContactNameNodeList.item(i);
            XMLImportTestUtil.createPassengerContainerFromContragentContactName(sourceDocument, sourceContragentContractNameElement, messages);
        }
    }

    public static void convertCommunicationsOrAddresses(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceContactInfoTypeNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0412\u0438\u0434\u044b\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438");
        for (int i = 0; i < sourceContactInfoTypeNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> COMMUNICATION OR ADDRESS TYPE FROM CONTACT INFO TYPE -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceContactInfoTypeNodeList.getLength())));
            Element sourceContactInfoTypeElement = (Element)sourceContactInfoTypeNodeList.item(i);
            XMLImportTestUtil.createCommunicationOrAddressType(sourceDocument, sourceContactInfoTypeElement, messages);
        }
        NodeList sourceContactInfoRegisterNodeList = sourceDocument.getElementsByTagName("InformationRegisterRecordSet.\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
        for (int i = 0; i < sourceContactInfoRegisterNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> COMMUNICATION OR ADDRESS FROM CONTACT INFO -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceContactInfoRegisterNodeList.getLength())));
            Element sourceContactInfoRegisterElement = (Element)sourceContactInfoRegisterNodeList.item(i);
            XMLImportTestUtil.createCommunicationOrAddress(sourceDocument, sourceContactInfoRegisterElement, messages);
        }
    }

    public static void convertMetadatas(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceObjectCategoryNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        for (int i = 0; i < sourceObjectCategoryNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> PROFILE CATEGORY FROM OBJECT CATEGORY -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceObjectCategoryNodeList.getLength())));
            Element sourceObjectCategoryElement = (Element)sourceObjectCategoryNodeList.item(i);
            XMLImportTestUtil.createProfileCategory(sourceDocument, sourceObjectCategoryElement, messages);
        }
        NodeList sourceObjectCategoryRegisterNodeList = sourceDocument.getElementsByTagName("InformationRegisterRecordSet.\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        for (int i = 0; i < sourceObjectCategoryRegisterNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> METADATA FROM OBJECT CATEGORY REGISTER -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceObjectCategoryRegisterNodeList.getLength())));
            Element sourceObjectCategoryRegisterElement = (Element)sourceObjectCategoryRegisterNodeList.item(i);
            XMLImportTestUtil.createMetadataFromCategory(sourceDocument, sourceObjectCategoryRegisterElement, messages);
        }
        NodeList sourceObjectPropertiesNodeList = sourceDocument.getElementsByTagName("ChartOfCharacteristicTypesObject.\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        for (int i = 0; i < sourceObjectPropertiesNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> METADATA KEY DESCRIPTOR FROM OBJECT PROPERTIES -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceObjectPropertiesNodeList.getLength())));
            Element sourceObjectPropertiesElement = (Element)sourceObjectPropertiesNodeList.item(i);
            XMLImportTestUtil.createMetadataKeyDescriptor(sourceDocument, sourceObjectPropertiesElement, messages);
        }
        NodeList sourceObjectPropertiesValueNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        for (int i = 0; i < sourceObjectPropertiesValueNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> METADATA VALUE FROM OBJECT PROPERTIES VALUE -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceObjectPropertiesValueNodeList.getLength())));
            Element sourceObjectPropertiesValueElement = (Element)sourceObjectPropertiesValueNodeList.item(i);
            XMLImportTestUtil.createMetadataValue(sourceDocument, sourceObjectPropertiesValueElement, messages);
        }
        NodeList sourceObjectPropertiesValuesRegisterNodeList = sourceDocument.getElementsByTagName("InformationRegisterRecordSet.\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        for (int i = 0; i < sourceObjectPropertiesValuesRegisterNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> METADATA FROM OBJECT PROPERTIES VALUE REGISTER -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceObjectPropertiesValuesRegisterNodeList.getLength())));
            Element sourceObjectPropertiesValuesRegisterElement = (Element)sourceObjectPropertiesValuesRegisterNodeList.item(i);
            XMLImportTestUtil.createMetadataFromProperties(sourceDocument, sourceObjectPropertiesValuesRegisterElement, messages);
        }
    }

    public static void convertCities(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceCityNodeList = sourceDocument.getElementsByTagName("CatalogObject.Fort_\u0413\u043e\u0440\u043e\u0434\u0430");
        for (int i = 0; i < sourceCityNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> GEO LOCATION FROM CITY -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceCityNodeList.getLength())));
            Element sourceCityElement = (Element)sourceCityNodeList.item(i);
            XMLImportTestUtil.createCity(sourceDocument, sourceCityElement, messages);
        }
    }

    public static void convertContracts(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceContragentContractNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432");
        for (int i = 0; i < sourceContragentContractNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> CONTRACT FROM CONTRAGENT CONTRACT -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceContragentContractNodeList.getLength())));
            Element sourceContragentContractElement = (Element)sourceContragentContractNodeList.item(i);
            XMLImportTestUtil.createContractFromContragentContract(sourceDocument, sourceContragentContractElement, messages);
        }
    }

    public static void convertContractClassesOfService(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceClassificationPriceTypeNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0422\u0438\u043f\u044b\u0426\u0435\u043d\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b");
        for (int i = 0; i < sourceClassificationPriceTypeNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> CONTRACT CLASS OF SERVICE RESTRICTION FROM CLAFFICATION PRICE TYPE -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceClassificationPriceTypeNodeList.getLength())));
            Element sourceClassificationPriceTypeElement = (Element)sourceClassificationPriceTypeNodeList.item(i);
            XMLImportTestUtil.createContractClassOfServiceRestrictions(sourceDocument, sourceClassificationPriceTypeElement, messages);
        }
    }

    public static void convertContractClassificationSpecifications(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceClassificationSpecificationsNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b");
        for (int i = 0; i < sourceClassificationSpecificationsNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> CONTRACT AIRLINE RESTRICTION FROM CLASSIFICATION SPECIFICATIONS -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceClassificationSpecificationsNodeList.getLength())));
            Element sourceClassificationSpecificationsElement = (Element)sourceClassificationSpecificationsNodeList.item(i);
            XMLImportTestUtil.createContractAirlineRestrictions(sourceDocument, sourceClassificationSpecificationsElement, messages);
        }
    }

    public static void convertContractDirections(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceDirectionNodeList = sourceDocument.getElementsByTagName("CatalogObject.\u041e\u0422_\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f");
        for (int i = 0; i < sourceDirectionNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> CONTRACT ROUTE RESTRICTION FROM DIRECTION -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceDirectionNodeList.getLength())));
            Element sourceDirectionElement = (Element)sourceDirectionNodeList.item(i);
            XMLImportTestUtil.createContractDirectionRestrictions(sourceDocument, sourceDirectionElement, messages);
        }
    }

    public static void convertContractRules(Document sourceDocument, List<Message> messages) throws Exception {
        NodeList sourceMarginDicountsRegisterNodeList = sourceDocument.getElementsByTagName("InformationRegisterRecordSet.\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b");
        for (int i = 0; i < sourceMarginDicountsRegisterNodeList.getLength(); ++i) {
            System.out.println(String.format(" -> CONTRACT RULES FROM MARGIN DISCOUNTS -> %s of %s", String.valueOf(i + 1), String.valueOf(sourceMarginDicountsRegisterNodeList.getLength())));
            Element sourceMarginDicountsRegisterElement = (Element)sourceMarginDicountsRegisterNodeList.item(i);
            XMLImportTestUtil.createContractRules(sourceDocument, sourceMarginDicountsRegisterElement, messages);
        }
    }

    private static void createRequiredDictionaries(Document sourceDocument, List<Message> messages) throws Exception {
        MetadataKeyDescriptor organizationBusinessTypeKeyDescriptorContainer = XMLImportTestUtil.createDictionaryContainer(MetadataKeyDescriptor.class, ORGANIZATION_BUSINESS_TYPE_KEY_DESCRIPTOR_CODE);
        organizationBusinessTypeKeyDescriptorContainer.setCategory(MetadataKeyCategory.ORGANIZATION);
        organizationBusinessTypeKeyDescriptorContainer.setValueType(MetadataValueType.BUSINESS_TYPE);
        organizationBusinessTypeKeyDescriptorContainer.setPredefined(false);
        organizationBusinessTypeKeyDescriptorContainer.getTranslations().put(new Locale("en"), "Business type");
        organizationBusinessTypeKeyDescriptorContainer.getTranslations().put(new Locale("ru", "RU"), "\u0412\u0438\u0434 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438");
        organizationBusinessTypeKeyDescriptorContainer.getTranslations().put(new Locale("uk", "UA"), "\u0412\u0438\u0434 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438");
        dictionaryContainers.put(ORGANIZATION_BUSINESS_TYPE_KEY_DESCRIPTOR_CODE, (BaseDictionary)organizationBusinessTypeKeyDescriptorContainer);
        MetadataKeyDescriptor organizationProfileCategoryKeyDescriptorContainer = XMLImportTestUtil.createDictionaryContainer(MetadataKeyDescriptor.class, ORGANIZATION_PROFILE_CATEGORY_KEY_DESCRIPTOR_CODE);
        organizationProfileCategoryKeyDescriptorContainer.setCategory(MetadataKeyCategory.ORGANIZATION);
        organizationProfileCategoryKeyDescriptorContainer.setValueType(MetadataValueType.PROFILE_CATEGORY);
        organizationProfileCategoryKeyDescriptorContainer.setPredefined(false);
        organizationProfileCategoryKeyDescriptorContainer.getTranslations().put(new Locale("en"), "Profiles Category");
        organizationProfileCategoryKeyDescriptorContainer.getTranslations().put(new Locale("ru", "RU"), "\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043f\u0440\u043e\u0444\u0438\u043b\u0435\u0439");
        organizationProfileCategoryKeyDescriptorContainer.getTranslations().put(new Locale("uk", "UA"), "\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043f\u0440\u043e\u0444\u0438\u043b\u0435\u0439");
        dictionaryContainers.put(ORGANIZATION_PROFILE_CATEGORY_KEY_DESCRIPTOR_CODE, (BaseDictionary)organizationProfileCategoryKeyDescriptorContainer);
        CommissionCategory airSellFeeFixedCommissionCategoryContainer = XMLImportTestUtil.createDictionaryContainer(CommissionCategory.class, AIR_SELL_FEE_FIXED_COMMISSION_CATEGORY_CODE);
        airSellFeeFixedCommissionCategoryContainer.getTranslations().put(new Locale("en"), "Air Sell Fee Fixed");
        airSellFeeFixedCommissionCategoryContainer.getTranslations().put(new Locale("ru", "RU"), "\u0421\u0431\u043e\u0440 \u0437\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (\u0444\u0438\u043a\u0441)");
        airSellFeeFixedCommissionCategoryContainer.getTranslations().put(new Locale("uk", "UA"), "\u0421\u0431\u043e\u0440 \u0437\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (\u0444\u0438\u043a\u0441)");
        dictionaryContainers.put(AIR_SELL_FEE_FIXED_COMMISSION_CATEGORY_CODE, (BaseDictionary)airSellFeeFixedCommissionCategoryContainer);
        CommissionCategory airSellFeePercentCommissionCategoryContainer = XMLImportTestUtil.createDictionaryContainer(CommissionCategory.class, AIR_SELL_FEE_PERCENT_COMMISSION_CATEGORY_CODE);
        airSellFeePercentCommissionCategoryContainer.getTranslations().put(new Locale("en"), "Air Sell Fee Percent");
        airSellFeePercentCommissionCategoryContainer.getTranslations().put(new Locale("ru", "RU"), "\u0421\u0431\u043e\u0440 \u0437\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (%)");
        airSellFeePercentCommissionCategoryContainer.getTranslations().put(new Locale("uk", "UA"), "\u0421\u0431\u043e\u0440 \u0437\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (%)");
        dictionaryContainers.put(AIR_SELL_FEE_PERCENT_COMMISSION_CATEGORY_CODE, (BaseDictionary)airSellFeePercentCommissionCategoryContainer);
        CommissionCategory airRefundFeeFixedCommissionCategoryContainer = XMLImportTestUtil.createDictionaryContainer(CommissionCategory.class, AIR_REFUND_FEE_FIXED_COMMISSION_CATEGORY_CODE);
        airRefundFeeFixedCommissionCategoryContainer.getTranslations().put(new Locale("en"), "Air Refund Fee Fixed");
        airRefundFeeFixedCommissionCategoryContainer.getTranslations().put(new Locale("ru", "RU"), "\u0421\u0431\u043e\u0440 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (\u0444\u0438\u043a\u0441)");
        airRefundFeeFixedCommissionCategoryContainer.getTranslations().put(new Locale("uk", "UA"), "\u0421\u0431\u043e\u0440 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (\u0444\u0438\u043a\u0441)");
        dictionaryContainers.put(AIR_REFUND_FEE_FIXED_COMMISSION_CATEGORY_CODE, (BaseDictionary)airRefundFeeFixedCommissionCategoryContainer);
        CommissionCategory airRefundFeePercentCommissionCategoryContainer = XMLImportTestUtil.createDictionaryContainer(CommissionCategory.class, AIR_REFUND_FEE_PERCENT_COMMISSION_CATEGORY_CODE);
        airRefundFeePercentCommissionCategoryContainer.getTranslations().put(new Locale("en"), "Air Refund Fee Percent");
        airRefundFeePercentCommissionCategoryContainer.getTranslations().put(new Locale("ru", "RU"), "\u0421\u0431\u043e\u0440 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (%)");
        airRefundFeePercentCommissionCategoryContainer.getTranslations().put(new Locale("uk", "UA"), "\u0421\u0431\u043e\u0440 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (%)");
        dictionaryContainers.put(AIR_REFUND_FEE_PERCENT_COMMISSION_CATEGORY_CODE, (BaseDictionary)airRefundFeePercentCommissionCategoryContainer);
    }

    private static void createRequiredEntities(Document sourceDocument, List<Message> messages) throws Exception {
        EntityContainer<FeeProperties> airSellFeeFixedCommissionPropertiesContainer = XMLImportTestUtil.createEntityContainer(FeeProperties.class, AIR_SELL_FEE_FIXED_COMMISSION_PROPERTIES_UID);
        FeeProperties airSellFeeFixedCommissionProperties = (FeeProperties)airSellFeeFixedCommissionPropertiesContainer.getEntity();
        CommissionCategory airSellFeeFixedCommissionCategory = (CommissionCategory)dictionaryContainers.get(AIR_SELL_FEE_FIXED_COMMISSION_CATEGORY_CODE);
        airSellFeeFixedCommissionProperties.setCategory((DictionaryReference)airSellFeeFixedCommissionCategory.toReference());
        airSellFeeFixedCommissionProperties.setDisplayName("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (\u0444\u0438\u043a\u0441)");
        airSellFeeFixedCommissionProperties.setRate(false);
        airSellFeeFixedCommissionProperties.setType(FeeType.STANDARD);
        airSellFeeFixedCommissionProperties.setRoundingMode(RoundingMode.MATH);
        airSellFeeFixedCommissionProperties.setRoundingValue(RoundingValue.V_0_0_1);
        airSellFeeFixedCommissionProperties.setOperation(Operation.SELL);
        airSellFeeFixedCommissionProperties.setCalculateFromDifference(false);
        airSellFeeFixedCommissionProperties.setCalculationBasis(null);
        airSellFeeFixedCommissionProperties.setCalculationType(CalculationType.TICKET);
        airSellFeeFixedCommissionProperties.getReturnCases().clear();
        airSellFeeFixedCommissionProperties.getRouteTypes().clear();
        airSellFeeFixedCommissionProperties.getProductTypes().add(ProductType.AIR_TICKET);
        entityContainers.put(AIR_SELL_FEE_FIXED_COMMISSION_PROPERTIES_UID, airSellFeeFixedCommissionPropertiesContainer);
        EntityContainer<FeeProperties> airSellFeePercentCommissionPropertiesContainer = XMLImportTestUtil.createEntityContainer(FeeProperties.class, AIR_SELL_FEE_PERCENT_COMMISSION_PROPERTIES_UID);
        FeeProperties airSellFeePercentCommissionProperties = (FeeProperties)airSellFeePercentCommissionPropertiesContainer.getEntity();
        CommissionCategory airSellFeePercentCommissionCategory = (CommissionCategory)dictionaryContainers.get(AIR_SELL_FEE_PERCENT_COMMISSION_CATEGORY_CODE);
        airSellFeePercentCommissionProperties.setCategory((DictionaryReference)airSellFeePercentCommissionCategory.toReference());
        airSellFeePercentCommissionProperties.setDisplayName("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (%)");
        airSellFeePercentCommissionProperties.setRate(true);
        airSellFeePercentCommissionProperties.setType(FeeType.STANDARD);
        airSellFeePercentCommissionProperties.setRoundingMode(RoundingMode.MATH);
        airSellFeePercentCommissionProperties.setRoundingValue(RoundingValue.V_0_0_1);
        airSellFeePercentCommissionProperties.setOperation(Operation.SELL);
        airSellFeePercentCommissionProperties.setCalculateFromDifference(false);
        airSellFeePercentCommissionProperties.setCalculationBasis(CalculationBasis.FARE);
        airSellFeePercentCommissionProperties.setCalculationType(null);
        airSellFeePercentCommissionProperties.getReturnCases().clear();
        airSellFeePercentCommissionProperties.getRouteTypes().clear();
        airSellFeePercentCommissionProperties.getProductTypes().add(ProductType.AIR_TICKET);
        entityContainers.put(AIR_SELL_FEE_PERCENT_COMMISSION_PROPERTIES_UID, airSellFeePercentCommissionPropertiesContainer);
        EntityContainer<FeeProperties> airRefundFeeFixedCommissionPropertiesContainer = XMLImportTestUtil.createEntityContainer(FeeProperties.class, AIR_REFUND_FEE_FIXED_COMMISSION_PROPERTIES_UID);
        FeeProperties airRefundFeeFixedCommissionProperties = (FeeProperties)airRefundFeeFixedCommissionPropertiesContainer.getEntity();
        CommissionCategory airRefundFeeFixedCommissionCategory = (CommissionCategory)dictionaryContainers.get(AIR_REFUND_FEE_FIXED_COMMISSION_CATEGORY_CODE);
        airRefundFeeFixedCommissionProperties.setCategory((DictionaryReference)airRefundFeeFixedCommissionCategory.toReference());
        airRefundFeeFixedCommissionProperties.setDisplayName("\u0421\u0431\u043e\u0440 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (\u0444\u0438\u043a\u0441)");
        airRefundFeeFixedCommissionProperties.setRate(false);
        airRefundFeeFixedCommissionProperties.setType(FeeType.STANDARD);
        airRefundFeeFixedCommissionProperties.setRoundingMode(RoundingMode.MATH);
        airRefundFeeFixedCommissionProperties.setRoundingValue(RoundingValue.V_0_0_1);
        airRefundFeeFixedCommissionProperties.setOperation(Operation.REFUND);
        airRefundFeeFixedCommissionProperties.setCalculateFromDifference(false);
        airRefundFeeFixedCommissionProperties.setCalculationBasis(null);
        airRefundFeeFixedCommissionProperties.setCalculationType(CalculationType.TICKET);
        airRefundFeeFixedCommissionProperties.getReturnCases().clear();
        airRefundFeeFixedCommissionProperties.getRouteTypes().clear();
        airRefundFeeFixedCommissionProperties.getProductTypes().add(ProductType.AIR_TICKET);
        entityContainers.put(AIR_REFUND_FEE_FIXED_COMMISSION_PROPERTIES_UID, airRefundFeeFixedCommissionPropertiesContainer);
        EntityContainer<FeeProperties> airRefundFeePercentCommissionPropertiesContainer = XMLImportTestUtil.createEntityContainer(FeeProperties.class, AIR_REFUND_FEE_PERCENT_COMMISSION_PROPERTIES_UID);
        FeeProperties airRefundFeePercentCommissionProperties = (FeeProperties)airRefundFeePercentCommissionPropertiesContainer.getEntity();
        CommissionCategory airRefundFeePercentCommissionCategory = (CommissionCategory)dictionaryContainers.get(AIR_REFUND_FEE_PERCENT_COMMISSION_CATEGORY_CODE);
        airRefundFeePercentCommissionProperties.setCategory((DictionaryReference)airRefundFeePercentCommissionCategory.toReference());
        airRefundFeePercentCommissionProperties.setDisplayName("\u0421\u0431\u043e\u0440 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 (%)");
        airRefundFeePercentCommissionProperties.setRate(true);
        airRefundFeePercentCommissionProperties.setType(FeeType.STANDARD);
        airRefundFeePercentCommissionProperties.setRoundingMode(RoundingMode.MATH);
        airRefundFeePercentCommissionProperties.setRoundingValue(RoundingValue.V_0_0_1);
        airRefundFeePercentCommissionProperties.setOperation(Operation.REFUND);
        airRefundFeePercentCommissionProperties.setCalculateFromDifference(false);
        airRefundFeePercentCommissionProperties.setCalculationBasis(CalculationBasis.FARE);
        airRefundFeePercentCommissionProperties.setCalculationType(null);
        airRefundFeePercentCommissionProperties.getReturnCases().clear();
        airRefundFeePercentCommissionProperties.getRouteTypes().clear();
        airRefundFeePercentCommissionProperties.getProductTypes().add(ProductType.AIR_TICKET);
        entityContainers.put(AIR_REFUND_FEE_PERCENT_COMMISSION_PROPERTIES_UID, airRefundFeePercentCommissionPropertiesContainer);
    }

    private static void createOrganizationContainerFromAgency(Document sourceDocument, Element sourceOrganizationElement, List<Message> messages) throws Exception {
        String edrpou;
        String inn;
        String fullNameDefault;
        String uid = XHelper.readString((Element)sourceOrganizationElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceOrganizationElement}));
            return;
        }
        if (entityContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceOrganizationElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        EntityContainer<Organization> organizationContainer = XMLImportTestUtil.createEntityContainer(Organization.class, uid);
        Organization organization = (Organization)organizationContainer.getEntity();
        String nameDefault = XHelper.readString((Element)sourceOrganizationElement, (String)"Description");
        if (!TextUtil.isBlank((String)nameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameDefault.trim());
            }
            L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)nameDefault.trim(), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)nameDefault.trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)nameDefault.trim(), (Locale)LocaleUtil.LOCALE_UK);
        }
        if (!TextUtil.isBlank((String)(fullNameDefault = XHelper.readString((Element)sourceOrganizationElement, (String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u041f\u043e\u043b\u043d\u043e\u0435")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, fullNameDefault.trim());
            }
            L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullNameDefault.trim(), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullNameDefault.trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullNameDefault.trim(), (Locale)LocaleUtil.LOCALE_UK);
        }
        if (!TextUtil.isBlank((String)(inn = XHelper.readString((Element)sourceOrganizationElement, (String)"\u0418\u041d\u041d")))) {
            organization.setRegistrationId(inn.trim());
        }
        if (!TextUtil.isBlank((String)(edrpou = XHelper.readString((Element)sourceOrganizationElement, (String)"\u041a\u043e\u0434\u041f\u043e\u0415\u0414\u0420\u041f\u041e\u0423")))) {
            organization.setOkpoCode(edrpou.trim());
        }
        organization.setForeign(false);
        organization.setVatPayer(Boolean.TRUE);
        String vatLicenceNumber = XHelper.readString((Element)sourceOrganizationElement, (String)"\u041d\u043e\u043c\u0435\u0440\u0421\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430");
        if (!TextUtil.isBlank((String)vatLicenceNumber)) {
            organization.setVatLicenseNumber(vatLicenceNumber.trim());
        }
        organization.getTypes().add(OrganizationType.AGENCY);
        agencyReference = organizationContainer.toReference();
        entityContainers.put(uid, organizationContainer);
    }

    private static void createOrganizationContainerFromContragent(Document sourceDocument, Element sourceOrganizationElement, List<Message> messages) throws Exception {
        String edrpou;
        String inn;
        String fullNameEn;
        String nameEn;
        String fullNameDefault;
        String uid = XHelper.readString((Element)sourceOrganizationElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceOrganizationElement}));
            return;
        }
        if (entityContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceOrganizationElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        boolean folder = XHelper.readBoolean((Element)sourceOrganizationElement, (String)"IsFolder", (boolean)false);
        if (folder) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        EntityContainer<Organization> organizationContainer = XMLImportTestUtil.createEntityContainer(Organization.class, uid);
        Organization organization = (Organization)organizationContainer.getEntity();
        String dkNumber = XHelper.readString((Element)sourceOrganizationElement, (String)"DKNumber");
        if (TextUtil.isBlank((String)dkNumber)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u0434 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"DKNumber\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceOrganizationElement}));
            return;
        }
        organization.setCode(dkNumber.trim());
        String nameDefault = XHelper.readString((Element)sourceOrganizationElement, (String)"Description");
        if (!TextUtil.isBlank((String)nameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameDefault.trim());
            }
            L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)nameDefault.trim(), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)nameDefault.trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)nameDefault.trim(), (Locale)LocaleUtil.LOCALE_UK);
        }
        if (!TextUtil.isBlank((String)(fullNameDefault = XHelper.readString((Element)sourceOrganizationElement, (String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u041f\u043e\u043b\u043d\u043e\u0435")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, fullNameDefault.trim());
            }
            L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullNameDefault.trim(), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullNameDefault.trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullNameDefault.trim(), (Locale)LocaleUtil.LOCALE_UK);
        }
        if (!TextUtil.isBlank((String)(nameEn = XHelper.readString((Element)sourceOrganizationElement, (String)"Fort_Name")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameEn.trim());
            }
            L10nStringHelper.setValue((L10nString)organization.getShortName(), (String)nameEn.trim(), (Locale)LocaleUtil.LOCALE_EN);
        }
        if (!TextUtil.isBlank((String)(fullNameEn = XHelper.readString((Element)sourceOrganizationElement, (String)"Fort_FullName")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, fullNameEn.trim());
            }
            L10nStringHelper.setValue((L10nString)organization.getFullName(), (String)fullNameEn.trim(), (Locale)LocaleUtil.LOCALE_EN);
        }
        if (!TextUtil.isBlank((String)(inn = XHelper.readString((Element)sourceOrganizationElement, (String)"\u0418\u041d\u041d")))) {
            organization.setRegistrationId(inn.trim());
        }
        if (!TextUtil.isBlank((String)(edrpou = XHelper.readString((Element)sourceOrganizationElement, (String)"\u041a\u043e\u0434\u041f\u043e\u0415\u0414\u0420\u041f\u041e\u0423")))) {
            organization.setOkpoCode(edrpou.trim());
        }
        boolean foreign = XHelper.readBoolean((Element)sourceOrganizationElement, (String)"\u041d\u0435\u042f\u0432\u043b\u044f\u0435\u0442\u0441\u044f\u0420\u0435\u0437\u0438\u0434\u0435\u043d\u0442\u043e\u043c", (boolean)false);
        organization.setForeign(foreign);
        String notes = XHelper.readString((Element)sourceOrganizationElement, (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        if (!TextUtil.isBlank((String)notes)) {
            organization.setNotes(notes.trim());
        }
        Element sourceBusinessTypeElement = XmlUtil.getElement((Element)sourceOrganizationElement, (String)"\u0412\u0438\u0434\u044b\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438");
        NodeList sourceBusinessTypeRowsNodeList = sourceBusinessTypeElement.getElementsByTagName("Row");
        for (int i = 0; i < sourceBusinessTypeRowsNodeList.getLength(); ++i) {
            Element sourceBusinessTypeRowElement = (Element)sourceBusinessTypeRowsNodeList.item(i);
            String businessTypeUid = XHelper.readString((Element)sourceBusinessTypeRowElement, (String)"\u0412\u0438\u0434\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438");
            if (TextUtil.isBlank((String)businessTypeUid) || TextUtil.isSame((String)EMPTY_UID, (String)businessTypeUid)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u0412 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 \"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\" \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442 \"\u0412\u0438\u0434\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0412\u0438\u0434\u044b\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438/row/\u0412\u0438\u0434\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceOrganizationElement}));
                continue;
            }
            BusinessType businessType = (BusinessType)dictionaryContainers.get(businessTypeUid.trim());
            if (businessType == null) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u0438\u0434 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438", (String)String.format("\u0412\u0438\u0434 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", businessTypeUid.trim()), (Object[])new Object[]{sourceOrganizationElement}));
                continue;
            }
            Metadata metadata = new Metadata();
            MetadataKeyDescriptor metadataKeyDescriptor = (MetadataKeyDescriptor)dictionaryContainers.get(ORGANIZATION_BUSINESS_TYPE_KEY_DESCRIPTOR_CODE);
            metadata.setKey((DictionaryReference)metadataKeyDescriptor.toReference());
            metadata.setValue((Object)businessType.toReference());
            organization.getMetadata().add(metadata);
        }
        String rolesUid = XHelper.readString((Element)sourceOrganizationElement, (String)"CRM_\u0422\u0438\u043f\u041e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439");
        if (TextUtil.isBlank((String)rolesUid) || TextUtil.isSame((String)EMPTY_UID, (String)rolesUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u0412 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 \"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\" \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442 \"\u0422\u0438\u043f\u044b\u041e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439\u0421\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430\u043c\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"CRM_\u0422\u0438\u043f\u041e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceOrganizationElement}));
            return;
        }
        List roles = (List)objects.get(rolesUid.trim());
        if (roles == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0442\u0438\u043f \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439", (String)String.format("\u0422\u0438\u043f \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", rolesUid.trim()), (Object[])new Object[]{sourceOrganizationElement}));
            return;
        }
        organization.getTypes().addAll(roles);
        entityContainers.put(uid, organizationContainer);
    }

    private static void createBusinessType(Document sourceDocument, Element sourceBusinessTypeElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceBusinessTypeElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0412\u0438\u0434\u044b\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0412\u0438\u0434\u044b\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceBusinessTypeElement}));
            return;
        }
        if (dictionaryContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceBusinessTypeElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        BusinessType businessType = XMLImportTestUtil.createDictionaryContainer(BusinessType.class, uid);
        String name = XHelper.readString((Element)sourceBusinessTypeElement, (String)"Description");
        if (!TextUtil.isBlank((String)name)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, name.trim());
            }
            businessType.getTranslations().put(new Locale("en"), name.trim());
            businessType.getTranslations().put(new Locale("ru", "RU"), name.trim());
            businessType.getTranslations().put(new Locale("uk", "UA"), name.trim());
        }
        dictionaryContainers.put(uid, (BaseDictionary)businessType);
    }

    private static void createPersonPositionFromPosition(Document sourceDocument, Element sourcePersonPositionElement, List<Message> messages) throws Exception {
        String nameUk;
        String nameEn;
        String uid = XHelper.readString((Element)sourcePersonPositionElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u0438\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0439\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u0438\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0439\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourcePersonPositionElement}));
            return;
        }
        if (dictionaryContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourcePersonPositionElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        PersonPosition personPosition = XMLImportTestUtil.createDictionaryContainer(PersonPosition.class, uid);
        String nameDefault = XHelper.readString((Element)sourcePersonPositionElement, (String)"Description");
        if (!TextUtil.isBlank((String)nameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameDefault.trim());
            }
            personPosition.getTranslations().put(new Locale("en"), nameDefault.trim());
            personPosition.getTranslations().put(new Locale("ru", "RU"), nameDefault.trim());
            personPosition.getTranslations().put(new Locale("uk", "UA"), nameDefault.trim());
        }
        if (!TextUtil.isBlank((String)(nameEn = XHelper.readString((Element)sourcePersonPositionElement, (String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u0435")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameEn.trim());
            }
            personPosition.getTranslations().put(new Locale("en"), nameEn.trim());
        }
        if (!TextUtil.isBlank((String)(nameUk = XHelper.readString((Element)sourcePersonPositionElement, (String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0435")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameUk.trim());
            }
            personPosition.getTranslations().put(new Locale("uk", "UA"), nameUk.trim());
        }
        dictionaryContainers.put(uid, (BaseDictionary)personPosition);
    }

    private static void createMetadataKeyDescriptor(Document sourceDocument, Element sourceObjectPropertiesElement, List<Message> messages) throws Exception {
        Element sourceValueTypeTypesElement;
        String valueType;
        Element sourceValueTypeElement;
        NodeList sourceValueTypeTypesNodeList;
        String uid = XHelper.readString((Element)sourceObjectPropertiesElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceObjectPropertiesElement}));
            return;
        }
        if (dictionaryContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceObjectPropertiesElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        MetadataKeyDescriptor metadataKeyDescriptor = XMLImportTestUtil.createDictionaryContainer(MetadataKeyDescriptor.class, uid);
        metadataKeyDescriptor.setPredefined(false);
        metadataKeyDescriptor.setCategory(MetadataKeyCategory.ORGANIZATION);
        String nameDefault = XHelper.readString((Element)sourceObjectPropertiesElement, (String)"Description");
        if (!TextUtil.isBlank((String)nameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameDefault.trim());
            }
            metadataKeyDescriptor.getTranslations().put(new Locale("en"), nameDefault.trim());
            metadataKeyDescriptor.getTranslations().put(new Locale("ru", "RU"), nameDefault.trim());
            metadataKeyDescriptor.getTranslations().put(new Locale("uk", "UA"), nameDefault.trim());
        }
        if ((sourceValueTypeTypesNodeList = (sourceValueTypeElement = XmlUtil.getElement((Element)sourceObjectPropertiesElement, (String)"ValueType")).getElementsByTagName("v8:Types")).getLength() == 0) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"ValueType/v8:Types\"", title), (Object[])new Object[]{sourceObjectPropertiesElement}));
            return;
        }
        if (sourceValueTypeTypesNodeList.getLength() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" (%s) \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0442\u0438\u043f\u043e\u0432 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439, \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u043f\u0435\u0440\u0432\u044b\u0439", title), (Object[])new Object[]{sourceObjectPropertiesElement}));
        }
        if (TextUtil.isBlank((String)(valueType = XHelper.readString((Element)(sourceValueTypeTypesElement = (Element)sourceValueTypeTypesNodeList.item(0)), (String)"v8:Type")))) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"ValueType/v8:Types/v8:Type\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceObjectPropertiesElement}));
            return;
        }
        MetadataValueType metadataValueType = XMLImportTestUtil.getMetadataValueType(valueType);
        if (metadataValueType == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430", (String)String.format("\u0422\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", valueType), (Object[])new Object[]{sourceObjectPropertiesElement}));
            return;
        }
        metadataKeyDescriptor.setValueType(metadataValueType);
        dictionaryContainers.put(uid, (BaseDictionary)metadataKeyDescriptor);
    }

    private static void createPersonPositionContainerFromName(Document sourceDocument, String uid, String name, List<Message> messages) throws Exception {
        if (dictionaryContainers.containsKey(uid)) {
            return;
        }
        if (personPositions.containsKey(name)) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        PersonPosition personPosition = XMLImportTestUtil.createDictionaryContainer(PersonPosition.class, uid);
        if (!TextUtil.isBlank((String)name)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, name.trim());
            }
            personPosition.getTranslations().put(new Locale("en"), name.trim());
            personPosition.getTranslations().put(new Locale("ru", "RU"), name.trim());
            personPosition.getTranslations().put(new Locale("uk", "UA"), name.trim());
        }
        personPositions.put(name, uid);
        dictionaryContainers.put(uid, (BaseDictionary)personPosition);
    }

    private static void createBank(Document sourceDocument, Element sourceBankElement, List<Message> messages) throws Exception {
        String bik;
        String correspondentAccount;
        String city;
        String uid = XHelper.readString((Element)sourceBankElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0411\u0430\u043d\u043a\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0411\u0430\u043d\u043a\u0438\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceBankElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceBankElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        Bank bank = new Bank();
        String descrition = XHelper.readString((Element)sourceBankElement, (String)"Description");
        if (!TextUtil.isBlank((String)descrition)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, descrition.trim());
            }
            bank.setName(descrition.trim());
        }
        if (!TextUtil.isBlank((String)(city = XHelper.readString((Element)sourceBankElement, (String)"\u0413\u043e\u0440\u043e\u0434")))) {
            DictionaryReference cityReference;
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, city.trim());
            }
            if ((cityReference = DictHelper.findCityByName((String)city.trim())) != null) {
                bank.setCity((DictionaryReference<GeoLocation>)cityReference);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0433\u043e\u0440\u043e\u0434", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430 (%s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", city.trim()), (Object[])new Object[]{sourceBankElement}));
            }
        }
        if (!TextUtil.isBlank((String)(correspondentAccount = XHelper.readString((Element)sourceBankElement, (String)"\u041a\u043e\u0440\u0440\u0421\u0447\u0435\u0442")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, correspondentAccount.trim());
            }
            bank.setCorrespondentAccount(correspondentAccount.trim());
        }
        if (!TextUtil.isBlank((String)(bik = XHelper.readString((Element)sourceBankElement, (String)"\u041a\u043e\u0434\u041f\u043e\u0415\u0414\u0420\u041f\u041e\u0423")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, bik.trim());
            }
            bank.setBik(bik.trim());
        }
        objects.put(uid, bank);
    }

    private static void createBankAccount(Document sourceDocument, Element sourceBankAccountElement, List<Message> messages) throws Exception {
        String settlementAccount;
        String uid = XHelper.readString((Element)sourceBankAccountElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceBankAccountElement}));
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceBankAccountElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String ownerUid = XHelper.readString((Element)sourceBankAccountElement, (String)"Owner");
        if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Owner\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceBankAccountElement}));
            return;
        }
        EntityContainer<? extends BaseEntity> organizationContainer = entityContainers.get(ownerUid.trim());
        if (organizationContainer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceBankAccountElement}));
            return;
        }
        Organization organization = (Organization)organizationContainer.getEntity();
        String bankUid = XHelper.readString((Element)sourceBankAccountElement, (String)"\u0411\u0430\u043d\u043a");
        if (TextUtil.isBlank((String)bankUid) || TextUtil.isSame((String)EMPTY_UID, (String)bankUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0431\u0430\u043d\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0411\u0430\u043d\u043a\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceBankAccountElement}));
            return;
        }
        Bank bank = (Bank)objects.get(bankUid.trim());
        if (bank == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0431\u0430\u043d\u043a \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430", (String)String.format("\u0411\u0430\u043d\u043a \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", bankUid.trim()), (Object[])new Object[]{sourceBankAccountElement}));
            return;
        }
        BankAccount bankAccount = new BankAccount();
        bankAccount.setUid(uid);
        bankAccount.setBankName(bank.getName());
        bankAccount.setCity(bank.getCity());
        bankAccount.setCorrespondentAccount(bank.getCorrespondentAccount());
        bankAccount.setBik(bank.getBik());
        String descrition = XHelper.readString((Element)sourceBankAccountElement, (String)"Description");
        if (!TextUtil.isBlank((String)descrition)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, descrition.trim());
            }
            bankAccount.setRemarks(descrition.trim());
        }
        if (!TextUtil.isBlank((String)(settlementAccount = XHelper.readString((Element)sourceBankAccountElement, (String)"\u041d\u043e\u043c\u0435\u0440\u0421\u0447\u0435\u0442\u0430")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, settlementAccount.trim());
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u0441\u0447\u0435\u0442 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u041d\u043e\u043c\u0435\u0440\u0421\u0447\u0435\u0442\u0430\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceBankAccountElement}));
            return;
        }
        bankAccount.setSettlementAccount(settlementAccount.trim());
        String accountCurrencyUid = XHelper.readString((Element)sourceBankAccountElement, (String)"\u0412\u0430\u043b\u044e\u0442\u0430\u0414\u0435\u043d\u0435\u0436\u043d\u044b\u0445\u0421\u0440\u0435\u0434\u0441\u0442\u0432");
        if (TextUtil.isBlank((String)accountCurrencyUid) || TextUtil.isSame((String)EMPTY_UID, (String)accountCurrencyUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0412\u0430\u043b\u044e\u0442\u0430\u0414\u0435\u043d\u0435\u0436\u043d\u044b\u0445\u0421\u0440\u0435\u0434\u0441\u0442\u0432\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceBankAccountElement}));
            return;
        }
        String accountCurrency = (String)objects.get(accountCurrencyUid.trim());
        if (accountCurrency == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u0430\u043b\u044e\u0442\u0443 \u0441\u0447\u0435\u0442\u0430", (String)String.format("\u0412\u0430\u043b\u044e\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", accountCurrencyUid.trim()), (Object[])new Object[]{sourceBankAccountElement}));
            return;
        }
        bankAccount.setCurrency(accountCurrency);
        organization.getBankAccounts().add(bankAccount);
    }

    private static void createProfileCategory(Document sourceDocument, Element sourceProfileCategoryElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceProfileCategoryElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceProfileCategoryElement}));
            return;
        }
        if (dictionaryContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceProfileCategoryElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        ProfileCategory profileCategory = XMLImportTestUtil.createDictionaryContainer(ProfileCategory.class, uid);
        String nameDefault = XHelper.readString((Element)sourceProfileCategoryElement, (String)"Description");
        if (!TextUtil.isBlank((String)nameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameDefault.trim());
            }
            profileCategory.getTranslations().put(new Locale("en"), nameDefault.trim());
            profileCategory.getTranslations().put(new Locale("ru", "RU"), nameDefault.trim());
            profileCategory.getTranslations().put(new Locale("uk", "UA"), nameDefault.trim());
        }
        dictionaryContainers.put(uid, (BaseDictionary)profileCategory);
    }

    private static void createCostCodeProperties(Document sourceDocument, Element sourceCostCodePropertiesElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceCostCodePropertiesElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String costCodeCategoryUid = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"\u0422\u0438\u043f\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u0430");
        if (TextUtil.isBlank((String)costCodeCategoryUid) || TextUtil.isSame((String)EMPTY_UID, (String)costCodeCategoryUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0422\u0438\u043f\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u0430\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        CostCodeCategory costCodeCategory = (CostCodeCategory)dictionaryContainers.get(costCodeCategoryUid.trim());
        if (costCodeCategory == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430", (String)String.format("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", costCodeCategoryUid.trim()), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        CostCodeCategoryReference costCodeCategoryReference = costCodeCategory.toReference();
        CostCodeProperties costCodeProperties = new CostCodeProperties();
        costCodeProperties.setCategory((DictionaryReference)costCodeCategoryReference);
        costCodeProperties.setUid(uid);
        String name = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"Description");
        if (!TextUtil.isBlank((String)name)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, name.trim());
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        costCodeProperties.setName(name.trim());
        String mask = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"\u041c\u0430\u0441\u043a\u0430");
        if (!TextUtil.isBlank((String)mask)) {
            String convertMask = XMLImportTestUtil.convertMask(mask.trim());
            if (!TextUtil.isBlank((String)convertMask)) {
                costCodeProperties.setMask(convertMask.trim());
            }
            messages.add(MessageHelper.createMessage((String)"\u041c\u0430\u0441\u043a\u0430 UDID \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0430", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043c\u0430\u0441\u043a\u0438 UDID \"%s\" \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u043e \u0432 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\"", mask.trim(), convertMask.trim()), (Object[])new Object[0]));
        }
        boolean includeToInvoice = XHelper.readBoolean((Element)sourceCostCodePropertiesElement, (String)"\u0422\u044f\u043d\u0443\u0442\u044c\u0412\u0421\u0447\u0435\u0442", (boolean)false);
        costCodeProperties.setIncludeToInvoice(includeToInvoice);
        String remarks = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        if (!TextUtil.isBlank((String)remarks)) {
            costCodeProperties.setRemarks(remarks);
        }
        objects.put(uid, costCodeProperties);
    }

    private static void createCostCodeProperties2(Document sourceDocument, Element sourceCostCodePropertiesElement, List<Message> messages) throws Exception {
        List organizationCostCodeProperties;
        String uid = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceCostCodePropertiesElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String ownerUid = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"Owner");
        if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Owner\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        EntityContainer<? extends BaseEntity> organizationContainer = entityContainers.get(ownerUid.trim());
        if (organizationContainer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0442\u0438\u043f\u0430 UDID", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        Organization organization = (Organization)organizationContainer.getEntity();
        String costCodeCategoryUid = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"\u0422\u0438\u043f\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u0430");
        if (TextUtil.isBlank((String)costCodeCategoryUid) || TextUtil.isSame((String)EMPTY_UID, (String)costCodeCategoryUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0422\u0438\u043f\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u0430\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        CostCodeCategory costCodeCategory = (CostCodeCategory)dictionaryContainers.get(costCodeCategoryUid.trim());
        if (costCodeCategory == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430", (String)String.format("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", costCodeCategoryUid.trim()), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        CostCodeCategoryReference costCodeCategoryReference = costCodeCategory.toReference();
        CostCodeProperties costCodeProperties = new CostCodeProperties();
        costCodeProperties.setCategory((DictionaryReference)costCodeCategoryReference);
        costCodeProperties.setUid(uid);
        String name = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"Description");
        if (!TextUtil.isBlank((String)name)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, name.trim());
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u0422\u0438\u043f\u044b\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceCostCodePropertiesElement}));
            return;
        }
        costCodeProperties.setName(name.trim());
        String mask = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"\u041c\u0430\u0441\u043a\u0430");
        if (!TextUtil.isBlank((String)mask)) {
            String convertMask = XMLImportTestUtil.convertMask(mask.trim());
            if (!TextUtil.isBlank((String)convertMask)) {
                costCodeProperties.setMask(convertMask.trim());
            }
            messages.add(MessageHelper.createMessage((String)"\u041c\u0430\u0441\u043a\u0430 UDID \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0430", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043c\u0430\u0441\u043a\u0438 UDID \"%s\" \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u043e \u0432 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\"", mask.trim(), convertMask.trim()), (Object[])new Object[0]));
        }
        boolean includeToInvoice = XHelper.readBoolean((Element)sourceCostCodePropertiesElement, (String)"\u0422\u044f\u043d\u0443\u0442\u044c\u0412\u0421\u0447\u0435\u0442", (boolean)false);
        costCodeProperties.setIncludeToInvoice(includeToInvoice);
        String remarks = XHelper.readString((Element)sourceCostCodePropertiesElement, (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        if (!TextUtil.isBlank((String)remarks)) {
            costCodeProperties.setRemarks(remarks);
        }
        if (!(organizationCostCodeProperties = organization.getCostCodeProperties()).contains(costCodeProperties)) {
            CostCodeType costCodeType;
            CostCodeType costCodeType2 = costCodeType = organizationCostCodeProperties.size() > 0 ? ((CostCodeProperties)organizationCostCodeProperties.get(organizationCostCodeProperties.size() - 1)).getType() : null;
            costCodeType = costCodeType != null ? (costCodeType.ordinal() < CostCodeType.values().length - 1 ? CostCodeType.values()[costCodeType.ordinal() + 1] : costCodeType) : CostCodeType.COST_CODE_1;
            costCodeProperties.setType(costCodeType);
            organizationCostCodeProperties.add(costCodeProperties);
        }
        objects.put(uid, costCodeProperties);
    }

    private static void createCostCode(Document sourceDocument, Element sourceCostCodeElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceCostCodeElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u044b\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u044b\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCostCodeElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceCostCodeElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String ownerUid = XHelper.readString((Element)sourceCostCodeElement, (String)"Owner");
        if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u044b\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u044b\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Owner\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceCostCodeElement}));
            return;
        }
        EntityContainer<? extends BaseEntity> organizationContainer = entityContainers.get(ownerUid.trim());
        if (organizationContainer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 UDID", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceCostCodeElement}));
            return;
        }
        Organization organization = (Organization)organizationContainer.getEntity();
        String costCodePropertiesUid = XHelper.readString((Element)sourceCostCodeElement, (String)"\u0422\u0438\u043f\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u0430");
        if (TextUtil.isBlank((String)costCodePropertiesUid) || TextUtil.isSame((String)EMPTY_UID, (String)costCodePropertiesUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u044b\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u044b\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0422\u0438\u043f\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u0430\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceCostCodeElement}));
            return;
        }
        CostCodeProperties costCodeProperties = (CostCodeProperties)objects.get(costCodePropertiesUid.trim());
        if (costCodeProperties == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430 \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430", (String)String.format("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043a\u043e\u0441\u0442 \u043a\u043e\u0434\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", costCodePropertiesUid.trim()), (Object[])new Object[]{sourceCostCodeElement}));
            return;
        }
        CostCode costCode = new CostCode();
        costCode.setUid(uid);
        costCode.setCostCodeProperties(costCodeProperties);
        String costCodeValue = XHelper.readString((Element)sourceCostCodeElement, (String)"Description");
        if (!TextUtil.isBlank((String)costCodeValue)) {
            String mask;
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, costCodeValue.trim());
            }
            if (!TextUtil.isBlank((String)(mask = costCodeProperties.getMask()))) {
                try {
                    MaskFormatter formatter = new MaskFormatter(mask);
                    formatter.stringToValue(costCodeValue.trim());
                    costCode.setValue(costCodeValue.trim());
                }
                catch (ParseException e) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u0441\u0442-\u043a\u043e\u0434\u0430", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f UDID \"%s\" \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u0430\u0441\u043a\u0435 \u0442\u0438\u043f\u0430 \u043a\u043e\u0441\u0442-\u043a\u043e\u0434\u0430 \"%s\"", costCodeValue.trim(), mask), (Object[])new Object[]{sourceCostCodeElement}));
                    return;
                }
            } else {
                costCode.setValue(costCodeValue.trim());
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u044b\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u044b\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceCostCodeElement}));
            return;
        }
        List organizationCostCodeProperties = organization.getCostCodeProperties();
        if (!organizationCostCodeProperties.contains(costCodeProperties)) {
            CostCodeType costCodeType;
            CostCodeType costCodeType2 = costCodeType = organizationCostCodeProperties.size() > 0 ? ((CostCodeProperties)organizationCostCodeProperties.get(organizationCostCodeProperties.size() - 1)).getType() : null;
            costCodeType = costCodeType != null ? (costCodeType.ordinal() < CostCodeType.values().length - 1 ? CostCodeType.values()[costCodeType.ordinal() + 1] : costCodeType) : CostCodeType.COST_CODE_1;
            costCodeProperties.setType(costCodeType);
            organizationCostCodeProperties.add(costCodeProperties);
        }
        organization.getCostCodes().add(costCode);
        objects.put(uid, costCode);
    }

    private static void createReasonCode(Document sourceDocument, Element sourceReasonCodeElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceReasonCodeElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041e\u0422_\u0420\u0438\u0437\u043e\u043d\u041a\u043e\u0434\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041e\u0422_\u0420\u0438\u0437\u043e\u043d\u041a\u043e\u0434\u0430\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceReasonCodeElement}));
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceReasonCodeElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String ownerUid = XHelper.readString((Element)sourceReasonCodeElement, (String)"Owner");
        if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041e\u0422_\u0420\u0438\u0437\u043e\u043d\u041a\u043e\u0434\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041e\u0422_\u0420\u0438\u0437\u043e\u043d\u041a\u043e\u0434\u0430\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Owner\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceReasonCodeElement}));
            return;
        }
        EntityContainer<? extends BaseEntity> organizationContainer = entityContainers.get(ownerUid.trim());
        if (organizationContainer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0440\u0438\u0437\u043e\u043d-\u043a\u043e\u0434\u0430", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceReasonCodeElement}));
            return;
        }
        Organization organization = (Organization)organizationContainer.getEntity();
        ReasonCode reasonCode = new ReasonCode();
        String name = XHelper.readString((Element)sourceReasonCodeElement, (String)"Description");
        if (!TextUtil.isBlank((String)name)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, name.trim());
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041e\u0422_\u0420\u0438\u0437\u043e\u043d\u041a\u043e\u0434\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041e\u0422_\u0420\u0438\u0437\u043e\u043d\u041a\u043e\u0434\u0430\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceReasonCodeElement}));
            return;
        }
        reasonCode.setName(name.trim());
        String remarks = XHelper.readString((Element)sourceReasonCodeElement, (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        if (!TextUtil.isBlank((String)remarks)) {
            L10nStringHelper.setValue((L10nString)reasonCode.getRemarks(), (String)remarks.trim(), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)reasonCode.getRemarks(), (String)remarks.trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)reasonCode.getRemarks(), (String)remarks.trim(), (Locale)LocaleUtil.LOCALE_UK);
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041e\u0422_\u0420\u0438\u0437\u043e\u043d\u041a\u043e\u0434\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041e\u0422_\u0420\u0438\u0437\u043e\u043d\u041a\u043e\u0434\u0430\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceReasonCodeElement}));
        }
        reasonCode.setType(ReasonCodeType.REASON_CODE_AIR);
        organization.getReasonCodes().add(reasonCode);
    }

    private static void createVATPayer(Document sourceDocument, Element sourceVATPayerRegisterElement, List<Message> messages) throws Exception {
        NodeList sourceVATPayerRegisterRecordNodeList = sourceVATPayerRegisterElement.getElementsByTagName("Record");
        for (int i = 0; i < sourceVATPayerRegisterRecordNodeList.getLength(); ++i) {
            Element sourceVATPayerRegisterRecordElement = (Element)sourceVATPayerRegisterRecordNodeList.item(i);
            String ownerUid = XHelper.readString((Element)sourceVATPayerRegisterRecordElement, (String)"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442");
            if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0438\u041d\u0414\u0421\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0438\u041d\u0414\u0421\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceVATPayerRegisterRecordElement}));
                continue;
            }
            EntityContainer<? extends BaseEntity> organizationContainer = entityContainers.get(ownerUid.trim());
            if (organizationContainer == null) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430 \u041d\u0414\u0421", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceVATPayerRegisterRecordElement}));
                continue;
            }
            Organization organization = (Organization)organizationContainer.getEntity();
            String period = XHelper.readString((Element)sourceVATPayerRegisterRecordElement, (String)"Period");
            if (TextUtil.isBlank((String)period)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c period \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0438\u041d\u0414\u0421\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0438\u041d\u0414\u0421\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/Period\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceVATPayerRegisterRecordElement}));
                continue;
            }
            Date date = new Date();
            try {
                date = C1_DATE_FORMAT.parse(period.trim());
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c period \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0438\u041d\u0414\u0421\"", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\" \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0430\u0442\u043e\u0439", period.trim()), (Object[])new Object[]{sourceVATPayerRegisterRecordElement}));
                continue;
            }
            boolean vatPayer = XHelper.readBoolean((Element)sourceVATPayerRegisterRecordElement, (String)"\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u041d\u0414\u0421", (boolean)false);
            String vatLicenceNumber = XHelper.readString((Element)sourceVATPayerRegisterRecordElement, (String)"\u041d\u043e\u043c\u0435\u0440\u0421\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430");
            if (TextUtil.isBlank((String)vatLicenceNumber)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u0440 \u0441\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0438\u041d\u0414\u0421\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0438\u041d\u0414\u0421\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041d\u043e\u043c\u0435\u0440\u0421\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceVATPayerRegisterRecordElement}));
                continue;
            }
            HistoricalValue vatPayerHistoricalValue = new HistoricalValue();
            vatPayerHistoricalValue.setValue((Object)vatPayer);
            vatPayerHistoricalValue.setDate(date);
            organization.getVatPayerHistory().add(vatPayerHistoricalValue);
            HistoricalValue vatLicenceNumberHistoricalValue = new HistoricalValue();
            vatLicenceNumberHistoricalValue.setValue((Object)vatLicenceNumber);
            vatLicenceNumberHistoricalValue.setDate(date);
            organization.getVatLicenseNumberHistory().add(vatLicenceNumberHistoricalValue);
        }
    }

    private static void createContractRules(Document sourceDocument, Element sourceMarginDiscountsRegisterElement, List<Message> messages) throws Exception {
        NodeList sourceMarginDiscountsRegisterRecordNodeList = sourceMarginDiscountsRegisterElement.getElementsByTagName("Record");
        for (int i = 0; i < sourceMarginDiscountsRegisterRecordNodeList.getLength(); ++i) {
            String feeCode;
            RuleResultValue ruleResultValue;
            RuleResult ruleResult;
            String feeType;
            String cityUid;
            String directionUid;
            String airlineUid;
            Element sourceMarginDiscountsRegisterRecordElement = (Element)sourceMarginDiscountsRegisterRecordNodeList.item(i);
            boolean active = XHelper.readBoolean((Element)sourceMarginDiscountsRegisterRecordElement, (String)"Active", (boolean)false);
            if (!active) continue;
            String ownerType = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c\u0421\u043a\u0438\u0434\u043a\u0438@xsi:type");
            if (TextUtil.isBlank((String)ownerType)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"type\" \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \"Records/Record/\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c\u0421\u043a\u0438\u0434\u043a\u0438\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                continue;
            }
            if (!TextUtil.isSame((String)ownerType, (String)"CatalogRef.\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432")) continue;
            String ownerUid = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c\u0421\u043a\u0438\u0434\u043a\u0438");
            if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c\u0421\u043a\u0438\u0434\u043a\u0438\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                continue;
            }
            EntityContainer<? extends BaseEntity> contractContainer = entityContainers.get(ownerUid.trim());
            if (contractContainer == null) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043f\u0440\u0430\u0432\u0438\u043b\u0430", (String)String.format("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                continue;
            }
            Contract contract = (Contract)contractContainer.getEntity();
            RuleSettings ruleSettings = new RuleSettings();
            String target = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u0412\u0438\u0434\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438");
            if (TextUtil.isBlank((String)target)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0438\u0434 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u0412\u0438\u0434\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                continue;
            }
            RuleTarget ruleTarget = XMLImportTestUtil.getRuleTarget(target);
            if (ruleTarget == null) continue;
            ruleSettings.setTarget(ruleTarget);
            String periodBegin = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"Period");
            if (TextUtil.isBlank((String)periodBegin) || TextUtil.isSame((String)EMPTY_DATE, (String)periodBegin)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/Period\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                continue;
            }
            try {
                ruleSettings.setPeriodBegin(C1_DATE_FORMAT.parse(periodBegin.trim()));
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043f\u0440\u0430\u0432\u0438\u043b\u0430", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\" \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0430\u0442\u043e\u0439", periodBegin.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                continue;
            }
            String classOfServiceUid = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u0422\u0438\u043f\u0426\u0435\u043d\u044b");
            if (!TextUtil.isBlank((String)classOfServiceUid) && !TextUtil.isSame((String)EMPTY_UID, (String)classOfServiceUid)) {
                List ruleRestrictions = (List)objects.get(classOfServiceUid.trim());
                if (ruleRestrictions == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", (String)String.format("\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", classOfServiceUid.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                for (Object ruleRestriction : ruleRestrictions) {
                    ruleSettings.getRestrictions().add(ruleRestriction);
                }
            }
            if (!TextUtil.isBlank((String)(airlineUid = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a\u0430\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b"))) && !TextUtil.isSame((String)EMPTY_UID, (String)airlineUid)) {
                Object ruleRestriction;
                List ruleRestrictions = (List)objects.get(airlineUid.trim());
                if (ruleRestrictions == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044e", (String)String.format("\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", airlineUid.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                ruleRestriction = ruleRestrictions.iterator();
                while (ruleRestriction.hasNext()) {
                    RuleRestriction ruleRestriction2 = (RuleRestriction)ruleRestriction.next();
                    ruleSettings.getRestrictions().add(ruleRestriction2);
                }
            }
            if (!TextUtil.isBlank((String)(directionUid = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435"))) && !TextUtil.isSame((String)EMPTY_UID, (String)directionUid)) {
                List ruleRestrictions = (List)objects.get(directionUid.trim());
                if (ruleRestrictions == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", (String)String.format("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", directionUid.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                for (RuleRestriction ruleRestriction : ruleRestrictions) {
                    ruleSettings.getRestrictions().add(ruleRestriction);
                }
            }
            if (!TextUtil.isBlank((String)(cityUid = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u0413\u043e\u0440\u043e\u0434"))) && !TextUtil.isSame((String)EMPTY_UID, (String)cityUid)) {
                GeoLocation city = (GeoLocation)objects.get(cityUid.trim());
                if (city == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0433\u043e\u0440\u043e\u0434", (String)String.format("\u0413\u043e\u0440\u043e\u0434 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", cityUid.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                ArrayList<RuleRestriction> ruleRestrictions = new ArrayList<RuleRestriction>();
                RuleRestriction ruleRestriction = new RuleRestriction();
                ruleRestriction.setProperty((RuleProperty)com.gridnine.xtrip.common.model.rules.standard.Properties.ROUTE);
                ruleRestriction.setCondition((RuleCondition)Conditions.ENDS_WITH);
                ruleRestriction.setValue((Object)DictHelper.getCodeVariant((BaseDictionary)city, Arrays.asList(CodeSystem.IATA, CodeSystem.CRT, CodeSystem.ISO)));
                ruleRestrictions.add(ruleRestriction);
                ruleSettings.getRestrictions().addAll(ruleRestrictions);
            }
            if (TextUtil.isBlank((String)(feeType = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u0422\u0438\u043f\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e\u0421\u0431\u043e\u0440\u0430")))) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0441\u0431\u043e\u0440\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u0422\u0438\u043f\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e\u0421\u0431\u043e\u0440\u0430\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                continue;
            }
            if (TextUtil.isSame((String)feeType, (String)"\u0421\u0443\u043c\u043c\u0430")) {
                ruleResult = new RuleResult();
                ruleResult.setAction((RuleAction)Actions.SIMPLE_FEE);
                ruleResultValue = new RuleResultValue();
                feeCode = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u041a\u043e\u0434\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e\u0421\u0431\u043e\u0440\u0430");
                if (TextUtil.isBlank((String)feeCode)) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u0434 \u0441\u0431\u043e\u0440\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041a\u043e\u0434\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e\u0421\u0431\u043e\u0440\u0430\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                if (TextUtil.isSame((String)feeCode, (String)"SF")) {
                    EntityContainer<? extends BaseEntity> airSellFeeFixedCommissionPropertiesContainer = entityContainers.get(AIR_SELL_FEE_FIXED_COMMISSION_PROPERTIES_UID);
                    ruleResultValue.setTarget(airSellFeeFixedCommissionPropertiesContainer.toReference());
                } else if (TextUtil.isSame((String)feeCode, (String)"RF")) {
                    EntityContainer<? extends BaseEntity> airRefundFeeFixedCommissionPropertiesContainer = entityContainers.get(AIR_REFUND_FEE_FIXED_COMMISSION_PROPERTIES_UID);
                    ruleResultValue.setTarget(airRefundFeeFixedCommissionPropertiesContainer.toReference());
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u0434 \u0441\u0431\u043e\u0440\u0430", (String)String.format("\u041a\u043e\u0434 \u0441\u0431\u043e\u0440\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", feeCode.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                BigDecimal amount = XHelper.readBigDecimal((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u0426\u0435\u043d\u0430");
                if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0435\u043b\u0438\u0447\u0438\u043d\u0443 \u0441\u0431\u043e\u0440\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u0426\u0435\u043d\u0430\" \u043b\u0438\u0431\u043e \u0432\u0435\u043b\u0438\u0447\u0438\u043d\u0430 \u0440\u0430\u0432\u043d\u0430 0", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                ruleResultValue.setValue(amount.doubleValue());
                String \u0441urrencyUid = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u0412\u0430\u043b\u044e\u0442\u0430");
                if (TextUtil.isBlank((String)\u0441urrencyUid) || TextUtil.isSame((String)EMPTY_UID, (String)\u0441urrencyUid)) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443 \u0441\u0431\u043e\u0440\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u0412\u0430\u043b\u044e\u0442\u0430\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                String \u0441urrency = (String)objects.get(\u0441urrencyUid.trim());
                if (\u0441urrency == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u0430\u043b\u044e\u0442\u0443 \u0441\u0431\u043e\u0440\u0430", (String)String.format("\u0412\u0430\u043b\u044e\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", \u0441urrencyUid.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                ruleResultValue.setCurrencyCode(\u0441urrency);
                ruleResult.setValue((Object)ruleResultValue);
                ruleSettings.getResults().add(ruleResult);
            } else if (TextUtil.isSame((String)feeType, (String)"\u041f\u0440\u043e\u0446\u0435\u043d\u0442")) {
                ruleResult = new RuleResult();
                ruleResult.setAction((RuleAction)Actions.SIMPLE_FEE);
                ruleResultValue = new RuleResultValue();
                feeCode = XHelper.readString((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u041a\u043e\u0434\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e\u0421\u0431\u043e\u0440\u0430");
                if (TextUtil.isBlank((String)feeCode)) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u0434 \u0441\u0431\u043e\u0440\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041a\u043e\u0434\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e\u0421\u0431\u043e\u0440\u0430\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                if (TextUtil.isSame((String)feeCode, (String)"SF")) {
                    EntityContainer<? extends BaseEntity> airSellFeePercentCommissionPropertiesContainer = entityContainers.get(AIR_SELL_FEE_PERCENT_COMMISSION_PROPERTIES_UID);
                    ruleResultValue.setTarget(airSellFeePercentCommissionPropertiesContainer.toReference());
                } else if (TextUtil.isSame((String)feeCode, (String)"RF")) {
                    EntityContainer<? extends BaseEntity> airRefundFeePercentCommissionPropertiesContainer = entityContainers.get(AIR_REFUND_FEE_PERCENT_COMMISSION_PROPERTIES_UID);
                    ruleResultValue.setTarget(airRefundFeePercentCommissionPropertiesContainer.toReference());
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u0434 \u0441\u0431\u043e\u0440\u0430", (String)String.format("\u041a\u043e\u0434 \u0441\u0431\u043e\u0440\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", feeCode.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                BigDecimal percent = XHelper.readBigDecimal((Element)sourceMarginDiscountsRegisterRecordElement, (String)"\u041f\u0440\u043e\u0446\u0435\u043d\u0442\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438");
                if (percent == null || percent.compareTo(BigDecimal.ZERO) == 0) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0446\u0435\u043d\u0442\u043d\u0443\u044e \u0441\u0442\u0430\u0432\u043a\u0443 \u0441\u0431\u043e\u0440\u0430 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041f\u0440\u043e\u0446\u0435\u043d\u0442\u0421\u043a\u0438\u0434\u043a\u0438\u041d\u0430\u0446\u0435\u043d\u043a\u0438\" \u043b\u0438\u0431\u043e \u0432\u0435\u043b\u0438\u0447\u0438\u043d\u0430 \u0440\u0430\u0432\u043d\u0430 0", new Object[0]), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                    continue;
                }
                ruleResultValue.setValue(percent.doubleValue());
                ruleResultValue.setCurrencyCode("%");
                ruleResult.setValue((Object)ruleResultValue);
                ruleSettings.getResults().add(ruleResult);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0441\u0431\u043e\u0440\u0430", (String)String.format("\u0422\u0438\u043f \u0441\u0431\u043e\u0440\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", feeType.trim()), (Object[])new Object[]{sourceMarginDiscountsRegisterRecordElement}));
                continue;
            }
            if (contract.getRuleSet() == null) {
                RuleSet ruleSet = new RuleSet();
                contract.setRuleSet(ruleSet);
            }
            boolean valid = true;
            Iterator ruleSettingsIterator = contract.getRuleSet().getRules().iterator();
            while (ruleSettingsIterator.hasNext()) {
                RuleSettings ruleSettings2 = (RuleSettings)ruleSettingsIterator.next();
                if (!ruleSettingRestrictionsEqualator.equals(ruleSettings, ruleSettings2)) continue;
                if (ruleSettingsPeriodComparator.compare(ruleSettings, ruleSettings2) >= 0) {
                    ruleSettingsIterator.remove();
                    break;
                }
                valid = false;
                break;
            }
            if (!valid) continue;
            contract.getRuleSet().getRules().add(ruleSettings);
            Collections.sort(contract.getRuleSet().getRules(), ruleSettingsPriorityComparator);
        }
    }

    private static void createOrganizationRole(Document sourceDocument, Element sourceContragentRelationshipTypeElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceContragentRelationshipTypeElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"CRM_\u0422\u0438\u043f\u044b\u041e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439\u0421\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430\u043c\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"CRM_\u0422\u0438\u043f\u044b\u041e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439\u0421\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430\u043c\u0438\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContragentRelationshipTypeElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceContragentRelationshipTypeElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        ArrayList<OrganizationType> organiztionTypes = new ArrayList<OrganizationType>();
        NodeList sourceContragentRelationshipTypeRowNodeList = sourceContragentRelationshipTypeElement.getElementsByTagName("Row");
        for (int i = 0; i < sourceContragentRelationshipTypeRowNodeList.getLength(); ++i) {
            Element sourceContragentRelationshipTypeRowElement = (Element)sourceContragentRelationshipTypeRowNodeList.item(i);
            String type = XHelper.readString((Element)sourceContragentRelationshipTypeRowElement, (String)"\u0422\u0438\u043f");
            if (TextUtil.isBlank((String)type)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"CRM_\u0422\u0438\u043f\u044b\u041e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439\u0421\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430\u043c\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"CRM_\u0422\u0438\u043f\u044b\u041e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439\u0421\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430\u043c\u0438\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0422\u0438\u043f\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432/Row/\u0422\u0438\u043f\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceContragentRelationshipTypeRowElement}));
                continue;
            }
            OrganizationType organizationType = XMLImportTestUtil.getOrganizationType(type.trim());
            if (organizationType == null) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0440\u043e\u043b\u044c \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438", (String)String.format("\u0420\u043e\u043b\u044c \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", type.trim()), (Object[])new Object[]{sourceContragentRelationshipTypeRowElement}));
                continue;
            }
            organiztionTypes.add(organizationType);
        }
        if (organiztionTypes.isEmpty()) {
            return;
        }
        objects.put(uid, organiztionTypes);
    }

    private static void createMetadataFromCategory(Document sourceDocument, Element sourceObjectCategoryRegisterElement, List<Message> messages) throws Exception {
        NodeList sourceCategoriesRegisterRecordNodeList = sourceObjectCategoryRegisterElement.getElementsByTagName("Record");
        for (int i = 0; i < sourceCategoriesRegisterRecordNodeList.getLength(); ++i) {
            Element sourceCategoryRegisterRecordElement = (Element)sourceCategoriesRegisterRecordNodeList.item(i);
            String ownerUid = XHelper.readString((Element)sourceCategoryRegisterRecordElement, (String)"\u041e\u0431\u044a\u0435\u043a\u0442");
            if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041e\u0431\u044a\u0435\u043a\u0442\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCategoryRegisterRecordElement}));
                continue;
            }
            String ownerType = XHelper.readString((Element)sourceCategoryRegisterRecordElement, (String)"\u041e\u0431\u044a\u0435\u043a\u0442@xsi:type");
            if (TextUtil.isBlank((String)ownerType)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"type\" \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \"Records/Record/\u041e\u0431\u044a\u0435\u043a\u0442\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCategoryRegisterRecordElement}));
                continue;
            }
            if (TextUtil.isSame((String)ownerType, (String)"CatalogRef.\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b")) {
                EntityContainer<? extends BaseEntity> organizationContainer = entityContainers.get(ownerUid.trim());
                if (organizationContainer == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceCategoryRegisterRecordElement}));
                    continue;
                }
                Organization organization = (Organization)organizationContainer.getEntity();
                String profileCategoryUid = XHelper.readString((Element)sourceCategoryRegisterRecordElement, (String)"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
                if (TextUtil.isBlank((String)profileCategoryUid) || TextUtil.isSame((String)EMPTY_UID, (String)profileCategoryUid)) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u0412 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCategoryRegisterRecordElement}));
                    continue;
                }
                ProfileCategory profileCategory = (ProfileCategory)dictionaryContainers.get(profileCategoryUid.trim());
                if (profileCategory == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043e\u0431\u044a\u0435\u043a\u0442\u0430", (String)String.format("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", profileCategoryUid.trim()), (Object[])new Object[]{sourceCategoryRegisterRecordElement}));
                    continue;
                }
                Metadata metadata = new Metadata();
                MetadataKeyDescriptor metadataKeyDescriptor = (MetadataKeyDescriptor)dictionaryContainers.get(ORGANIZATION_PROFILE_CATEGORY_KEY_DESCRIPTOR_CODE);
                metadata.setKey((DictionaryReference)metadataKeyDescriptor.toReference());
                metadata.setValue((Object)profileCategory.toReference());
                organization.getMetadata().add(metadata);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", (String)String.format("\u0422\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", ownerType.trim()), (Object[])new Object[]{sourceCategoryRegisterRecordElement}));
            return;
        }
    }

    private static void createMetadataValue(Document sourceDocument, Element sourceObjectPropertiesValueElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceObjectPropertiesValueElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceObjectPropertiesValueElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceObjectPropertiesValueElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String value = XHelper.readString((Element)sourceObjectPropertiesValueElement, (String)"Description");
        if (!TextUtil.isBlank((String)value)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, value.trim());
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceObjectPropertiesValueElement}));
            return;
        }
        objects.put(uid, value);
    }

    private static void createMetadataFromProperties(Document sourceDocument, Element sourceObjectPropertiesValuesRegisterElement, List<Message> messages) throws Exception {
        NodeList sourceObjectPropertiesValuesRegisterRecordNodeList = sourceObjectPropertiesValuesRegisterElement.getElementsByTagName("Record");
        for (int i = 0; i < sourceObjectPropertiesValuesRegisterRecordNodeList.getLength(); ++i) {
            Element sourceObjectPropertiesValuesRegisterRecordElement = (Element)sourceObjectPropertiesValuesRegisterRecordNodeList.item(i);
            String ownerUid = XHelper.readString((Element)sourceObjectPropertiesValuesRegisterRecordElement, (String)"\u041e\u0431\u044a\u0435\u043a\u0442");
            if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041e\u0431\u044a\u0435\u043a\u0442\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                continue;
            }
            String ownerType = XHelper.readString((Element)sourceObjectPropertiesValuesRegisterRecordElement, (String)"\u041e\u0431\u044a\u0435\u043a\u0442@xsi:type");
            if (TextUtil.isBlank((String)ownerType)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"type\" \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \"Records/Record/\u041e\u0431\u044a\u0435\u043a\u0442\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                continue;
            }
            if (TextUtil.isSame((String)ownerType, (String)"CatalogRef.\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b")) {
                Object object;
                EntityContainer<? extends BaseEntity> organizationContainer = entityContainers.get(ownerUid.trim());
                if (organizationContainer == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                    continue;
                }
                Organization organization = (Organization)organizationContainer.getEntity();
                String title = String.format("%s | %s", organization.getUid(), organization.toString());
                Metadata metadata = new Metadata();
                String metadataKeyDescriptorUid = XHelper.readString((Element)sourceObjectPropertiesValuesRegisterRecordElement, (String)"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e");
                if (TextUtil.isBlank((String)metadataKeyDescriptorUid) || TextUtil.isSame((String)EMPTY_UID, (String)metadataKeyDescriptorUid)) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u0412 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442 \"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                    continue;
                }
                MetadataKeyDescriptor metadataKeyDescriptor = (MetadataKeyDescriptor)dictionaryContainers.get(metadataKeyDescriptorUid);
                metadata.setKey((DictionaryReference)metadataKeyDescriptor.toReference());
                String valueType = XHelper.readString((Element)sourceObjectPropertiesValuesRegisterRecordElement, (String)"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435@xsi:type");
                if (TextUtil.isBlank((String)valueType)) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"type\" \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \"Records/Record/\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                    continue;
                }
                MetadataValueType metadataValueType = XMLImportTestUtil.getMetadataValueType(valueType.trim());
                if (metadataValueType == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430", (String)String.format("\u0422\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", valueType.trim()), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                    continue;
                }
                if (metadataKeyDescriptor.getValueType() != metadataValueType) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430", (String)String.format("\u0422\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \"%s\" \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0442\u0438\u043f\u043e\u043c \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0432 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0435", valueType.trim()), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                    continue;
                }
                String value = XHelper.readString((Element)sourceObjectPropertiesValuesRegisterRecordElement, (String)"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
                if (TextUtil.isBlank((String)value)) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u0412 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435/\u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                    continue;
                }
                if (metadataValueType == MetadataValueType.BOOLEAN) {
                    metadata.setValue((Object)Boolean.valueOf(value.trim()));
                } else if (metadataValueType == MetadataValueType.STRING) {
                    object = objects.get(value.trim());
                    if (object == null) {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430", (String)String.format("\u0421\u0442\u0440\u043e\u043a\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", value.trim()), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                        continue;
                    }
                    metadata.setValue(objects.get(value.trim()));
                } else if (metadataValueType == MetadataValueType.PERSON) {
                    object = objects.get(value.trim());
                    if (object == null) {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430", (String)String.format("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", value.trim()), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
                        continue;
                    }
                    metadata.setValue((Object)((EntityContainer)objects.get(value)).toReference());
                }
                organization.getMetadata().add(metadata);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", (String)String.format("\u0422\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", ownerType.trim()), (Object[])new Object[]{sourceObjectPropertiesValuesRegisterRecordElement}));
            return;
        }
    }

    private static void createCostCodeCategoryContainer(Document sourceDocument, Element sourceCostCodeCategoryElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceCostCodeCategoryElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u041a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0422\u0438\u043f\u043e\u0432\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u041a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0422\u0438\u043f\u043e\u0432\u041a\u043e\u0441\u0442\u041a\u043e\u0434\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCostCodeCategoryElement}));
            return;
        }
        if (dictionaryContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceCostCodeCategoryElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        CostCodeCategory costCodeCategory = XMLImportTestUtil.createDictionaryContainer(CostCodeCategory.class, uid);
        String nameDefault = XHelper.readString((Element)sourceCostCodeCategoryElement, (String)"Description");
        if (!TextUtil.isBlank((String)nameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameDefault.trim());
            }
            costCodeCategory.getTranslations().put(new Locale("en"), nameDefault);
            costCodeCategory.getTranslations().put(new Locale("ru", "RU"), nameDefault);
            costCodeCategory.getTranslations().put(new Locale("uk", "UA"), nameDefault);
        }
        dictionaryContainers.put(uid, (BaseDictionary)costCodeCategory);
    }

    private static void createProfileGroupFromPerson(Document sourceDocument, Element sourceUserElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceUserElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        if (dictionaryContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceUserElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        boolean folder = XHelper.readBoolean((Element)sourceUserElement, (String)"IsFolder", (boolean)false);
        if (!folder) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        ProfileGroup profileGroup = XMLImportTestUtil.createDictionaryContainer(ProfileGroup.class, uid);
        String name = XHelper.readString((Element)sourceUserElement, (String)"Description");
        if (!TextUtil.isBlank((String)name)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, name.trim());
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        profileGroup.getTranslations().put(new Locale("en"), name.trim());
        profileGroup.getTranslations().put(new Locale("ru", "RU"), name.trim());
        profileGroup.getTranslations().put(new Locale("uk", "UA"), name.trim());
        if (profileGroupsNameToUid.containsKey(name.trim())) {
            profileGroupsUidToUid.put(uid, profileGroupsNameToUid.get(name.trim()));
        } else {
            profileGroupsUidToUid.put(uid, uid);
            profileGroupsNameToUid.put(name, uid);
            dictionaryContainers.put(uid, (BaseDictionary)profileGroup);
        }
    }

    private static void createProfileGroupFromUser(Document sourceDocument, Element sourceUserElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceUserElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        if (dictionaryContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceUserElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        boolean folder = XHelper.readBoolean((Element)sourceUserElement, (String)"IsFolder", (boolean)false);
        if (!folder) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        ProfileGroup profileGroup = XMLImportTestUtil.createDictionaryContainer(ProfileGroup.class, uid);
        String name = XHelper.readString((Element)sourceUserElement, (String)"Description");
        if (!TextUtil.isBlank((String)name)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, name.trim());
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        profileGroup.getTranslations().put(new Locale("en"), name.trim());
        profileGroup.getTranslations().put(new Locale("ru", "RU"), name.trim());
        profileGroup.getTranslations().put(new Locale("uk", "UA"), name.trim());
        if (profileGroupsNameToUid.containsKey(name.trim())) {
            profileGroupsUidToUid.put(uid, profileGroupsNameToUid.get(name.trim()));
        } else {
            profileGroupsUidToUid.put(uid, uid);
            profileGroupsNameToUid.put(name, uid);
            dictionaryContainers.put(uid, (BaseDictionary)profileGroup);
        }
    }

    private static void createManagerContainerFromPerson(Document sourceDocument, Element sourcePersonElement, List<Message> messages) throws Exception {
        String profileGroupUid;
        String nameUk;
        String nameEn;
        String uid = XHelper.readString((Element)sourcePersonElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourcePersonElement}));
            return;
        }
        if (entityContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourcePersonElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        boolean folder = XHelper.readBoolean((Element)sourcePersonElement, (String)"IsFolder", (boolean)false);
        if (folder) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        if (agencyReference == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430\"", (String)String.format("\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e \u043d\u0435 \u0431\u044b\u043b\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", new Object[0]), (Object[])new Object[]{sourcePersonElement}));
            return;
        }
        EntityContainer<Person> personContainer = XMLImportTestUtil.createEntityContainer(Person.class, uid);
        Person person = (Person)personContainer.getEntity();
        String nameDefault = XHelper.readString((Element)sourcePersonElement, (String)"Description");
        if (!TextUtil.isBlank((String)nameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameDefault.trim());
            }
            NameInfo nameInfo = new NameInfo();
            TextUtil.splitFullName((String)nameDefault, (PersonalName)nameInfo);
            String lastName = nameInfo.getLastName();
            String firstName = nameInfo.getFirstName();
            String middleName = nameInfo.getMiddleName();
            if (!TextUtil.isBlank((String)lastName)) {
                L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_EN);
                L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_UK);
            }
            if (!TextUtil.isBlank((String)firstName)) {
                L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_EN);
                L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_UK);
            }
            if (!TextUtil.isBlank((String)middleName)) {
                L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_EN);
                L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_UK);
            }
        }
        if (!TextUtil.isBlank((String)(nameEn = XHelper.readString((Element)sourcePersonElement, (String)"Fort_\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u0410\u043d\u0433\u043b")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameEn.trim());
            }
            NameInfo nameInfo = new NameInfo();
            TextUtil.splitFullName((String)nameEn, (PersonalName)nameInfo);
            String lastName = nameInfo.getLastName();
            String firstName = nameInfo.getFirstName();
            String middleName = nameInfo.getMiddleName();
            if (!TextUtil.isBlank((String)lastName)) {
                L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_EN);
            }
            if (!TextUtil.isBlank((String)firstName)) {
                L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_EN);
            }
            if (!TextUtil.isBlank((String)middleName)) {
                L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_EN);
            }
        }
        if (!TextUtil.isBlank((String)(nameUk = XHelper.readString((Element)sourcePersonElement, (String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u0423\u043a\u0440")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameUk.trim());
            }
            NameInfo nameInfo = new NameInfo();
            TextUtil.splitFullName((String)nameUk, (PersonalName)nameInfo);
            String lastName = nameInfo.getLastName();
            String firstName = nameInfo.getFirstName();
            String middleName = nameInfo.getMiddleName();
            if (!TextUtil.isBlank((String)lastName)) {
                L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_UK);
            }
            if (!TextUtil.isBlank((String)firstName)) {
                L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_UK);
            }
            if (!TextUtil.isBlank((String)middleName)) {
                L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_UK);
            }
        }
        if (TextUtil.isBlank((String)(profileGroupUid = XHelper.readString((Element)sourcePersonElement, (String)"Parent"))) || TextUtil.isSame((String)EMPTY_UID, (String)profileGroupUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0431\u0430\u043d\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Parent\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourcePersonElement}));
            return;
        }
        if (!profileGroupsUidToUid.containsKey(profileGroupUid.trim())) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0433\u0440\u0443\u043f\u043f\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", (String)String.format("\u0413\u0440\u0443\u043f\u043f\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", profileGroupUid.trim()), (Object[])new Object[]{sourcePersonElement}));
            return;
        }
        ProfileGroup profileGroup = (ProfileGroup)dictionaryContainers.get(profileGroupsUidToUid.get(profileGroupUid.trim()));
        if (profileGroup == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0433\u0440\u0443\u043f\u043f\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", (String)String.format("\u0413\u0440\u0443\u043f\u043f\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", profileGroupUid.trim()), (Object[])new Object[]{sourcePersonElement}));
            return;
        }
        PersonMetadata metadata = new PersonMetadata();
        metadata.setOrganization(agencyReference);
        MetadataKeyDescriptor metadataKeyDescriptor = (MetadataKeyDescriptor)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).findByCode(MetadataKeyDescriptor.class, MetadataKey.KEY_PERSON_PROFILE_GROUP.name());
        metadata.setKey((DictionaryReference)metadataKeyDescriptor.toReference());
        metadata.setValue((Object)profileGroup.toReference());
        person.getMetadata().add(metadata);
        PersonEmployment personEmployment = new PersonEmployment();
        personEmployment.setOrganization(agencyReference);
        personEmployment.setAuthorized(false);
        person.getEmployments().add(personEmployment);
        person.getTypes().add(PersonType.MANAGER);
        objects.put(uid, personContainer);
        entityContainers.put(uid, personContainer);
    }

    private static void createAgentContainerFromUser(Document sourceDocument, Element sourceUserElement, List<Message> messages) throws Exception {
        String profileGroupUid;
        String uid = XHelper.readString((Element)sourceUserElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        if (entityContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceUserElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        boolean folder = XHelper.readBoolean((Element)sourceUserElement, (String)"IsFolder", (boolean)false);
        if (folder) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String personUid = XHelper.readString((Element)sourceUserElement, (String)"\u0424\u0438\u0437\u041b\u0438\u0446\u043e");
        if (TextUtil.isBlank((String)personUid) || TextUtil.isSame((String)EMPTY_UID, (String)personUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0435 \u043b\u0438\u0446\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0424\u0438\u0437\u041b\u0438\u0446\u043e\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        EntityContainer<? extends BaseEntity> personContainer = entityContainers.get(personUid.trim());
        if (personContainer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", (String)String.format("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", personUid.trim()), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        Person person = (Person)personContainer.getEntity();
        String nameDefault = XHelper.readString((Element)sourceUserElement, (String)"Description");
        if (!TextUtil.isBlank((String)nameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameDefault.trim());
            }
            NameInfo nameInfo = new NameInfo();
            TextUtil.splitFullName((String)nameDefault, (PersonalName)nameInfo);
            String lastName = nameInfo.getLastName();
            String firstName = nameInfo.getFirstName();
            String middleName = nameInfo.getMiddleName();
            if (!TextUtil.isBlank((String)lastName)) {
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_EN);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_RU);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)LocaleUtil.LOCALE_UK, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_UK);
                }
            }
            if (!TextUtil.isBlank((String)firstName)) {
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_EN);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_RU);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)LocaleUtil.LOCALE_UK, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_UK);
                }
            }
            if (!TextUtil.isBlank((String)middleName)) {
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_EN);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_RU);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)LocaleUtil.LOCALE_UK, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_UK);
                }
            }
        }
        if (TextUtil.isBlank((String)(profileGroupUid = XHelper.readString((Element)sourceUserElement, (String)"Parent"))) || TextUtil.isSame((String)EMPTY_UID, (String)profileGroupUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0431\u0430\u043d\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Parent\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        if (!profileGroupsUidToUid.containsKey(profileGroupUid.trim())) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0433\u0440\u0443\u043f\u043f\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", (String)String.format("\u0413\u0440\u0443\u043f\u043f\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", profileGroupUid.trim()), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        ProfileGroup profileGroup = (ProfileGroup)dictionaryContainers.get(profileGroupsUidToUid.get(profileGroupUid.trim()));
        if (profileGroup == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0433\u0440\u0443\u043f\u043f\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", (String)String.format("\u0413\u0440\u0443\u043f\u043f\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", profileGroupUid.trim()), (Object[])new Object[]{sourceUserElement}));
            return;
        }
        PersonMetadata metadata = new PersonMetadata();
        metadata.setOrganization(agencyReference);
        MetadataKeyDescriptor metadataKeyDescriptor = (MetadataKeyDescriptor)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).findByCode(MetadataKeyDescriptor.class, MetadataKey.KEY_PERSON_PROFILE_GROUP.name());
        metadata.setKey((DictionaryReference)metadataKeyDescriptor.toReference());
        metadata.setValue((Object)profileGroup.toReference());
        if (!ProfileHelper.isContainsMetadata((PersonMetadata)metadata, (Collection)person.getMetadata(), (boolean)false)) {
            person.getMetadata().add(metadata);
        }
        person.getTypes().remove(PersonType.MANAGER);
        person.getTypes().add(PersonType.AGENT);
        objects.put(uid, personContainer);
    }

    private static void createManagerContainerFromContactName(Document sourceDocument, Element sourceContactNameElement, List<Message> messages) throws Exception {
        String birthday;
        String sex;
        String nameEn;
        String middleNameDefault;
        String firstNameDefault;
        String uid = XHelper.readString((Element)sourceContactNameElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContactNameElement}));
            return;
        }
        if (entityContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceContactNameElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        EntityContainer<Person> personContainer = XMLImportTestUtil.createEntityContainer(Person.class, uid);
        Person person = (Person)personContainer.getEntity();
        String lastNameDefault = XHelper.readString((Element)sourceContactNameElement, (String)"\u0424\u0430\u043c\u0438\u043b\u0438\u044f");
        if (!TextUtil.isBlank((String)lastNameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, lastNameDefault.trim());
            }
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastNameDefault.trim(), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastNameDefault.trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastNameDefault.trim(), (Locale)LocaleUtil.LOCALE_UK);
        }
        if (!TextUtil.isBlank((String)(firstNameDefault = XHelper.readString((Element)sourceContactNameElement, (String)"\u0418\u043c\u044f")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, firstNameDefault.trim());
            }
            L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstNameDefault.trim(), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstNameDefault.trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstNameDefault.trim(), (Locale)LocaleUtil.LOCALE_UK);
        }
        if (!TextUtil.isBlank((String)(middleNameDefault = XHelper.readString((Element)sourceContactNameElement, (String)"\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, middleNameDefault.trim());
            }
            L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleNameDefault.trim(), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleNameDefault.trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleNameDefault.trim(), (Locale)LocaleUtil.LOCALE_UK);
        }
        if (!TextUtil.isBlank((String)(nameEn = XHelper.readString((Element)sourceContactNameElement, (String)"Fort_\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u0410\u043d\u0433\u043b")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameEn.trim());
            }
            NameInfo nameInfo = new NameInfo();
            TextUtil.splitFullName((String)nameEn, (PersonalName)nameInfo);
            String lastName = nameInfo.getLastName();
            String firstName = nameInfo.getFirstName();
            String middleName = nameInfo.getMiddleName();
            if (!TextUtil.isBlank((String)lastName)) {
                L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_EN);
            }
            if (!TextUtil.isBlank((String)firstName)) {
                L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_EN);
            }
            if (!TextUtil.isBlank((String)middleName)) {
                L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_EN);
            }
        }
        if (!TextUtil.isBlank((String)(sex = XHelper.readString((Element)sourceContactNameElement, (String)"\u041f\u043e\u043b")))) {
            Gender gender = XMLImportTestUtil.getGender(sex.trim());
            if (gender != null) {
                person.setGender(gender);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u043e\u043b \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430", (String)String.format("\u041f\u043e\u043b \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", sex.trim()), (Object[])new Object[]{sourceContactNameElement}));
            }
        }
        if (!TextUtil.isBlank((String)(birthday = XHelper.readString((Element)sourceContactNameElement, (String)"\u0414\u0430\u0442\u0430\u0420\u043e\u0436\u0434\u0435\u043d\u0438\u044f")))) {
            try {
                C1_DATE_FORMAT.parse(birthday);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        person.getTypes().add(PersonType.MANAGER);
        objects.put(uid, personContainer);
        entityContainers.put(uid, personContainer);
    }

    private static void createPassengerContainerFromContragentContactName(Document sourceDocument, Element sourceContragentContactNameElement, List<Message> messages) throws Exception {
        String nameUk;
        String uid = XHelper.readString((Element)sourceContragentContactNameElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContragentContactNameElement}));
            return;
        }
        if (entityContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceContragentContactNameElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String ownerUid = XHelper.readString((Element)sourceContragentContactNameElement, (String)"Owner");
        if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Owner\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceContragentContactNameElement}));
            return;
        }
        EntityContainer<? extends BaseEntity> organizationContainer = entityContainers.get(ownerUid.trim());
        if (organizationContainer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceContragentContactNameElement}));
            return;
        }
        EntityReference organizationReference = organizationContainer.toReference();
        String contactNameUid = XHelper.readString((Element)sourceContragentContactNameElement, (String)"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0435\u041b\u0438\u0446\u043e");
        if (TextUtil.isBlank((String)contactNameUid) || TextUtil.isSame((String)EMPTY_UID, (String)contactNameUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0435 \u043b\u0438\u0446\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0435\u041b\u0438\u0446\u043e\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceContragentContactNameElement}));
            return;
        }
        EntityContainer<? extends BaseEntity> personContainer = entityContainers.get(contactNameUid.trim());
        if (personContainer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0435 \u043b\u0438\u0446\u043e \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430", (String)String.format("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", contactNameUid.trim()), (Object[])new Object[]{sourceContragentContactNameElement}));
            return;
        }
        Person person = (Person)personContainer.getEntity();
        String nameDefault = XHelper.readString((Element)sourceContragentContactNameElement, (String)"Description");
        if (!TextUtil.isBlank((String)nameDefault)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameDefault.trim());
            }
            NameInfo nameInfo = new NameInfo();
            TextUtil.splitFullName((String)nameDefault, (PersonalName)nameInfo);
            String lastName = nameInfo.getLastName();
            String firstName = nameInfo.getFirstName();
            String middleName = nameInfo.getMiddleName();
            if (!TextUtil.isBlank((String)lastName)) {
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_EN);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_RU);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)LocaleUtil.LOCALE_UK, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_UK);
                }
            }
            if (!TextUtil.isBlank((String)firstName)) {
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_EN);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_RU);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)LocaleUtil.LOCALE_UK, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_UK);
                }
            }
            if (!TextUtil.isBlank((String)middleName)) {
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_EN);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_RU);
                }
                if (TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)LocaleUtil.LOCALE_UK, (boolean)true))) {
                    L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_UK);
                }
            }
        }
        if (!TextUtil.isBlank((String)(nameUk = XHelper.readString((Element)sourceContragentContactNameElement, (String)"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0435")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, nameUk.trim());
            }
            NameInfo nameInfo = new NameInfo();
            TextUtil.splitFullName((String)nameUk, (PersonalName)nameInfo);
            String lastName = nameInfo.getLastName();
            String firstName = nameInfo.getFirstName();
            String middleName = nameInfo.getMiddleName();
            if (!TextUtil.isBlank((String)lastName)) {
                L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName.trim(), (Locale)LocaleUtil.LOCALE_UK);
            }
            if (!TextUtil.isBlank((String)firstName)) {
                L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName.trim(), (Locale)LocaleUtil.LOCALE_UK);
            }
            if (!TextUtil.isBlank((String)middleName)) {
                L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName.trim(), (Locale)LocaleUtil.LOCALE_UK);
            }
        }
        PersonEmployment personEmployment = new PersonEmployment();
        personEmployment.setOrganization(organizationReference);
        boolean authorized = XHelper.readBoolean((Element)sourceContragentContactNameElement, (String)"Fort_\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439", (boolean)false);
        personEmployment.setAuthorized(authorized);
        String positionNil = XHelper.readString((Element)sourceContragentContactNameElement, (String)"\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c@xsi:nil");
        if (TextUtil.isBlank((String)positionNil) || !TextUtil.isSame((String)positionNil, (String)"true")) {
            String personPositionName;
            String positionType = XHelper.readString((Element)sourceContragentContactNameElement, (String)"\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c@xsi:type");
            if (TextUtil.isBlank((String)positionType)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0434\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u0438 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"type\" \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \"\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContragentContactNameElement}));
                return;
            }
            if (TextUtil.isSame((String)positionType, (String)"CatalogRef.\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u0438\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0439")) {
                String personPositionUid = XHelper.readString((Element)sourceContragentContactNameElement, (String)"\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c");
                if (!TextUtil.isBlank((String)personPositionUid) && !TextUtil.isSame((String)EMPTY_UID, (String)personPositionUid)) {
                    PersonPosition personPosition = (PersonPosition)dictionaryContainers.get(personPositionUid.trim());
                    if (personPosition == null) {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0434\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430", (String)String.format("\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", personPositionUid.trim()), (Object[])new Object[]{sourceContragentContactNameElement}));
                        return;
                    }
                    personEmployment.setPosition((DictionaryReference)personPosition.toReference());
                }
            } else if (TextUtil.isSame((String)positionType, (String)"xs:string") && !TextUtil.isBlank((String)(personPositionName = XHelper.readString((Element)sourceContragentContactNameElement, (String)"\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c")))) {
                PersonPosition personPosition;
                String personPositionUid = personPositions.get(personPositionName);
                if (TextUtil.isBlank((String)personPositionUid)) {
                    personPositionUid = UUIDGenerator.generate((boolean)false).toString();
                    XMLImportTestUtil.createPersonPositionContainerFromName(sourceDocument, personPositionUid, personPositionName, messages);
                }
                if ((personPosition = (PersonPosition)dictionaryContainers.get(personPositionUid.trim())) == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0434\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430", (String)String.format("\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u0431\u044b\u043b\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0430", personPositionUid.trim()), (Object[])new Object[]{sourceContragentContactNameElement}));
                    return;
                }
                personEmployment.setPosition((DictionaryReference)personPosition.toReference());
            }
        }
        person.getEmployments().add(personEmployment);
        person.getTypes().remove(PersonType.MANAGER);
        person.getTypes().add(PersonType.PASSENGER);
        objects.put(uid, personContainer);
        entityContainers.put(contactNameUid, personContainer);
    }

    private static void createContractFromContragentContract(Document sourceDocument, Element sourceContragentContractElement, List<Message> messages) throws Exception {
        String endDate;
        String startDate;
        String date;
        String uid = XHelper.readString((Element)sourceContragentContractElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContragentContractElement}));
            return;
        }
        if (entityContainers.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceContragentContractElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String status = XHelper.readString((Element)sourceContragentContractElement, (String)"\u0421\u0442\u0430\u0442\u0443\u0441\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        if (TextUtil.isBlank((String)status) || !TextUtil.isSame((String)"\u0410\u043a\u0442\u0438\u0432\u0435\u043d", (String)status)) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String agencyUid = XHelper.readString((Element)sourceContragentContractElement, (String)"\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f");
        if (TextUtil.isBlank((String)agencyUid) || TextUtil.isSame((String)EMPTY_UID, (String)agencyUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceContragentContractElement}));
            return;
        }
        EntityContainer<? extends BaseEntity> agencyContainer = entityContainers.get(agencyUid.trim());
        if (agencyContainer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", agencyUid.trim()), (Object[])new Object[]{sourceContragentContractElement}));
            return;
        }
        String ownerUid = XHelper.readString((Element)sourceContragentContractElement, (String)"Owner");
        if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Owner\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceContragentContractElement}));
            return;
        }
        EntityContainer<? extends BaseEntity> clientContainer = entityContainers.get(ownerUid.trim());
        if (clientContainer == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceContragentContractElement}));
            return;
        }
        EntityReference agencyReference = agencyContainer.toReference();
        EntityReference clientReference = clientContainer.toReference();
        String paymentCurrencyUid = XHelper.readString((Element)sourceContragentContractElement, (String)"\u0412\u0430\u043b\u044e\u0442\u0430\u041e\u043f\u043b\u0430\u0442\u044b");
        if (TextUtil.isBlank((String)paymentCurrencyUid) || TextUtil.isSame((String)EMPTY_UID, (String)paymentCurrencyUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443 \u043e\u043f\u043b\u0430\u0442\u044b \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0412\u0430\u043b\u044e\u0442\u0430\u041e\u043f\u043b\u0430\u0442\u044b\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceContragentContractElement}));
            return;
        }
        String paymentCurrency = (String)objects.get(paymentCurrencyUid.trim());
        if (paymentCurrency == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u0430\u043b\u044e\u0442\u0443 \u043e\u043f\u043b\u0430\u0442\u044b", (String)String.format("\u0412\u0430\u043b\u044e\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", paymentCurrencyUid.trim()), (Object[])new Object[]{sourceContragentContractElement}));
            return;
        }
        EntityContainer<Contract> contractContainer = XMLImportTestUtil.createEntityContainer(Contract.class, uid);
        Contract contract = (Contract)contractContainer.getEntity();
        contract.setSupplier(agencyReference);
        String type = XHelper.readString((Element)sourceContragentContractElement, (String)"\u0412\u0438\u0434\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        if (!TextUtil.isBlank((String)type)) {
            ContractType contractType = XMLImportTestUtil.getContractType(type.trim());
            if (contractType != null) {
                if (!extendedTitle) {
                    extendedTitle = true;
                    title = String.format("%s | %s", title, type.trim());
                }
                contract.setContractType(contractType);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", type.trim()), (Object[])new Object[]{sourceContragentContractElement}));
            }
        }
        ContractCustomerInfo contractCustomerInfo = new ContractCustomerInfo();
        contractCustomerInfo.setPaymentCurrency(paymentCurrency);
        String number = XHelper.readString((Element)sourceContragentContractElement, (String)"Description");
        if (!TextUtil.isBlank((String)number)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, number.trim());
            }
            contract.setName(number.trim());
            contractCustomerInfo.setNumber(number.trim());
        }
        if (!TextUtil.isBlank((String)(date = XHelper.readString((Element)sourceContragentContractElement, (String)"\u0414\u0430\u0442\u0430"))) && !TextUtil.isSame((String)EMPTY_DATE, (String)date)) {
            try {
                contractCustomerInfo.setIssueDate(C1_DATE_FORMAT.parse(date.trim()));
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0434\u0430\u0442\u0443 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\" \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0430\u0442\u043e\u0439", date.trim()), (Object[])new Object[]{sourceContragentContractElement}));
            }
        }
        if (!TextUtil.isBlank((String)(startDate = XHelper.readString((Element)sourceContragentContractElement, (String)"\u0414\u0430\u0442\u0430\u041d\u0430\u0447\u0430\u043b\u0430"))) && !TextUtil.isSame((String)EMPTY_DATE, (String)startDate)) {
            try {
                contractCustomerInfo.setStartDate(C1_DATE_FORMAT.parse(startDate.trim()));
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\" \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0430\u0442\u043e\u0439", startDate.trim()), (Object[])new Object[]{sourceContragentContractElement}));
            }
        }
        if (!TextUtil.isBlank((String)(endDate = XHelper.readString((Element)sourceContragentContractElement, (String)"\u0414\u0430\u0442\u0430\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f"))) && !TextUtil.isSame((String)EMPTY_DATE, (String)endDate)) {
            try {
                contractCustomerInfo.setEndDate(C1_DATE_FORMAT.parse(endDate.trim()));
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0435\u0447\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\" \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0430\u0442\u043e\u0439", endDate.trim()), (Object[])new Object[]{sourceContragentContractElement}));
            }
        }
        contractCustomerInfo.setCustomer(clientReference);
        boolean deposit = XHelper.readBoolean((Element)sourceContragentContractElement, (String)"\u0413\u0430\u0440\u0430\u043d\u0442\u0438\u0440\u0443\u044e\u0449\u0438\u0439\u0414\u0435\u043f\u043e\u0437\u0438\u0442", (boolean)false);
        contractCustomerInfo.getPaymentConditions().setDeposite(deposit);
        BigDecimal depositAmount = XHelper.readBigDecimal((Element)sourceContragentContractElement, (String)"\u0421\u0443\u043c\u043c\u0430\u0414\u0435\u043f\u043e\u0437\u0438\u0442\u0430");
        if (depositAmount != null && depositAmount.compareTo(BigDecimal.ZERO) != 0) {
            Money money = new Money();
            money.setValue(depositAmount);
            money.setCurrency(paymentCurrency);
            contractCustomerInfo.getPaymentConditions().setDepositeAmount(money);
        }
        NodeList sourcePayConditionsNodeList = sourceContragentContractElement.getElementsByTagName("\u0423\u0441\u043b\u043e\u0432\u0438\u044f\u041e\u043f\u043b\u0430\u0442\u044b");
        for (int i = 0; i < sourcePayConditionsNodeList.getLength(); ++i) {
            Element sourcePayConditionsElement = (Element)sourcePayConditionsNodeList.item(i);
            NodeList sourcePayConditionsRowNodeList = sourcePayConditionsElement.getElementsByTagName("Row");
            for (int j = 0; j < sourcePayConditionsRowNodeList.getLength(); ++j) {
                String feePeriodicity;
                Integer feePeriod;
                String feeFOP;
                String servicePeriodicity;
                Integer servicePeriod;
                String serviceFOP;
                Element sourcePayConditionsRowElement = (Element)sourcePayConditionsRowNodeList.item(j);
                PaymentConditionItem paymentConditionItem = new PaymentConditionItem();
                String serviceName = XHelper.readString((Element)sourcePayConditionsRowElement, (String)"\u0412\u0438\u0434\u0414\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438");
                if (!TextUtil.isBlank((String)serviceName)) {
                    String service = XMLImportTestUtil.getService(serviceName.trim());
                    if (!TextUtil.isBlank((String)service)) {
                        if (!TextUtil.isSame((String)SERVICE_ANY_ID, (String)service)) {
                            paymentConditionItem.setAppliedTo(service);
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443", (String)String.format("\u0423\u0441\u043b\u0443\u0433\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", serviceName.trim()), (Object[])new Object[]{sourcePayConditionsElement}));
                    }
                }
                if (!TextUtil.isBlank((String)(serviceFOP = XHelper.readString((Element)sourcePayConditionsRowElement, (String)"\u0424\u043e\u0440\u043c\u0430\u041e\u043f\u043b\u0430\u0442\u044b\u0423\u0441\u043b\u0443\u0433\u0438")))) {
                    PaymentType paymentType = XMLImportTestUtil.getPaymentType(serviceFOP.trim());
                    if (paymentType != null) {
                        paymentConditionItem.setServicePaymentType(paymentType);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0444\u043e\u0440\u043c\u0443 \u043e\u043f\u043b\u0430\u0442\u044b \u0443\u0441\u043b\u0443\u0433\u0438", (String)String.format("\u0424\u043e\u0440\u043c\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", serviceFOP.trim()), (Object[])new Object[]{sourcePayConditionsElement}));
                    }
                }
                if ((servicePeriod = XHelper.readInt((Element)sourcePayConditionsRowElement, (String)"\u0421\u0440\u043e\u043a\u041e\u043f\u043b\u0430\u0442\u044b\u0423\u0441\u043b\u0443\u0433\u0438")) != null) {
                    paymentConditionItem.setServicePaymentTime(servicePeriod);
                }
                if (!TextUtil.isBlank((String)(servicePeriodicity = XHelper.readString((Element)sourcePayConditionsRowElement, (String)"\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c\u041e\u043f\u043b\u0430\u0442\u044b\u0423\u0441\u043b\u0443\u0433")))) {
                    PeriodicityOfPayment periodicityOfPayment = XMLImportTestUtil.getPeriodicityOfPayment(servicePeriodicity.trim());
                    if (periodicityOfPayment != null) {
                        paymentConditionItem.setServicePeriodicity(periodicityOfPayment);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u043e\u043f\u043b\u0430\u0442\u044b \u0443\u0441\u043b\u0443\u0433\u0438", (String)String.format("\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u043e\u043f\u043b\u0430\u0442\u044b \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", servicePeriodicity.trim()), (Object[])new Object[]{sourcePayConditionsElement}));
                    }
                }
                if (!TextUtil.isBlank((String)(feeFOP = XHelper.readString((Element)sourcePayConditionsRowElement, (String)"\u0424\u043e\u0440\u043c\u0430\u041e\u043f\u043b\u0430\u0442\u044b\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e\u0421\u0431\u043e\u0440\u0430")))) {
                    PaymentType paymentType = XMLImportTestUtil.getPaymentType(feeFOP.trim());
                    if (paymentType != null) {
                        paymentConditionItem.setFeePaymentType(paymentType);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0444\u043e\u0440\u043c\u0443 \u043e\u043f\u043b\u0430\u0442\u044b \u0441\u0431\u043e\u0440\u0430", (String)String.format("\u0424\u043e\u0440\u043c\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", feeFOP.trim()), (Object[])new Object[]{sourcePayConditionsElement}));
                    }
                }
                if ((feePeriod = XHelper.readInt((Element)sourcePayConditionsRowElement, (String)"\u0421\u0440\u043e\u043a\u041e\u043f\u043b\u0430\u0442\u044b\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e\u0421\u0431\u043e\u0440\u0430")) != null) {
                    paymentConditionItem.setFeePaymentTime(feePeriod);
                }
                if (!TextUtil.isBlank((String)(feePeriodicity = XHelper.readString((Element)sourcePayConditionsRowElement, (String)"\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c\u041e\u043f\u043b\u0430\u0442\u044b\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e\u0421\u0431\u043e\u0440\u0430")))) {
                    PeriodicityOfPayment periodicityOfPayment = XMLImportTestUtil.getPeriodicityOfPayment(feePeriodicity.trim());
                    if (periodicityOfPayment != null) {
                        paymentConditionItem.setFeePeriodicity(periodicityOfPayment);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u043e\u043f\u043b\u0430\u0442\u044b \u0441\u0431\u043e\u0440\u0430", (String)String.format("\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u043e\u043f\u043b\u0430\u0442\u044b \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", feePeriodicity.trim()), (Object[])new Object[]{sourcePayConditionsElement}));
                    }
                }
                boolean feeSeparately = XHelper.readBoolean((Element)sourcePayConditionsRowElement, (String)"\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439\u0421\u0431\u043e\u0440\u041e\u0442\u0434\u0435\u043b\u044c\u043d\u043e", (boolean)false);
                paymentConditionItem.setFeeSeparately(feeSeparately);
                boolean defaultFOP = XHelper.readBoolean((Element)sourcePayConditionsRowElement, (String)"\u041f\u043e\u0423\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", (boolean)false);
                paymentConditionItem.setPaymentTypeByDefault(defaultFOP);
                contractCustomerInfo.getPaymentConditions().getPaymentItems().add(paymentConditionItem);
            }
        }
        contract.getCustomers().add(contractCustomerInfo);
        entityContainers.put(uid, contractContainer);
    }

    private static void createCommunicationOrAddress(Document sourceDocument, Element sourceContactInfoRegisterElement, List<Message> messages) throws Exception {
        NodeList sourceContactInfoRegisterRecordNodeList = sourceContactInfoRegisterElement.getElementsByTagName("Record");
        for (int i = 0; i < sourceContactInfoRegisterRecordNodeList.getLength(); ++i) {
            Element sourceContactInfoRegisterRecordElement = (Element)sourceContactInfoRegisterRecordNodeList.item(i);
            String ownerUid = XHelper.readString((Element)sourceContactInfoRegisterRecordElement, (String)"\u041e\u0431\u044a\u0435\u043a\u0442");
            if (TextUtil.isBlank((String)ownerUid) || TextUtil.isSame((String)EMPTY_UID, (String)ownerUid)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u041e\u0431\u044a\u0435\u043a\u0442\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContactInfoRegisterRecordElement}));
                continue;
            }
            String ownerType = XHelper.readString((Element)sourceContactInfoRegisterRecordElement, (String)"\u041e\u0431\u044a\u0435\u043a\u0442@xsi:type");
            if (TextUtil.isBlank((String)ownerType)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"type\" \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \"Records/Record/\u041e\u0431\u044a\u0435\u043a\u0442\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContactInfoRegisterRecordElement}));
                continue;
            }
            String type = XHelper.readString((Element)sourceContactInfoRegisterRecordElement, (String)"\u0422\u0438\u043f");
            if (TextUtil.isBlank((String)type)) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Records/Record/\u0422\u0438\u043f\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContactInfoRegisterRecordElement}));
                continue;
            }
            if (TextUtil.isSame((String)ownerType, (String)"CatalogRef.\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b")) {
                Communication communication;
                EntityContainer<? extends BaseEntity> organizationContainer = entityContainers.get(ownerUid.trim());
                if (organizationContainer == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438", (String)String.format("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceContactInfoRegisterRecordElement}));
                    continue;
                }
                Organization organization = (Organization)organizationContainer.getEntity();
                if (TextUtil.isSame((String)type, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d")) {
                    communication = new Communication();
                    XMLImportTestUtil.initializePhoneInternal(sourceDocument, communication, sourceContactInfoRegisterRecordElement, messages);
                    if (communication.getType() == null) continue;
                    organization.getCommunications().add(communication);
                    continue;
                }
                if (TextUtil.isSame((String)type, (String)"\u0410\u0434\u0440\u0435\u0441\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439\u041f\u043e\u0447\u0442\u044b")) {
                    communication = new Communication();
                    XMLImportTestUtil.initializeEmailInternal(sourceDocument, communication, sourceContactInfoRegisterRecordElement, messages);
                    if (communication.getType() == null) continue;
                    organization.getCommunications().add(communication);
                    continue;
                }
                if (TextUtil.isSame((String)type, (String)"\u0410\u0434\u0440\u0435\u0441")) {
                    Address address = new Address();
                    XMLImportTestUtil.initializeAddressInternal(sourceDocument, address, sourceContactInfoRegisterRecordElement, messages);
                    if (address.getAddressType() == null) continue;
                    organization.getAddresses().add(address);
                    continue;
                }
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", type.trim()), (Object[])new Object[]{sourceContactInfoRegisterRecordElement}));
                return;
            }
            if (TextUtil.isSame((String)ownerType, (String)"CatalogRef.\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435\u041b\u0438\u0446\u0430\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432")) {
                PersonCommunication personCommunication;
                EntityContainer personContainer = (EntityContainer)objects.get(ownerUid.trim());
                if (personContainer == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438", (String)String.format("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", ownerUid.trim()), (Object[])new Object[]{sourceContactInfoRegisterRecordElement}));
                    continue;
                }
                Person person = (Person)personContainer.getEntity();
                if (person.getEmployments().size() == 0 || ((PersonEmployment)person.getEmployments().get(0)).getOrganization() == null) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0433\u043e \u043b\u0438\u0446\u0430", (String)String.format("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b", ownerUid.trim()), (Object[])new Object[]{sourceContactInfoRegisterRecordElement}));
                    continue;
                }
                EntityReference organization = ((PersonEmployment)person.getEmployments().get(0)).getOrganization();
                if (TextUtil.isSame((String)type, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d")) {
                    personCommunication = new PersonCommunication();
                    personCommunication.setOrganization(organization);
                    XMLImportTestUtil.initializePhoneInternal(sourceDocument, (Communication)personCommunication, sourceContactInfoRegisterRecordElement, messages);
                    if (personCommunication.getType() == null) continue;
                    person.getCommunications().add(personCommunication);
                    continue;
                }
                if (TextUtil.isSame((String)type, (String)"\u0410\u0434\u0440\u0435\u0441\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439\u041f\u043e\u0447\u0442\u044b")) {
                    personCommunication = new PersonCommunication();
                    personCommunication.setOrganization(organization);
                    XMLImportTestUtil.initializeEmailInternal(sourceDocument, (Communication)personCommunication, sourceContactInfoRegisterRecordElement, messages);
                    if (personCommunication.getType() == null) continue;
                    person.getCommunications().add(personCommunication);
                    continue;
                }
                if (TextUtil.isSame((String)type, (String)"\u0410\u0434\u0440\u0435\u0441")) {
                    PersonAddress personAddress = new PersonAddress();
                    personAddress.setOrganization(organization);
                    XMLImportTestUtil.initializeAddressInternal(sourceDocument, (Address)personAddress, sourceContactInfoRegisterRecordElement, messages);
                    if (personAddress.getAddressType() == null) continue;
                    person.getAddresses().add(personAddress);
                    continue;
                }
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", type.trim()), (Object[])new Object[]{sourceContactInfoRegisterRecordElement}));
                return;
            }
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438", (String)String.format("\u0422\u0438\u043f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", ownerType.trim()), (Object[])new Object[]{sourceContactInfoRegisterRecordElement}));
            return;
        }
    }

    private static void initializePhoneInternal(Document sourceDocument, Communication communication, Element sourceContactInfoRecordElement, List<Message> messages) throws Exception {
        String number;
        String title = "\u0422\u0435\u043b\u0435\u0444\u043e\u043d";
        boolean extendedTitle = false;
        String typeUid = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u0412\u0438\u0434");
        if (TextUtil.isBlank((String)typeUid) || TextUtil.isSame((String)EMPTY_UID, (String)typeUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0412\u0438\u0434\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContactInfoRecordElement}));
            return;
        }
        CommunicationType type = (CommunicationType)objects.get(typeUid.trim());
        if (type == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", typeUid.trim()), (Object[])new Object[]{sourceContactInfoRecordElement}));
            return;
        }
        communication.setType(type);
        boolean empty = true;
        String code = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04352");
        if (!TextUtil.isBlank((String)code)) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, code.trim());
            }
            empty = false;
            communication.setCityCode(code.trim());
        }
        if (!TextUtil.isBlank((String)(number = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04353")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, number.trim());
            }
            empty = false;
            communication.setSense(number.trim());
        }
        if (empty && !TextUtil.isBlank((String)(number = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, number.trim());
            }
            communication.setSense(number.trim());
        }
    }

    private static void initializeEmailInternal(Document sourceDocument, Communication communication, Element sourceContactInfoRecordElement, List<Message> messages) throws Exception {
        String title = "\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430";
        boolean extendedTitle = false;
        String typeUid = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u0412\u0438\u0434");
        if (TextUtil.isBlank((String)typeUid) || TextUtil.isSame((String)EMPTY_UID, (String)typeUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0412\u0438\u0434\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContactInfoRecordElement}));
            return;
        }
        CommunicationType type = (CommunicationType)objects.get(typeUid.trim());
        if (type == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", typeUid.trim()), (Object[])new Object[]{sourceContactInfoRecordElement}));
            return;
        }
        communication.setType(type);
        boolean empty = true;
        String email = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04351");
        if (!TextUtil.isBlank((String)email)) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, email.trim());
            }
            empty = false;
            communication.setSense(email.trim());
        }
        if (empty && !TextUtil.isBlank((String)(email = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, email.trim());
            }
            communication.setSense(email.trim());
        }
    }

    private static void initializeAddressInternal(Document sourceDocument, Address address, Element sourceContactInfoRecordElement, List<Message> messages) throws Exception {
        String flat;
        String housing;
        String house;
        String street;
        String town;
        String city;
        String district;
        String region;
        String title = "\u0410\u0434\u0440\u0435\u0441";
        boolean extendedTitle = false;
        String typeUid = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u0412\u0438\u0434");
        if (TextUtil.isBlank((String)typeUid) || TextUtil.isSame((String)EMPTY_UID, (String)typeUid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"\u0412\u0438\u0434\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContactInfoRecordElement}));
            return;
        }
        AddressType type = (AddressType)objects.get(typeUid.trim());
        if (type == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435", typeUid.trim()), (Object[])new Object[]{sourceContactInfoRecordElement}));
            return;
        }
        address.setAddressType(type);
        boolean empty = true;
        String index = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04351");
        if (!TextUtil.isBlank((String)index)) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, index.trim());
            }
            empty = false;
            address.setZip(index.trim());
        }
        if (!TextUtil.isBlank((String)(region = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04352")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, region.trim());
            }
            empty = false;
            DictionaryReference regionRef = DictHelper.findGeoRegionByName((String)region.trim());
            if (regionRef != null) {
                address.setRegion(regionRef);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0440\u0435\u0433\u0438\u043e\u043d", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0433\u0438\u043e\u043d\u0430 (%s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", region.trim()), (Object[])new Object[]{sourceContactInfoRecordElement}));
            }
        }
        if (!TextUtil.isBlank((String)(district = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04353")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, district.trim());
            }
            empty = false;
            L10nStringHelper.setValue((L10nString)address.getDistrict(), (String)district.trim(), (Locale)LocaleUtil.LOCALE_RU);
        }
        if (!TextUtil.isBlank((String)(city = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04354")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, city.trim());
            }
            empty = false;
            DictionaryReference cityReference = DictHelper.findCityByName((String)city.trim());
            if (cityReference != null) {
                address.setCity(cityReference);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0433\u043e\u0440\u043e\u0434", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430 (%s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", city.trim()), (Object[])new Object[]{sourceContactInfoRecordElement}));
            }
        }
        if (!TextUtil.isBlank((String)(town = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04355")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, town.trim());
            }
            empty = false;
            L10nStringHelper.setValue((L10nString)address.getTown(), (String)town.trim(), (Locale)LocaleUtil.LOCALE_RU);
        }
        if (!TextUtil.isBlank((String)(street = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04356")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, street.trim());
            }
            empty = false;
            L10nStringHelper.setValue((L10nString)address.getAddress(), (String)street.trim(), (Locale)LocaleUtil.LOCALE_RU);
        }
        if (!TextUtil.isBlank((String)(house = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04357")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, house.trim());
            }
            empty = false;
            L10nStringHelper.setValue((L10nString)address.getHouse(), (String)house.trim(), (Locale)LocaleUtil.LOCALE_RU);
        }
        if (!TextUtil.isBlank((String)(housing = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04358")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, housing.trim());
            }
            empty = false;
            L10nStringHelper.setValue((L10nString)address.getHousing(), (String)housing.trim(), (Locale)LocaleUtil.LOCALE_RU);
        }
        if (!TextUtil.isBlank((String)(flat = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u043e\u043b\u04359")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, flat.trim());
            }
            empty = false;
            L10nStringHelper.setValue((L10nString)address.getFlat(), (String)flat.trim(), (Locale)LocaleUtil.LOCALE_RU);
        }
        if (empty && !TextUtil.isBlank((String)(street = XHelper.readString((Element)sourceContactInfoRecordElement, (String)"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435")))) {
            if (!extendedTitle) {
                title = String.format("%s | %s", title, street.trim());
            }
            L10nStringHelper.setValue((L10nString)address.getAddress(), (String)street.trim(), (Locale)LocaleUtil.LOCALE_RU);
        }
    }

    private static void createCommunicationOrAddressType(Document sourceDocument, Element sourceContactInfoTypeElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceContactInfoTypeElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0412\u0438\u0434\u044b\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0412\u0438\u0434\u044b\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceContactInfoTypeElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceContactInfoTypeElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String description = XHelper.readString((Element)sourceContactInfoTypeElement, (String)"Description");
        if (TextUtil.isBlank((String)description)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0412\u0438\u0434\u044b\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0412\u0438\u0434\u044b\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0439\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", uid), (Object[])new Object[]{sourceContactInfoTypeElement}));
            return;
        }
        Enum<?> communicationOrAddressType = XMLImportTestUtil.getCommunicationOrAddressType(description.trim());
        if (communicationOrAddressType == null) {
            return;
        }
        objects.put(uid, communicationOrAddressType);
    }

    private static void createCurrency(Document sourceDocument, Element sourceCurrencyElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceCurrencyElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0412\u0430\u043b\u044e\u0442\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0412\u0430\u043b\u044e\u0442\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCurrencyElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceCurrencyElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String currency = null;
        String currencyCode = XHelper.readString((Element)sourceCurrencyElement, (String)"\u041a\u0440\u0430\u0442\u043a\u043e");
        if (!TextUtil.isBlank((String)currencyCode)) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, currencyCode.trim());
            }
            currency = DictHelper.getCurrencyByAnyCode((String)currencyCode.trim());
        }
        if (currency == null && !TextUtil.isBlank((String)(currencyCode = XHelper.readString((Element)sourceCurrencyElement, (String)"Fort_\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u0410\u043d\u0433\u043b")))) {
            if (!extendedTitle) {
                extendedTitle = true;
                title = String.format("%s | %s", title, currencyCode.trim());
            }
            currency = DictHelper.getCurrencyByAnyCode((String)currencyCode.trim());
        }
        if (currency == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432\u0430\u043b\u044e\u0442\u044b (%s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", title), (Object[])new Object[]{sourceCurrencyElement}));
            return;
        }
        objects.put(uid, currency);
    }

    private static void createCity(Document sourceDocument, Element sourceCityElement, List<Message> messages) throws Exception {
        String cityNameEn;
        String cityNameRu;
        String uid = XHelper.readString((Element)sourceCityElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"Fort_\u0413\u043e\u0440\u043e\u0434\u0430\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"Fort_\u0413\u043e\u0440\u043e\u0434\u0430\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCityElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceCityElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        GeoLocation city = null;
        String description = XHelper.readString((Element)sourceCityElement, (String)"Description");
        if (!TextUtil.isBlank((String)description)) {
            title = String.format("%s | %s", title, description.trim());
        }
        if (!TextUtil.isBlank((String)(cityNameRu = XHelper.readString((Element)sourceCityElement, (String)"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u0420\u0443\u0441")))) {
            title = String.format("%s | %s", title, cityNameRu.trim());
        }
        if (!TextUtil.isBlank((String)(cityNameEn = XHelper.readString((Element)sourceCityElement, (String)"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u0410\u043d\u0433")))) {
            title = String.format("%s | %s", title, cityNameEn.trim());
        }
        if (!(TextUtil.isBlank((String)description) && TextUtil.isBlank((String)cityNameRu) && TextUtil.isBlank((String)cityNameEn))) {
            DictionaryCache cache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
            block0: for (Map.Entry entry : cache.getAll(GeoLocation.class).entrySet()) {
                GeoLocation geoLocation = (GeoLocation)entry.getValue();
                if (!geoLocation.getType().equals((Object)LocationType.CITY)) continue;
                for (String translation : geoLocation.getTranslations().values()) {
                    if (!TextUtil.isBlank((String)description) && description.trim().equalsIgnoreCase(translation)) {
                        city = geoLocation;
                        break block0;
                    }
                    if (!TextUtil.isBlank((String)cityNameRu) && cityNameRu.trim().equalsIgnoreCase(translation)) {
                        city = geoLocation;
                        break block0;
                    }
                    if (TextUtil.isBlank((String)cityNameEn) || !cityNameEn.trim().equalsIgnoreCase(translation)) continue;
                    city = geoLocation;
                    break block0;
                }
            }
        }
        if (city == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0433\u043e\u0440\u043e\u0434", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430 (%s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", title), (Object[])new Object[]{sourceCityElement}));
            return;
        }
        objects.put(uid, city);
    }

    private static void createContractClassOfServiceRestrictions(Document sourceDocument, Element sourceClassificationPriceTypeElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceClassificationPriceTypeElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0422\u0438\u043f\u044b\u0426\u0435\u043d\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0422\u0438\u043f\u044b\u0426\u0435\u043d\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceClassificationPriceTypeElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceClassificationPriceTypeElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String description = XHelper.readString((Element)sourceClassificationPriceTypeElement, (String)"Description");
        if (TextUtil.isBlank((String)description)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0422\u0438\u043f\u044b\u0426\u0435\u043d\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0422\u0438\u043f\u044b\u0426\u0435\u043d\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceClassificationPriceTypeElement}));
            return;
        }
        ClassOfService classOfService = XMLImportTestUtil.getClassOfService(description.trim());
        if (classOfService == null) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043b\u0430\u0441\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043b\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u0430", (String)String.format("\u0422\u0438\u043f \u043a\u043b\u0430\u0441\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", description.trim()), (Object[])new Object[]{sourceClassificationPriceTypeElement}));
            return;
        }
        ArrayList<RuleRestriction> ruleRestrictions = new ArrayList<RuleRestriction>();
        RuleRestriction ruleRestriction = new RuleRestriction();
        ruleRestriction.setProperty((RuleProperty)com.gridnine.xtrip.common.model.rules.standard.Properties.SERVICE_CLASSES);
        ruleRestriction.setCondition((RuleCondition)Conditions.INCLUDE);
        ruleRestriction.setValue(Arrays.asList(classOfService));
        ruleRestrictions.add(ruleRestriction);
        objects.put(uid, ruleRestrictions);
    }

    private static void createContractAirlineRestrictions(Document sourceDocument, Element sourceClassificationSpecificationsElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceClassificationSpecificationsElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceClassificationSpecificationsElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceClassificationSpecificationsElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String airline = XHelper.readString((Element)sourceClassificationSpecificationsElement, (String)"Description");
        if (TextUtil.isBlank((String)airline)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a\u0438\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u044b\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceClassificationSpecificationsElement}));
            return;
        }
        ArrayList<RuleRestriction> ruleRestrictions = new ArrayList<RuleRestriction>();
        RuleRestriction ruleRestriction = new RuleRestriction();
        ruleRestriction.setProperty((RuleProperty)com.gridnine.xtrip.common.model.rules.standard.Properties.CARRIERS);
        ruleRestriction.setCondition((RuleCondition)Conditions.INCLUDE);
        ruleRestriction.setValue(Arrays.asList(airline.trim()));
        ruleRestrictions.add(ruleRestriction);
        objects.put(uid, ruleRestrictions);
    }

    private static void createContractDirectionRestrictions(Document sourceDocument, Element sourceDirectionElement, List<Message> messages) throws Exception {
        String uid = XHelper.readString((Element)sourceDirectionElement, (String)"Ref");
        if (TextUtil.isBlank((String)uid) || TextUtil.isSame((String)EMPTY_UID, (String)uid)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c uid \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041e\u0422_\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041e\u0422_\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Ref\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceDirectionElement}));
            return;
        }
        if (objects.containsKey(uid)) {
            return;
        }
        boolean delete = XHelper.readBoolean((Element)sourceDirectionElement, (String)"DeletionMark", (boolean)false);
        if (delete) {
            return;
        }
        String title = uid;
        boolean extendedTitle = false;
        String route = XHelper.readString((Element)sourceDirectionElement, (String)"Description");
        if (TextUtil.isBlank((String)route)) {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041e\u0422_\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\"", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"\u041e\u0422_\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\" (%s) \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"Description\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", title), (Object[])new Object[]{sourceDirectionElement}));
            return;
        }
        if (TextUtil.isSame((String)route, (String)"\u041f\u043e \u0423\u043a\u0440\u0430\u0438\u043d\u0435")) {
            ArrayList<RuleRestriction> ruleRestrictions = new ArrayList<RuleRestriction>();
            RuleRestriction ruleRestriction = new RuleRestriction();
            ruleRestriction.setProperty((RuleProperty)Properties.TRANSPORTATION_TYPE);
            ruleRestriction.setCondition((RuleCondition)com.gridnine.xtrip.common.ukraine.model.rules.standard.Conditions.TRANSPORTATION_UKRAINE);
            ruleRestrictions.add(ruleRestriction);
            objects.put(uid, ruleRestrictions);
        } else if (TextUtil.isSame((String)route, (String)"\u0421\u041d\u0413")) {
            ArrayList<RuleRestriction> ruleRestrictions = new ArrayList<RuleRestriction>();
            RuleRestriction ruleRestriction = new RuleRestriction();
            ruleRestriction.setProperty((RuleProperty)Properties.TRANSPORTATION_TYPE);
            ruleRestriction.setCondition((RuleCondition)com.gridnine.xtrip.common.ukraine.model.rules.standard.Conditions.TRANSPORTATION_CIS);
            ruleRestrictions.add(ruleRestriction);
            objects.put(uid, ruleRestrictions);
        } else if (TextUtil.isSame((String)route, (String)"\u0415\u0432\u0440\u043e\u043f\u0430")) {
            ArrayList<RuleRestriction> ruleRestrictions = new ArrayList<RuleRestriction>();
            RuleRestriction ruleRestriction = new RuleRestriction();
            ruleRestriction.setProperty((RuleProperty)Properties.TRANSPORTATION_TYPE);
            ruleRestriction.setCondition((RuleCondition)com.gridnine.xtrip.common.ukraine.model.rules.standard.Conditions.TRANSPORTATION_EUROPE);
            ruleRestrictions.add(ruleRestriction);
            objects.put(uid, ruleRestrictions);
        } else if (TextUtil.isSame((String)route, (String)"\u0418\u043d\u0442\u0435\u0440\u043a\u043e\u043d\u0442\u0438\u043d\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e\u0435")) {
            ArrayList<RuleRestriction> ruleRestrictions = new ArrayList<RuleRestriction>();
            RuleRestriction ruleRestriction = new RuleRestriction();
            ruleRestriction.setProperty((RuleProperty)Properties.TRANSPORTATION_TYPE);
            ruleRestriction.setCondition((RuleCondition)com.gridnine.xtrip.common.ukraine.model.rules.standard.Conditions.TRANSPORTATION_INTERCONTINANTAL);
            ruleRestrictions.add(ruleRestriction);
            objects.put(uid, ruleRestrictions);
        } else {
            messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u0430", (String)String.format("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", route.trim()), (Object[])new Object[]{sourceDirectionElement}));
            return;
        }
    }

    private static final <T extends BaseEntity> EntityContainer<T> createEntityContainer(Class<T> entityClass, String uid) throws Exception {
        EntityContainer entityContainer = new EntityContainer(entityClass, uid);
        entityContainer.setCreatedBy(IMPORTER);
        entityContainer.setModifiedBy(IMPORTER);
        VersionInfo versionInfo = entityContainer.getVersionInfo();
        String versionInfoUid = UUIDGenerator.generate((boolean)false).toString();
        versionInfo.setUid(versionInfoUid);
        versionInfo.setCreatedBy(IMPORTER);
        versionInfo.setModifiedBy(IMPORTER);
        String dataSource = "file";
        versionInfo.setDataSource(dataSource);
        return entityContainer;
    }

    private static final <T extends BaseDictionary> T createDictionaryContainer(Class<T> dictionaryClass, String uid) throws Exception {
        BaseDictionary dictionaryContainer = (BaseDictionary)dictionaryClass.newInstance();
        dictionaryContainer.setUid(uid);
        dictionaryContainer.setCode(uid);
        dictionaryContainer.setCreatedBy(IMPORTER);
        dictionaryContainer.setModifiedBy(IMPORTER);
        return (T)dictionaryContainer;
    }

    private static <T extends BaseEntity> Element createEntityContainerElement(Document convertDocument, EntityContainer<T> entityContainer) throws Exception {
        Element entityContainerElement = convertDocument.createElementNS(null, "object");
        entityContainerElement.setAttribute("class", EntityContainer.class.getName());
        entityContainer.toXML(entityContainerElement);
        return entityContainerElement;
    }

    private static <D extends BaseDictionary> Element createDictionatyContainerElement(Document convertDocument, D dictionaryContainer) throws Exception {
        Element dictionaryContainerElement = convertDocument.createElementNS(null, "object");
        dictionaryContainerElement.setAttribute("class", dictionaryContainer.getClass().getName());
        dictionaryContainer.toXML(dictionaryContainerElement);
        return dictionaryContainerElement;
    }

    private static String convertMask(String mask) {
        if (TextUtil.isBlank((String)mask)) {
            return null;
        }
        String convertMask = mask;
        convertMask = convertMask.replaceAll("!", "");
        convertMask = convertMask.replaceAll("^", "");
        convertMask = convertMask.replaceAll("\\\\", "'");
        convertMask = convertMask.replaceAll("(?<!')9", "#");
        convertMask = convertMask.replaceAll("(?<!')U", "A");
        convertMask = convertMask.replaceAll("(?<!')N", "A");
        convertMask = convertMask.replaceAll("(?<!')X", "*");
        convertMask = convertMask.replaceAll("(?<!')h", "H");
        convertMask = convertMask.replaceAll("(?<!')@", "U");
        return convertMask;
    }

    private static OrganizationType getOrganizationType(String organizationType) {
        if (TextUtil.isSame((String)organizationType, (String)"\u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044c")) {
            return OrganizationType.CORPORATE_CLIENT;
        }
        if (TextUtil.isSame((String)organizationType, (String)"\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a")) {
            return OrganizationType.CORPORATE_CLIENT;
        }
        return null;
    }

    private static ContractType getContractType(String contractType) {
        if (TextUtil.isSame((String)contractType, (String)"\u0421\u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u0435\u043c")) {
            return ContractType.CLIENT;
        }
        return null;
    }

    private static PaymentType getPaymentType(String paymentType) {
        if (TextUtil.isSame((String)paymentType, (String)"\u0411\u0435\u0437\u041d\u0430\u043b")) {
            return PaymentType.INVOICE;
        }
        if (TextUtil.isSame((String)paymentType, (String)"\u041a\u0440\u0435\u0434\u0438\u0442\u043d\u0430\u044f\u041a\u0430\u0440\u0442\u0430\u041e\u0444\u0438\u0441")) {
            return PaymentType.CREDIT_CARD_AGENCY;
        }
        if (TextUtil.isSame((String)paymentType, (String)"\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435\u041f\u0440\u0438\u0432\u0430\u0442\u0411\u0430\u043d\u043a")) {
            return PaymentType.CASH;
        }
        if (TextUtil.isSame((String)paymentType, (String)"\u041a\u0440\u0435\u0434\u0438\u0442\u043d\u0430\u044f\u041a\u0430\u0440\u0442\u0430\u0413\u043e\u0441\u0442\u0438\u043d\u0438\u0446\u0430")) {
            return PaymentType.CREDIT_CARD;
        }
        return null;
    }

    private static PeriodicityOfPayment getPeriodicityOfPayment(String periodicityOfPayment) {
        if (TextUtil.isSame((String)periodicityOfPayment, (String)"\u0421\u0432\u043e\u0434\u043d\u044b\u0439\u0421\u0447\u0435\u04422\u0420\u0430\u0437\u0430\u0412\u041c\u0435\u0441")) {
            return PeriodicityOfPayment.TWICE_PER_MONTH;
        }
        if (TextUtil.isSame((String)periodicityOfPayment, (String)"\u041f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0430")) {
            return PeriodicityOfPayment.PREPAYMENT;
        }
        if (TextUtil.isSame((String)periodicityOfPayment, (String)"\u041f\u043e\u0424\u0430\u043a\u0442\u0443")) {
            return PeriodicityOfPayment.NOW;
        }
        if (TextUtil.isSame((String)periodicityOfPayment, (String)"\u0421\u0432\u043e\u0434\u043d\u044b\u0439\u0421\u0447\u0435\u04421\u0420\u0430\u0437\u0412\u041c\u0435\u0441")) {
            return PeriodicityOfPayment.ONCE_PER_MONTH;
        }
        if (TextUtil.isSame((String)periodicityOfPayment, (String)"\u0421\u0432\u043e\u0434\u043d\u044b\u0439\u0421\u0447\u0435\u0442\u041f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u043e")) {
            return PeriodicityOfPayment.ONE_PER_WEEK;
        }
        if (TextUtil.isSame((String)periodicityOfPayment, (String)"\u0421\u0432\u043e\u0434\u043d\u044b\u0439\u0421\u0447\u0435\u0442\u041f\u043e\u043a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u043e")) {
            return PeriodicityOfPayment.ONE_PER_WEEK;
        }
        return null;
    }

    private static Enum<?> getCommunicationOrAddressType(String communicationType) {
        if (TextUtil.isSame((String)communicationType, (String)"\u0410\u0434\u0440\u0435\u0441")) {
            return AddressType.DELIVERY;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0410\u0434\u0440\u0435\u0441 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430")) {
            return AddressType.DELIVERY;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0410\u0434\u0440\u0435\u0441 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 (\u041d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c)")) {
            return AddressType.FACTUAL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0410\u0434\u0440\u0435\u0441 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439")) {
            return AddressType.CONTACT;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430")) {
            return AddressType.FACTUAL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 - \u0448\u0442\u0430\u0431 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u0430")) {
            return AddressType.FACTUAL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438")) {
            return AddressType.FACTUAL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 (\u0440\u0443\u0441\u0441.)")) {
            return AddressType.FACTUAL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0438\u0437. \u0430\u0434\u0440\u0435\u0441 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c")) {
            return AddressType.FACTUAL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u042e\u0440. \u0430\u0434\u0440\u0435\u0441 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c")) {
            return AddressType.LEGAL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430")) {
            return AddressType.LEGAL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438")) {
            return AddressType.LEGAL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430")) {
            return CommunicationType.MOBILE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u041d\u043e\u043c\u0435\u0440 \u0444\u0430\u043a\u0441\u0430")) {
            return CommunicationType.FAX;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b. \u043c\u043e\u0431.")) {
            return CommunicationType.MOBILE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d (\u0441\u0442\u043e\u0439\u043a\u0430 \u0432 \u0433\u043e\u0441\u0442\u0438\u043d\u0438\u0446\u0435)")) {
            return CommunicationType.HOTEL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d 1")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d 2")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d 3")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d 4")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d 5")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")) {
            return CommunicationType.HOTEL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0432 \u0441\u0447\u0435\u0442\u0430\u0445")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0444\u0438\u0437 \u043b\u0438\u0446\u0430 (\u0441\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439)")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0444\u0438\u0437. \u043b\u0438\u0446\u0430")) {
            return CommunicationType.WORK_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0444\u0438\u0437. \u043b\u0438\u0446\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0438\u0439")) {
            return CommunicationType.HOME_PHONE;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0430\u043a\u0441")) {
            return CommunicationType.FAX;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0430\u043a\u0441 \u0410\u041e\u041d")) {
            return CommunicationType.FAX;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0430\u043a\u0441 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430")) {
            return CommunicationType.FAX;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0430\u043a\u0441 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438")) {
            return CommunicationType.FAX;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0424\u0430\u043a\u0441 \u0441\u0442\u043e\u0439\u043a\u0430")) {
            return CommunicationType.FAX;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u0434\u043b\u044f \u043e\u0431\u043c\u0435\u043d\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u043c\u0438")) {
            return CommunicationType.EMAIL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430")) {
            return CommunicationType.EMAIL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043e\u0431\u043c\u0435\u043d\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u043c\u0438")) {
            return CommunicationType.EMAIL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u041e\u0431\u0449\u0438\u0439")) {
            return CommunicationType.EMAIL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0420\u0430\u0431\u043e\u0447\u0438\u0439")) {
            return CommunicationType.EMAIL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f")) {
            return CommunicationType.EMAIL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u0444\u0438\u0437. \u043b\u0438\u0446\u0430")) {
            return CommunicationType.EMAIL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u042d\u043b. \u044f\u0449\u0438\u043a")) {
            return CommunicationType.EMAIL;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0412\u0435\u0431-\u0441\u0430\u0439\u0442 1")) {
            return CommunicationType.WEB;
        }
        if (TextUtil.isSame((String)communicationType, (String)"\u0412\u0435\u0431-\u0441\u0430\u0439\u0442 2")) {
            return CommunicationType.WEB;
        }
        if (TextUtil.isSame((String)communicationType, (String)"web site")) {
            return CommunicationType.WEB;
        }
        return null;
    }

    private static Gender getGender(String gender) {
        if (TextUtil.isSame((String)gender, (String)"\u041c\u0443\u0436\u0441\u043a\u043e\u0439")) {
            return Gender.MALE;
        }
        if (TextUtil.isSame((String)gender, (String)"\u0416\u0435\u043d\u0441\u043a\u0438\u0439")) {
            return Gender.FEMALE;
        }
        return null;
    }

    private static RuleTarget getRuleTarget(String target) {
        if (TextUtil.isSame((String)target, (String)"\u0410\u0432\u0438\u0430")) {
            return Targets.PRODUCT_COMMISSION;
        }
        return null;
    }

    private static String getService(String serviceName) {
        if (TextUtil.isSame((String)serviceName, (String)"\u0410\u0432\u0438\u0430")) {
            return Targets.PRODUCT_COMMISSION.getId();
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u0411\u0413\u0423")) {
            return Targets.HOTELS_DOMESTIC.getId();
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u0412\u0418\u041f")) {
            return SabreSynchronizationAdditionalTargets.VIP_AIRPORT.getId();
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u0412\u0438\u0437\u044b")) {
            return SabreSynchronizationAdditionalTargets.VISUM.getId();
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u0413\u0417\u0420")) {
            return Targets.HOTELS_FOREIGN.getId();
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u0414\u043e\u0441\u0442\u0430\u0432\u043a\u0430")) {
            return Targets.DELIVERY.getId();
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u0416\u0414")) {
            return "RAILWAY_PRODUCT_COMMISSION";
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u041f\u0440\u043e\u0447\u0435\u0435")) {
            return SERVICE_ANY_ID;
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u0421\u0442\u0440\u0430\u0445\u043e\u0432\u0430\u043d\u0438\u0435")) {
            return Targets.INSURANCE_TOURISTIC_COMMISSION.getId();
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442")) {
            return Targets.CAR.getId();
        }
        if (TextUtil.isSame((String)serviceName, (String)"\u0422\u0443\u0440\u0438\u0437\u043c")) {
            // empty if block
        }
        return null;
    }

    private static ClassOfService getClassOfService(String classOfService) {
        if (TextUtil.isSame((String)classOfService, (String)"\u042d\u043a\u043e\u043d\u043e\u043c \u043a\u043b\u0430\u0441\u0441 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442")) {
            return ClassOfService.ECONOMY;
        }
        if (TextUtil.isSame((String)classOfService, (String)"\u0411\u0438\u0437\u043d\u0435\u0441 \u043a\u043b\u0430\u0441\u0441 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442")) {
            return ClassOfService.BUSINESS;
        }
        return null;
    }

    private static MetadataValueType getMetadataValueType(String valueType) {
        if (TextUtil.isSame((String)valueType, (String)"CatalogRef.\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432")) {
            return MetadataValueType.STRING;
        }
        if (TextUtil.isSame((String)valueType, (String)"p1:boolean") || TextUtil.isSame((String)valueType, (String)"xs:boolean")) {
            return MetadataValueType.BOOLEAN;
        }
        if (TextUtil.isSame((String)valueType, (String)"CatalogRef.\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435\u041b\u0438\u0446\u0430")) {
            return MetadataValueType.PERSON;
        }
        return null;
    }

    public static Document getSourceDocument(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    public static String toString(Node node) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer transformer = XUtil.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(new DOMSource(node), new StreamResult(baos));
        return baos.toString("utf-8");
    }

    public static String toStructure(Node node) throws Exception {
        return XMLImportTestUtil.toStructure(node, 0);
    }

    public static String toStructure(Node node, int depth) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TextUtil.repeat((String)"    ", (int)depth));
        stringBuilder.append(node.getNodeName());
        stringBuilder.append("\n");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            stringBuilder.append(XMLImportTestUtil.toStructure(children.item(i), depth + 1));
        }
        return stringBuilder.toString();
    }

    public static void verbose(Document sourceDocument, Document convertDocument) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("= SOURCE STRING ===============================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toString(sourceDocument));
        stringBuilder.append("= CONVERT STRING ==============================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toString(convertDocument));
        stringBuilder.append("= SOURCE STRUCTURE ============================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toStructure(sourceDocument));
        stringBuilder.append("= CONVERT STRUCTURE ===========================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toStructure(convertDocument));
        System.out.println(stringBuilder.toString());
    }

    static {
        entityContainers = new HashMap<String, EntityContainer<? extends BaseEntity>>();
        objects = new HashMap<String, Object>();
        dictionaryContainers = new HashMap<String, BaseDictionary>();
        C1_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
        ruleSettingRestrictionsEqualator = new RuleSettingRestrictionsEqualator();
        ruleSettingsPeriodComparator = new RuleSettingsPeriodComparator();
        ruleSettingsPriorityComparator = new RuleSettingsPriorityComparator();
        personPositions = new HashMap<String, String>();
        profileGroupsNameToUid = new HashMap<String, String>();
        profileGroupsUidToUid = new HashMap<String, String>();
    }

    static interface Equalator<E> {
        public boolean equals(E var1, E var2);
    }

    static class ImportNamespaceContext
    implements NamespaceContext {
        ImportNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("prefix can't be null");
            }
            if ("V8Exch".equals(prefix)) {
                return "http://www.1c.ru/V8/1CV8DtUD/";
            }
            if ("v8".equals(prefix)) {
                return "http://v8.1c.ru/data";
            }
            if ("xsi".equals(prefix)) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (namespaceURI == null) {
                throw new IllegalArgumentException("namespace uri can't be null");
            }
            if (namespaceURI.equals("http://www.1c.ru/V8/1CV8DtUD/")) {
                return "V8Exch";
            }
            if (namespaceURI.equals("http://v8.1c.ru/data")) {
                return "v8";
            }
            if (namespaceURI.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                return "xsi";
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }

    static class RuleSettingRestrictionsEqualator
    implements Equalator<RuleSettings> {
        RuleSettingRestrictionsEqualator() {
        }

        @Override
        public boolean equals(RuleSettings o1, RuleSettings o2) {
            List ruleRestrictions1 = o1.getRestrictions();
            List ruleRestrictions2 = o2.getRestrictions();
            if (ruleRestrictions1.size() != ruleRestrictions2.size()) {
                return false;
            }
            for (int i = 0; i < ruleRestrictions1.size(); ++i) {
                RuleRestriction ruleRestriction2;
                RuleRestriction ruleRestriction1 = (RuleRestriction)ruleRestrictions1.get(i);
                if (ruleRestriction1.equals((Object)(ruleRestriction2 = (RuleRestriction)ruleRestrictions2.get(i)))) continue;
                return false;
            }
            return true;
        }
    }

    static class RuleSettingsPeriodComparator
    implements Comparator<RuleSettings> {
        RuleSettingsPeriodComparator() {
        }

        @Override
        public int compare(RuleSettings o1, RuleSettings o2) {
            return MiscUtil.compare((Date)o1.getPeriodBegin(), (Date)o2.getPeriodBegin());
        }
    }

    static class RuleSettingsPriorityComparator
    implements Comparator<RuleSettings> {
        RuleSettingsPriorityComparator() {
        }

        private int getCount(RuleSettings ruleSettings) {
            HashSet<RuleProperty> ruleProperties = new HashSet<RuleProperty>();
            for (RuleRestriction ruleRestriction : ruleSettings.getRestrictions()) {
                ruleProperties.add(ruleRestriction.getProperty());
            }
            return ruleProperties.size();
        }

        private int getPriority(RuleSettings ruleSettings) {
            int priority = 0;
            for (RuleRestriction ruleRestriction : ruleSettings.getRestrictions()) {
                RuleProperty ruleProperty = ruleRestriction.getProperty();
                if (ruleProperty == com.gridnine.xtrip.common.model.rules.standard.Properties.SERVICE_CLASSES) {
                    priority |= 1;
                    continue;
                }
                if (ruleProperty == com.gridnine.xtrip.common.model.rules.standard.Properties.CARRIERS) {
                    priority |= 2;
                    continue;
                }
                if (ruleProperty == Properties.TRANSPORTATION_TYPE) {
                    priority |= 4;
                    continue;
                }
                if (ruleProperty != com.gridnine.xtrip.common.model.rules.standard.Properties.ROUTE) continue;
                priority |= 8;
            }
            return priority;
        }

        @Override
        public int compare(RuleSettings o1, RuleSettings o2) {
            int result = this.getCount(o2) - this.getCount(o1);
            if (result != 0) {
                return result / Math.abs(result);
            }
            result = this.getPriority(o2) - this.getPriority(o1);
            return result != 0 ? result / Math.abs(result) : 0;
        }
    }

    static class Bank {
        private String name;
        private DictionaryReference<GeoLocation> city;
        private String correspondentAccount;
        private String bik;

        Bank() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setCity(DictionaryReference<GeoLocation> city) {
            this.city = city;
        }

        public DictionaryReference<GeoLocation> getCity() {
            return this.city;
        }

        public void setCorrespondentAccount(String correspondentAccount) {
            this.correspondentAccount = correspondentAccount;
        }

        public String getCorrespondentAccount() {
            return this.correspondentAccount;
        }

        public void setBik(String bik) {
            this.bik = bik;
        }

        public String getBik() {
            return this.bik;
        }
    }

    static class NameInfo
    implements PersonalName {
        private String lastName;
        private String firstName;
        private String middleName;

        NameInfo() {
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public String getMiddleName() {
            return this.middleName;
        }
    }
}

