/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ukraine.utils.excel;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.FeeRemarkTemplate;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationAdditionalTargets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.ukraine.utils.excel.ExcelImportTestUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Document;

public class ExcelImportTestParse
extends ModelTestBase {
    public static final String PATH_TO_1C_XML = "testdata/importProfilesATHold.zip";
    public static final List<String> LIST_OF_PATHS_TO_ORGANIZATIONS = new ArrayList<String>(){
        private static final long serialVersionUID = -4635044248113823548L;
        {
            this.add("testdata/ATH-orgs-4.xls");
        }
    };
    public static final List<String> LIST_OF_PATHS_TO_PERSONS = new ArrayList<String>(){
        private static final long serialVersionUID = 2526203021201375224L;
        {
            this.add("testdata/ATH-persons-10.xls");
        }
    };
    public static final String PATH_TO_FEE_REMARK_TEMPLATE_DICT = "plugins/com.gridnine.xtrip.server.ukraine/source-test/com/gridnine/xtrip/server/ukraine/utils/excel/testdata/FeeRemarkTemplate.xml";
    public static final String PATH_TO_PERSON_POSITION_DICT = "plugins/com.gridnine.xtrip.server.ukraine/source-test/com/gridnine/xtrip/server/ukraine/utils/excel/testdata/PersonPosition.xml";
    public static final String PATH_TO_LEGAL_FORM_DICT = "plugins/com.gridnine.xtrip.server.ukraine/source-test/com/gridnine/xtrip/server/ukraine/utils/excel/testdata/LegalForm.xml";
    public static final String PATH_TO_CITY_DICT = "config/server/setup/dict/GeoLocation.xml";
    public static final String PATH_TO_AIRLINE_DICT = "config/server/setup/dict/Airline.xml";
    public static final String PATH_TO_COUNTRY_DICT = "config/server/setup/dict/Country.xml";
    public static final String PATH_TO_OUTPUT_XML = "temp/server/importProfilesATHtest.zip";

    public void setUp() throws Exception {
        super.setUp();
        this.loadDictionaryFromFile(PATH_TO_LEGAL_FORM_DICT);
        this.loadDictionaryFromFile(PATH_TO_CITY_DICT);
        this.loadDictionaryFromFile(PATH_TO_COUNTRY_DICT);
        this.loadDictionaryFromFile(PATH_TO_AIRLINE_DICT);
        RulesEnvironment re = (RulesEnvironment)Environment.getPublished(RulesEnvironment.class);
        re.registerTargets((RuleTarget[])SabreSynchronizationAdditionalTargets.values());
    }

    private void loadDictionaryFromFile(String path) {
        Document doc;
        List<Object> res = new ArrayList();
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(path);
        }
        catch (Exception e) {
            doc = null;
            e.printStackTrace();
        }
        if (doc != null) {
            try {
                res = ExcelImportTestUtil.getDictionariesFromXml(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (BaseDictionary dict : res) {
            try {
                if (!(dict instanceof FeeRemarkTemplate) && (!(dict instanceof GeoLocation) || ((GeoLocation)dict).getType() != LocationType.CITY) && !(dict instanceof Country) && !(dict instanceof Airline) && !(dict instanceof LegalForm)) continue;
                DictionaryStorage.get().save(dict);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void testExcelImport() {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList<HSSFWorkbook> excelInputOrgsList = new ArrayList<HSSFWorkbook>();
        ArrayList<HSSFWorkbook> excelInputPersonsList = new ArrayList<HSSFWorkbook>();
        try {
            for (String fileName : LIST_OF_PATHS_TO_ORGANIZATIONS) {
                excelInputOrgsList.add(new HSSFWorkbook((InputStream)new FileInputStream(IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource(fileName)))));
            }
            for (String fileName : LIST_OF_PATHS_TO_PERSONS) {
                excelInputPersonsList.add(new HSSFWorkbook((InputStream)new FileInputStream(IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource(fileName)))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (excelInputOrgsList.size() == 0) {
            messages.add(MessageHelper.createErrorMessage((String)"Excel files for organizations not found.", (Object[])null));
        }
        if (excelInputPersonsList.size() == 0) {
            messages.add(MessageHelper.createErrorMessage((String)"Excel files for persons not found.", (Object[])null));
        }
        ArrayList<BaseEntity> containers = new ArrayList<BaseEntity>();
        ZipInputStream zipInput = null;
        ZipFile zipFile = null;
        try {
            zipInput = new ZipInputStream(new FileInputStream(IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource(PATH_TO_1C_XML))));
            zipFile = new ZipFile(IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource(PATH_TO_1C_XML)));
            messages.add(MessageHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"Zip file found.", null, (Object[])null));
        }
        catch (FileNotFoundException e) {
            zipInput = null;
            e.printStackTrace();
        }
        catch (Exception e) {
            zipFile = null;
            e.printStackTrace();
        }
        if (zipFile == null || zipInput == null) {
            messages.add(MessageHelper.createErrorMessage((String)"Zip file not found.", (Object[])null));
            return;
        }
        try {
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                Document doc;
                System.out.println("Reading entry: " + entry.getName());
                try {
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    doc = docBuilder.parse(zipFile.getInputStream(entry));
                }
                catch (Exception e) {
                    doc = null;
                    e.printStackTrace();
                }
                if (doc == null) continue;
                List<BaseEntity> list = ExcelImportTestUtil.getContainersFromXml(doc);
                containers.addAll(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<EntityContainer<BaseEntity>> containersMom = new ArrayList<EntityContainer<BaseEntity>>();
        ArrayList<Document> res = new ArrayList();
        try {
            res = ExcelImportTestUtil.convert(containers, containersMom, excelInputOrgsList, excelInputPersonsList, messages);
            ExcelImportTestUtil.createZipArchive(res, PATH_TO_OUTPUT_XML);
        }
        catch (Exception e) {
            messages.add(MessageHelper.createErrorMessage((String)"Exception while converting documents", (Object[])null));
            messages.add(MessageHelper.createErrorMessage((String)e.getMessage(), (Object[])null));
            e.printStackTrace();
        }
        ExcelImportTestUtil.printMessages(messages, null);
    }
}

