/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ukraine.utils.excel;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommonReasonCode;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FeeRemarkTemplate;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.dict.ServicePlatform;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfileHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.PaymentConditionItem;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.profile.SabreContactEmail;
import com.gridnine.xtrip.common.model.profile.SabreContactPhone;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand1Fnbts;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionAir;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionCar;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionDelivery;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionEts;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionHotel;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionRail;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionTravel;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineType;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.model.profile.WorkMode;
import com.gridnine.xtrip.common.model.profile.WorkModeType;
import com.gridnine.xtrip.common.model.rules.standard.SabreRemarkResult;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationActions;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationAdditionalTargets;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.CarTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.HotelTripartiteContractActions;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKeyCategory;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptor;
import com.gridnine.xtrip.common.model.system.MetadataValueType;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.text.MaskFormatter;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExcelImportTestUtil {
    private static final int EXCEL_LAST_ROW_NUM_ORG = 513;
    private static final String EXCEL_COL_NUM_DESCR_ORG = "A";
    private static final String EXCEL_COL_NUM_VALUE_START_ORG = "B";
    private static final String EXCEL_COL_NUM_VALUE_FINISH_ORG = "I";
    private static final int EXCEL_ROW_NUM_VALUE_START_PER = 1;
    private static final int EXCEL_ROW_NUM_VALUE_FINISH_PER = 1348;
    private static final String EXCEL_COL_NUM_VALUE_START_PER = "A";
    private static final String EXCEL_COL_NUM_VALUE_FINISH_PER = "CR";
    private static final int EXCEL_ROW_NUM_DEFINITION_PER = 0;
    private static final String EXCEL_COL_NUM_DEFINITION_ORG = "A";
    private static final int MAX_ENTRIES_PER_DOCUMENT = 600;
    public static final Locale LOCALE_RU = new Locale("ru");
    public static final Locale LOCALE_EN = new Locale("en");
    private static final Locale LOCALE_UK = new Locale("uk");
    private static final String NODE_OBJECT = "object";
    private static final String EXCEL_SHEET_NAME = "profile2";
    private static final String EXCEL_SHEET_NAME_ORG = "profile1";
    private static final String NULL_KEY = "NULL_KEY";
    public static final String IMPORTER = "importer";
    private static final String EXCEL_COL_NAME_PER = "NAME OF 2-ND LEVEL STAR";
    private static final String EXCEL_COL_DK_PER = "COMPANY NAME";
    private static final String EXCEL_COL_DEP_SUFF = "DEPSUFF";
    private static final String ADDRESS_DELIMITER_SYMBOL = ";";
    private static final String KEY_ORGANIZATION_SERVICE_PLATFORM = "KEY_ORGANIZATION_SERVICE_PLATFORM";
    private static final String KEY_ORGANIZATION_BRAND_CODE_OWNER = "KEY_ORGANIZATION_BRAND_CODE_OWNER";
    private static final List<BaseEntity> particularContainers = new ArrayList<BaseEntity>();
    private static final List<String> uniquePersonsList = new ArrayList<String>();
    private static EntityContainer<Contract> ctrWithMainAgencyCont;
    private static EntityContainer<Organization> mainAgencyCont;
    private static final Map<String, EntityContainer<Organization>> organizationContainers;
    private static final List<EntityReference<Organization>> agencyReferences;
    private static final Map<String, EntityContainer<Organization>> newOrganizationContainers;
    private static final Map<String, Organization> referenceOrganizationContainers;
    private static final Map<String, List<EntityContainer<Person>>> personContainers;
    private static final Map<String, List<EntityContainer<Person>>> newPersonContainers;
    private static final Map<String, List<EntityContainer<Person>>> usedPersonContainers;
    private static final Map<String, EntityContainer<Organization>> usedOrganizationContainers;
    private static final Map<String, EntityContainer<Contract>> contractContainers;
    private static final Map<String, EntityContainer<Contract>> newContractContainers;
    private static final Map<String, EntityContainer<TripartiteContract>> newTripartiteContractContainers;
    private static final Map<String, EntityContainer<BaseCommissionProperties>> commissionContainers;
    public static final Map<String, BaseDictionary> newDictionaryContainers;
    private static final Map<String, DictionaryReference<CostCodeCategory>> costCodeCategoryReferences;
    private static final Map<String, DictionaryReference<CommonReasonCode>> reasonCodesReferences;
    private static final Map<String, DictionaryReference<PersonPosition>> personPositionReferences;
    private static Map<String, DictionaryReference<CostCodeCategory>> costCodeCategoriesMap;
    private static int orgCount;
    private static int perCount;

    public static List<Document> convert(List<BaseEntity> inputContainers, List<EntityContainer<BaseEntity>> containersMom, List<HSSFWorkbook> excelInputOrgsList, List<HSSFWorkbook> excelInputPersonsList, List<Message> messages) throws Exception {
        ArrayList<Document> res = new ArrayList();
        ExcelImportTestUtil.arrangeContainers(inputContainers, messages);
        ExcelImportTestUtil.parseExcelOrganizations(excelInputOrgsList, containersMom, messages);
        ExcelImportTestUtil.parseExcelPersons(excelInputPersonsList, messages);
        ExcelImportTestUtil.collectAllContainersToResultList(inputContainers, messages);
        res = ExcelImportTestUtil.fillResultDocumentList(particularContainers);
        return res;
    }

    private static void arrangeContainers(List<BaseEntity> inputContainers, List<Message> messages) {
        int numOrg = 0;
        int numPer = 0;
        int numOther = 0;
        BufferedWriter bw = ExcelImportTestUtil.createWriterForAdditionalLog("temp/server/persons.txt");
        for (BaseEntity base : inputContainers) {
            if (base instanceof EntityContainer) {
                String key;
                if (((EntityContainer)base).getEntity() instanceof Organization) {
                    Organization org = (Organization)((EntityContainer)base).getEntity();
                    if (org == null) continue;
                    key = !TextUtil.isBlank((String)org.getCode()) ? org.getCode() : NULL_KEY;
                    ExcelImportTestUtil.log2File(bw, "Org. Key: " + key + " ShortName:" + org.getShortName() + " FullName:" + org.getFullName());
                    if (org.getTypes().contains(OrganizationType.AGENCY)) {
                        agencyReferences.add((EntityReference<Organization>)((EntityContainer)base).toReference());
                    }
                    if (organizationContainers.containsKey(key) && !key.equals(NULL_KEY)) {
                        messages.add(MessageHelper.createErrorMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0441 DK = " + key + ", \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 = " + org.getShortName()), (Object[])null));
                    }
                    if (!key.equals(NULL_KEY) && !organizationContainers.containsKey(key)) {
                        organizationContainers.put(key, (EntityContainer<Organization>)((EntityContainer)base));
                        referenceOrganizationContainers.put(((EntityContainer)base).toReference().getUid(), (Organization)((EntityContainer)base).getEntity());
                    }
                    ++numOrg;
                    continue;
                }
                if (((EntityContainer)base).getEntity() instanceof Person) {
                    Person per = (Person)((EntityContainer)base).getEntity();
                    key = ExcelImportTestUtil.getKeyForPerson(per);
                    if (!key.equals(NULL_KEY)) {
                        List<Object> list = !personContainers.containsKey(key) ? new ArrayList() : personContainers.get(key);
                        ExcelImportTestUtil.log2File(bw, "Per. Key: " + key);
                        list.add((EntityContainer)base);
                        personContainers.put(key, list);
                    }
                    ++numPer;
                    continue;
                }
                if (((EntityContainer)base).getEntity() instanceof BaseCommissionProperties) {
                    FeeProperties fee = (FeeProperties)((EntityContainer)base).getEntity();
                    String string = key = fee != null && !TextUtil.isBlank((String)fee.getUid()) ? fee.getUid() : NULL_KEY;
                    if (commissionContainers.containsKey(key) && !key.equals(NULL_KEY)) {
                        messages.add(MessageHelper.createErrorMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0430\u044f\u0441\u044f \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f: " + key), (Object[])null));
                    }
                    if (key.equals(NULL_KEY)) continue;
                    ExcelImportTestUtil.log2File(bw, "Com. Key: " + key);
                    commissionContainers.put(key, (EntityContainer<BaseCommissionProperties>)((EntityContainer)base));
                    continue;
                }
                ++numOther;
                continue;
            }
            if (base instanceof BaseDictionary) {
                if (base instanceof CostCodeCategory) {
                    CostCodeCategory cat = (CostCodeCategory)base;
                    if (!cat.getTranslations().containsKey(LOCALE_EN) || TextUtil.isBlank((String)((String)cat.getTranslations().get(LOCALE_EN)))) continue;
                    costCodeCategoryReferences.put(((String)cat.getTranslations().get(LOCALE_EN)).toUpperCase(), (DictionaryReference<CostCodeCategory>)cat.toReference());
                    try {
                        LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)cat);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(base instanceof PersonPosition)) continue;
                PersonPosition personPosition = (PersonPosition)base;
                personPositionReferences.put(personPosition.getCode(), (DictionaryReference<PersonPosition>)personPosition.toReference());
                try {
                    LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)personPosition);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            ++numOther;
        }
        for (BaseEntity base : inputContainers) {
            if (!(base instanceof EntityContainer) || !(((EntityContainer)base).getEntity() instanceof Contract)) continue;
            Contract ctr = (Contract)((EntityContainer)base).getEntity();
            StringBuilder orgName = new StringBuilder();
            String key = ExcelImportTestUtil.getKeyForContract(ctr, orgName);
            boolean placeToMap = true;
            if (contractContainers.containsKey(key) && !key.equals(NULL_KEY)) {
                messages.add(MessageHelper.createErrorMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0439\u0441\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c, DK \u043a\u043b\u0438\u0435\u043d\u0442\u0430 = " + key + " - " + orgName.toString() + ", \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u2116" + ctr.getName()), (Object[])null));
            }
            if (!placeToMap || key.equals(NULL_KEY)) continue;
            ExcelImportTestUtil.log2File(bw, "Ctr. Key: " + key);
            contractContainers.put(key, (EntityContainer<Contract>)((EntityContainer)base));
        }
        try {
            MetadataKeyDescriptor servicePlatformKeyDescriptorContainer = (MetadataKeyDescriptor)SabreProfileHelper.createDictionaryContainer(MetadataKeyDescriptor.class, (String)KEY_ORGANIZATION_SERVICE_PLATFORM);
            servicePlatformKeyDescriptorContainer.setCategory(MetadataKeyCategory.ORGANIZATION);
            servicePlatformKeyDescriptorContainer.setValueType(MetadataValueType.SERVICE_PLATFORM);
            servicePlatformKeyDescriptorContainer.setPredefined(false);
            servicePlatformKeyDescriptorContainer.getTranslations().put(new Locale("en"), "Service Platform");
            servicePlatformKeyDescriptorContainer.getTranslations().put(new Locale("ru", "RU"), "\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
            servicePlatformKeyDescriptorContainer.getTranslations().put(new Locale("uk", "UA"), "\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
            LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)servicePlatformKeyDescriptorContainer);
            MetadataKeyDescriptor brandCodeOwnerKeyDescriptorContainer = (MetadataKeyDescriptor)SabreProfileHelper.createDictionaryContainer(MetadataKeyDescriptor.class, (String)KEY_ORGANIZATION_SERVICE_PLATFORM);
            servicePlatformKeyDescriptorContainer.setCategory(MetadataKeyCategory.ORGANIZATION);
            servicePlatformKeyDescriptorContainer.setValueType(MetadataValueType.SERVICE_PLATFORM);
            servicePlatformKeyDescriptorContainer.setPredefined(false);
            servicePlatformKeyDescriptorContainer.getTranslations().put(new Locale("en"), "Service Platform");
            servicePlatformKeyDescriptorContainer.getTranslations().put(new Locale("ru", "RU"), "\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
            servicePlatformKeyDescriptorContainer.getTranslations().put(new Locale("uk", "UA"), "\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
            LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)servicePlatformKeyDescriptorContainer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ExcelImportTestUtil.createMainAgency("ATH0001");
        ExcelImportTestUtil.createContractWithMainAgencyContainer();
    }

    private static void createMainAgency(String dkForMainAgency) {
        mainAgencyCont = ExcelImportTestUtil.createOrganizationContainer(dkForMainAgency);
        Organization agency = (Organization)mainAgencyCont.getEntity();
        L10nStringHelper.setValue((L10nString)agency.getFullName(), (String)"ATH", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)agency.getShortName(), (String)"ATH", (Locale)Locale.ENGLISH);
        newOrganizationContainers.put(dkForMainAgency, mainAgencyCont);
        particularContainers.add((BaseEntity)mainAgencyCont);
    }

    private static void createContractWithMainAgencyContainer() {
        try {
            ctrWithMainAgencyCont = SabreProfileHelper.createEntityContainer(Contract.class, (String)UUIDGenerator.generate().toString());
        }
        catch (Exception e) {
            return;
        }
        Contract ctr = (Contract)ctrWithMainAgencyCont.getEntity();
        ctr.setName("ATH contract with clients");
        ctr.setSupplier(mainAgencyCont.toReference());
        ctr.setContractType(ContractType.CLIENT);
        RuleSet rs = new RuleSet();
        ctr.setRuleSet(rs);
        newContractContainers.put(((Organization)mainAgencyCont.getEntity()).getCode(), ctrWithMainAgencyCont);
        contractContainers.put(((Organization)mainAgencyCont.getEntity()).getCode(), ctrWithMainAgencyCont);
        particularContainers.add((BaseEntity)ctrWithMainAgencyCont);
    }

    private static void collectAllContainersToResultList(List<BaseEntity> inputContainers, List<Message> messages) {
        int oldPersonNum = 0;
        boolean newPersonNum = false;
        int usedPersonNum = 0;
        Iterator<BaseEntity> iter = inputContainers.iterator();
        while (iter.hasNext()) {
            EntityContainer p;
            EntityContainer entityContainer;
            Object be;
            BaseEntity a = iter.next();
            if (!(a instanceof EntityContainer) || !((be = (entityContainer = (EntityContainer)a).getEntity()) instanceof Person)) continue;
            if (!((Person)be).getTypes().contains(PersonType.AGENT)) {
                if (!((Person)be).getTypes().contains(PersonType.MANAGER)) {
                    iter.remove();
                    ++oldPersonNum;
                    continue;
                }
                p = (Person)be;
                boolean isTrueManager = false;
                for (PersonEmployment pe : p.getEmployments()) {
                    if (pe.getOrganization() == null || !agencyReferences.contains(pe.getOrganization())) continue;
                    isTrueManager = true;
                    break;
                }
                if (isTrueManager) continue;
                iter.remove();
                ++oldPersonNum;
                continue;
            }
            p = (Person)be;
            if (usedPersonContainers.containsKey(ExcelImportTestUtil.getKeyForPerson((Person)p))) continue;
            System.out.println("Unused Agent: " + p.getLastName() + " " + p.getFirstName());
        }
        for (Map.Entry entry : usedPersonContainers.entrySet()) {
            for (EntityContainer p : (List)entry.getValue()) {
                inputContainers.add((BaseEntity)p);
                String types = "";
                String emplIds = "";
                if (p != null && p.getEntity() != null) {
                    for (PersonType t : ((Person)p.getEntity()).getTypes()) {
                        types = types + t.name() + " ";
                    }
                    for (PersonEmployment pe : ((Person)p.getEntity()).getEmployments()) {
                        EntityContainer<Organization> orgContainerOriginal;
                        EntityReference orgRef = pe.getOrganization();
                        Organization orgTemp = referenceOrganizationContainers.get(orgRef.getUid());
                        if (orgTemp == null || (orgContainerOriginal = organizationContainers.get(orgTemp.getCode())) == null) continue;
                        pe.setOrganization(orgContainerOriginal.toReference());
                    }
                    for (PersonEmployment pe : ((Person)p.getEntity()).getEmployments()) {
                        emplIds = emplIds + pe.getOrganization().getCaption() + " ";
                    }
                }
                if (p == null || p.getEntity() == null) continue;
                System.out.println(((Person)p.getEntity()).getLastName() + " - " + types + " - " + emplIds);
                ++usedPersonNum;
            }
        }
        inputContainers.addAll(newOrganizationContainers.values());
        inputContainers.addAll(newContractContainers.values());
        inputContainers.addAll(newTripartiteContractContainers.values());
        System.out.println("Organizations parsed: " + orgCount);
        System.out.println("Persons parsed: " + perCount);
        particularContainers.addAll(newDictionaryContainers.values());
        Map frtMap = ((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(FeeRemarkTemplate.class);
        Map map = ((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(PersonPosition.class);
        Map metadataMap = ((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(MetadataKeyDescriptor.class);
        Map legalFormMap = ((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(LegalForm.class);
        inputContainers.addAll(frtMap.values());
        for (Map.Entry entry : map.entrySet()) {
            if (((PersonPosition)entry.getValue()).isPredefined()) continue;
            inputContainers.add((BaseEntity)entry.getValue());
        }
        for (Map.Entry entry : metadataMap.entrySet()) {
            if (((MetadataKeyDescriptor)entry.getValue()).isPredefined()) continue;
            inputContainers.add((BaseEntity)entry.getValue());
        }
        for (Map.Entry entry : legalFormMap.entrySet()) {
            particularContainers.add((BaseEntity)entry.getValue());
        }
    }

    private static void parseExcelOrganizations(List<HSSFWorkbook> excelInputOrgsList, List<EntityContainer<BaseEntity>> containersMom, List<Message> messages) {
        HashSet<String> starNames = new HashSet<String>();
        for (HSSFWorkbook hSSFWorkbook : excelInputOrgsList) {
            HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)hSSFWorkbook, (String)EXCEL_SHEET_NAME_ORG);
            List dataColumns = ExcelUtils.prepareDataColumns((String)EXCEL_COL_NUM_VALUE_START_ORG, (String)EXCEL_COL_NUM_VALUE_FINISH_ORG);
            for (String col : dataColumns) {
                LinkedHashMap<String, List<String>> descriptions = new LinkedHashMap<String, List<String>>();
                LinkedHashMap<String, List<String>> values = new LinkedHashMap<String, List<String>>();
                for (int n = 0; n < 513; ++n) {
                    HSSFRow row = sheet.getRow(n);
                    if (row == null) continue;
                    HSSFCell cellDef = row.getCell(ExcelUtils.stringToIndex((String)"A"));
                    HSSFCell cellDescr = row.getCell(ExcelUtils.stringToIndex((String)"A"));
                    HSSFCell cellValue = row.getCell(ExcelUtils.stringToIndex((String)col));
                    if (cellDef == null || cellDescr == null || cellValue == null) continue;
                    String def = ExcelImportTestUtil.readCell(cellDef);
                    String descr = ExcelImportTestUtil.readCell(cellDescr);
                    String value = ExcelImportTestUtil.readCell(cellValue);
                    if (TextUtil.isBlank((String)value)) continue;
                    List<Object> descrList = descriptions.containsKey(def) ? descriptions.get(def) : new ArrayList();
                    descrList.add(descr);
                    descriptions.put(def, descrList);
                    List<Object> valueList = values.containsKey(def) ? values.get(def) : new ArrayList();
                    valueList.add(value);
                    values.put(def, valueList);
                }
                ExcelImportTestUtil.parseExcelDataOrg(descriptions, values, messages, starNames);
            }
        }
        for (BaseEntity baseEntity : containersMom) {
            EntityContainer cont;
            Organization org;
            if (!(baseEntity instanceof EntityContainer) || !(((EntityContainer)baseEntity).getEntity() instanceof Organization) || (org = (Organization)(cont = (EntityContainer)baseEntity).getEntity()) == null || TextUtil.isBlank((String)org.getCode())) continue;
            organizationContainers.put(org.getCode(), (EntityContainer<Organization>)cont);
            if (!org.getCode().equals("MOT8584") && !org.getCode().equals("SAN8623")) continue;
            System.out.println("MOTOROLA OR SANOFI in orgs!");
        }
    }

    private static void parseExcelPersons(List<HSSFWorkbook> excelInputPersonsList, List<Message> messages) {
        for (HSSFWorkbook excelSheet : excelInputPersonsList) {
            HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)excelSheet, (String)EXCEL_SHEET_NAME);
            List dataRows = ExcelUtils.prepareDataRows((int)1, (int)1348);
            HSSFRow titleRow = sheet.getRow(0);
            List dataCols = ExcelUtils.prepareDataColumns((String)"A", (String)EXCEL_COL_NUM_VALUE_FINISH_PER);
            LinkedHashMap<String, String> definitions = new LinkedHashMap<String, String>();
            for (String col : dataCols) {
                HSSFCell cellTitle = titleRow.getCell(ExcelUtils.stringToIndex((String)col));
                if (cellTitle == null) continue;
                String def = ExcelImportTestUtil.readCell(cellTitle);
                definitions.put(col, def.toUpperCase());
            }
            for (Integer rowNum : dataRows) {
                HSSFRow row = sheet.getRow(rowNum.intValue());
                if (row == null) continue;
                LinkedHashMap<String, List<String>> values = new LinkedHashMap<String, List<String>>();
                for (String col : dataCols) {
                    HSSFCell cellValue = row.getCell(ExcelUtils.stringToIndex((String)col));
                    if (cellValue == null) continue;
                    String value = ExcelImportTestUtil.readCell(cellValue);
                    if (!definitions.containsKey(col) || TextUtil.isBlank((String)value)) continue;
                    String key = (String)definitions.get(col);
                    List<Object> temp = values.containsKey(key) ? values.get(key) : new ArrayList();
                    temp.add(value);
                    values.put(key, temp);
                }
                if (values.size() <= 0) continue;
                ExcelImportTestUtil.parseExcelDataPer(values, messages);
            }
        }
    }

    private static void parseExcelDataPer(LinkedHashMap<String, List<String>> values, List<Message> messages) {
        Person per;
        String depSuff;
        String nameValue;
        boolean noNameInExcel = false;
        if (!values.containsKey(EXCEL_COL_NAME_PER) || values.get(EXCEL_COL_NAME_PER) == null || values.get(EXCEL_COL_NAME_PER).size() == 0) {
            noNameInExcel = true;
        }
        if (TextUtil.isBlank((String)(nameValue = values.get(EXCEL_COL_NAME_PER).get(0)))) {
            noNameInExcel = true;
        }
        if (noNameInExcel) {
            messages.add(MessageHelper.createErrorMessage((String)"\u0412 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u043c excel-\u0444\u0430\u0439\u043b\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a \u0431\u0435\u0437 \u0438\u043c\u0435\u043d\u0438", (Object[])null));
            return;
        }
        boolean noDkInExcel = false;
        if (!values.containsKey(EXCEL_COL_DK_PER) || values.get(EXCEL_COL_DK_PER) == null || values.get(EXCEL_COL_DK_PER).size() == 0) {
            noDkInExcel = true;
        }
        String dkValue = values.containsKey(EXCEL_COL_DK_PER) ? values.get(EXCEL_COL_DK_PER).get(0) : "";
        String string = depSuff = values.containsKey(EXCEL_COL_DEP_SUFF) ? values.get(EXCEL_COL_DEP_SUFF).get(0) : "";
        if (TextUtil.isBlank((String)dkValue)) {
            noDkInExcel = true;
        }
        if (noDkInExcel) {
            messages.add(MessageHelper.createErrorMessage((String)("\u0412 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u043c excel-\u0444\u0430\u0439\u043b\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a \u0431\u0435\u0437 DK-\u043d\u043e\u043c\u0435\u0440\u0430 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438: " + nameValue), (Object[])null));
            return;
        }
        if (nameValue.contains("'")) {
            messages.add(MessageHelper.createErrorMessage((String)("\u0410\u043f\u043e\u0441\u0442\u0440\u043e\u0444 \u0432 \u0438\u043c\u0435\u043d\u0438 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430: " + nameValue), (Object[])null));
        }
        nameValue = nameValue.replaceAll("'", "");
        Pattern p = Pattern.compile("([a-zA-Z \\-\\_\\.]+)/([a-zA-Z\\s\\-\\.]+)\\s+([a-zA-Z]+)");
        Pattern p2 = Pattern.compile("([a-zA-Z \\-\\_\\.]+)/([a-zA-Z\\s\\-\\.]+)");
        Matcher m = p.matcher(nameValue);
        Matcher m2 = p2.matcher(nameValue);
        String lastName = "";
        String firstName = "";
        String fullName = "";
        String gender = "";
        if (m.matches()) {
            lastName = m.group(1);
            firstName = m.group(2);
            gender = m.group(3);
            fullName = lastName + " " + firstName;
        } else if (m2.matches()) {
            lastName = m2.group(1);
            firstName = m2.group(2);
            fullName = lastName + " " + firstName;
        } else {
            messages.add(MessageHelper.createErrorMessage((String)("\u0412 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u043c excel-\u0444\u0430\u0439\u043b\u0435 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u043e\u0432 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446 \u0441 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u043c \u043f\u043e\u043b\u0435\u043c \u0438\u043c\u0435\u043d\u0438: " + nameValue), (Object[])null));
            Pattern p3 = Pattern.compile("([a-zA-Z\u0430-\u044f\u0410-\u042f \\-\\_\\.]+)/([a-zA-Z\u0430-\u044f\u0410-\u042f\\s\\-\\.]+)\\s+([a-zA-Z\u0430-\u044f\u0410-\u042f]+)");
            Pattern p4 = Pattern.compile("([a-zA-Z\u0430-\u044f\u0410-\u042f \\-\\_\\.]+)/([a-zA-Z\u0430-\u044f\u0410-\u042f\\s\\-\\.]+)");
            Matcher m3 = p3.matcher(nameValue);
            Matcher m4 = p4.matcher(nameValue);
            if (m3.matches()) {
                lastName = m3.group(1);
                firstName = m3.group(2);
                gender = m3.group(3);
                fullName = lastName + " " + firstName;
            } else if (m4.matches()) {
                lastName = m4.group(1);
                firstName = m4.group(2);
                fullName = lastName + " " + firstName;
            } else {
                messages.add(MessageHelper.createErrorMessage((String)("\u0412 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u043c excel-\u0444\u0430\u0439\u043b\u0435 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u043e\u0432 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446 \u0441 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u043c \u043f\u043e\u043b\u0435\u043c \u0438\u043c\u0435\u043d\u0438 (\u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0440\u0443\u0441\u0441\u043a\u0438\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432): " + nameValue), (Object[])null));
                return;
            }
        }
        EntityReference orgRef = null;
        Organization org = null;
        if (values.containsKey(EXCEL_COL_DK_PER)) {
            EntityContainer<Organization> orgContainer;
            String dkNumber = values.get(EXCEL_COL_DK_PER).get(0);
            if (!organizationContainers.containsKey(dkNumber) && !newOrganizationContainers.containsKey(dkNumber)) {
                messages.add(MessageHelper.createWarningMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430: " + fullName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0441 DK = " + dkNumber), (Object[])null));
                return;
            }
            EntityContainer<Organization> entityContainer = orgContainer = organizationContainers.containsKey(dkNumber) ? organizationContainers.get(dkNumber) : newOrganizationContainers.get(dkNumber);
            if (orgContainer == null || orgContainer.getEntity() == null) {
                messages.add(MessageHelper.createWarningMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430: " + fullName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0441 DK = " + dkNumber), (Object[])null));
            }
            orgRef = orgContainer != null ? orgContainer.toReference() : null;
            Organization organization = org = orgContainer != null ? (Organization)orgContainer.getEntity() : null;
        }
        if (org == null) {
            return;
        }
        EntityContainer<Person> personContainer = ExcelImportTestUtil.getPersonContainer(fullName, orgRef, messages);
        if (personContainer == null || personContainer.getEntity() == null) {
            EntityContainer<Person> cont = ExcelImportTestUtil.createPersonContainer(fullName);
            Person person = per = cont != null ? (Person)cont.getEntity() : null;
            if (per == null) {
                messages.add(MessageHelper.createErrorMessage((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043d\u043e\u0432\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 Person", (Object[])null));
                return;
            }
            String key = ExcelImportTestUtil.getKeyForPerson(per);
            List<Object> temp = !newPersonContainers.containsKey(key) ? new ArrayList() : newPersonContainers.get(key);
            temp.add(cont);
            if (uniquePersonsList.contains(dkValue + " " + key + " " + depSuff)) {
                messages.add(MessageHelper.createErrorMessage((String)("====== \u041e\u0448\u0438\u0431\u043a\u0430! \u041f\u0435\u0440\u0441\u043e\u043d\u0430 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c = " + key + " \u0434\u043b\u044f DK = " + dkValue + " \u0443\u0436\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430!"), (Object[])null));
                return;
            }
            uniquePersonsList.add(dkValue + " " + key + " " + depSuff);
            newPersonContainers.put(key, temp);
            particularContainers.add((BaseEntity)cont);
            ++perCount;
            personContainer = cont;
        } else {
            per = (Person)personContainer.getEntity();
            per.getEmployments().clear();
            Pattern pat = Pattern.compile("(\\S*)\\s(.*)");
            Matcher mat = pat.matcher(fullName);
            if (mat.matches()) {
                L10nStringHelper.setValue((L10nString)per.getLastName(), (String)mat.group(1), (Locale)LocaleUtil.LOCALE_EN);
                L10nStringHelper.setValue((L10nString)per.getFirstName(), (String)mat.group(2), (Locale)LocaleUtil.LOCALE_EN);
            } else {
                L10nStringHelper.setValue((L10nString)per.getLastName(), (String)fullName, (Locale)LocaleUtil.LOCALE_EN);
            }
            particularContainers.add((BaseEntity)personContainer);
            ++perCount;
        }
        ExcelImportTestUtil.clearAllPersonData(per);
        PersonEmployment pe = new PersonEmployment();
        pe.setOrganization(orgRef);
        pe.setDepartmentSuffix(depSuff);
        per.getEmployments().add(pe);
        if (gender.equals("MRS") || gender.equals("MS")) {
            per.setGender(Gender.FEMALE);
        } else {
            per.setGender(Gender.MALE);
        }
        if (!per.getTypes().contains(PersonType.PASSENGER)) {
            per.getTypes().add(PersonType.PASSENGER);
        }
        SabreContactPhone phoneRemark1 = new SabreContactPhone();
        SabreContactPhone phoneRemark2 = new SabreContactPhone();
        SabreContactPhone phoneRemark3 = new SabreContactPhone();
        SabreContactPhone phoneRemark4 = new SabreContactPhone();
        SabreContactEmail emailRemark1 = new SabreContactEmail();
        SabreContactEmail emailRemark2 = new SabreContactEmail();
        for (Map.Entry<String, List<String>> entry : values.entrySet()) {
            String def = entry.getKey();
            List<String> tempValueList = entry.getValue();
            ArrayList<String> valueList = new ArrayList<String>();
            for (String item : tempValueList) {
                valueList.add(item.replace('\u0001', ' '));
            }
            if (valueList == null || valueList.size() == 0) continue;
            String valueFirst = (String)valueList.get(0);
            if (def.contains("SUBJECT LINE-NAME")) {
                ExcelImportTestUtil.parsePersonPosition(per, (EntityReference<Organization>)orgRef, valueFirst, fullName, messages);
                continue;
            }
            if (def.contains("PRIORITY LINES")) {
                ExcelImportTestUtil.parseRemarksPer(per, valueList, SabreProfileLineType.P, null, null, false);
                continue;
            }
            if (def.contains("PHONE PAX 1")) {
                ExcelImportTestUtil.parseCommunicationsPer(per, valueList, (EntityReference<Organization>)orgRef, null, messages);
                continue;
            }
            if (def.contains("PHONE PAX 2")) {
                ExcelImportTestUtil.parseCommunicationsPer(per, valueList, (EntityReference<Organization>)orgRef, null, messages);
                continue;
            }
            if (def.contains("PHONE PAX 3")) {
                ExcelImportTestUtil.parseCommunicationsPer(per, valueList, (EntityReference<Organization>)orgRef, null, messages);
                continue;
            }
            if (def.equals("PHONE AST") && !def.contains("TO") && !def.contains("REMARK")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark1, valueFirst, false, messages);
                continue;
            }
            if (def.equals("PHONE AST REMARK")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark1, valueFirst, true, messages);
                continue;
            }
            if (def.contains("PHONE AST 2") && !def.contains("TO") && !def.contains("REMARK")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark2, valueFirst, false, messages);
                continue;
            }
            if (def.contains("PHONE AST REMARK 2")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark2, valueFirst, true, messages);
                continue;
            }
            if (def.contains("PHONE AST 3") && !def.contains("TO") && !def.contains("REMARK")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark3, valueFirst, false, messages);
                continue;
            }
            if (def.contains("PHONE AST REMARK 3")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark3, valueFirst, true, messages);
                continue;
            }
            if (def.contains("PHONE AST 4") && !def.contains("TO") && !def.contains("REMARK")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark4, valueFirst, false, messages);
                continue;
            }
            if (def.contains("PHONE AST REMARK 4")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark4, valueFirst, true, messages);
                continue;
            }
            if (def.contains("PHONE EMG") && !def.contains("REMARK")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark3, valueFirst, false, messages);
                continue;
            }
            if (def.contains("PHONE EMG REMARK")) {
                ExcelImportTestUtil.parsePhonePerRemarks(phoneRemark3, valueFirst, true, messages);
                continue;
            }
            if (def.contains("E-MAIL PAX") && !def.contains("LANG")) {
                ExcelImportTestUtil.parseCommunicationsPer(per, valueList, (EntityReference<Organization>)orgRef, CommunicationType.EMAIL, messages);
                continue;
            }
            if (def.contains("E-MAIL PAX LANG")) {
                if (valueFirst.equals("U")) {
                    per.setPreferredLocale(LOCALE_RU);
                    continue;
                }
                per.setPreferredLocale(LOCALE_EN);
                continue;
            }
            if (def.contains("E-MAIL AST TO") && !def.contains("REMARK")) {
                ExcelImportTestUtil.parseEmailPerRemark(emailRemark1, valueFirst, "TO:", false);
                continue;
            }
            if (def.contains("E-MAIL AST TO") && def.contains("REMARK")) {
                ExcelImportTestUtil.parseEmailPerRemark(emailRemark1, valueFirst, null, true);
                continue;
            }
            if (def.contains("E-MAIL AST CC") && !def.contains("REMARK")) {
                ExcelImportTestUtil.parseEmailPerRemark(emailRemark2, valueFirst, "CC:", false);
                continue;
            }
            if (def.contains("E-MAIL AST CC") && def.contains("REMARK")) {
                ExcelImportTestUtil.parseEmailPerRemark(emailRemark2, valueFirst, null, true);
                continue;
            }
            if (def.contains("UDID")) {
                ExcelImportTestUtil.parseUdidsPer(per, org, (EntityReference<Organization>)orgRef, def, valueList, messages);
                continue;
            }
            if (def.contains("FF CARD")) {
                ExcelImportTestUtil.parseFrequentFlyerCardsPer(per, valueList, fullName, messages);
                continue;
            }
            if (def.contains("SEAT PREFERENCE") && def.contains("SCRIPT")) {
                ExcelImportTestUtil.parseSeatPreferencePer(per, valueList, false);
                continue;
            }
            if (def.contains("SEAT PREFERENCE") && !def.contains("SCRIPT")) {
                ExcelImportTestUtil.parseSeatPreferencePer(per, valueList, true);
                continue;
            }
            if (def.contains("MEAL PREFERENCE") && def.contains("SCRIPT")) {
                ExcelImportTestUtil.parseMealPreferencePer(per, valueList, false);
                continue;
            }
            if (def.contains("MEAL PREFERENCE") && !def.contains("SCRIPT")) {
                ExcelImportTestUtil.parseMealPreferencePer(per, valueList, true);
                continue;
            }
            if (def.contains("AIR PREFERENCE")) {
                ExcelImportTestUtil.parseRemarksPer(per, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, null, false);
                continue;
            }
            if (def.contains("HOTEL INFORMATION")) {
                ExcelImportTestUtil.parseRemarksPer(per, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, null, false);
                continue;
            }
            if (def.contains("CAR INFORMATION")) {
                ExcelImportTestUtil.parseRemarksPer(per, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.C, null, false);
                continue;
            }
            if (def.contains("RAIL INFORMATION")) {
                ExcelImportTestUtil.parseRemarksPer(per, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.R, null, false);
                continue;
            }
            if (def.contains("CREDIT CARD")) {
                ExcelImportTestUtil.parseCreditCards(per, valueList, fullName, messages);
                continue;
            }
            if (def.contains("PASSPORT DOMESTIC")) {
                ExcelImportTestUtil.parsePassports(per, valueList, fullName, gender, messages);
                continue;
            }
            if (def.contains("PASSPORT FOREIGN")) {
                ExcelImportTestUtil.parsePassports(per, valueList, fullName, gender, messages);
                continue;
            }
            if (def.contains("VISA INFO")) {
                ExcelImportTestUtil.parseVisas(per, valueList, fullName, messages);
                continue;
            }
            if (def.contains("VISA REMARKS")) {
                ExcelImportTestUtil.parseVisasRemarks(per, valueList, fullName, messages);
                continue;
            }
            if (def.contains("INSURANCE")) {
                ExcelImportTestUtil.parseRemarksPer(per, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.N, null, false);
                continue;
            }
            if (def.contains("OTHER INFORMATION")) {
                ExcelImportTestUtil.parseRemarksPer(per, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.O, null, false);
                continue;
            }
            if (!def.contains("ZREMARK")) continue;
            ExcelImportTestUtil.parseRemarksPer(per, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.Z, null, false);
        }
        int phoneNum = 0;
        for (PersonCommunication pc : per.getCommunications()) {
            if (pc.getType() == null || !EnumSet.of(CommunicationType.AGENCY, CommunicationType.MOBILE, CommunicationType.CELL, CommunicationType.HOME_PHONE, CommunicationType.WORK_PHONE).contains(pc.getType())) continue;
            ++phoneNum;
        }
        if (phoneNum == 0) {
            phoneRemark1.setPrimaryContact(true);
        }
        if (!TextUtil.isBlank((String)phoneRemark1.getSense())) {
            per.getSabrePhoneContacts().add(phoneRemark1);
        }
        if (!TextUtil.isBlank((String)phoneRemark2.getSense())) {
            per.getSabrePhoneContacts().add(phoneRemark2);
        }
        if (!TextUtil.isBlank((String)phoneRemark3.getSense())) {
            per.getSabrePhoneContacts().add(phoneRemark3);
        }
        if (!TextUtil.isBlank((String)phoneRemark4.getSense())) {
            per.getSabrePhoneContacts().add(phoneRemark4);
        }
        if (!TextUtil.isBlank((String)emailRemark1.getSense())) {
            per.getSabreEmailContacts().add(emailRemark1);
        }
        if (!TextUtil.isBlank((String)emailRemark2.getSense())) {
            per.getSabreEmailContacts().add(emailRemark2);
        }
    }

    private static void parsePersonPositionOriginal(Person per, EntityReference<Organization> orgRef, String value, String fullName, List<Message> messages) {
        boolean isOrgIndicated = false;
        for (PersonEmployment pe : per.getEmployments()) {
            PersonPosition newPosition;
            String oldProfession;
            if (pe.getOrganization() == null || !pe.getOrganization().equals(orgRef)) continue;
            isOrgIndicated = true;
            DictionaryReference oldPositionRef = pe.getPosition();
            PersonPosition oldPosition = oldPositionRef != null ? (PersonPosition)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(oldPositionRef) : null;
            String string = oldProfession = oldPosition != null && oldPosition.getTranslations().containsKey(LOCALE_EN) ? (String)oldPosition.getTranslations().get(LOCALE_EN) : "";
            if (oldProfession.equals(value) || (newPosition = ExcelImportTestUtil.getOrCreatePersonPosition(value, true)) == null) break;
            pe.setPosition((DictionaryReference)newPosition.toReference());
            break;
        }
        if (!isOrgIndicated) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a \u0441 \u0438\u043c\u0435\u043d\u0435\u043c: " + fullName + " \u043d\u0430\u0439\u0434\u0435\u043d, \u043d\u043e \u0443 \u043d\u0435\u0433\u043e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u043a \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438."), (Object[])null));
            PersonEmployment pe = new PersonEmployment();
            pe.setOrganization(orgRef);
            PersonPosition newPosition = ExcelImportTestUtil.getOrCreatePersonPosition(value, true);
            if (newPosition != null) {
                pe.setPosition((DictionaryReference)newPosition.toReference());
            }
            per.getEmployments().add(pe);
        }
    }

    private static String readCell(HSSFCell cell) {
        String res = "";
        try {
            res = cell.getRichStringCellValue() != null ? cell.getRichStringCellValue().getString().toUpperCase().trim() : "";
        }
        catch (Exception e) {
            try {
                res = String.format("%.0f", cell.getNumericCellValue());
            }
            catch (Exception e2) {
                res = "";
            }
        }
        return res;
    }

    private static void parseExcelDataOrg(Map<String, List<String>> descriptions, Map<String, List<String>> values, List<Message> messages, Set<String> starNames) {
        String orgName;
        if (!values.containsKey("DK NUMBER")) {
            return;
        }
        List<String> dkNumbers = values.get("DK NUMBER");
        if (dkNumbers.size() < 1) {
            return;
        }
        String dkNumber = dkNumbers.get(0);
        if (usedOrganizationContainers.containsKey(dkNumber)) {
            messages.add(MessageHelper.createErrorMessage((String)("====== \u041e\u0448\u0438\u0431\u043a\u0430! \u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 DK = " + dkNumber + " \u0443\u0436\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430!"), (Object[])null));
        }
        EntityContainer<Organization> orgContainer = null;
        if (!organizationContainers.containsKey(dkNumber)) {
            orgContainer = ExcelImportTestUtil.createOrganizationContainer(dkNumber);
            orgName = dkNumber;
            if (values.get("SUBJECT LINE") != null && values.get("SUBJECT LINE").size() > 0) {
                orgName = values.get("SUBJECT LINE").get(0);
            }
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getShortName(), (String)orgName, (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getShortName(), (String)orgName, (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getShortName(), (String)orgName, (Locale)LocaleUtil.LOCALE_UK);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getFullName(), (String)orgName, (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getFullName(), (String)orgName, (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getFullName(), (String)orgName, (Locale)LocaleUtil.LOCALE_UK);
            newOrganizationContainers.put(dkNumber, orgContainer);
            particularContainers.add((BaseEntity)orgContainer);
            ++orgCount;
        } else {
            orgContainer = organizationContainers.get(dkNumber);
            orgName = "";
            if (values.get("SUBJECT LINE") != null && values.get("SUBJECT LINE").size() > 0) {
                orgName = values.get("SUBJECT LINE").get(0);
            }
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getShortName(), (String)orgName, (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getShortName(), (String)orgName, (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getShortName(), (String)orgName, (Locale)LocaleUtil.LOCALE_UK);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getFullName(), (String)orgName, (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getFullName(), (String)orgName, (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)((Organization)orgContainer.getEntity()).getFullName(), (String)orgName, (Locale)LocaleUtil.LOCALE_UK);
            newOrganizationContainers.put(dkNumber, orgContainer);
            particularContainers.add((BaseEntity)orgContainer);
            ++orgCount;
        }
        if (orgContainer == null || orgContainer.getEntity() == null) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0441 DK = " + dkNumber), (Object[])null));
            return;
        }
        usedOrganizationContainers.put(dkNumber, orgContainer);
        Organization org = (Organization)orgContainer.getEntity();
        if (dkNumber.length() != 6 && dkNumber.length() != 7 && dkNumber.length() != 10) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 DK (\u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c 6,7 \u0438\u043b\u0438 10 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432) = " + dkNumber), (Object[])null));
        }
        ExcelImportTestUtil.clearAllOrganizationData(org);
        Address addrFact = null;
        Iterator iter = org.getAddresses().iterator();
        while (iter.hasNext()) {
            Address a = (Address)iter.next();
            if (a.getAddressType() == null || !a.getAddressType().equals((Object)AddressType.FACTUAL)) continue;
            addrFact = a;
            iter.remove();
            break;
        }
        if (addrFact == null) {
            addrFact = new Address();
            addrFact.setUid(UUIDGenerator.generate().toString());
            addrFact.setAddressType(AddressType.FACTUAL);
        }
        Contract ctr = null;
        if (contractContainers.containsKey(org.getCode())) {
            EntityContainer<Contract> ctrCont = contractContainers.get(org.getCode());
            ctr = (Contract)ctrCont.getEntity();
            for (ContractCustomerInfo cci : ctr.getCustomers()) {
                cci.getPaymentConditions().getPaymentItems().clear();
            }
            newContractContainers.put(org.getCode(), ctrCont);
            contractContainers.put(org.getCode(), ctrCont);
            particularContainers.add((BaseEntity)ctrCont);
        }
        EntityContainer<TripartiteContract> tripCtrAirCont = ExcelImportTestUtil.createTripartiteContractContainer(TripartiteContractType.AVIA, (EntityReference<Organization>)orgContainer.toReference());
        TripartiteContract tripCtrAir = (TripartiteContract)tripCtrAirCont.getEntity();
        EntityContainer<TripartiteContract> tripCtrCarCont = ExcelImportTestUtil.createTripartiteContractContainer(TripartiteContractType.CAR, (EntityReference<Organization>)orgContainer.toReference());
        TripartiteContract tripCtrCar = (TripartiteContract)tripCtrCarCont.getEntity();
        EntityContainer<TripartiteContract> tripCtrHotelCont = ExcelImportTestUtil.createTripartiteContractContainer(TripartiteContractType.HOTEL, (EntityReference<Organization>)orgContainer.toReference());
        TripartiteContract tripCtrHotel = (TripartiteContract)tripCtrHotelCont.getEntity();
        boolean hasTripCtrAir = false;
        boolean hasTripCtrCar = false;
        boolean hasTripCtrHotel = false;
        Map templateMap = ((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(FeeRemarkTemplate.class);
        LinkedHashMap<String, String> keyContactsName = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> keyContactsProfession = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> keyContactsPhone1 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> keyContactsPhone2 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> keyContactsEmail = new LinkedHashMap<String, String>();
        if (org.getTypes().size() == 0) {
            org.getTypes().add(OrganizationType.CORPORATE_CLIENT);
        }
        for (Map.Entry<String, List<String>> entry : descriptions.entrySet()) {
            Metadata m;
            String def = entry.getKey();
            List<String> descrList = entry.getValue();
            List<String> tempValueList = values.get(def);
            ArrayList<String> valueList = new ArrayList<String>();
            for (String item : tempValueList) {
                valueList.add(item.replace('\u0001', ' '));
            }
            if (valueList.size() < 1) continue;
            String valueFirst = (String)valueList.get(0);
            String descrFirst = descrList.get(0);
            if (def.equals("STAR NAME")) {
                if (!starNames.contains(valueFirst)) {
                    starNames.add(valueFirst);
                } else {
                    messages.add(MessageHelper.createErrorMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 - \u0434\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 STAR NAME: " + valueFirst), (Object[])null));
                }
                L10nStringHelper.setValue((L10nString)org.getShortName(), (String)valueFirst, (Locale)LocaleUtil.LOCALE_EN);
                if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)org.getShortName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) continue;
                L10nStringHelper.setValue((L10nString)org.getShortName(), (String)valueFirst, (Locale)LocaleUtil.LOCALE_RU);
                continue;
            }
            if (def.equals("SUBJECT LINE")) {
                L10nStringHelper.setValue((L10nString)org.getFullName(), (String)valueFirst, (Locale)LocaleUtil.LOCALE_EN);
                if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)org.getFullName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) continue;
                L10nStringHelper.setValue((L10nString)org.getFullName(), (String)valueFirst, (Locale)LocaleUtil.LOCALE_RU);
                continue;
            }
            if (def.contains("ORG FORM")) {
                ExcelImportTestUtil.parseLegalForm(org, valueFirst, messages);
                continue;
            }
            if (def.equals("PRIORITY LINE")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.P, null, null, false);
                continue;
            }
            if (def.startsWith("ADDRESS")) {
                ExcelImportTestUtil.parseAddress(addrFact, def, valueFirst, messages);
                continue;
            }
            if (def.startsWith("OFFICE TELEPHONE")) {
                ExcelImportTestUtil.parseCommunications(org, valueList, null, messages);
                continue;
            }
            if (def.startsWith("FAX")) {
                ExcelImportTestUtil.parseCommunications(org, valueList, CommunicationType.FAX, messages);
                continue;
            }
            if (def.startsWith("OFFICE EMAIL")) {
                ExcelImportTestUtil.parseCommunications(org, valueList, CommunicationType.EMAIL, messages);
                continue;
            }
            if (def.startsWith("WEB SITE")) {
                ExcelImportTestUtil.parseCommunications(org, valueList, CommunicationType.WEB, messages);
                continue;
            }
            if (def.startsWith("WORKING HOURS")) {
                ExcelImportTestUtil.parseWorkingHours(org, valueList, messages);
                continue;
            }
            if (def.startsWith("ACCOUNT MNGR")) {
                ExcelImportTestUtil.parseAccountManager(org, valueList, messages);
                continue;
            }
            if (def.startsWith("SERVICE CONFIGURATION")) {
                ExcelImportTestUtil.parseServiceConfiguration(org, valueList, messages);
                continue;
            }
            if (def.startsWith("TP -")) {
                ExcelImportTestUtil.parseRemarksForTravelPolicy(org, def, valueList);
                continue;
            }
            if (def.startsWith("UDID")) {
                ExcelImportTestUtil.parseUdids(org, def, descrFirst, valueList, messages);
                continue;
            }
            if (def.startsWith("TRX FEE") && !def.contains("REMARK")) {
                if (ctr == null) {
                    ctr = ExcelImportTestUtil.createContractWithMainAgencySeparate(orgContainer);
                }
                ExcelImportTestUtil.parseContractRule(ctr, def, descrFirst, valueFirst, templateMap, messages);
                continue;
            }
            if (def.startsWith("TRX FEE REMARK")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.F, null, false);
                continue;
            }
            if (def.startsWith("AIR") && !def.contains("CORP PRICING")) {
                ExcelImportTestUtil.parseRemarksForAir(org, def, descrFirst, valueList);
                continue;
            }
            if (def.startsWith("AIR CORP PRICING")) {
                ExcelImportTestUtil.parseCorpPricingForAir(org, tripCtrAir, descrList, valueList);
                hasTripCtrAir = true;
                continue;
            }
            if (def.startsWith("AFS")) {
                ExcelImportTestUtil.parseReasonCodesForAir(org, def, descrFirst, valueFirst, messages);
                continue;
            }
            if (def.startsWith("HOTEL") && !def.contains("CORP PRICING")) {
                ExcelImportTestUtil.parseRemarksForHotel(org, def, descrFirst, valueList);
                continue;
            }
            if (def.startsWith("HOTEL CORP PRICING")) {
                ExcelImportTestUtil.parseCorpPricingForHotel(org, tripCtrHotel, descrList, valueList);
                hasTripCtrHotel = true;
                continue;
            }
            if (def.startsWith("CAR") && !def.contains("CORP ID")) {
                ExcelImportTestUtil.parseRemarksForCar(org, def, descrFirst, valueList);
                continue;
            }
            if (def.startsWith("CAR CORP ID")) {
                ExcelImportTestUtil.parseCorpPricingForCar(org, tripCtrCar, valueList);
                hasTripCtrCar = true;
                continue;
            }
            if (def.startsWith("ETS")) {
                ExcelImportTestUtil.parseRemarksForEts(org, def, valueList);
                continue;
            }
            if (def.startsWith("RAIL")) {
                ExcelImportTestUtil.parseRemarksForRail(org, def, valueList);
                continue;
            }
            if (def.startsWith("DELIVERY")) {
                ExcelImportTestUtil.parseRemarksForDelivery(org, def, descrFirst, valueList);
                continue;
            }
            if (def.startsWith("PAYER")) {
                ExcelImportTestUtil.parsePayers(org, def, descrFirst, valueFirst, messages);
                continue;
            }
            if (def.startsWith("FOP")) {
                if (ctr == null) {
                    ctr = ExcelImportTestUtil.createContractWithMainAgencySeparate(orgContainer);
                }
                ExcelImportTestUtil.parseFops(org, ctr, def, descrFirst, valueFirst, messages);
                continue;
            }
            if (def.startsWith("RMZ")) {
                ExcelImportTestUtil.parseRMZ(org, valueList, messages);
                continue;
            }
            if (def.startsWith("REMARKS FOR AIRL")) {
                ExcelImportTestUtil.parseCmd2(org, valueList, messages);
                continue;
            }
            if (def.startsWith("ITINERARY REMARKS")) {
                ExcelImportTestUtil.parseItineraryRemarks(org, valueList);
                continue;
            }
            if (def.startsWith("INSURANCE")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.N, null, false);
                continue;
            }
            if (def.startsWith("EWTEND INFO REMARK")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.O, null, false);
                continue;
            }
            if (def.startsWith("MICE")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.G, null, false);
                continue;
            }
            if (def.startsWith("VISA")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.V, null, false);
                continue;
            }
            if (def.startsWith("ZREMARK")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.Z, null, false);
                continue;
            }
            if (def.startsWith("CONTACT TEL")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.K, null, false);
                continue;
            }
            if (def.startsWith("E-MAIL")) {
                ExcelImportTestUtil.parseCommunications(org, valueList, CommunicationType.EMAIL, messages);
                continue;
            }
            if (def.equals("BRANDID")) {
                m = new Metadata();
                m.setKey((DictionaryReference)((MetadataKeyDescriptor)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(MetadataKeyDescriptor.class).get(KEY_ORGANIZATION_BRAND_CODE_OWNER)).toReference());
                m.setValue((Object)valueFirst);
                org.getMetadata().add(m);
                continue;
            }
            if (def.equals("BRANDCODE")) {
                m = new Metadata();
                m.setKey((DictionaryReference)((MetadataKeyDescriptor)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(MetadataKeyDescriptor.class).get("KEY_ORGANIZATION_BRAND_CODE_VALUE")).toReference());
                m.setValue((Object)valueFirst);
                org.getMetadata().add(m);
                continue;
            }
            if (def.startsWith("FNBTS")) {
                ExcelImportTestUtil.parseFnbts(org, valueFirst, messages);
                continue;
            }
            if (!def.startsWith("CID")) continue;
            ExcelImportTestUtil.parseClientId(org, valueFirst, messages);
        }
        org.getAddresses().add(addrFact);
        ExcelImportTestUtil.fillRemarksForKeyContacts(org, (EntityReference<Organization>)orgContainer.toReference(), keyContactsName, keyContactsProfession, keyContactsPhone1, keyContactsPhone2, keyContactsEmail, messages);
        if (hasTripCtrAir) {
            newTripartiteContractContainers.put(dkNumber, tripCtrAirCont);
        }
        if (hasTripCtrCar) {
            newTripartiteContractContainers.put(dkNumber, tripCtrCarCont);
        }
        if (hasTripCtrHotel) {
            newTripartiteContractContainers.put(dkNumber, tripCtrHotelCont);
        }
    }

    private static Contract addCustomerToCtrWithMainAgency(EntityContainer<Organization> orgContainer) {
        Contract ctr = (Contract)ctrWithMainAgencyCont.getEntity();
        ContractCustomerInfo cci = new ContractCustomerInfo();
        cci.setCustomer(orgContainer.toReference());
        ctr.getCustomers().add(cci);
        return ctr;
    }

    private static Contract createContractWithMainAgencySeparate(EntityContainer<Organization> orgCont) {
        EntityContainer ctrCont;
        try {
            ctrCont = SabreProfileHelper.createEntityContainer(Contract.class, (String)UUIDGenerator.generate().toString());
        }
        catch (Exception e) {
            return null;
        }
        Contract ctr = (Contract)ctrCont.getEntity();
        Organization client = (Organization)orgCont.getEntity();
        ctr.setName("ATH contract with " + client.getShortName());
        ctr.setSupplier(mainAgencyCont.toReference());
        ctr.setContractType(ContractType.CLIENT);
        ContractCustomerInfo cci = new ContractCustomerInfo();
        cci.setCustomer(orgCont.toReference());
        ctr.getCustomers().add(cci);
        RuleSet rs = new RuleSet();
        ctr.setRuleSet(rs);
        newContractContainers.put(client.getCode(), (EntityContainer<Contract>)ctrCont);
        contractContainers.put(client.getCode(), (EntityContainer<Contract>)ctrCont);
        particularContainers.add((BaseEntity)ctrCont);
        return ctr;
    }

    private static void clearAllOrganizationData(Organization org) {
        org.getAddresses().clear();
        org.getBankAccounts().clear();
        org.getCards().clear();
        org.getCommunications().clear();
        org.getCostCodeProperties().clear();
        org.getCostCodes().clear();
        org.getManagers().clear();
        org.getMetadata().clear();
        org.getPayers().clear();
        org.getResponsiblePersons().clear();
        org.getReasonCodes().clear();
        org.getSabreAdditionalCommand1Lines().clear();
        org.getSabreAdditionalCommand2Lines().clear();
        org.getSabreAdditionalCommand3Lines().clear();
        org.getSabreAdditionalProfileLines().clear();
        org.getTypes().clear();
        org.getVatLicenseNumberHistory().clear();
        org.getVatPayerHistory().clear();
        org.getWorkModes().clear();
        org.setAfsSettings(null);
        org.setAirline(null);
        org.setClientID(null);
        org.setKpp(null);
        org.setLegalForm(null);
        org.setNotes(null);
        org.setOkpoCode(null);
        org.setOldShortName(null);
        org.setOldDkNumber(null);
        org.setParent(null);
        org.setPreferredLocale(null);
        org.setRegistrationId(null);
        org.setSabreNotes(null);
        org.setSigner(null);
        org.setVatLicenseNumber(null);
        org.setVatPayer(null);
        org.getFullName().setStringValue(null);
        org.getShortName().setStringValue(null);
    }

    private static void clearAllPersonData(Person per) {
        per.getAddresses().clear();
        per.getAirlineBonusCards().clear();
        per.getBankAccounts().clear();
        per.getCards().clear();
        per.getCommunications().clear();
        per.getCostCodes().clear();
        per.getEmployments().clear();
        per.getGdsReferences().clear();
        per.getPassports().clear();
        per.getSabreAdditionalProfileLines().clear();
        per.getSabreEmailContacts().clear();
        per.getSabrePhoneContacts().clear();
        per.getSalesPoints().clear();
        per.getTypes().clear();
        per.getVisas().clear();
        per.setGender(null);
        per.setLoginName(null);
        per.setNotes(null);
        per.setOldFirstName(null);
        per.setOldLastName(null);
    }

    private static void parseLegalForm(Organization org, String valueFirst, List<Message> messages) {
        if ("EMPTY".equals(valueFirst)) {
            return;
        }
        LegalForm lf = (LegalForm)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).findByCode(LegalForm.class, valueFirst);
        if (lf == null) {
            messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u044e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0444\u043e\u0440\u043c\u044b: " + valueFirst + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
            return;
        }
        org.setLegalForm((DictionaryReference)lf.toReference());
    }

    private static void parseRemarksForKeyContacts(Organization org, String def, String valueFirst, LinkedHashMap<String, String> keyContactsName, LinkedHashMap<String, String> keyContactsProfession, LinkedHashMap<String, String> keyContactsPhone1, LinkedHashMap<String, String> keyContactsPhone2, LinkedHashMap<String, String> keyContactsEmail, List<Message> messages) {
        Pattern p = Pattern.compile("(.*)\\s+(\\d+)");
        Matcher m = p.matcher(def);
        if (m.matches()) {
            String type = m.group(1);
            String num = m.group(2);
            if (type.contains("CONTACT")) {
                String[] parts = valueFirst.split("-");
                if (parts.length == 4) {
                    keyContactsName.put(num, parts[3]);
                    keyContactsPhone1.put(num, parts[0]);
                    keyContactsProfession.put(num, parts[2]);
                }
            } else if (type.contains("MOB")) {
                String[] parts = valueFirst.split("-");
                if (parts.length == 4) {
                    keyContactsName.put(num, parts[3]);
                    keyContactsPhone2.put(num, parts[0]);
                    keyContactsProfession.put(num, parts[2]);
                }
            } else if (type.contains("E-MAIL")) {
                keyContactsEmail.put(num, valueFirst);
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430: " + def + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
        }
    }

    private static void fillRemarksForKeyContacts(Organization org, EntityReference<Organization> orgRef, LinkedHashMap<String, String> keyContactsName, LinkedHashMap<String, String> keyContactsProfession, LinkedHashMap<String, String> keyContactsPhone1, LinkedHashMap<String, String> keyContactsPhone2, LinkedHashMap<String, String> keyContactsEmail, List<Message> messages) {
        if (orgRef.getUid().equals("9fd0df37-c185-11df-8453-003048621e2b")) {
            System.out.println("BAIN!");
        }
        ArrayList<EntityReference> keyContacts = new ArrayList<EntityReference>();
        for (String num : keyContactsName.keySet()) {
            PersonPosition newPosition;
            PersonCommunication pc;
            EntityContainer<Person> personCont = ExcelImportTestUtil.getPersonContainer(keyContactsName.get(num), orgRef, messages);
            if (personCont != null) {
                PersonCommunication pc2;
                Person person = (Person)personCont.getEntity();
                Pattern pat = Pattern.compile("(\\S*)\\s(.*)");
                Matcher mat = pat.matcher(keyContactsName.get(num));
                if (mat.matches()) {
                    L10nStringHelper.setValue((L10nString)person.getLastName(), (String)mat.group(1), (Locale)LocaleUtil.LOCALE_EN);
                    L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)mat.group(2), (Locale)LocaleUtil.LOCALE_EN);
                } else {
                    L10nStringHelper.setValue((L10nString)person.getLastName(), (String)keyContactsName.get(num), (Locale)LocaleUtil.LOCALE_EN);
                }
                if (!person.getTypes().contains(PersonType.PASSENGER)) {
                    person.getTypes().add(PersonType.PASSENGER);
                    if (person.getTypes().contains(PersonType.MANAGER)) {
                        person.getTypes().remove(PersonType.MANAGER);
                    }
                }
                if (person.getEmployments().size() > 0) {
                    PersonEmployment empl = null;
                    for (PersonEmployment pe : person.getEmployments()) {
                        if (!pe.getOrganization().equals(orgRef)) continue;
                        empl = pe;
                        break;
                    }
                    if (empl != null) {
                        DictionaryReference posRef = empl.getPosition();
                        if (posRef != null) {
                            PersonPosition newPosition2;
                            PersonPosition pos = (PersonPosition)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(posRef);
                            if (pos != null && pos.getTranslations().containsKey(LOCALE_EN) && !((String)pos.getTranslations().get(LOCALE_EN)).equals(keyContactsProfession.get(num)) && (newPosition2 = ExcelImportTestUtil.getOrCreatePersonPosition(keyContactsProfession.get(num), false)) != null) {
                                empl.setPosition((DictionaryReference)newPosition2.toReference());
                            }
                        } else {
                            PersonPosition newPosition3 = ExcelImportTestUtil.getOrCreatePersonPosition(keyContactsProfession.get(num), false);
                            if (newPosition3 != null) {
                                empl.setPosition((DictionaryReference)newPosition3.toReference());
                            }
                        }
                    } else {
                        PersonPosition newPosition4 = ExcelImportTestUtil.getOrCreatePersonPosition(keyContactsProfession.get(num), false);
                        if (newPosition4 != null) {
                            PersonEmployment newEmpl = new PersonEmployment();
                            newEmpl.setPosition((DictionaryReference)newPosition4.toReference());
                            newEmpl.setOrganization(orgRef);
                            person.getEmployments().add(newEmpl);
                        }
                    }
                } else {
                    PersonPosition newPosition5 = ExcelImportTestUtil.getOrCreatePersonPosition(keyContactsProfession.get(num), false);
                    if (newPosition5 != null) {
                        PersonEmployment newEmpl = new PersonEmployment();
                        newEmpl.setPosition((DictionaryReference)newPosition5.toReference());
                        newEmpl.setOrganization(orgRef);
                        person.getEmployments().add(newEmpl);
                    }
                }
                if (keyContactsPhone1.containsKey(num) && !TextUtil.isBlank((String)keyContactsPhone1.get(num))) {
                    pc2 = SabreProfileHelper.parsePhoneBase((String)keyContactsPhone1.get(num), orgRef, (CommunicationType)CommunicationType.WORK_PHONE);
                    person.getCommunications().add(pc2);
                }
                if (keyContactsPhone2.containsKey(num) && !TextUtil.isBlank((String)keyContactsPhone2.get(num))) {
                    pc2 = SabreProfileHelper.parsePhoneBase((String)keyContactsPhone2.get(num), orgRef, (CommunicationType)CommunicationType.MOBILE);
                    person.getCommunications().add(pc2);
                }
                if (keyContactsEmail.containsKey(num) && !TextUtil.isBlank((String)keyContactsEmail.get(num))) {
                    pc2 = SabreProfileHelper.parsePhoneBase((String)keyContactsEmail.get(num), orgRef, (CommunicationType)CommunicationType.EMAIL);
                    person.getCommunications().add(pc2);
                }
                keyContacts.add(personCont.toReference());
                continue;
            }
            EntityContainer<Person> newPersonCont = ExcelImportTestUtil.createPersonContainer(keyContactsName.get(num));
            if (newPersonCont == null) {
                messages.add(MessageHelper.createErrorMessage((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043d\u043e\u0432\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 Person", (Object[])null));
                continue;
            }
            Person person2 = (Person)newPersonCont.getEntity();
            person2.getTypes().add(PersonType.PASSENGER);
            if (keyContactsPhone1.containsKey(num) && !TextUtil.isBlank((String)keyContactsPhone1.get(num))) {
                pc = SabreProfileHelper.parsePhoneBase((String)keyContactsPhone1.get(num), orgRef, (CommunicationType)CommunicationType.WORK_PHONE);
                person2.getCommunications().add(pc);
            }
            if (keyContactsPhone2.containsKey(num) && !TextUtil.isBlank((String)keyContactsPhone2.get(num))) {
                pc = SabreProfileHelper.parsePhoneBase((String)keyContactsPhone2.get(num), orgRef, (CommunicationType)CommunicationType.MOBILE);
                person2.getCommunications().add(pc);
            }
            if (keyContactsEmail.containsKey(num) && !TextUtil.isBlank((String)keyContactsEmail.get(num))) {
                pc = SabreProfileHelper.parsePhoneBase((String)keyContactsEmail.get(num), orgRef, (CommunicationType)CommunicationType.EMAIL);
                person2.getCommunications().add(pc);
            }
            if ((newPosition = ExcelImportTestUtil.getOrCreatePersonPosition(keyContactsProfession.get(num), false)) != null) {
                PersonEmployment newEmpl = new PersonEmployment();
                newEmpl.setPosition((DictionaryReference)newPosition.toReference());
                newEmpl.setOrganization(orgRef);
                person2.getEmployments().add(newEmpl);
            }
            keyContacts.add(newPersonCont.toReference());
            String key = ExcelImportTestUtil.getKeyForPerson(person2);
            List<Object> temp = !newPersonContainers.containsKey(key) ? new ArrayList() : newPersonContainers.get(key);
            temp.add(newPersonCont);
            newPersonContainers.put(key, temp);
        }
        for (EntityReference p : keyContacts) {
            Metadata m = new Metadata();
            m.setKey((DictionaryReference)((MetadataKeyDescriptor)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(MetadataKeyDescriptor.class).get("KEY_ORGANIZATION_KEY_CONTACT")).toReference());
            m.setValue((Object)p);
            org.getMetadata().add(m);
        }
    }

    private static void parseCommunicationsPer(Person per, List<String> valueList, EntityReference<Organization> orgRef, CommunicationType type, List<Message> messages) {
        if (type != null && (type.equals((Object)CommunicationType.EMAIL) || type.equals((Object)CommunicationType.WEB))) {
            for (String value : valueList) {
                PersonCommunication pc = new PersonCommunication();
                if (value.toLowerCase().startsWith("http//")) {
                    value = value.substring("http//".length());
                }
                pc.setType(type);
                pc.setSense(value);
                pc.setOrganization(orgRef);
                per.getCommunications().add(pc);
            }
        } else {
            ExcelImportTestUtil.parsePhonePer(per, valueList, orgRef, type, messages);
        }
    }

    private static void parsePhonePer(Person per, List<String> valueList, EntityReference<Organization> orgRef, CommunicationType titleType, List<Message> messages) {
        for (String str : valueList) {
            if ("-".equals(str)) continue;
            Pattern p1 = Pattern.compile("([0-9X \\-]+)");
            Pattern p2 = Pattern.compile("([0-9X \\-]+)-([a-zA-Z])");
            Matcher m1 = p1.matcher(str);
            Matcher m2 = p2.matcher(str);
            if (m1.matches() || m2.matches()) {
                String number = m1.matches() ? m1.group(1) : m2.group(1);
                String strType = m2.matches() ? m2.group(2) : EXCEL_COL_NUM_VALUE_START_ORG;
                CommunicationType type = ProfileSynchronizationUtil.getCommTypeFromString((String)strType);
                if (type == null) {
                    messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 (\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430): " + str + " \u0434\u043b\u044f " + per.getLastName() + " " + per.getFirstName()), (Object[])null));
                }
                PersonCommunication pc = SabreProfileHelper.parsePhoneBase((String)number, orgRef, (CommunicationType)type);
                per.getCommunications().add(pc);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430: " + str + " \u0434\u043b\u044f " + per.getLastName() + " " + per.getFirstName()), (Object[])null));
        }
    }

    private static void parsePhonePerRemarks(SabreContactPhone phone, String value, boolean isComment, List<Message> messages) {
        if (!isComment) {
            Pattern p = Pattern.compile("([0-9X \\-]+)-([a-zA-Z])");
            Matcher m = p.matcher(value);
            if (m.matches()) {
                String number = m.group(1);
                String strType = m.group(2);
                CommunicationType type = ProfileSynchronizationUtil.getCommTypeFromString((String)strType);
                ExcelImportTestUtil.parsePhoneRemark(phone, number, type);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0432 \u0440\u0435\u043c\u0430\u0440\u043a\u0430\u0445: " + value), (Object[])null));
            }
        } else {
            phone.setContactName(value);
        }
    }

    private static void parseEmailPerRemark(SabreContactEmail email, String valueFirst, String type, boolean isComment) {
        if (!isComment) {
            email.setType(type);
            email.setSense(valueFirst);
        } else {
            email.setContactName(valueFirst);
        }
    }

    private static void parsePhoneRemark(SabreContactPhone phone, String str, CommunicationType type) {
        if (type != null) {
            phone.setType(type);
            if (type == CommunicationType.WEB || type == CommunicationType.EMAIL) {
                phone.setSense(str);
            } else {
                Pattern p1 = Pattern.compile("(\\d+)[\\s-]+(\\d+)[\\s-]+([\\d\\s-]+)X?(\\d*)");
                Pattern p2 = Pattern.compile("(\\d+)[\\s-]+([\\d\\s-]+)X?(\\d*)");
                Matcher m1 = p1.matcher(str);
                Matcher m2 = p2.matcher(str);
                if (m1.matches()) {
                    phone.setCountryCode(m1.group(1));
                    phone.setCityCode(m1.group(2));
                    phone.setSense(m1.group(3));
                    if (m1.groupCount() == 4) {
                        String internal = m1.group(4);
                        phone.setInternalNumber(internal);
                    }
                } else if (m2.matches()) {
                    phone.setCityCode(m2.group(1));
                    phone.setSense(m2.group(2));
                    if (m2.groupCount() == 3) {
                        String internal = m2.group(3);
                        phone.setInternalNumber(internal);
                    }
                } else {
                    phone.setSense(str);
                }
            }
        } else {
            phone.setSense(str);
        }
    }

    private static void parseReasonCodesForAir(Organization org, String def, String descrFirst, String valueFirst, List<Message> messages) {
        if (def.contains("VALIDATION")) {
            if (valueFirst.toUpperCase().equals("Y")) {
                org.setSabreStatistics(true);
            } else {
                org.setSabreStatistics(false);
            }
        } else {
            Pattern p = Pattern.compile("([A-Z]+)\\s*-\\s*(.*)");
            Matcher m = p.matcher(valueFirst);
            if (m.matches()) {
                String letter = m.group(1);
                String value = m.group(2);
                boolean hasCode = false;
                for (ReasonCode rc : org.getReasonCodes()) {
                    if (!rc.getType().equals((Object)ReasonCodeType.REASON_CODE_AIR) || !rc.getName().equals(letter)) continue;
                    rc.setSabreName(value);
                    hasCode = true;
                    break;
                }
                if (!hasCode) {
                    org.getReasonCodes().add(ExcelImportTestUtil.createReasonCode(ReasonCodeType.REASON_CODE_AIR, letter, value));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0440\u0438\u0437\u043e\u043d-\u043a\u043e\u0434\u0430: " + valueFirst + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
            }
        }
    }

    private static void parseRemarksForAir(Organization org, String def, String descr, List<String> valueList) {
        if (def.contains("OPTIONS")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, SabreProfileLineSubsectionAir.OPTIONS.toString(), false);
        } else if (def.contains("PREFERENCES")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, SabreProfileLineSubsectionAir.PREFERENCES.toString(), false);
        } else if (def.contains("BLACK LIST")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, SabreProfileLineSubsectionAir.BLACKLIST_AIRLINES.toString(), false);
        } else if (def.contains("CLASS OF SERVICE")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, SabreProfileLineSubsectionAir.CLASS.toString(), false);
        } else if (def.contains("FARE SEARCH WINDOW")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, SabreProfileLineSubsectionAir.FARE_SEARCH_WINDOW.toString(), false);
        } else if (def.contains("OUT OF POLICY")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, SabreProfileLineSubsectionAir.OOP.toString(), false);
        } else if (def.contains("CORP DEALS")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, SabreProfileLineSubsectionAir.CORPORATE_DEALS.toString(), false);
        } else if (!def.contains("CORP PRICING")) {
            if (def.contains("LOYALTY PROG")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, SabreProfileLineSubsectionAir.LOYALTY_PRG.toString(), false);
            } else if (def.contains("TICKETING")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, SabreProfileLineSubsectionAir.TICKETING.toString(), false);
            } else if (def.contains("FREE TEXT")) {
                ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.A, null, false);
            }
        }
    }

    private static void parseRemarksForHotel(Organization org, String def, String descrFirst, List<String> valueList) {
        if (def.contains("CHANNEL")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, SabreProfileLineSubsectionHotel.PREF_BOOK_CHANNEL.toString(), true);
        } else if (def.contains("PREFERENCES")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, SabreProfileLineSubsectionHotel.OPTIONS.toString(), false);
        } else if (def.contains("LINK TO POLICY")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, SabreProfileLineSubsectionHotel.PROGRAM.toString(), false);
        } else if (def.contains("BLACKLISTED")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, SabreProfileLineSubsectionHotel.BLACKLISTED.toString(), false);
        } else if (def.contains("LIMITS")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, SabreProfileLineSubsectionHotel.LIMITS.toString(), false);
        } else if (def.contains("OOP")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, SabreProfileLineSubsectionHotel.OOP.toString(), false);
        } else if (def.contains("REASON CODES")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, SabreProfileLineSubsectionHotel.REASON_CODES.toString(), true);
        } else if (def.contains("FREE TEXT")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, null, false);
        } else {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.H, null, false);
        }
    }

    private static void parseRemarksForCar(Organization org, String def, String descrFirst, List<String> valueList) {
        if (def.contains("VENDOR")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.C, SabreProfileLineSubsectionCar.PREFERRED_VENDORS.toString(), false);
        } else if (def.contains("OPTIONS")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.C, SabreProfileLineSubsectionCar.OPTIONS.toString(), false);
        } else if (def.contains("FREE TEXT")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.C, null, false);
        }
    }

    private static void parseRemarksForDelivery(Organization org, String def, String descrFirst, List<String> valueList) {
        if (def.contains("ADDRESS")) {
            ArrayList<String> correctedList = new ArrayList<String>();
            for (String val : valueList) {
                if (val.contains(ADDRESS_DELIMITER_SYMBOL)) {
                    String[] parts = val.split("\\;");
                    correctedList.add(parts[0]);
                    continue;
                }
                correctedList.add(val);
            }
            ExcelImportTestUtil.parseRemarksOrg(org, correctedList, SabreProfileLineType.A, SabreProfileLineServiceType.D, SabreProfileLineSubsectionDelivery.ADDRESS.toString(), false);
        } else if (def.contains("CONT PERS")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.D, SabreProfileLineSubsectionDelivery.CNTC_PAX_FOR_DLV.toString(), false);
        } else if (def.contains("TIME")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.D, SabreProfileLineSubsectionDelivery.TIME.toString(), false);
        } else if (def.contains("FREE TEXT")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.D, null, false);
        }
    }

    private static void parseRemarksForEts(Organization org, String def, List<String> valueList) {
        if (def.contains("AUTHORIZATION")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.E, SabreProfileLineSubsectionEts.AUTHORIZATION.toString(), false);
        } else if (def.contains("PASSWORD")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.E, SabreProfileLineSubsectionEts.PASSWORD.toString(), false);
        } else if (def.contains("EXCEPTIONS")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.E, SabreProfileLineSubsectionEts.EXCEPTIONS.toString(), false);
        } else if (def.contains("FEE")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.E, SabreProfileLineSubsectionEts.FEE.toString(), false);
        } else {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.E, null, false);
        }
    }

    private static void parseRemarksForRail(Organization org, String def, List<String> valueList) {
        if (def.contains("POLICY RZD")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.R, SabreProfileLineSubsectionRail.POLICY_RZD.toString(), false);
        } else if (def.contains("POLICY UFS")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.R, SabreProfileLineSubsectionRail.POLICY_UFS.toString(), false);
        } else {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.R, null, false);
        }
    }

    private static void parseCorpPricingForAir(Organization org, TripartiteContract tripCtrAir, List<String> descrList, List<String> valueList) {
        for (int i = 0; i < descrList.size(); ++i) {
            RuleResult rr;
            RuleSettings rs;
            Airline airline;
            Set airlines;
            String airlineStr;
            String codeStr;
            Matcher m;
            Pattern p;
            String descr = descrList.get(i);
            String value = valueList.get(i);
            if (descr.contains("CORP.ID")) {
                p = Pattern.compile("(\\w+)\\s*\\-\\s*(\\w+)");
                m = p.matcher(value);
                codeStr = "";
                airlineStr = "";
                if (m.matches()) {
                    codeStr = m.group(1);
                    airlineStr = m.group(2);
                    airlines = DictHelper.getAirlinesByAnyCode((String)airlineStr, null);
                    if (airlines.size() > 0) {
                        airline = (Airline)airlines.iterator().next();
                        tripCtrAir.getAviaVendorData().getAirlines().add(airline.toReference());
                    }
                }
                rs = new RuleSettings();
                rs.setName("CORP PRICING " + airlineStr);
                rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
                rr = new RuleResult();
                rr.setAction((RuleAction)AviaTripartiteContractActions.AVIA_CORPORATE_ID);
                rr.setValue((Object)(m.matches() ? codeStr : value));
                rs.getResults().add(rr);
                tripCtrAir.getRuleSet().getRules().add(rs);
                continue;
            }
            if (!descr.contains("ACCT.CO")) continue;
            p = Pattern.compile("(\\w+)\\s*\\-\\s*(\\w+)");
            m = p.matcher(value);
            codeStr = "";
            airlineStr = "";
            if (m.matches()) {
                codeStr = m.group(1);
                airlineStr = m.group(2);
                airlines = DictHelper.getAirlinesByAnyCode((String)airlineStr, null);
                if (airlines.size() > 0) {
                    airline = (Airline)airlines.iterator().next();
                    tripCtrAir.getAviaVendorData().getAirlines().add(airline.toReference());
                }
            }
            rs = new RuleSettings();
            rs.setName("ACCOUNT CODE " + airlineStr);
            rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
            rr = new RuleResult();
            rr.setAction((RuleAction)AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE);
            rr.setValue((Object)(m.matches() ? codeStr : value));
            rs.getResults().add(rr);
            tripCtrAir.getRuleSet().getRules().add(rs);
        }
    }

    private static void parseCorpPricingForCar(Organization org, TripartiteContract tripCtrCar, List<String> valueList) {
        for (String value : valueList) {
            RuleSettings rs = new RuleSettings();
            rs.setName("CAR CORP ID " + value);
            rs.setTarget((RuleTarget)Targets.CAR);
            RuleResult rr = new RuleResult();
            rr.setAction((RuleAction)CarTripartiteContractActions.CAR_DISCOUNT_NUMBER);
            rr.setValue((Object)value);
            rs.getResults().add(rr);
            tripCtrCar.getRuleSet().getRules().add(rs);
        }
    }

    private static void parseCorpPricingForHotel(Organization org, TripartiteContract tripCtrHotel, List<String> descrList, List<String> valueList) {
        for (int i = 0; i < descrList.size(); ++i) {
            String descr = descrList.get(i);
            String value = valueList.get(i);
            if (descr.contains("HOTL.CO")) {
                RuleSettings rs = new RuleSettings();
                rs.setName("HOTEL DISCOUNT NUMBER " + value);
                rs.setTarget((RuleTarget)Targets.HOTELS_FOREIGN);
                RuleResult rr = new RuleResult();
                rr.setAction((RuleAction)HotelTripartiteContractActions.HOTEL_DISCOUNT_NUMBER);
                rr.setValue((Object)value);
                rs.getResults().add(rr);
                tripCtrHotel.getRuleSet().getRules().add(rs);
                continue;
            }
            if (!descr.contains("CODI.PL")) continue;
            Pattern p = Pattern.compile("(\\w+)\\*(\\w+)");
            Matcher m = p.matcher(value);
            String codeStr = "";
            if (m.matches()) {
                codeStr = m.group(1);
                String hotelStr = m.group(2);
                Set hotels = DictHelper.findHotelBrandByCode((String)hotelStr);
                if (hotels.size() > 0) {
                    HotelsBrand hotel = (HotelsBrand)hotels.iterator().next();
                    tripCtrHotel.getHotelVendorData().getBrands().add(hotel.toReference());
                }
            }
            RuleSettings rs = new RuleSettings();
            rs.setName("HOTEL CORPORATE ID " + value);
            rs.setTarget((RuleTarget)Targets.HOTELS_FOREIGN);
            RuleResult rr = new RuleResult();
            rr.setAction((RuleAction)HotelTripartiteContractActions.HOTEL_CORPORATE_ID);
            rr.setValue((Object)(m.matches() ? codeStr : value));
            rs.getResults().add(rr);
            tripCtrHotel.getRuleSet().getRules().add(rs);
        }
    }

    private static void parseUdids(Organization org, String def, String descrFirst, List<String> valueList, List<Message> messages) {
        String valueFirst = valueList.get(0);
        if (def.contains("NAME")) {
            ExcelImportTestUtil.parseUdidNames(org, descrFirst, valueFirst, messages);
        } else if (def.contains(" SCRIPT")) {
            ExcelImportTestUtil.parseUdidShortNames(org, descrFirst, valueFirst, messages);
        } else if (def.contains("DESCRIPTION")) {
            ExcelImportTestUtil.parseUdidSyntax(org, descrFirst, valueFirst, messages);
        } else if (!def.contains("LIST") && def.contains("VALUE")) {
            ExcelImportTestUtil.parseUdidDefaultValue(org, descrFirst, valueFirst, messages);
        }
    }

    private static void parseUdidsPer(Person per, Organization org, EntityReference<Organization> orgRef, String def, List<String> valueList, List<Message> messages) {
        for (String value : valueList) {
            String num = def.substring(def.length() - 1);
            CostCodeType cct = ProfileSynchronizationUtil.getCostCodeTypeForNumber((String)("U0" + num));
            CostCodeProperties udidType = null;
            for (CostCodeProperties ccp : org.getCostCodeProperties()) {
                if (ccp.getType() == null || !ccp.getType().equals((Object)cct)) continue;
                udidType = ccp;
                break;
            }
            PersonCostCode costCode = new PersonCostCode();
            costCode.setOrganization(orgRef);
            costCode.setValue(value);
            costCode.setCostCodeProperties(udidType);
            per.getCostCodes().add(costCode);
        }
    }

    private static void parseRemarksForTravelPolicy(Organization org, String def, List<String> valueList) {
        if (def.contains("AUTHORIZATION")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.T, SabreProfileLineSubsectionTravel.AUTH.toString(), false);
        } else if (def.contains("RISK DESTINATION")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.T, SabreProfileLineSubsectionTravel.TRAVEL_RISK_DEST.toString(), false);
        } else if (def.contains("SECURITY")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.T, SabreProfileLineSubsectionTravel.SECURITY.toString(), true);
        } else if (def.contains("ATLAS")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.T, SabreProfileLineSubsectionTravel.ATLAS.toString(), true);
        } else if (def.contains("FREE TEXT")) {
            ExcelImportTestUtil.parseRemarksOrg(org, valueList, SabreProfileLineType.A, SabreProfileLineServiceType.T, null, false);
        }
    }

    private static void parseAddress(Address addrFact, String def, String valueFirst, List<Message> messages) {
        String[] words = valueFirst.split("\\;");
        String valueEn = words[0].trim();
        String valueRu = null;
        if (words.length > 1) {
            valueRu = words[1].trim();
        }
        if (def.toUpperCase().contains("STREET")) {
            L10nStringHelper.setValue((L10nString)addrFact.getAddress(), (String)valueEn, (Locale)LocaleUtil.LOCALE_EN);
            if (valueRu != null) {
                L10nStringHelper.setValue((L10nString)addrFact.getAddress(), (String)valueRu, (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)addrFact.getAddress(), (String)valueRu, (Locale)LocaleUtil.LOCALE_UK);
            }
        } else if (def.toUpperCase().contains("BUILDING")) {
            L10nStringHelper.setValue((L10nString)addrFact.getHouse(), (String)valueEn, (Locale)LocaleUtil.LOCALE_EN);
            if (valueRu != null) {
                L10nStringHelper.setValue((L10nString)addrFact.getHouse(), (String)valueRu, (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)addrFact.getHouse(), (String)valueRu, (Locale)LocaleUtil.LOCALE_UK);
            } else {
                L10nStringHelper.setValue((L10nString)addrFact.getHouse(), (String)valueEn, (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)addrFact.getHouse(), (String)valueEn, (Locale)LocaleUtil.LOCALE_UK);
            }
        } else if (def.toUpperCase().contains("BUSINESS")) {
            L10nStringHelper.setValue((L10nString)addrFact.getBuilding(), (String)valueEn, (Locale)LocaleUtil.LOCALE_EN);
            if (valueRu != null) {
                L10nStringHelper.setValue((L10nString)addrFact.getBuilding(), (String)valueRu, (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)addrFact.getBuilding(), (String)valueRu, (Locale)LocaleUtil.LOCALE_RU);
            }
        } else if (def.toUpperCase().contains("KORPUS")) {
            L10nStringHelper.setValue((L10nString)addrFact.getHousing(), (String)valueEn, (Locale)LocaleUtil.LOCALE_EN);
            if (valueRu != null) {
                L10nStringHelper.setValue((L10nString)addrFact.getHousing(), (String)valueRu, (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)addrFact.getHousing(), (String)valueRu, (Locale)LocaleUtil.LOCALE_UK);
            } else {
                L10nStringHelper.setValue((L10nString)addrFact.getHousing(), (String)valueEn, (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)addrFact.getHousing(), (String)valueEn, (Locale)LocaleUtil.LOCALE_UK);
            }
        } else if (def.toUpperCase().contains("FLOOR")) {
            L10nStringHelper.setValue((L10nString)addrFact.getPavilion(), (String)valueEn, (Locale)LocaleUtil.LOCALE_EN);
            if (valueRu != null) {
                L10nStringHelper.setValue((L10nString)addrFact.getPavilion(), (String)valueRu, (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)addrFact.getPavilion(), (String)valueRu, (Locale)LocaleUtil.LOCALE_UK);
            }
        } else if (def.toUpperCase().contains("OFFICE")) {
            L10nStringHelper.setValue((L10nString)addrFact.getOffice(), (String)valueEn, (Locale)LocaleUtil.LOCALE_EN);
            if (valueRu != null) {
                L10nStringHelper.setValue((L10nString)addrFact.getOffice(), (String)valueRu, (Locale)LocaleUtil.LOCALE_RU);
                L10nStringHelper.setValue((L10nString)addrFact.getOffice(), (String)valueRu, (Locale)LocaleUtil.LOCALE_UK);
            }
        } else if (def.toUpperCase().contains("CITY")) {
            if ("SAINT-PETERSBURG".equals(valueEn.toUpperCase())) {
                valueEn = "St Petersburg";
            }
            if ("EKATERINBURG".equals(valueEn.toUpperCase())) {
                valueEn = "Yekaterinburg";
            }
            if ("YUZHNO-SAKHALINSK".equals(valueEn.toUpperCase())) {
                valueEn = "Yuzhno Sakhalinsk";
            }
            if ("N/A".equals(valueEn)) {
                return;
            }
            DictionaryReference city = DictHelper.findCityByName((String)valueEn);
            if (city != null && addrFact.getCity() == null) {
                addrFact.setCity(city);
            }
            if (city == null) {
                messages.add(MessageHelper.createErrorMessage((String)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0433\u043e\u0440\u043e\u0434 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435: " + valueEn), (Object[])null));
                try {
                    GeoLocation newCity = (GeoLocation)SabreProfileHelper.createDictionaryContainer(GeoLocation.class, (String)UUIDGenerator.generate().toString());
                    newCity.setType(LocationType.CITY);
                    newCity.getTranslations().put(LOCALE_EN, valueEn);
                    newCity.getTranslations().put(LOCALE_RU, valueEn);
                    newCity.getTranslations().put(LOCALE_UK, valueEn);
                    newCity.setCode(valueEn);
                    addrFact.setCity((DictionaryReference)newCity.toReference());
                    LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)newCity);
                    newDictionaryContainers.put(newCity.getCode(), (BaseDictionary)newCity);
                }
                catch (Exception e) {
                    messages.add(MessageHelper.createErrorMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0433\u043e\u0440\u043e\u0434\u0430 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435: " + valueEn), (Object[])null));
                }
            }
        } else if (def.toUpperCase().contains("INDEX")) {
            addrFact.setZip(valueEn);
        } else if (def.toUpperCase().contains("COUNTRY")) {
            DictionaryReference country;
            if ("russia".equals(valueEn.toLowerCase())) {
                valueEn = "Russian Federation";
            }
            if (valueEn.toLowerCase().startsWith("spain")) {
                valueEn = "Spain and Canary Islands";
            }
            if ((country = DictHelper.findCountryByName((String)valueEn)) != null && addrFact.getCountry() == null) {
                addrFact.setCountry(country);
            }
            if (country == null) {
                messages.add(MessageHelper.createErrorMessage((String)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0430 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435: " + valueEn), (Object[])null));
            }
        }
    }

    private static void parseContractRule(Contract ctr, String def, String descr, String value, Map<String, FeeRemarkTemplate> templateMap, List<Message> messages) {
        if (ctr == null) {
            return;
        }
        if (def.contains("NO SF IF COMMISSION")) {
            FeeRemarkTemplate template = ExcelImportTestUtil.getFeeRemarkTemplate(value, templateMap);
            if (template != null) {
                SabreRemarkResult srr = new SabreRemarkResult();
                srr.setTemplate(template.getTemplate());
                RuleSettings rs = new RuleSettings();
                rs.setName("AIR COMM TRIGGER");
                rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
                RuleResult rr = new RuleResult();
                rr.setAction((RuleAction)SabreSynchronizationActions.ADD_REMARK2);
                rr.setValue((Object)srr);
                rs.getResults().add(rr);
                if (ctr.getRuleSet() != null) {
                    ctr.getRuleSet().getRules().add(rs);
                } else {
                    RuleSet ruleSet = new RuleSet();
                    ruleSet.getRules().add(rs);
                    ctr.setRuleSet(ruleSet);
                }
            }
        } else if (!descr.contains("AIR.")) {
            FeeRemarkTemplate template = ExcelImportTestUtil.getFeeRemarkTemplate(descr, templateMap);
            if (template != null) {
                Pattern p = Pattern.compile("(\\d+([\\.,]\\d+)?)\\s+([a-zA-Z]+|%)");
                Matcher m = p.matcher(value);
                String amount = null;
                String currency = null;
                if (m.matches()) {
                    amount = m.group(1);
                    currency = m.group(3);
                }
                SabreRemarkResult srr = new SabreRemarkResult();
                srr.setTemplate(template.getTemplate());
                if (!TextUtil.isBlank((String)amount)) {
                    amount = amount.replaceAll(",", ".");
                    try {
                        BigDecimal decAmount = new BigDecimal(amount);
                        srr.setValue(decAmount);
                    }
                    catch (Exception decAmount) {
                        // empty catch block
                    }
                }
                if (!TextUtil.isBlank((String)currency)) {
                    srr.setCurrencyCode(currency);
                }
                RuleSettings rs = new RuleSettings();
                rs.setName(descr);
                RuleTarget rt = ExcelImportTestUtil.getRuleSettingsTarget(template.getAppliedTo());
                if (rt == null) {
                    messages.add(MessageHelper.createErrorMessage((String)("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u043c\u043e \u043a:' \u0434\u043b\u044f " + template.getAppliedTo()), (Object[])null));
                }
                rs.setTarget(rt);
                RuleResult rr = new RuleResult();
                rr.setAction((RuleAction)SabreSynchronizationActions.ADD_REMARK2);
                rr.setValue((Object)srr);
                rs.getResults().add(rr);
                if (ctr.getRuleSet() != null) {
                    ctr.getRuleSet().getRules().add(rs);
                } else {
                    RuleSet ruleSet = new RuleSet();
                    ruleSet.getRules().add(rs);
                    ctr.setRuleSet(ruleSet);
                }
            } else {
                messages.add(MessageHelper.createErrorMessage((String)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d  \u0448\u0430\u0431\u043b\u043e\u043d \u0440\u0435\u043c\u0430\u0440\u043a\u0438 \u0441\u0431\u043e\u0440\u043e\u0432 \u0434\u043b\u044f: " + descr), (Object[])null));
            }
        }
    }

    private static RuleTarget getRuleSettingsTarget(String appliedTo) {
        if (TextUtil.isBlank((String)appliedTo)) {
            return null;
        }
        Collection targets = ((RulesEnvironment)Environment.getPublished(RulesEnvironment.class)).getTargets(null);
        for (RuleTarget target : targets) {
            String name = "";
            name = target instanceof SabreSynchronizationAdditionalTargets ? ((SabreSynchronizationAdditionalTargets)target).getDisplayName() : (target instanceof Targets ? ((Targets)target).getDisplayName() : "\u0416/\u0414 \u0411\u0438\u043b\u0435\u0442\u044b");
            if (!name.equals(appliedTo)) continue;
            return target;
        }
        return null;
    }

    private static FeeRemarkTemplate getFeeRemarkTemplate(String str, Map<String, FeeRemarkTemplate> templateMap) {
        FeeRemarkTemplate res = null;
        for (Map.Entry<String, FeeRemarkTemplate> entry : templateMap.entrySet()) {
            if (!entry.getValue().getTemplate().contains(str)) continue;
            res = entry.getValue();
            break;
        }
        return res;
    }

    private static void parseFops(Organization org, Contract ctr, String def, String descrFirst, String valueFirst, List<Message> messages) {
        PaymentConditionItem pci = new PaymentConditionItem();
        pci.setUid(UUIDGenerator.generate().toString());
        pci.setSabreRemark(valueFirst);
        int n = ctr.getCustomers().size();
        if (ctr != null && ctr.getCustomers().size() > 0 && ctr.getCustomers().get(n - 1) != null && ((ContractCustomerInfo)ctr.getCustomers().get(n - 1)).getPaymentConditions() != null && ((ContractCustomerInfo)ctr.getCustomers().get(n - 1)).getPaymentConditions().getPaymentItems() != null) {
            ((ContractCustomerInfo)ctr.getCustomers().get(n - 1)).getPaymentConditions().getPaymentItems().add(pci);
        }
    }

    private static void parseUdidNames(Organization org, String descrFirst, String valueFirst, List<Message> messages) {
        Pattern p = Pattern.compile(".*(\\d+).*");
        Matcher m = p.matcher(descrFirst);
        if (m.matches()) {
            String number = m.group(1);
            String udidName = valueFirst;
            CostCodeProperties ccp = ExcelImportTestUtil.createCostCodeProperties(udidName, number);
            ccp.setSabreRemarks(valueFirst);
            ccp.setSabreShortName(udidName);
            ccp.setType(ProfileSynchronizationUtil.getCostCodeTypeForNumber((String)("U0" + number)));
            org.getCostCodeProperties().add(ccp);
        }
    }

    private static void parseUdidShortNames(Organization org, String descrFirst, String valueFirst, List<Message> messages) {
        Pattern p = Pattern.compile(".*(\\d+).*");
        Matcher m = p.matcher(descrFirst);
        if (m.matches()) {
            int udidPos;
            String udidNumber = m.group(1);
            String udidShortName = valueFirst;
            List<Integer> numbers = ExcelImportTestUtil.getUdidPosByNumber(org.getCostCodeProperties(), udidNumber);
            int n = udidPos = numbers.size() > 0 ? numbers.get(0) : -1;
            if (udidPos != -1) {
                ((CostCodeProperties)org.getCostCodeProperties().get(udidPos)).setSabreShortName(udidShortName);
                CostCodeCategory cat = (CostCodeCategory)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(((CostCodeProperties)org.getCostCodeProperties().get(udidPos)).getCategory());
                if (cat != null && TextUtil.isBlank((String)cat.getShortName())) {
                    cat.setShortName(valueFirst);
                    newDictionaryContainers.put(cat.getCode(), (BaseDictionary)cat);
                }
            }
        }
    }

    private static void parseUdidDefaultValue(Organization org, String descrFirst, String valueFirst, List<Message> messages) {
        Pattern p = Pattern.compile(".*(\\d+).*");
        Matcher m = p.matcher(descrFirst);
        if (m.matches()) {
            int udidPos;
            String udidNumber = m.group(1);
            String udidShortName = valueFirst;
            List<Integer> numbers = ExcelImportTestUtil.getUdidPosByNumber(org.getCostCodeProperties(), udidNumber);
            int n = udidPos = numbers.size() > 0 ? numbers.get(0) : -1;
            if (udidPos != -1) {
                ((CostCodeProperties)org.getCostCodeProperties().get(udidPos)).setSabreShortName(udidShortName);
                ((CostCodeProperties)org.getCostCodeProperties().get(udidPos)).setSabreValue(valueFirst);
            }
        }
    }

    private static void parsePayers(Organization org, String def, String descrFirst, String valueFirst, List<Message> messages) {
        Pattern p = Pattern.compile("(.*)\\*(.*)\\*");
        Matcher m = p.matcher(valueFirst);
        if (m.matches()) {
            String shortName = m.group(1).trim();
            String dk = m.group(2).trim();
            if (!organizationContainers.containsKey(dk)) {
                messages.add(MessageHelper.createErrorMessage((String)("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044e \u0441 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c " + shortName + ", DK = " + dk + ", \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430 \u0434\u043b\u044f \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 " + org.getFullName()), (Object[])null));
                return;
            }
            if (organizationContainers.get(dk) != null) {
                L10nStringHelper.setValue((L10nString)((Organization)organizationContainers.get(dk).getEntity()).getShortName(), (String)shortName, (Locale)LocaleUtil.LOCALE_EN);
                EntityReference payer = organizationContainers.get(dk).toReference();
                org.getPayers().add(payer);
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430: " + valueFirst + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
        }
    }

    private static void parseRMZ(Organization org, List<String> valueList, List<Message> messages) {
        for (String s : valueList) {
            Pattern p = Pattern.compile("PDQ\\.(.*)");
            Matcher m = p.matcher(s);
            if (m.matches()) {
                String value = m.group(1);
                SabreProfileCommand1Fnbts cmd = new SabreProfileCommand1Fnbts();
                cmd.setUid(UUIDGenerator.generate().toString());
                cmd.setEntry5(value);
                org.getSabreAdditionalCommand1Lines().add(cmd);
                continue;
            }
            SabreProfileCommand1Fnbts cmd = new SabreProfileCommand1Fnbts();
            cmd.setUid(UUIDGenerator.generate().toString());
            cmd.setEntry5(s);
            org.getSabreAdditionalCommand1Lines().add(cmd);
        }
    }

    private static void parseCmd2(Organization org, List<String> valueList, List<Message> messages) {
        for (String s : valueList) {
            Pattern p = Pattern.compile("(\\S*)\\s+(.*)");
            Matcher m = p.matcher(s);
            if (m.matches()) {
                String code = m.group(1);
                String value = m.group(2);
                SabreProfileCommand2Osi cmd = new SabreProfileCommand2Osi();
                cmd.setUid(UUIDGenerator.generate().toString());
                cmd.setEntry1(code);
                cmd.setEntry2(value);
                org.getSabreAdditionalCommand2Lines().add(cmd);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043f\u043e\u043b\u0435\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b OSI: " + s + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
        }
    }

    private static void parseItineraryRemarks(Organization org, List<String> valueList) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)org.getSabreNotes())) {
            sb.append(org.getSabreNotes());
        }
        for (String s : valueList) {
            if (sb.toString().length() > 0) {
                sb.append("\n");
            }
            sb.append(s);
        }
        org.setSabreNotes(sb.toString());
    }

    private static CostCodeProperties createCostCodeProperties(String name, String udidNumber) {
        CostCodeProperties ccp = new CostCodeProperties();
        ccp.setUid(UUIDGenerator.generate().toString());
        ccp.setName(name);
        ccp.setSabreName(name);
        CostCodeCategory cat = null;
        boolean wasInMap = false;
        if (costCodeCategoryReferences.containsKey(name.toUpperCase())) {
            cat = (CostCodeCategory)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(costCodeCategoryReferences.get(name.toUpperCase()));
            wasInMap = true;
        } else {
            try {
                cat = (CostCodeCategory)SabreProfileHelper.createDictionaryContainer(CostCodeCategory.class, (String)UUIDGenerator.generate().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cat != null) {
            cat.setName(name);
            cat.setShortName(name);
            cat.getTranslations().put(LOCALE_EN, name.toUpperCase());
            try {
                LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)cat);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            newDictionaryContainers.put(cat.getCode(), (BaseDictionary)cat);
            costCodeCategoryReferences.put(name.toUpperCase(), (DictionaryReference<CostCodeCategory>)cat.toReference());
        }
        if (cat != null) {
            ccp.setCategory((DictionaryReference)cat.toReference());
        }
        ccp.setType(ProfileSynchronizationUtil.getCostCodeTypeForNumber((String)udidNumber));
        return ccp;
    }

    private static CostCode createCostCode(CostCodeProperties ccp, String value) {
        CostCode cc = new CostCode();
        cc.setUid(UUIDGenerator.generate().toString());
        cc.setCostCodeProperties(ccp);
        cc.setValue(value);
        return cc;
    }

    private static ReasonCode createReasonCode(ReasonCodeType type, String letter, String value) {
        ReasonCode rc = new ReasonCode();
        rc.setUid(UUIDGenerator.generate().toString());
        rc.setType(type);
        rc.setName(letter);
        rc.setSabreName(value);
        L10nStringHelper.setValue((L10nString)rc.getRemarks(), (String)value, (Locale)LocaleUtil.LOCALE_EN);
        if (!reasonCodesReferences.containsKey(value.toUpperCase())) {
            CommonReasonCode rcCat = null;
            try {
                rcCat = (CommonReasonCode)SabreProfileHelper.createDictionaryContainer(CommonReasonCode.class, (String)UUIDGenerator.generate().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (rcCat != null) {
                rcCat.setType(type);
                rcCat.setSabreName(letter);
                rcCat.setDescription(value);
                rcCat.setCode(letter + "-" + value);
                newDictionaryContainers.put(rcCat.getCode(), (BaseDictionary)rcCat);
                reasonCodesReferences.put(value.toUpperCase(), (DictionaryReference<CommonReasonCode>)rcCat.toReference());
            }
        }
        return rc;
    }

    private static void parseUdidSyntax(Organization org, String descrFirst, String valueFirst, List<Message> messages) {
        Pattern p = Pattern.compile("(U0\\d).*");
        Matcher m = p.matcher(descrFirst);
        if (m.matches()) {
            int udidPos;
            String udidNumber = m.group(1);
            List<Integer> numbers = ExcelImportTestUtil.getUdidPosByNumber(org.getCostCodeProperties(), udidNumber);
            int n = udidPos = numbers.size() > 0 ? numbers.get(0) : -1;
            if (udidPos >= 0) {
                ((CostCodeProperties)org.getCostCodeProperties().get(udidPos)).setSabreRemarks(valueFirst);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0430 \u044e\u0434\u0438\u0434\u0430 (\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u043e\u043c\u0435\u0440 \u044e\u0434\u0438\u0434\u0430): " + descrFirst + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
            }
        } else {
            Pattern p2 = Pattern.compile(".*(\\d+).*");
            Matcher m2 = p2.matcher(descrFirst);
            if (m2.matches()) {
                int udidPos;
                String number = m2.group(1);
                List<Integer> numbers = ExcelImportTestUtil.getUdidPosByNumber(org.getCostCodeProperties(), number);
                int n = udidPos = numbers.size() > 0 ? numbers.get(0) : -1;
                if (udidPos >= 0) {
                    ((CostCodeProperties)org.getCostCodeProperties().get(udidPos)).setSabreRemarks(valueFirst);
                } else {
                    String udidName = "U0" + number;
                    CostCodeProperties ccp = ExcelImportTestUtil.createCostCodeProperties(udidName, number);
                    ccp.setSabreRemarks(valueFirst);
                    ccp.setSabreShortName(udidName);
                    ccp.setType(ProfileSynchronizationUtil.getCostCodeTypeForNumber((String)udidName));
                    ccp.setSabreName(udidName);
                    org.getCostCodeProperties().add(ccp);
                }
            }
        }
    }

    private static void parseUdidList(Organization org, String descrFirst, List<String> values, List<Message> messages) {
        Pattern p = Pattern.compile("(U0\\d)\\*DL.*");
        Matcher m = p.matcher(descrFirst);
        if (m.matches()) {
            int udidPos;
            String udidNumber = m.group(1);
            List<Integer> numbers = ExcelImportTestUtil.getUdidPosByNumber(org.getCostCodeProperties(), udidNumber);
            int n = udidPos = numbers.size() > 0 ? numbers.get(0) : -1;
            if (udidPos >= 0) {
                ((CostCodeProperties)org.getCostCodeProperties().get(udidPos)).setSabreDropList(true);
                for (Integer num : numbers) {
                    CostCodeProperties ccp = (CostCodeProperties)org.getCostCodeProperties().get(num);
                    ExcelImportTestUtil.clearCostCodesForType(org, ccp);
                }
                for (String str : values) {
                    String[] udids;
                    StringBuilder s = new StringBuilder(str);
                    while (s.indexOf("*") >= 0) {
                        s.deleteCharAt(s.indexOf("*"));
                    }
                    for (String udid : udids = s.toString().split(",")) {
                        udid = udid.trim();
                        boolean maskAccepted = false;
                        String maskGlobal = "";
                        for (Integer num : numbers) {
                            CostCodeProperties ccp = (CostCodeProperties)org.getCostCodeProperties().get(num);
                            String mask = ccp.getMask();
                            maskGlobal = maskGlobal + (maskGlobal.length() > 0 ? " \u0438\u043b\u0438 " + mask : mask);
                            if (!ExcelImportTestUtil.checkMask(mask, udid)) continue;
                            org.getCostCodes().add(ExcelImportTestUtil.createCostCode(ccp, udid));
                            maskAccepted = true;
                            break;
                        }
                        if (maskAccepted) continue;
                        messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0430 \u044e\u0434\u0438\u0434\u0430 (\u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u0430\u0441\u043a\u0435): " + udid + " \u0434\u043b\u044f \u043c\u0430\u0441\u043a\u0438 " + maskGlobal + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
                    }
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0430 \u044e\u0434\u0438\u0434\u0430 (\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u043e\u043c\u0435\u0440 \u044e\u0434\u0438\u0434\u0430): " + descrFirst + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0434\u0440\u043e\u043f-\u043b\u0438\u0441\u0442\u0430 \u044e\u0434\u0438\u0434\u0430: " + descrFirst + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
        }
    }

    private static void clearCostCodesForType(Organization org, CostCodeProperties ccp) {
        Iterator iter = org.getCostCodes().iterator();
        if (ccp != null) {
            while (iter.hasNext()) {
                if (!((CostCode)iter.next()).getCostCodeProperties().equals((Object)ccp)) continue;
                iter.remove();
            }
        }
    }

    public static boolean checkMask(String mask, String value) {
        if (!TextUtil.isBlank((String)mask)) {
            try {
                MaskFormatter formatter = new MaskFormatter(mask);
                formatter.stringToValue(value);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return true;
    }

    private static List<Integer> getUdidPosByNumber(List<CostCodeProperties> list, String udidNumber) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int i = 0;
        for (CostCodeProperties ccp : list) {
            if (ProfileSynchronizationUtil.getUdidNumberString((CostCodeType)ccp.getType()).contains(udidNumber)) {
                res.add(i);
            }
            ++i;
        }
        return res;
    }

    private static List<Integer> getUdidPosByName(List<CostCodeProperties> list, String valueFirst) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int i = 0;
        for (CostCodeProperties ccp : list) {
            if (ccp.getName() != null && ccp.getName().toUpperCase().equals(valueFirst.toUpperCase())) {
                res.add(i);
            }
            ++i;
        }
        return res;
    }

    private static void clearCommunications(Organization org, CommunicationType type) {
        Iterator iter = org.getCommunications().iterator();
        if (type != null) {
            while (iter.hasNext()) {
                CommunicationType t = ((Communication)iter.next()).getType();
                if (t == null || !t.equals((Object)type)) continue;
                iter.remove();
            }
        } else {
            while (iter.hasNext()) {
                if (!EnumSet.of(CommunicationType.AGENCY, CommunicationType.CELL, CommunicationType.HOTEL, CommunicationType.MOBILE, CommunicationType.WORK_PHONE).contains(((Communication)iter.next()).getType())) continue;
                iter.remove();
            }
        }
    }

    private static void parseFrequentFlyerCardsPer(Person per, List<String> valueList, String fullName, List<Message> messages) {
        for (String value : valueList) {
            String airlineCode = value.substring(0, 2);
            String number = value.substring(2);
            Airline cardAirline = null;
            Set airlines = DictHelper.getAirlinesByAnyCode((String)airlineCode, null);
            if (airlines.size() > 0) {
                cardAirline = (Airline)airlines.iterator().next();
            }
            AirlineBonusCard card = new AirlineBonusCard();
            card.setNameOnCard(fullName);
            card.setNumber(number);
            if (cardAirline != null) {
                card.setAirline((DictionaryReference)cardAirline.toReference());
            } else {
                messages.add(MessageHelper.createWarningMessage((String)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f \u043f\u043e \u043a\u043e\u0434\u0443 " + airlineCode + " \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b \u0434\u043b\u044f " + fullName), (Object[])null));
            }
            per.getAirlineBonusCards().add(card);
        }
    }

    private static void parseCreditCards(Person per, List<String> valueList, String fullName, List<Message> messages) {
        for (String str : valueList) {
            Pattern p = Pattern.compile("(\\w\\w)(\\d+)EXP(\\d+)(.*)");
            Matcher m = p.matcher(str);
            if (m.matches()) {
                Date expDate;
                String typeStr = m.group(1);
                String numberStr = m.group(2);
                String dateStr = m.group(3);
                String otherStr = m.group(4);
                CardVendor cv = ProfileSynchronizationUtil.getCardVendorByString((String)typeStr);
                Card c = new Card();
                c.setVendor(cv);
                c.setNameOnCard(fullName);
                c.setNumber(numberStr);
                try {
                    expDate = new SimpleDateFormat("MMyy").parse(dateStr);
                }
                catch (ParseException e) {
                    messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043a\u0440\u0435\u0434\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b \u0434\u043b\u044f " + fullName + ": \u043d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f: " + dateStr), (Object[])null));
                    expDate = null;
                }
                c.setExpiration(expDate);
                otherStr = otherStr.trim();
                if (otherStr.startsWith("SOF")) {
                    c.setSof(true);
                    otherStr = otherStr.substring(3).trim();
                } else {
                    c.setSof(false);
                }
                if (otherStr.startsWith("CVV")) {
                    int endIndex = otherStr.contains(" ") ? otherStr.indexOf(" ") : otherStr.length();
                    String code = otherStr.substring(3, endIndex);
                    c.setSecurityCode(code);
                    otherStr = otherStr.substring(endIndex).trim();
                }
                c.setRemarks(otherStr);
                per.getCards().add(c);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043a\u0440\u0435\u0434\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b: " + str + " \u0434\u043b\u044f " + per.getLastName() + " " + per.getFirstName()), (Object[])null));
        }
    }

    private static void parsePassports(Person per, List<String> valueList, String fullName, String genderFromTitle, List<Message> messages) {
        for (String str : valueList) {
            Passport passport = SabreProfileHelper.parsePassport((String)(str = str.toUpperCase()), (String)fullName, (String)genderFromTitle, messages);
            if (passport == null) continue;
            per.getPassports().add(passport);
        }
    }

    private static void parseVisas(Person per, List<String> valueList, String fullName, List<Message> messages) {
        for (String str : valueList) {
            Visa visa = SabreProfileHelper.parseVisa((String)str, (String)fullName, messages);
            if (visa == null) continue;
            per.getVisas().add(visa);
        }
    }

    private static void parseVisasRemarks(Person per, List<String> valueList, String fullName, List<Message> messages) {
        for (String str : valueList) {
            SabreProfileLine line;
            int countryPos = str.indexOf("-");
            String country = "";
            String remark = str;
            if (countryPos > 0 && countryPos < str.length() - 1) {
                country = str.substring(0, countryPos).trim();
                remark = str.substring(countryPos + 1).trim();
            }
            if ((line = SabreProfileHelper.createRemarkLine((SabreProfileLineType)SabreProfileLineType.A, (SabreProfileLineServiceType)SabreProfileLineServiceType.V, (String)country, (boolean)false, (String)remark)) == null) continue;
            per.getSabreAdditionalProfileLines().add(line);
        }
    }

    private static void parseSeatPreferencePer(Person per, List<String> valueList, boolean isRemark) {
        if (!isRemark) {
            for (String str : valueList) {
                SabreProfileLine line = SabreProfileHelper.createRemarkLine((SabreProfileLineType)SabreProfileLineType.A, (SabreProfileLineServiceType)SabreProfileLineServiceType.S, (String)str, (boolean)false, (String)"");
                if (line == null) continue;
                per.getSabreAdditionalProfileLines().add(line);
            }
        } else {
            for (String str : valueList) {
                SabreProfileLine line = SabreProfileHelper.createRemarkLine((SabreProfileLineType)SabreProfileLineType.A, (SabreProfileLineServiceType)SabreProfileLineServiceType.S, (String)"", (boolean)false, (String)str);
                if (line == null) continue;
                per.getSabreAdditionalProfileLines().add(line);
            }
        }
    }

    private static void parseMealPreferencePer(Person per, List<String> valueList, boolean isRemark) {
        if (!isRemark) {
            for (String str : valueList) {
                SabreProfileLine line = SabreProfileHelper.createRemarkLine((SabreProfileLineType)SabreProfileLineType.A, (SabreProfileLineServiceType)SabreProfileLineServiceType.M, (String)str, (boolean)false, (String)"");
                if (line == null) continue;
                per.getSabreAdditionalProfileLines().add(line);
            }
        } else {
            for (String str : valueList) {
                SabreProfileLine line = SabreProfileHelper.createRemarkLine((SabreProfileLineType)SabreProfileLineType.A, (SabreProfileLineServiceType)SabreProfileLineServiceType.M, (String)"", (boolean)false, (String)str);
                if (line == null) continue;
                per.getSabreAdditionalProfileLines().add(line);
            }
        }
    }

    private static void parseRemarksOrg(Organization org, List<String> valueList, SabreProfileLineType lineType, SabreProfileLineServiceType serviceType, String subsection, boolean needParse) {
        for (String str : valueList) {
            SabreProfileLine line;
            if (TextUtil.isBlank((String)str) || (line = SabreProfileHelper.createRemarkLine((SabreProfileLineType)lineType, (SabreProfileLineServiceType)serviceType, (String)subsection, (boolean)needParse, (String)str)) == null) continue;
            org.getSabreAdditionalProfileLines().add(line);
        }
    }

    private static void parseRemarksPer(Person per, List<String> valueList, SabreProfileLineType lineType, SabreProfileLineServiceType serviceType, String subsection, boolean needParse) {
        for (String str : valueList) {
            SabreProfileLine line;
            if (TextUtil.isBlank((String)str) || (line = SabreProfileHelper.createRemarkLine((SabreProfileLineType)lineType, (SabreProfileLineServiceType)serviceType, (String)subsection, (boolean)needParse, (String)str)) == null) continue;
            per.getSabreAdditionalProfileLines().add(line);
        }
    }

    private static void parseAccountManager(Organization org, List<String> valueList, List<Message> messages) {
        ArrayList<EntityContainer<Person>> currentPersonContainers = new ArrayList<EntityContainer<Person>>();
        for (String string : valueList) {
            EntityContainer<Person> personCont = ExcelImportTestUtil.getPersonContainer(string, null, messages);
            if (personCont != null) {
                currentPersonContainers.add(personCont);
                continue;
            }
            messages.add(MessageHelper.createErrorMessage((String)("\u0412 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0430\u043a\u043a\u0430\u0443\u043d\u0442-\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440: " + string + ", \u0441\u043e\u0437\u0434\u0430\u043d \u0437\u0430\u043d\u043e\u0432\u043e."), (Object[])null));
            EntityContainer<Person> newPersonCont = ExcelImportTestUtil.createPersonContainer(string);
            if (newPersonCont == null) {
                messages.add(MessageHelper.createErrorMessage((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043d\u043e\u0432\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 Person", (Object[])null));
                continue;
            }
            Person person2 = (Person)newPersonCont.getEntity();
            person2.getTypes().add(PersonType.AGENT);
            currentPersonContainers.add(newPersonCont);
            String key = ExcelImportTestUtil.getKeyForPerson(person2);
            List<Object> temp = !newPersonContainers.containsKey(key) ? new ArrayList() : newPersonContainers.get(key);
            temp.add(newPersonCont);
            newPersonContainers.put(key, temp);
            personContainers.put(key, temp);
        }
        for (EntityContainer entityContainer : currentPersonContainers) {
            if (!((Person)entityContainer.getEntity()).getTypes().contains(PersonType.AGENT)) {
                ((Person)entityContainer.getEntity()).getTypes().add(PersonType.AGENT);
                if (((Person)entityContainer.getEntity()).getTypes().contains(PersonType.MANAGER)) {
                    ((Person)entityContainer.getEntity()).getTypes().remove(PersonType.MANAGER);
                }
            }
            Metadata m = new Metadata();
            m.setKey((DictionaryReference)((MetadataKeyDescriptor)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(MetadataKeyDescriptor.class).get("KEY_ORGANIZATION_ACCOUNT_MANAGER")).toReference());
            m.setValue((Object)entityContainer.toReference());
            org.getMetadata().add(m);
        }
    }

    private static void parseServiceConfiguration(Organization org, List<String> valueList, List<Message> messages) {
        for (String str : valueList) {
            String[] parts = str.split("\\-");
            if (parts.length != 2 && parts.length != 1) {
                messages.add(MessageHelper.createMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: " + str + " \u0434\u043b\u044f " + org.getShortName()), (Object[])null));
                continue;
            }
            String nameStr = parts[0].trim();
            String valueStr = "";
            if (parts.length == 2) {
                valueStr = parts[1].trim();
            }
            ServicePlatform name = ProfileSynchronizationUtil.getServicePlatformByString((String)nameStr);
            Metadata m = new Metadata();
            m.setKey((DictionaryReference)((MetadataKeyDescriptor)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(MetadataKeyDescriptor.class).get(KEY_ORGANIZATION_SERVICE_PLATFORM)).toReference());
            m.setValue((Object)name);
            m.setRemarks(valueStr);
            org.getMetadata().add(m);
        }
    }

    private static EntityContainer<Person> getPersonContainer(String value, EntityReference<Organization> orgRef, List<Message> messages) {
        EntityContainer<Person> res = null;
        Pattern p = Pattern.compile("([a-zA-Z_\\- ]+).*");
        Matcher m = p.matcher(value);
        if (m.matches()) {
            String name = m.group(1).trim();
            String[] wordParts = name.split("\\s+");
            String name2 = "";
            if (wordParts.length > 1) {
                name2 = wordParts[1] + " " + wordParts[0];
            }
            if (personContainers.containsKey(name) || personContainers.containsKey(name2)) {
                String key = personContainers.containsKey(name) ? name : name2;
                List<EntityContainer<Person>> listOfContainers = personContainers.get(key);
                if (listOfContainers.size() > 0) {
                    if (orgRef != null) {
                        boolean found = false;
                        for (EntityContainer<Person> pc : listOfContainers) {
                            Person per = (Person)pc.getEntity();
                            for (PersonEmployment emp : per.getEmployments()) {
                                if (!emp.getOrganization().equals(orgRef)) continue;
                                res = pc;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            break;
                        }
                    } else {
                        res = listOfContainers.get(0);
                    }
                }
                if (listOfContainers.size() > 1) {
                    // empty if block
                }
                ArrayList<EntityContainer<Person>> tempList = new ArrayList<EntityContainer<Person>>();
                tempList.add(res);
                usedPersonContainers.put(key, tempList);
            }
        } else {
            messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0438\u043c\u0435\u043d\u0438 \u043f\u0440\u0438 \u043f\u043e\u0438\u0441\u043a\u0435 \u0444\u0438\u0437. \u043b\u0438\u0446\u0430: " + value), (Object[])null));
        }
        return res;
    }

    private static EntityReference<Person> getPersonReference(String value, EntityReference<Organization> orgRef, List<Message> messages) {
        EntityContainer<Person> personCont = ExcelImportTestUtil.getPersonContainer(value, orgRef, messages);
        if (personCont != null) {
            Pattern pat = Pattern.compile("(\\S*)\\s(.*)");
            Matcher mat = pat.matcher(value);
            if (mat.matches()) {
                L10nStringHelper.setValue((L10nString)((Person)personCont.getEntity()).getLastName(), (String)mat.group(1), (Locale)LocaleUtil.LOCALE_EN);
                L10nStringHelper.setValue((L10nString)((Person)personCont.getEntity()).getFirstName(), (String)mat.group(2), (Locale)LocaleUtil.LOCALE_EN);
            } else {
                L10nStringHelper.setValue((L10nString)((Person)personCont.getEntity()).getLastName(), (String)value, (Locale)LocaleUtil.LOCALE_EN);
            }
        }
        return personCont != null ? personCont.toReference() : null;
    }

    private static List<EntityReference<Person>> getPersonReferences(List<String> values, EntityReference<Organization> orgRef, List<Message> messages) {
        ArrayList<EntityReference<Person>> res = new ArrayList<EntityReference<Person>>();
        for (String str : values) {
            EntityReference<Person> personRef = ExcelImportTestUtil.getPersonReference(str, orgRef, messages);
            if (personRef == null) continue;
            res.add(personRef);
        }
        return res;
    }

    private static void parseWorkingHours(Organization org, List<String> valueList, List<Message> messages) {
        String dayOfWeekRegexp = "";
        for (WorkModeType t : WorkModeType.values()) {
            dayOfWeekRegexp = dayOfWeekRegexp + (dayOfWeekRegexp.length() > 0 ? "|" : "") + ProfileSynchronizationUtil.getWorkModeTypeForSabre((WorkModeType)t);
        }
        Pattern p = Pattern.compile("(" + dayOfWeekRegexp + ")\\s+(\\d+)-(\\d+)(AM|PM|\\s)\\s*-\\s*(\\d+)-(\\d+)((AM|PM)*)");
        for (String str : valueList) {
            Matcher m = p.matcher(str);
            if (m.find()) {
                try {
                    WorkMode wm = new WorkMode();
                    wm.setUid(UUIDGenerator.generate().toString());
                    wm.setWorkModeType(ProfileSynchronizationUtil.getWorkModeTypeFromString((String)m.group(1)));
                    Calendar startCal = Calendar.getInstance();
                    Calendar finishCal = Calendar.getInstance();
                    int hour1 = 0;
                    int min1 = 0;
                    int hour2 = 0;
                    int min2 = 0;
                    boolean parseRes = true;
                    try {
                        hour1 = Integer.valueOf(m.group(2));
                        min1 = Integer.valueOf(m.group(3));
                        if (!TextUtil.isBlank((String)m.group(4)) && m.group(4).equals("PM")) {
                            hour1 += 12;
                        }
                        hour2 = Integer.valueOf(m.group(5));
                        min2 = Integer.valueOf(m.group(6));
                        if (!TextUtil.isBlank((String)m.group(7)) && m.group(7).equals("PM")) {
                            hour2 += 12;
                        }
                    }
                    catch (NumberFormatException exc) {
                        parseRes = false;
                    }
                    if (parseRes) {
                        startCal.set(Calendar.getInstance().get(1), Calendar.getInstance().get(2), Calendar.getInstance().get(5), hour1, min1);
                        finishCal.set(Calendar.getInstance().get(1), Calendar.getInstance().get(2), Calendar.getInstance().get(5), hour2, min2);
                    }
                    wm.setStartTime(startCal.getTime());
                    wm.setFinishTime(finishCal.getTime());
                    org.getWorkModes().add(wm);
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Out of bounds: no such group");
                }
                continue;
            }
            messages.add(MessageHelper.createWarningMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 \u0441 \u0440\u0435\u0436\u0438\u043c\u043e\u043c \u0440\u0430\u0431\u043e\u0442\u044b \u0434\u043b\u044f \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438: " + org.getShortName() + ", \u0441\u0442\u0440\u043e\u043a\u0430: '" + str + "' \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430"), (Object[])null));
        }
    }

    private static void parseCommunications(Organization org, List<String> valueList, CommunicationType commType, List<Message> messages) {
        if (commType != null && commType != CommunicationType.FAX) {
            for (String val : valueList) {
                Communication comm = new Communication();
                comm.setUid(UUIDGenerator.generate().toString());
                comm.setType(commType);
                if (val.toLowerCase().startsWith("http//")) {
                    val = val.substring("http//".length());
                }
                comm.setSense(val);
                org.getCommunications().add(comm);
            }
        } else {
            for (String val : valueList) {
                Pattern p = Pattern.compile("[0-9XBFM \\-]+");
                Matcher m = p.matcher(val);
                if (!m.matches()) {
                    messages.add(MessageHelper.createWarningMessage((String)("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b \u0432 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u043c \u043d\u043e\u043c\u0435\u0440\u0435: " + val + " \u0434\u043b\u044f \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438: " + org.getShortName()), (Object[])null));
                    val = val.replaceAll("^[0-9XBFM \\-]", "");
                }
                if (TextUtil.isBlank((String)(val = val.replaceAll("\\-", "")))) continue;
                Communication comm = new Communication();
                comm.setUid(UUIDGenerator.generate().toString());
                String letter = val.substring(val.length() - 1);
                if (!Character.isLetter(letter.charAt(0)) || val.length() < 3) {
                    val = val + "-B";
                    letter = EXCEL_COL_NUM_VALUE_START_ORG;
                }
                if (Character.isLetter(letter.charAt(0))) {
                    String[] phoneParts;
                    String phone = val.substring(0, val.length() - 2);
                    comm.setType(ProfileSynchronizationUtil.getCommTypeFromString((String)letter));
                    String internalPart = "";
                    String internalDelim = "X";
                    if (phone.contains(internalDelim) && phone.indexOf(internalDelim) < phone.length() - 1) {
                        internalPart = phone.substring(phone.indexOf(internalDelim) + 1);
                        phone = phone.substring(0, phone.indexOf(internalDelim));
                    }
                    if ((phoneParts = phone.split("\\s+")).length > 2) {
                        comm.setCountryCode(phoneParts[0]);
                        comm.setCityCode(phoneParts[1]);
                        StringBuilder sensePart = new StringBuilder();
                        for (int i = 2; i < phoneParts.length; ++i) {
                            sensePart.append((sensePart.toString().length() > 0 ? " " : "") + phoneParts[i]);
                        }
                        comm.setSense(sensePart.toString());
                    } else if (phoneParts.length > 1) {
                        comm.setCityCode(phoneParts[0]);
                        comm.setSense(phoneParts[1]);
                    } else {
                        comm.setSense(phoneParts[0]);
                    }
                    if (!TextUtil.isBlank((String)internalPart)) {
                        comm.setInternalNumber(internalPart);
                    }
                }
                if (TextUtil.isBlank((String)comm.getSense()) && TextUtil.isBlank((String)comm.getCountryCode()) && TextUtil.isBlank((String)comm.getCityCode())) continue;
                org.getCommunications().add(comm);
            }
        }
    }

    private static BufferedWriter createWriterForAdditionalLog(String fileName) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(new File(fileName)));
        }
        catch (IOException e) {
            e.printStackTrace();
            bw = null;
        }
        return bw;
    }

    private static String getKeyForPerson(Person per) {
        String res = "";
        if (per == null || TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true)) && TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            return NULL_KEY;
        }
        if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            res = L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        } else if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            res = L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        }
        if (!ProfileSynchronizationUtil.checkForLatinSymbols((String)res, (boolean)false)) {
            res = TextUtil.translit((String)res, (boolean)true);
        }
        String firstName = "";
        if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            firstName = L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        } else if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            firstName = L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        }
        if (!ProfileSynchronizationUtil.checkForLatinSymbols((String)firstName, (boolean)false)) {
            firstName = TextUtil.translit((String)firstName, (boolean)true);
        }
        if (!res.contains(firstName)) {
            res = res + (res.length() > 0 ? " " : "") + firstName;
        }
        if (TextUtil.isBlank((String)res)) {
            res = NULL_KEY;
        }
        return res.toUpperCase();
    }

    private static String getKeyForContract(Contract ctr, StringBuilder orgName) {
        String res = "";
        if (ctr == null || ctr.getCustomers().size() == 0) {
            return NULL_KEY;
        }
        ContractCustomerInfo cci = (ContractCustomerInfo)ctr.getCustomers().get(0);
        EntityReference orgRef = cci.getCustomer();
        Organization org = null;
        try {
            org = referenceOrganizationContainers.get(orgRef.getUid());
        }
        catch (Exception e) {
            org = null;
        }
        if (org == null) {
            return NULL_KEY;
        }
        res = org.getCode();
        orgName.append(org.getFullName());
        return res;
    }

    public static List<BaseEntity> getContainersFromXml(Document doc) throws Exception {
        ArrayList<BaseEntity> res = new ArrayList<BaseEntity>();
        Element docEle = doc.getDocumentElement();
        NodeList containers = docEle.getElementsByTagName(NODE_OBJECT);
        if (containers != null && containers.getLength() > 0) {
            for (int i = 0; i < containers.getLength(); ++i) {
                Node node = containers.item(i);
                if (node.getNodeType() != 1) continue;
                Element elm = (Element)node;
                String className = elm.getAttribute("class");
                if (className.contains("EntityContainer")) {
                    String typeClass = XHelper.readString((Element)elm, (String)"entityType");
                    Class<?> cls = Class.forName(typeClass);
                    EntityContainer etc = (EntityContainer)EntityContainer.class.getConstructor(Class.class).newInstance(cls);
                    etc.fromXML(elm);
                    res.add((BaseEntity)etc);
                    continue;
                }
                Class<?> cls = Class.forName(className);
                BaseDictionary dictionary = (BaseDictionary)cls.newInstance();
                dictionary.fromXML(elm);
                res.add((BaseEntity)dictionary);
            }
        }
        return res;
    }

    public static List<BaseDictionary> getDictionariesFromXml(Document doc) throws Exception {
        ArrayList<BaseDictionary> res = new ArrayList<BaseDictionary>();
        Element docEle = doc.getDocumentElement();
        NodeList containers = docEle.getElementsByTagName(NODE_OBJECT);
        if (containers != null && containers.getLength() > 0) {
            for (int i = 0; i < containers.getLength(); ++i) {
                Node node = containers.item(i);
                if (node.getNodeType() != 1) continue;
                Element elm = (Element)node;
                String className = elm.getAttribute("class");
                Class<?> cls = Class.forName(className);
                BaseDictionary dictionary = (BaseDictionary)cls.newInstance();
                dictionary.fromXML(elm);
                res.add(dictionary);
            }
        }
        return res;
    }

    public static List<Document> fillResultDocumentList(List<BaseEntity> list) throws Exception {
        ArrayList<Document> res = new ArrayList<Document>();
        int count = 0;
        Element element = null;
        Document convertDocument = null;
        for (BaseEntity c : list) {
            if (!ExcelImportTestUtil.finalFilter(c)) continue;
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                res.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element entityElement = null;
            if (c instanceof EntityContainer) {
                entityElement = ExcelImportTestUtil.createEntityContainerElement(convertDocument, c);
            } else if (c instanceof BaseDictionary) {
                entityElement = ExcelImportTestUtil.createDictionatyContainerElement(convertDocument, (BaseDictionary)c);
            }
            if (element != null && entityElement != null) {
                element.appendChild(entityElement);
                element.setAttribute("totalCount", String.valueOf(count + 1));
            }
            ++count;
        }
        return res;
    }

    private static boolean finalFilter(BaseEntity c) {
        boolean res = false;
        if (c instanceof EntityContainer) {
            EntityContainer cont = (EntityContainer)c;
            if (cont.getEntity() instanceof Person) {
                res = true;
            } else if (cont.getEntity() instanceof Organization && !organizationContainers.containsKey(((Organization)cont.getEntity()).getCode())) {
                System.out.println("ORG FILTERED: " + ((Organization)cont.getEntity()).getShortName().getStringValue());
                res = true;
            }
        }
        return res;
    }

    private static boolean orgInList(Organization entity) {
        ArrayList<String> dkList = new ArrayList<String>(){
            {
                this.add("0010209");
            }
        };
        if (dkList.contains(entity.getCode())) {
            System.out.println("Organization allowed for DK = " + entity.getCode());
        }
        return dkList.contains(entity.getCode());
    }

    public static void printMessages(List<Message> messages, MessageType type) {
        StringBuilder str = new StringBuilder();
        if (type == null) {
            Collections.sort(messages, new Comparator<Message>(){

                @Override
                public int compare(Message o1, Message o2) {
                    if (o1 == null || o1.getMessage() == null || o2 == null || o2.getMessage() == null) {
                        return 0;
                    }
                    return o1.getMessage().toString().compareTo(o2.getMessage().toString());
                }
            });
            StringBuilder s1 = new StringBuilder();
            for (Message msg : messages) {
                s1.append(MessageType.ERROR.name() + ": " + msg.getMessage() + "\n");
            }
            str.append(s1.toString());
        } else {
            for (Message msg : messages) {
                if (msg.getType() == null || !msg.getType().equals((Object)type)) continue;
                String msgType = msg.getType() != null ? msg.getType().name() + ": " : "";
                str.append(msgType + msg.getMessage() + "\n");
            }
        }
        BufferedWriter bw = ExcelImportTestUtil.createWriterForAdditionalLog("temp/server/Summary.txt");
        ExcelImportTestUtil.log2File(bw, str.toString());
        System.out.println(str.toString());
    }

    private static Element createEntityContainerElement(Document convertDocument, BaseEntity entityContainer) throws Exception {
        EntityContainer c;
        BaseEntity be;
        Element entityContainerElement = convertDocument.createElementNS(null, NODE_OBJECT);
        entityContainerElement.setAttribute("class", EntityContainer.class.getName());
        if (entityContainer instanceof EntityContainer && (be = (c = (EntityContainer)entityContainer).getEntity()) instanceof PersonCommunication) {
            PersonCommunication personCommunication = (PersonCommunication)be;
        }
        entityContainer.toXML(entityContainerElement);
        return entityContainerElement;
    }

    private static <D extends BaseDictionary> Element createDictionatyContainerElement(Document convertDocument, D dictionaryContainer) throws Exception {
        Element dictionaryContainerElement = convertDocument.createElementNS(null, NODE_OBJECT);
        dictionaryContainerElement.setAttribute("class", dictionaryContainer.getClass().getName());
        dictionaryContainer.toXML(dictionaryContainerElement);
        return dictionaryContainerElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createZipArchive(List<Document> list, String filename) throws Exception {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(new File(filename))));){
            zipOutputStream.setComment("Excel to Mid Office Manager convert");
            int count = 0;
            for (Document convertDocument : list) {
                zipOutputStream.putNextEntry(new ZipEntry(String.format("%08d.xml", count + 1)));
                Transformer transformer = XUtil.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                try {
                    transformer.transform(new DOMSource(convertDocument), new StreamResult(zipOutputStream));
                    ++count;
                }
                finally {
                    zipOutputStream.closeEntry();
                }
            }
        }
    }

    private static void log2File(BufferedWriter bw, String msg) {
        if (bw == null) {
            return;
        }
        try {
            bw.write(msg);
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testParseGroups() {
        String str = "MON-FRI 09-12AM - 06-35PM";
        String dayOfWeekRegexp = "";
        for (WorkModeType t : WorkModeType.values()) {
            dayOfWeekRegexp = dayOfWeekRegexp + (dayOfWeekRegexp.length() > 0 ? "|" : "") + ProfileSynchronizationUtil.getWorkModeTypeForSabre((WorkModeType)t);
        }
        Pattern p = Pattern.compile("(" + dayOfWeekRegexp + ")\\s+(\\d+)-(\\d+)(AM|PM|\\s)\\s*-\\s+(\\d+)-(\\d+)((AM|PM)*)");
        Matcher m = p.matcher(str);
        if (m.find()) {
            try {
                System.out.println("day=" + m.group(1));
                System.out.println("hour1=" + m.group(2));
                System.out.println("min1=" + m.group(3));
                System.out.println("half1=" + m.group(4));
                System.out.println("hour2=" + m.group(5));
                System.out.println("min2=" + m.group(6));
                System.out.println("half2=" + m.group(7));
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println("Out of bounds: no such group");
            }
        } else {
            System.out.println("No match");
        }
    }

    public static void parsePersonPosition(Person per, EntityReference<Organization> orgRef, String value, String fullName, List<Message> messages) {
        per.getEmployments().clear();
        PersonEmployment pe = new PersonEmployment();
        pe.setOrganization(orgRef);
        PersonPosition newPosition = ExcelImportTestUtil.getOrCreatePersonPosition(value, true);
        if (newPosition != null) {
            pe.setPosition((DictionaryReference)newPosition.toReference());
        }
        pe.setMainEmployment(true);
        per.getEmployments().add(pe);
        Iterator addressIterator = per.getAddresses().iterator();
        while (addressIterator.hasNext()) {
            PersonAddress address = (PersonAddress)addressIterator.next();
            if (address.getOrganization() == null || address.getOrganization().equals(orgRef)) continue;
            addressIterator.remove();
        }
        Iterator communicationIterator = per.getCommunications().iterator();
        while (communicationIterator.hasNext()) {
            PersonCommunication communication = (PersonCommunication)communicationIterator.next();
            if (communication.getOrganization() == null || communication.getOrganization().equals(orgRef)) continue;
            communicationIterator.remove();
        }
        Iterator metadataIterator = per.getMetadata().iterator();
        while (metadataIterator.hasNext()) {
            PersonMetadata metadata = (PersonMetadata)metadataIterator.next();
            if (metadata.getOrganization() == null || metadata.getOrganization().equals(orgRef)) continue;
            metadataIterator.remove();
        }
    }

    public static PersonPosition getOrCreatePersonPosition(String positionName, boolean needToBeSaved) {
        PersonPosition newPosition = null;
        Map positionsMap = ((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(PersonPosition.class);
        for (Map.Entry entry : positionsMap.entrySet()) {
            PersonPosition pos = (PersonPosition)entry.getValue();
            if (pos == null || !pos.getTranslations().containsKey(LOCALE_EN) || !((String)pos.getTranslations().get(LOCALE_EN)).equals(positionName)) continue;
            newPosition = pos;
            break;
        }
        if (newPosition == null) {
            try {
                newPosition = (PersonPosition)SabreProfileHelper.createDictionaryContainer(PersonPosition.class, (String)UUIDGenerator.generate().toString());
                newPosition.getTranslations().put(LOCALE_EN, positionName);
                newPosition.getTranslations().put(LOCALE_RU, positionName);
                if (needToBeSaved) {
                    newDictionaryContainers.put(newPosition.getCode(), (BaseDictionary)newPosition);
                }
                LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)newPosition);
            }
            catch (Exception e) {
                e.printStackTrace();
                newPosition = null;
            }
        }
        return newPosition;
    }

    private static final EntityContainer<Person> createPersonContainer(String name) {
        EntityContainer newPersonCont = null;
        try {
            newPersonCont = SabreProfileHelper.createEntityContainer(Person.class, (String)UUIDGenerator.generate().toString());
        }
        catch (Exception e) {
            return newPersonCont;
        }
        Person person = (Person)newPersonCont.getEntity();
        Pattern pat = Pattern.compile("(\\S*)\\s(.*)");
        Matcher mat = pat.matcher(name);
        if (mat.matches()) {
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)mat.group(1), (Locale)LocaleUtil.LOCALE_EN);
            L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)mat.group(2), (Locale)LocaleUtil.LOCALE_EN);
        } else {
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)name, (Locale)LocaleUtil.LOCALE_EN);
        }
        return newPersonCont;
    }

    private static final EntityContainer<Organization> createOrganizationContainer(String dkCode) {
        EntityContainer newOrgCont = null;
        try {
            newOrgCont = SabreProfileHelper.createEntityContainer(Organization.class, (String)UUIDGenerator.generate().toString());
        }
        catch (Exception e) {
            return null;
        }
        Organization org = (Organization)newOrgCont.getEntity();
        org.setCode(dkCode);
        return newOrgCont;
    }

    private static EntityContainer<Contract> createContractContainer(EntityReference<Organization> client) {
        EntityContainer newCtrCont = null;
        try {
            newCtrCont = SabreProfileHelper.createEntityContainer(Contract.class, (String)UUIDGenerator.generate().toString());
        }
        catch (Exception e) {
            return null;
        }
        Contract ctr = (Contract)newCtrCont.getEntity();
        ContractCustomerInfo cci = new ContractCustomerInfo();
        cci.setCustomer(client);
        for (EntityReference<Organization> ref : agencyReferences) {
            if (!ref.getCaption().contains("Obriy") && !ref.getCaption().contains("\u041e\u0431\u0440")) continue;
            ctr.setSupplier(ref);
            break;
        }
        ctr.getCustomers().add(cci);
        ctr.setContractType(ContractType.CLIENT);
        RuleSet rs = new RuleSet();
        ctr.setRuleSet(rs);
        return newCtrCont;
    }

    private static EntityContainer<TripartiteContract> createTripartiteContractContainer(TripartiteContractType type, EntityReference<Organization> client) {
        EntityContainer newCtrCont = null;
        try {
            newCtrCont = SabreProfileHelper.createEntityContainer(TripartiteContract.class, (String)UUIDGenerator.generate().toString());
        }
        catch (Exception e) {
            return null;
        }
        TripartiteContract ctr = (TripartiteContract)newCtrCont.getEntity();
        TripartiteContractCustomerInfo cci = new TripartiteContractCustomerInfo();
        cci.setCustomer(client);
        for (EntityReference<Organization> ref : agencyReferences) {
            if (!ref.getCaption().contains("Obriy") && !ref.getCaption().contains("\u041e\u0431\u0440")) continue;
            ctr.setAgency(ref);
            break;
        }
        ctr.getCustomers().add(cci);
        ctr.setType(type);
        RuleSet rs = new RuleSet();
        ctr.setRuleSet(rs);
        return newCtrCont;
    }

    private static void parseFnbts(Organization org, String valueFirst, List<Message> messages) {
        Pattern p = Pattern.compile("([a-zA-Z0-9]+)/([a-zA-Z0-9]+)/([a-zA-Z0-9]+)\\-(([a-zA-Z0-9 ]+))");
        Matcher m = p.matcher(valueFirst);
        if (m.matches()) {
            String code1 = m.group(1);
            String code2 = m.group(2);
            String code3 = m.group(3);
            String code4 = m.group(4);
            SabreProfileCommand1Fnbts cmd = new SabreProfileCommand1Fnbts();
            cmd.setEntry1(code1);
            cmd.setEntry2(code2);
            cmd.setEntry3(code3);
            cmd.setEntry4(code4);
            cmd.setEntry5("");
            org.getSabreAdditionalCommand1Lines().add(cmd);
        } else {
            messages.add(MessageHelper.createErrorMessage((String)("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043a\u043e\u043c\u0430\u043d\u0434\u044b FNBTS \u0434\u043b\u044f \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 " + org.getShortName() + ": " + valueFirst), (Object[])null));
        }
    }

    private static void parseClientId(Organization org, String valueFirst, List<Message> messages) {
        org.setClientID(valueFirst);
    }

    static {
        organizationContainers = new HashMap<String, EntityContainer<Organization>>();
        agencyReferences = new ArrayList<EntityReference<Organization>>();
        newOrganizationContainers = new HashMap<String, EntityContainer<Organization>>();
        referenceOrganizationContainers = new HashMap<String, Organization>();
        personContainers = new HashMap<String, List<EntityContainer<Person>>>();
        newPersonContainers = new HashMap<String, List<EntityContainer<Person>>>();
        usedPersonContainers = new HashMap<String, List<EntityContainer<Person>>>();
        usedOrganizationContainers = new HashMap<String, EntityContainer<Organization>>();
        contractContainers = new HashMap<String, EntityContainer<Contract>>();
        newContractContainers = new HashMap<String, EntityContainer<Contract>>();
        newTripartiteContractContainers = new HashMap<String, EntityContainer<TripartiteContract>>();
        commissionContainers = new HashMap<String, EntityContainer<BaseCommissionProperties>>();
        newDictionaryContainers = new HashMap<String, BaseDictionary>();
        costCodeCategoryReferences = new HashMap<String, DictionaryReference<CostCodeCategory>>();
        reasonCodesReferences = new HashMap<String, DictionaryReference<CommonReasonCode>>();
        personPositionReferences = new HashMap<String, DictionaryReference<PersonPosition>>();
        costCodeCategoriesMap = new HashMap<String, DictionaryReference<CostCodeCategory>>();
        orgCount = 0;
        perCount = 0;
    }
}

