/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.rest;

import com.gridnine.xtrip.common.json.JSONMarshaller;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.BaseRestResponse;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.util.RestUtil;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

@Deprecated
public class RestAdvice
extends BaseAdvice {
    private static final String START_TIMING_KEY = RestAdvice.class.getName() + ".startTiming";

    public void before(MessageContext ctx) throws Exception {
        ctx.putObject(START_TIMING_KEY, (Object)System.currentTimeMillis());
    }

    public boolean handleException(Throwable e, MessageContext ctx) {
        try {
            BaseRestResponse response;
            HttpServletResponse res = (HttpServletResponse)ctx.getMandatoryObject((Enum)IBusRestContextKeys.HTTP_SERVLET_RESPONSE);
            if (res.getStatus() == 200 && !(e instanceof ValidationException)) {
                res.setStatus(400);
            }
            if ((response = (BaseRestResponse)ctx.getObject((Enum)IBusRestContextKeys.REST_RESPONSE)) == null) {
                String userMessage = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0438 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0442\u0440\u0443\u0434\u043d\u043e\u0441\u0442\u0438, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0441\u0432\u044f\u0436\u0438\u0442\u0435\u0441\u044c \u0441 \u043d\u0430\u0448\u0435\u0439 \u0441\u043b\u0443\u0436\u0431\u043e\u0439 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438.";
                String developerMessage = null;
                if (e instanceof Xeption) {
                    Xeption xe = (Xeption)e;
                    if (xe.getEndUserMessage() != null) {
                        userMessage = xe.getEndUserMessage().toString();
                    } else if (xe.getAdminMessage() != null) {
                        userMessage = xe.getAdminMessage().toString() + " \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u0441\u043b\u0443\u0436\u0431\u0443 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438.";
                    }
                    developerMessage = xe.getMessage();
                }
                response = new BaseRestResponse();
                response.setUserErrorMessage(userMessage);
                response.setDeveloperErrorMessage(developerMessage);
                if (MiscUtil.isTrue((String)System.getProperty("debug.rest"))) {
                    String message = RestUtil.handleException(this.log, e);
                    response.setExceptionStackTrace(message);
                }
            }
            JSONObject json = (JSONObject)JSONMarshaller.marshal((Object)response);
            HttpResponse httpRes = new HttpResponse();
            httpRes.setContent(json.toString().getBytes());
            httpRes.setContentType("application/json");
            ctx.putObject((Enum)IBusRestContextKeys.REST_BINARY_RESPONSE, (Object)httpRes);
            ctx.putObject((Enum)IBusRestContextKeys.HTTP_SERVLET_RESPONSE, (Object)res);
            return true;
        }
        catch (Throwable t) {
            this.log.error("failed sending exception as json", t);
            return false;
        }
    }

    public void after(MessageContext ctx) throws Exception {
        Long startTiming = (Long)ctx.getMandatoryObject(START_TIMING_KEY);
        HttpServletResponse res = (HttpServletResponse)ctx.getMandatoryObject((Enum)IBusRestContextKeys.HTTP_SERVLET_RESPONSE);
        HttpResponse response = (HttpResponse)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_BINARY_RESPONSE);
        if (0 != response.getResponseCode()) {
            res.setStatus(response.getResponseCode());
        }
        res.setHeader("Cache-Control", "no-store");
        res.setHeader("Pragma", "no-cache");
        res.setHeader("X-ServerExecutionTime", Long.toString(System.currentTimeMillis() - startTiming));
        res.setContentType(response.getContentType());
        if (!StringUtils.isBlank((String)response.getCharacterEncoding())) {
            res.setCharacterEncoding(response.getCharacterEncoding());
        }
        res.getOutputStream().write(response.getContent());
    }
}

