/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.rest;

import com.gridnine.xtrip.common.json.JSONMarshaller;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.Validatable;
import com.gridnine.xtrip.common.model.system.BaseRestRequest;
import com.gridnine.xtrip.common.model.system.BaseRestResponse;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.HttpServletRequestParametersUnmarshaller;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.json.JSONTokener;

@Deprecated
public class RestMarshallingAdvice
extends BaseAdvice {
    private static final String REQUEST_CLASS_PARAM = "request-class";
    private static final String RESPONSE_CLASS_PARAM = "response-class";
    private Class<?> requestClass;
    private boolean marshalResponse;
    private static final String EXCEPTION = RestMarshallingAdvice.class.getName() + ".Exception";

    public void configure(Map<String, String> params) throws Exception {
        String responseClassName;
        String requestClassName = params.get(REQUEST_CLASS_PARAM);
        if (!StringUtils.isBlank((String)requestClassName)) {
            this.requestClass = Class.forName(requestClassName);
            if (!Introspectable.class.isAssignableFrom(this.requestClass)) {
                throw new IllegalArgumentException(String.format("request-class %s is not an instance of %s", this.requestClass, Introspectable.class));
            }
        }
        this.marshalResponse = !StringUtils.isBlank((String)(responseClassName = params.get(RESPONSE_CLASS_PARAM)));
    }

    public void before(MessageContext ctx) throws Exception {
        BaseRestRequest request;
        if (this.requestClass == null) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)ctx.getMandatoryObject((Enum)IBusRestContextKeys.HTTP_SERVLET_REQUEST);
        List<String> jsonMethods = Arrays.asList("POST", "PUT");
        if (jsonMethods.contains(req.getMethod())) {
            JSONObject json = new JSONObject(new JSONTokener((Reader)req.getReader()));
            request = (BaseRestRequest)JSONMarshaller.unmarshal((Object)json, this.requestClass);
            if (MetaRegistryHelper.getEntityType((String)request.getClass().getName()).isValidatable() && !ValidationHelper.isValid((Validatable)request)) {
                BaseRestResponse response = new BaseRestResponse();
                response.setValidatedRequest((BaseRestRequest)ValidationHelper.clearValidValues((Validatable)request));
                ctx.putObject((Enum)IBusRestContextKeys.REST_RESPONSE, (Object)response);
                throw new ValidationException();
            }
        } else if ("GET".equals(req.getMethod())) {
            request = (BaseRestRequest)this.requestClass.newInstance();
            HttpServletRequestParametersUnmarshaller.unmarshal((Introspectable)request, req.getParameterMap());
        } else {
            throw new IllegalArgumentException("unsupported request method " + req.getMethod());
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_REQUEST, (Object)request);
    }

    public boolean handleException(Throwable e, MessageContext ctx) {
        ctx.putObject(EXCEPTION, (Object)e);
        return false;
    }

    public void after(MessageContext ctx) throws Exception {
        if (ctx.getObject(EXCEPTION) == null && this.marshalResponse) {
            BaseRestResponse response = (BaseRestResponse)ctx.getObject((Enum)IBusRestContextKeys.REST_RESPONSE);
            JSONObject json = null;
            if (response != null) {
                if (MiscUtil.isTrue((String)System.getProperty("debug.rest"))) {
                    for (Message message : ctx.getMessagesReadOnly()) {
                        response.getContextMessages().add(message.getMessage().toString());
                    }
                }
                json = (JSONObject)JSONMarshaller.marshal((Object)response);
            }
            HttpResponse httpRes = new HttpResponse();
            if (json == null) {
                json = new JSONObject();
            }
            httpRes.setContent(json.toString().getBytes());
            httpRes.setContentType("application/json");
            ctx.putObject((Enum)IBusRestContextKeys.REST_BINARY_RESPONSE, (Object)httpRes);
        }
    }
}

