/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;

public class PluginJarScanner
extends StandardJarScanner {
    private final Log log = LogFactory.getLog(PluginJarScanner.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.scan");
    private static final Set<ClassLoader> CLASSLOADER_HIERARCHY;
    private PluginDescriptor plugin;
    private URL pluginCodeSource;
    private ClassLoader pluginClassLoader;

    public PluginDescriptor getPlugin() {
        return this.plugin;
    }

    public void setPlugin(PluginDescriptor plugin) {
        this.plugin = plugin;
        this.pluginCodeSource = null;
        String pluginJarName = "plugin-" + plugin.getId() + ".jar";
        for (Library lib : plugin.getLibraries()) {
            String path;
            if (!lib.isCodeLibrary() || !(path = lib.getPath()).endsWith("/" + pluginJarName) && !path.equalsIgnoreCase(pluginJarName) && !path.endsWith("/classes/") && !path.endsWith("/classes") && !path.equalsIgnoreCase("classes")) continue;
            PluginManager manager = PluginManager.lookup((Object)((Object)((Object)this)).getClass().getClassLoader());
            this.pluginCodeSource = manager.getPathResolver().resolvePath((Identity)lib, lib.getPath());
            this.pluginClassLoader = manager.getPluginClassLoader(plugin);
            break;
        }
    }

    public void scan(JarScanType scanType, ServletContext context, JarScannerCallback callback) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("jarScan.webinflibStart"));
        }
        if (this.getJarScanFilter().isSkipAll()) {
            return;
        }
        HashSet<URL> processedURLs = new HashSet<URL>();
        Set dirList = context.getResourcePaths("/WEB-INF/lib/");
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith(".jar") && this.getJarScanFilter().check(scanType, path.substring(path.lastIndexOf(47) + 1))) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)sm.getString("jarScan.webinflibJarScan", new Object[]{path}));
                    }
                    URL url = null;
                    try {
                        url = context.getResource(path);
                        processedURLs.add(url);
                        this.process(scanType, callback, url, path, true, null);
                    }
                    catch (IOException e) {
                        this.log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{url}), (Throwable)e);
                    }
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)sm.getString("jarScan.webinflibJarNoScan", new Object[]{path}));
            }
        }
        try {
            URL webInfURL = context.getResource("/WEB-INF/classes");
            if (webInfURL != null) {
                URL url;
                processedURLs.add(webInfURL);
                if (this.isScanAllDirectories() && (url = context.getResource("/WEB-INF/classes/META-INF")) != null) {
                    try {
                        callback.scanWebInfClasses();
                    }
                    catch (IOException e) {
                        this.log.warn((Object)sm.getString("jarScan.webinfclassesFail"), (Throwable)e);
                    }
                }
            }
        }
        catch (MalformedURLException webInfURL) {
            // empty catch block
        }
        if (this.pluginCodeSource != null) {
            try {
                this.process(scanType, callback, this.pluginCodeSource, null, PluginJarScanner.isWebappClassLoader(this.pluginClassLoader), null);
            }
            catch (IOException ioe) {
                this.log.warn((Object)sm.getString("jarScan.classloaderFail", new Object[]{this.pluginCodeSource}), (Throwable)ioe);
            }
        }
        if (this.isScanClassPath()) {
            this.doScanClassPath(scanType, context, callback, processedURLs);
        }
    }

    private static boolean isWebappClassLoader(ClassLoader classLoader) {
        return !CLASSLOADER_HIERARCHY.contains(classLoader);
    }

    static {
        HashSet<ClassLoader> cls = new HashSet<ClassLoader>();
        for (ClassLoader cl = StandardJarScanner.class.getClassLoader(); cl != null; cl = cl.getParent()) {
            cls.add(cl);
        }
        CLASSLOADER_HIERARCHY = Collections.unmodifiableSet(cls);
    }
}

