/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.server.web.ServletInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServletsRegistry {
    private final Map<String, ServletInfo> servlets = new LinkedHashMap<String, ServletInfo>();

    public static synchronized ServletsRegistry get() {
        ServletsRegistry result;
        if (!Environment.isPublished(ServletsRegistry.class)) {
            result = new ServletsRegistry();
            Environment.publish((Object)result);
        } else {
            result = (ServletsRegistry)Environment.getPublished(ServletsRegistry.class);
        }
        return result;
    }

    private ServletsRegistry() {
    }

    public Collection<ServletInfo> getServlets() {
        return this.servlets.values();
    }

    public Collection<ServletInfo> getServlets(String context) {
        ArrayList<ServletInfo> result = new ArrayList<ServletInfo>();
        for (ServletInfo item : this.servlets.values()) {
            if (!context.equals(item.getWebContextPath())) continue;
            result.add(item);
        }
        return result;
    }

    public void register(ServletInfo info) {
        this.servlets.put(info.getId(), info);
    }
}

