/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.service.impl.ExecutorServiceFacadeImpl;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.server.web.PluginJarScanner;
import com.gridnine.xtrip.server.web.ServletInfo;
import com.gridnine.xtrip.server.web.ServletsRegistry;
import com.gridnine.xtrip.server.web.WebContextInfo;
import com.gridnine.xtrip.server.web.WebServer;
import com.gridnine.xtrip.server.web.WebSocketEndpointInfo;
import com.gridnine.xtrip.server.web.WebSocketUrlFilter;
import com.gridnine.xtrip.server.web.WebSocketsRegistry;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.annotation.MultipartConfig;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardThreadExecutor;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.apache.tomcat.websocket.server.WsSci;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TomcatServer
implements WebServer {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Tomcat tomcat = new Tomcat();

    static File getTempFolder() {
        return new File(Environment.getTempFolder(), ".tomcat-work");
    }

    @Override
    public void configure(ExtendedProperties properties) throws Exception {
        this.tomcat.setBaseDir(TomcatServer.getTempFolder().getCanonicalPath());
        this.configureConnectors(properties);
        this.tomcat.getServer().setParentClassLoader(this.getClass().getClassLoader());
        this.tomcat.getEngine().setDefaultHost(this.tomcat.getHost().getName());
        this.configureErrorValve(properties);
        this.tomcat.init();
    }

    private void configureErrorValve(ExtendedProperties properties) {
        Host host = this.tomcat.getHost();
        if (!(host instanceof StandardHost)) {
            return;
        }
        StandardHost standardHost = (StandardHost)host;
        boolean debugErrorValve = Boolean.parseBoolean(properties.getProperty("debugErrorValve"));
        if (debugErrorValve) {
            return;
        }
        standardHost.setErrorReportValveClass(SecureErrorReportValve.class.getName());
    }

    private void configureConnectors(ExtendedProperties properties) {
        Map<String, Map<String, String>> configurations = this.getConfigiurations(properties);
        boolean defaultConnectorInitialized = false;
        for (Map.Entry<String, Map<String, String>> configuration : configurations.entrySet()) {
            String name = configuration.getKey();
            HashMap<String, String> attributes = new HashMap<String, String>(configuration.getValue());
            this.log.debug(String.format("starting initalizing %s connector", name));
            String protocol = (String)attributes.get("protocol");
            attributes.remove("protocol");
            if (TextUtil.isBlank((String)protocol)) {
                protocol = "org.apache.coyote.http11.Http11Nio2Protocol";
            }
            this.log.debug(String.format("initalizing %s connector: protocol = %s", name, protocol));
            Connector connector = new Connector(protocol);
            String portString = (String)attributes.get("port");
            attributes.remove("port");
            Integer port = null;
            if (!TextUtil.isBlank((String)portString)) {
                try {
                    port = Integer.valueOf(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (port == null) {
                port = 8080;
            }
            this.log.debug(String.format("initalizing %s connector: port = %s", name, port));
            connector.setPort(port.intValue());
            String proxyName = (String)attributes.get("proxyName");
            attributes.remove("proxyName");
            if (!TextUtil.isBlank((String)proxyName)) {
                this.log.debug(String.format("initalizing %s connector: proxyName = %s", name, proxyName));
                connector.setProxyName(proxyName);
            }
            String proxyPortString = (String)attributes.get("proxyPort");
            attributes.remove("proxyPort");
            if (!TextUtil.isBlank((String)proxyPortString)) {
                Integer proxyPort = null;
                try {
                    proxyPort = Integer.valueOf(proxyPortString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (proxyPort != null) {
                    this.log.debug(String.format("initalizing %s connector: proxyPort = %s", name, proxyPort));
                    connector.setProxyPort(proxyPort.intValue());
                }
            }
            String secureString = (String)attributes.get("secure");
            attributes.remove("secure");
            boolean secure = Boolean.valueOf(secureString);
            this.log.debug(String.format("initalizing %s connector: secure = %s", name, String.valueOf(secure)));
            connector.setSecure(secure);
            String scheme = (String)attributes.get("scheme");
            attributes.remove("scheme");
            if (!TextUtil.isBlank((String)scheme)) {
                this.log.debug(String.format("initalizing %s connector: scheme = %s", name, scheme));
                connector.setScheme(scheme);
            }
            String uriEncoding = (String)attributes.get("URIEncoding");
            attributes.remove("URIEncoding");
            if (TextUtil.isBlank((String)uriEncoding)) {
                uriEncoding = "utf-8";
            }
            this.log.debug(String.format("initalizing %s connector: URIEncoding = %s", name, uriEncoding));
            connector.setURIEncoding(uriEncoding);
            String defaultString = (String)attributes.get("default");
            attributes.remove("default");
            boolean defaultt = Boolean.valueOf(defaultString);
            for (Map.Entry attribute : attributes.entrySet()) {
                String attributeName = (String)attribute.getKey();
                String attributeValue = (String)attribute.getValue();
                if (TextUtil.isBlank((String)attributeValue)) continue;
                this.log.debug(String.format("initalizing %s connector: %s = %s", name, attributeName, attributeValue));
                connector.setProperty(attributeName, attributeValue);
            }
            this.configureExecutor(connector, name);
            if (!defaultConnectorInitialized && defaultt) {
                this.log.debug(String.format("connector %s set as default", name));
                this.tomcat.setConnector(connector);
                defaultConnectorInitialized = true;
            } else {
                this.tomcat.getService().addConnector(connector);
            }
            this.log.debug(String.format("finishing initalizing %s connector", name));
        }
        if (!defaultConnectorInitialized) {
            Connector connector = new Connector("org.apache.coyote.http11.Http11Nio2Protocol");
            connector.setPort(8080);
            connector.setURIEncoding("utf-8");
            this.configureExecutor(connector, "default");
            this.tomcat.setConnector(connector);
        }
    }

    private Map<String, Map<String, String>> getConfigiurations(ExtendedProperties properties) {
        HashMap<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
        for (Map.Entry property : properties.entrySet()) {
            String[] tokens;
            String key = property.getKey().toString().trim();
            String value = property.getValue().toString().trim();
            if (TextUtil.isBlank((String)key) || TextUtil.isBlank((String)value) || (tokens = key.split("\\.", 2)).length != 2) continue;
            String name = tokens[0];
            HashMap<String, String> configuration = (HashMap<String, String>)configurations.get(name);
            if (configuration == null) {
                configuration = new HashMap<String, String>();
                configurations.put(name, configuration);
            }
            configuration.put(tokens[1], value);
        }
        return configurations;
    }

    private void configureExecutor(Connector connector, String connectorName) {
        TomcatThreadExecutor executor = new TomcatThreadExecutor();
        executor.setName(connectorName);
        AbstractProtocol protocol = (AbstractProtocol)connector.getProtocolHandler();
        String namePrefix = protocol.getName();
        namePrefix = namePrefix.substring(1, namePrefix.length() - 1);
        executor.setNamePrefix(namePrefix + "-exec-");
        executor.setMaxThreads(protocol.getMaxThreads());
        executor.setMinSpareThreads(protocol.getMinSpareThreads());
        this.tomcat.getEngine().getService().addExecutor((org.apache.catalina.Executor)executor);
        protocol.setExecutor((Executor)((Object)executor));
    }

    @Override
    public void start() throws Exception {
        this.tomcat.start();
        this.log.info("Tomcat web server started");
    }

    @Override
    public void stop() throws Exception {
        this.tomcat.stop();
        this.tomcat.destroy();
        this.log.info("Tomcat web server stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(WebContextInfo ctx) throws Exception {
        Context context = this.findContext(ctx);
        if (context != null) {
            return;
        }
        long start = System.currentTimeMillis();
        String webContextPath = ctx.isRoot() ? "" : "/" + ctx.getId();
        try {
            PluginManager.lookup((Object)this).activatePlugin(ctx.getDeclaringExtension().getDeclaringPluginDescriptor().getId());
            File docBase = IoUtil.url2file((URL)ctx.getDataLocation());
            final Collection<WebSocketEndpointInfo> wsEndpoints = WebSocketsRegistry.get().getWebsocketEndpoints(webContextPath);
            AddContextListener addListener = wsEndpoints.isEmpty() ? null : new AddContextListener(){

                @Override
                public void beforeAdd(Context ctxBeforeAdd) {
                    ctxBeforeAdd.addLifecycleListener(new LifecycleListener(){

                        public void lifecycleEvent(LifecycleEvent event) {
                            if ("before_start".equals(event.getType())) {
                                TomcatServer.this.initWebSocketsSupport(wsEndpoints, (Context)event.getLifecycle());
                            }
                        }
                    });
                }
            };
            context = this.addWebapp(this.tomcat.getHost(), webContextPath, webContextPath, docBase.getCanonicalPath(), ctx.getDeclaringExtension().getDeclaringPluginDescriptor(), addListener);
            if ("true".equals(System.getProperty("com.gridnine.xtrip.server.web.disableCaching"))) {
                WebResourceRoot resources = context.getResources();
                resources.setCachingAllowed(false);
                resources.setCacheMaxSize(0L);
                resources.setCacheTtl(0L);
            }
            this.log.debug(String.format("context deployed, info=%s, context=%s", ctx, context));
            for (ServletInfo item : ServletsRegistry.get().getServlets(webContextPath)) {
                Servlet servlet = item.getServlet();
                Wrapper wrapper = this.tomcat.addServlet(webContextPath, item.getServletName(), servlet);
                context.addServletMappingDecoded(item.getServletMappingPattern(), item.getServletName());
                MultipartConfig annotation = servlet.getClass().getAnnotation(MultipartConfig.class);
                if (annotation != null) {
                    wrapper.setMultipartConfigElement(new MultipartConfigElement(annotation));
                }
                this.log.debug(String.format("servlet deployed, id=%s, context=%s", item.getId(), ctx));
            }
        }
        finally {
            this.log.info("web context " + webContextPath + " deployed in " + (System.currentTimeMillis() - start) + " ms.");
        }
    }

    @Override
    public void undeploy(WebContextInfo ctx) throws Exception {
        Context context = this.findContext(ctx);
        if (context == null) {
            return;
        }
        if (context.getState().isAvailable()) {
            context.stop();
        }
        this.log.debug(String.format("context undeployed, info=%s, context=%s", ctx, context));
    }

    @Override
    public void start(WebContextInfo ctx) throws Exception {
        Context context = this.findContext(ctx);
        if (context == null) {
            throw new Exception("web context " + ctx.getId() + " not found");
        }
        if (!context.getState().isAvailable()) {
            context.start();
        }
    }

    @Override
    public void stop(WebContextInfo ctx) throws Exception {
        Context context = this.findContext(ctx);
        if (context == null) {
            throw new Exception("web context " + ctx.getId() + " not found");
        }
        if (context.getState().isAvailable()) {
            context.stop();
        }
    }

    @Override
    public boolean isStarted(WebContextInfo ctx) {
        Context context = this.findContext(ctx);
        return context != null && context.getState().isAvailable();
    }

    @Override
    public void reload(WebContextInfo ctx) throws Exception {
        Context context = this.findContext(ctx);
        if (context == null) {
            throw new Exception("web context " + ctx.getId() + " not found");
        }
        if (!context.getState().isAvailable()) {
            context.start();
        } else {
            context.reload();
        }
    }

    private Context findContext(WebContextInfo ctx) {
        return (Context)this.tomcat.getHost().findChild(ctx.isRoot() ? "" : "/" + ctx.getId());
    }

    @Override
    public int getSubmittedCount() {
        int count = 0;
        Connector[] connectors = this.tomcat.getService().findConnectors();
        if (connectors != null) {
            for (Connector connector : connectors) {
                count += ((ThreadPoolExecutor)connector.getProtocolHandler().getExecutor()).getSubmittedCount();
            }
        }
        return count;
    }

    protected Context addWebapp(String contextPath, String baseDir, PluginDescriptor pluginDescriptor) {
        return this.addWebapp(this.tomcat.getHost(), contextPath, baseDir, pluginDescriptor);
    }

    protected Context addWebapp(Host host, String url, String path, PluginDescriptor pluginDescriptor) {
        return this.addWebapp(host, url, url, path, pluginDescriptor);
    }

    protected Context addWebapp(Host host, String url, String name, String path, PluginDescriptor pluginDescriptor) {
        return this.addWebapp(host, url, name, path, pluginDescriptor, null);
    }

    private Context addWebapp(Host host, String url, String name, String path, PluginDescriptor pluginDescriptor, AddContextListener contextAddListened) {
        this.silence(host, url);
        PluginManager manager = PluginManager.lookup((Object)this.getClass().getClassLoader());
        StandardContext ctx = new StandardContext();
        ctx.setName(name);
        ctx.setPath(url);
        ctx.setDocBase(path);
        ctx.setParentClassLoader((ClassLoader)manager.getPluginClassLoader(pluginDescriptor));
        ctx.setContainerSciFilter(Pattern.quote(WsSci.class.getName()));
        PluginJarScanner jarScanner = new PluginJarScanner();
        jarScanner.setPlugin(pluginDescriptor);
        jarScanner.setScanClassPath(false);
        ctx.setJarScanner((JarScanner)jarScanner);
        ctx.addLifecycleListener((LifecycleListener)new WebXmlListener());
        ContextConfig ctxCfg = new ContextConfig();
        ctx.addLifecycleListener((LifecycleListener)ctxCfg);
        ctxCfg.setDefaultWebXml(this.tomcat.noDefaultWebXmlPath());
        if (contextAddListened != null) {
            contextAddListened.beforeAdd((Context)ctx);
        }
        if (host == null) {
            this.tomcat.getHost().addChild((Container)ctx);
        } else {
            host.addChild((Container)ctx);
        }
        if (contextAddListened != null) {
            contextAddListened.afterAdd((Context)ctx);
        }
        return ctx;
    }

    private void silence(Host host, String ctx) {
        String base = "org.apache.catalina.core.ContainerBase.[default].[";
        base = host == null ? base + this.tomcat.getHost().getName() : base + host.getName();
        base = base + "].[";
        base = base + ctx;
        base = base + "]";
        java.util.logging.Logger.getLogger(base).setLevel(Level.WARNING);
    }

    private final void initWebSocketsSupport(Collection<WebSocketEndpointInfo> wsEndpoints, Context context) {
        WsServerContainer sc;
        try {
            Method wssciInitMethod = WsSci.class.getDeclaredMethod("init", ServletContext.class, Boolean.TYPE);
            wssciInitMethod.setAccessible(true);
            sc = (WsServerContainer)wssciInitMethod.invoke(null, context.getServletContext(), true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error initalizing WebSockets support for context", e);
        }
        wsEndpoints.forEach(ep -> {
            try {
                String contextPath = ep.getWebContextPath();
                if ("".equals(contextPath)) {
                    contextPath = "/";
                }
                String socketPath = contextPath + ep.getPath();
                sc.addEndpoint(ServerEndpointConfig.Builder.create(ep.getEndpointClass(), (String)socketPath).configurator(ep.getEndpointConfigurator()).build());
            }
            catch (DeploymentException e) {
                throw new IllegalStateException("Error configuring WebSockets for context", e);
            }
        });
        wsEndpoints.forEach(ep -> {
            String filterName = WebSocketUrlFilter.class.getName() + ":" + ep.getId();
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterClass(WebSocketUrlFilter.class.getName());
            filterDef.addInitParameter("PATH", ep.getPath());
            filterDef.setFilterName(filterName);
            context.addFilterDef(filterDef);
            String filterPath = ep.getPath();
            if (!filterPath.startsWith("/")) {
                filterPath = "/" + filterPath;
            }
            if (!filterPath.endsWith("/")) {
                filterPath = filterPath + "/";
            }
            filterPath = filterPath + "*";
            FilterMap filterMap = new FilterMap();
            filterMap.addURLPattern(filterPath);
            filterMap.setFilterName(filterName);
            context.addFilterMap(filterMap);
        });
        this.log.debug(String.format("WebSockets configuration initialized, ids=%s, context=%s", wsEndpoints.stream().map(ep -> ep.getId()).collect(Collectors.joining(",")), context));
    }

    public static class WebXmlListener
    extends Tomcat.DefaultWebXmlListener {
        public void lifecycleEvent(LifecycleEvent event) {
            super.lifecycleEvent(event);
            if ("before_start".equals(event.getType())) {
                Context ctx = (Context)event.getLifecycle();
                Wrapper servlet = (Wrapper)ctx.findChild("jsp");
                servlet.addInitParameter("compilerSourceVM", "1.8");
                servlet.addInitParameter("compilerTargetVM", "1.8");
            }
        }
    }

    protected static class TomcatThreadExecutor
    extends StandardThreadExecutor {
        protected TomcatThreadExecutor() {
        }

        private Runnable getCommand(Runnable command) {
            return () -> {
                try {
                    command.run();
                }
                finally {
                    try {
                        ExecutorServiceFacadeImpl.clearThreadLocals((Thread)Thread.currentThread());
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(TomcatThreadExecutor.class).error("error while clear thread locals", (Throwable)e);
                    }
                }
            };
        }

        public void execute(Runnable command, long timeout, TimeUnit unit) {
            super.execute(this.getCommand(command), timeout, unit);
        }

        public void execute(Runnable command) {
            super.execute(this.getCommand(command));
        }
    }

    public static class SecureErrorReportValve
    extends ErrorReportValve {
        private static final Logger logger = LoggerFactory.getLogger(SecureErrorReportValve.class);

        protected void report(Request request, Response response, Throwable throwable) {
            if (response.getStatus() < 400) {
                super.report(request, response, throwable);
                return;
            }
            String uuid = UUIDUtil.toString((UUID)UUID.randomUUID());
            logger.error("tomcat error {}", (Object)uuid, (Object)throwable);
            response.setContentType("text/plain");
            try {
                PrintWriter writer = response.getReporter();
                if (writer != null) {
                    ((Writer)writer).write(uuid);
                    response.finishResponse();
                }
            }
            catch (IOException ex) {
                logger.error("error while reporting tomcat error uuid", (Throwable)ex);
            }
            response.setErrorReported();
        }
    }

    private static interface AddContextListener {
        default public void beforeAdd(Context ctx) {
        }

        default public void afterAdd(Context ctx) {
        }
    }
}

