/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web;

import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.web.WebContextListener;
import com.gridnine.xtrip.server.web.WebService;
import java.io.File;
import java.net.URL;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;

public final class WebContextInfo {
    private static final WebContextListener FAKE_LISTENER = new WebContextListener(){

        @Override
        public void afterUndeploy(WebContextInfo ctx) {
        }

        @Override
        public void beforeDeploy(WebContextInfo ctx) {
        }
    };
    private final Extension ext;
    private final String id;
    private final boolean isVirtual;
    private final URL dataLocation;
    private final boolean isDataLocationRelativeToWorkDir;
    private final WebService webService;
    private WebContextListener listener;

    WebContextInfo(WebService service, Extension anExt) throws Exception {
        this.ext = anExt;
        PluginManager manager = PluginManager.lookup((Object)this);
        this.webService = service;
        this.id = anExt.getParameter("id").valueAsString();
        PluginClassLoader clsLoader = manager.getPluginClassLoader(anExt.getDeclaringPluginDescriptor());
        this.isDataLocationRelativeToWorkDir = anExt.getParameter("isDataLocationRelativeToWorkDir") != null ? anExt.getParameter("isDataLocationRelativeToWorkDir").valueAsBoolean() : false;
        this.dataLocation = this.isDataLocationRelativeToWorkDir ? new File(".", anExt.getParameter("dataLocation").valueAsString()).toURI().toURL() : clsLoader.getResource(anExt.getParameter("dataLocation").valueAsString());
        if (this.dataLocation == null) {
            throw new Exception("can't get context base URL for " + anExt.getParameter("dataLocation").valueAsString() + " as declared in extension " + anExt + ", skipping this context");
        }
        Extension.Parameter param = anExt.getParameter("isVirtual");
        this.isVirtual = param != null && param.valueAsBoolean() != false;
    }

    public Extension getDeclaringExtension() {
        return this.ext;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRoot() {
        String rootContext = this.webService.getConfiguration().getRootContext();
        if (rootContext == null) {
            return this.id.equals("standard-root");
        }
        return this.id.equals(rootContext);
    }

    public boolean isActive() {
        return this.webService.getConfiguration().isContextActive(this.id);
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public URL getDataLocation() {
        return this.dataLocation;
    }

    public String toString() {
        return this.ext.getUniqueId();
    }

    public ClassLoader getClassLoader() {
        return PluginManager.lookup((Object)this).getPluginClassLoader(this.ext.getDeclaringPluginDescriptor());
    }

    WebContextListener getListener() throws Exception {
        if (this.listener != null) {
            return this.listener;
        }
        Extension.Parameter param = this.ext.getParameter("listener-class");
        this.listener = param != null ? (WebContextListener)JpfUtil.getClass((Extension.Parameter)param).newInstance() : FAKE_LISTENER;
        return this.listener;
    }
}

