/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gracefulstop.GracefulStoppable;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.Service;
import com.gridnine.xtrip.server.web.Configuration;
import com.gridnine.xtrip.server.web.TomcatServer;
import com.gridnine.xtrip.server.web.WebContextInfo;
import com.gridnine.xtrip.server.web.WebContextManager;
import com.gridnine.xtrip.server.web.WebServer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.java.plugin.registry.Extension;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebService
implements Service,
GracefulStoppable {
    public static final String UID = "web-service";
    static final String DEFAULT_ROOT_CONTEXT = "standard-root";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Configuration configuration;
    private WebServer server;
    private final HashMap<String, WebContextInfo> contexts = new HashMap();
    private AtomicBoolean shutdown = new AtomicBoolean();
    private final Thread shutdownWatcher = new Thread("web-server-shutdown-watcher"){

        @Override
        public void run() {
            try {
                while (!WebService.this.shutdown.get()) {
                    if (new File(Environment.getRootFolder(), ".shutdown").exists()) {
                        WebService.this.shutdown();
                        break;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable t) {
                WebService.this.log.error("an unexpected error has occurred", t);
            }
        }
    };

    public String getUid() {
        return UID;
    }

    public void configure(ExtendedProperties config) throws Exception {
        this.server = new TomcatServer();
        this.server.configure(config.getSubset("tomcat."));
        this.populateContexts();
    }

    public void start() throws Exception {
        this.configuration = Configuration.load();
        this.server.start();
        WebContextManager.webService = this;
        try {
            for (WebContextInfo ctx : this.contexts.values()) {
                if (!ctx.isActive() && !ctx.isRoot()) continue;
                try {
                    WebContextManager.setContextState(ctx, true);
                }
                catch (Exception e) {
                    this.log.error("can't deploy context " + ctx, (Throwable)e);
                }
                if (!ctx.isRoot()) continue;
                this.log.info("ROOT context is mapped to extension " + ctx);
            }
        }
        catch (Exception e) {
            this.log.error("error starting server", (Throwable)e);
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.shutdownWatcher.setDaemon(true);
        this.shutdownWatcher.start();
    }

    private void updeploy() {
        for (WebContextInfo ctx : this.contexts.values()) {
            try {
                WebContextManager.setContextStateInternal(ctx, false);
            }
            catch (Exception e) {
                this.log.error("can't undeploy context " + ctx, (Throwable)e);
            }
        }
        Configuration.save(this.configuration);
    }

    public void stop() throws Exception {
        this.shutdown();
        if (this.server != null) {
            this.server.stop();
        }
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    WebServer getServer() {
        return this.server;
    }

    Map<String, WebContextInfo> getContexts() {
        return this.contexts;
    }

    private void populateContexts() throws Exception {
        this.log.debug("populating web applications");
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server.web", (String)"WebContext")) {
            try {
                WebContextInfo ctx = new WebContextInfo(this, ext);
                if (this.contexts.containsKey(ctx.getId())) {
                    this.log.warn(String.format("duplicate web context ID detected - %s, the extension %s will be ignored", ctx.getId(), ext));
                    continue;
                }
                this.contexts.put(ctx.getId(), ctx);
            }
            catch (Exception e) {
                this.log.error("can't populate context", (Throwable)e);
            }
        }
    }

    public void initiateShutdown() {
        this.shutdown();
    }

    public boolean canStop() {
        return true;
    }

    private void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        this.shutdownWatcher.interrupt();
        this.updeploy();
    }
}

