/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketUrlFilter
implements Filter {
    public static final String INIT_PARAM_PATH = "PATH";
    public static final String REQUEST_PARAM_PATH = "REQUEST_PARAM_PATH";
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketUrlFilter.class);
    private String wsServicePath;

    public void init(FilterConfig filterConfig) {
        this.wsServicePath = filterConfig.getInitParameter(INIT_PARAM_PATH);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String prefix;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestURI = httpRequest.getRequestURI();
        String contextPath = httpRequest.getContextPath();
        if (contextPath.equals("")) {
            contextPath = "/";
        }
        if (!requestURI.startsWith(prefix = contextPath + this.wsServicePath)) {
            LOG.error(String.format("Illegal access to WebSocket - URL %s does not start with prefix %s", requestURI, prefix));
            throw new IllegalStateException("Illegal access to WebSocket");
        }
        String path = requestURI.substring(prefix.length());
        request.getRequestDispatcher("/" + this.wsServicePath + "?" + REQUEST_PARAM_PATH + "=" + URLEncoder.encode(path, "UTF-8")).forward(request, response);
    }

    public void destroy() {
    }
}

