/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.lockmanager;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockMantaince;
import com.gridnine.xtrip.common.lockmanager.LockStats;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.jsp.JspWriter;

public class LocksViewer {
    private static void println(JspWriter out, String str) throws IOException {
        String str2 = str.replace("<", "&lt;");
        str2 = str2.replace(">", "&gt;");
        str2 = str2.replace("\n", "<BR>");
        str2 = str2.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        str2 = str2.replace(" ", "&nbsp;");
        out.println(str2 + "<BR>");
    }

    public static void build(JspWriter out) throws Exception {
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        out.println("<HTML>");
        out.println("<HEAD>");
        out.println("<TITLE>Locks</TITLE>");
        out.println("</HEAD>");
        out.println("<BODY>");
        out.println("<FORM ACTION=\"locks.jsp\" METHOD=\"post\">");
        out.println("<TABLE BORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"5\" WIDTH=\"99%\">");
        out.println("<CAPTION style=\"text-align:left;\">LOCKS:</CAPTION>");
        out.println("<TR>");
        out.println("<TH>&nbsp;</TH>");
        out.println("<TH>Name</TH>");
        out.println("<TH>Node</TH>");
        out.println("<TH>Thread</TH>");
        out.println("<TH>User</TH>");
        out.println("<TH>Operation</TH>");
        out.println("<TH>Expired</TH>");
        out.println("</TR>");
        LockMantaince lockManager = (LockMantaince)Environment.getPublished(LockMantaince.class);
        LockStats stats = lockManager.getStats();
        ArrayList locks = new ArrayList(stats.getLockList());
        Collections.sort(locks, new Comparator<LockStats.Lock>(){

            @Override
            public int compare(LockStats.Lock o1, LockStats.Lock o2) {
                return TextUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true, (boolean)true);
            }
        });
        for (LockStats.Lock lock : locks) {
            String lockName = lock.getName();
            Date date = lock.getExpire();
            String host = lock.getHost();
            String user = lock.getUser();
            String operation = lock.getOperation();
            Long threadId = lock.getThreadId();
            out.println("<TR>");
            out.println("<TD align=\"center\">");
            out.println("<NOBR><INPUT TYPE=\"checkbox\" NAME=\"lockName\" VALUE=\"" + lockName + "\"/></NOBR>");
            out.println("</TD>");
            out.println("<TD>");
            if (lockName != null) {
                LocksViewer.println(out, lockName);
            }
            out.println("</TD>");
            out.println("<TD align=\"center\">");
            if (host != null) {
                LocksViewer.println(out, host);
            }
            out.println("</TD>");
            out.println("<TD align=\"center\">");
            if (threadId != null) {
                LocksViewer.println(out, threadId.toString());
            }
            out.println("</TD>");
            out.println("<TD align=\"center\">");
            if (user != null) {
                LocksViewer.println(out, user);
            }
            out.println("</TD>");
            out.println("<TD align=\"center\">");
            if (operation != null) {
                LocksViewer.println(out, operation);
            }
            out.println("</TD>");
            long diff = date != null ? TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - date.getTime()) : 0L;
            String color = null;
            if (diff >= 30L) {
                color = "red";
            } else if (diff >= 10L) {
                color = "yellow";
            }
            out.println("<TD align=\"center\"" + (color != null ? " style=\"background:" + color + ";\"" : "") + ">");
            if (date != null) {
                LocksViewer.println(out, new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(date));
            }
            out.println("</TD>");
            out.println("</TR>");
        }
        out.println("</TABLE>");
        out.println("<P><INPUT TYPE=\"submit\" NAME=\"delete\" VALUE=\"UNLOCK!\" ONCLICK=\"return confirm('Sure to unlock seleted locks?')\"/><P>");
        out.println("</FORM>");
        out.println("</BODY>");
        out.println("</HTML>");
    }

    public static void delete(String lockName) throws Exception {
        LockManager lockManager = LockUtil.getLockManager();
        try (NamedLock lock = lockManager.getLock((Object)lockName);){
            lock.unlock();
        }
    }

    protected static class Data {
        public long date;
        public String user;
        public String operation;

        protected Data() {
        }
    }
}

