/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest;

import com.gridnine.xtrip.server.web.rest.BaseHandshakeAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.http.util.TextUtils;
import org.json.JSONObject;

public class HandshakeRequestAdapter
extends BaseHandshakeAdapter
implements HttpServletRequest {
    private static final Pattern SEMICOLON = Pattern.compile(";", 16);
    private static final Pattern EQ = Pattern.compile("=", 16);
    final HandshakeRequest handshakeRequest;
    private final Map<String, List<String>> savedHeaders;
    private boolean getHeadersCalled = false;
    private final ServerEndpointConfig endpointConfig;
    private final Cookie[] cookies;
    private InputStream inputStream;
    private Reader reader;
    private boolean getReaderCalled = false;
    private boolean customHeadersRead = false;
    private final Map<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();
    private final String requestURI;

    public HandshakeRequestAdapter(HandshakeRequest handshakeRequestValue, ServerEndpointConfig endpointConfigValue) {
        this.handshakeRequest = Objects.requireNonNull(handshakeRequestValue);
        this.endpointConfig = Objects.requireNonNull(endpointConfigValue);
        this.savedHeaders = this.lowercaseHeaders(this.handshakeRequest.getHeaders());
        List<String> cookieHeaders = this.savedHeaders.get("cookie");
        this.cookies = cookieHeaders == null || cookieHeaders.isEmpty() ? null : (Cookie[])Arrays.stream(SEMICOLON.split(cookieHeaders.get(0), -1)).map(String::trim).map(s -> EQ.split((CharSequence)s, 2)).map(arr -> {
            if (((String[])arr).length != 2) {
                throw new IllegalArgumentException("Invalid cookie pair length:" + ((String[])arr).length);
            }
            return new Cookie(arr[0], arr[1]);
        }).toArray(Cookie[]::new);
        String servicePath = (String)Objects.requireNonNull(((List)this.handshakeRequest.getParameterMap().get("REQUEST_PARAM_PATH")).get(0));
        this.requestURI = handshakeRequestValue.getRequestURI().getPath() + servicePath;
    }

    protected void setInputStream(InputStream inputStream) {
        if (this.inputStream != null) {
            throw new IllegalStateException("InputStream already assigned");
        }
        if (this.getReaderCalled) {
            throw new IllegalStateException("getReader has already been called");
        }
        this.inputStream = inputStream;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void readHeadersFromInputStream() throws IOException {
        if (this.getHeadersCalled) {
            throw new IllegalStateException("headers have already been read from this instance of response");
        }
        if (this.getReaderCalled) {
            throw new IllegalStateException("getReader has already been called");
        }
        if (this.customHeadersRead) {
            throw new IllegalStateException("readHeadersFromInputStream has already been called");
        }
        BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(this.inputStream, 1024), StandardCharsets.UTF_8), 1024);
        StringBuilder headersObjStr = new StringBuilder(200);
        int bufLength = 1024;
        char[] buf = new char[bufLength];
        int i = 0;
        int scan = 0;
        int openBracesCount = 0;
        int closeBracesCount = 0;
        block4: while ((i = inputReader.read(buf)) != -1) {
            int j = 0;
            while (j < i) {
                switch (buf[j]) {
                    case '{': {
                        ++openBracesCount;
                        break;
                    }
                    case '}': {
                        ++closeBracesCount;
                        if (openBracesCount == 0) {
                            throw new IOException(String.format("Invalid closing brace at index %s", scan * bufLength + j));
                        }
                        if (openBracesCount != closeBracesCount) break;
                        headersObjStr.append(buf, 0, j + 1);
                        if (j < i - 1) {
                            this.reader = new SequenceReader(new CharArrayReader(buf, j + 1, i - j - 1), inputReader);
                            break block4;
                        }
                        this.reader = inputReader;
                        break block4;
                    }
                }
                ++j;
            }
            headersObjStr.append(buf, 0, i);
            ++scan;
        }
        JSONObject headersObj = new JSONObject(headersObjStr.toString());
        Iterator it = headersObj.keys();
        while (true) {
            if (!it.hasNext()) {
                this.customHeadersRead = true;
                return;
            }
            String key = (String)it.next();
            String value = headersObj.getString(key);
            if (this.savedHeaders.containsKey(key = key.toLowerCase())) {
                throw new IllegalStateException(String.format("Header %s already defined", key));
            }
            this.savedHeaders.put(key, Collections.singletonList(value));
        }
    }

    @Override
    protected Map<String, List<String>> getHandshakeHeaders() {
        return this.savedHeaders;
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        String[] result = this.getParameterValues(name);
        if (result == null || result.length == 0) {
            return null;
        }
        return result[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.handshakeRequest.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        List values = (List)this.handshakeRequest.getParameterMap().get(name);
        if (values == null) {
            return null;
        }
        return (String[])values.stream().toArray(String[]::new);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        this.handshakeRequest.getParameterMap().forEach((k, v) -> {
            String[] cfr_ignored_0 = (String[])result.put((String)k, (String[])v.stream().toArray(String[]::new));
        });
        return result;
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        throw new UnsupportedOperationException();
    }

    public String getServerName() {
        throw new UnsupportedOperationException();
    }

    public int getServerPort() {
        throw new UnsupportedOperationException();
    }

    public BufferedReader getReader() throws IOException {
        if (this.getReaderCalled) {
            throw new IllegalStateException("getReader has already been called");
        }
        if (!this.customHeadersRead) {
            throw new IllegalStateException("readHeadersFromInputStream has should be called before getting the reader");
        }
        BufferedReader result = new BufferedReader(this.reader);
        this.getReaderCalled = true;
        return result;
    }

    public String getRemoteAddr() {
        throw new UnsupportedOperationException();
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String name, Object o) {
        this.attributeMap.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    public Enumeration<Locale> getLocales() {
        throw new UnsupportedOperationException();
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public ServletContext getServletContext() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public String getAuthType() {
        throw new UnsupportedOperationException();
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public int getIntHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public String getMethod() {
        return "GET";
    }

    public String getPathInfo() {
        String result = this.endpointConfig.getPath();
        if (TextUtils.isBlank((CharSequence)result)) {
            return null;
        }
        return result;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        throw new UnsupportedOperationException();
    }

    public String getQueryString() {
        return this.handshakeRequest.getQueryString();
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException();
    }

    public String getServletPath() {
        throw new UnsupportedOperationException();
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException();
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
        throw new UnsupportedOperationException();
    }

    public Part getPart(String name) throws IOException, IllegalStateException, ServletException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Map<String, List<String>> getHeadersLowercased() {
        return this.savedHeaders;
    }

    @Override
    public String getHeader(String name) {
        this.getHeadersCalled = true;
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        this.getHeadersCalled = true;
        return Collections.enumeration(this.getHeadersLowercased().keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        this.getHeadersCalled = true;
        return Collections.enumeration(this.getHeadersCollection(name));
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public long getContentLengthLong() {
        throw new UnsupportedOperationException();
    }

    private static class SequenceReader
    extends Reader {
        private Reader currentReader;
        private final Reader[] readers;
        private int readerIndex = 0;

        SequenceReader(Reader ... readers) {
            this.readers = readers;
            this.currentReader = readers[this.readerIndex];
        }

        @Override
        public boolean ready() throws IOException {
            return this.currentReader.ready();
        }

        @Override
        public int read() throws IOException {
            while (this.currentReader != null) {
                int c = this.currentReader.read();
                if (c != -1) {
                    return c;
                }
                this.nextReader();
            }
            return -1;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            while (this.currentReader != null) {
                int count = this.currentReader.read(cbuf, off, len);
                if (count != -1) {
                    return count;
                }
                this.nextReader();
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            while (this.currentReader != null) {
                this.nextReader();
            }
        }

        private void nextReader() throws IOException {
            this.currentReader.close();
            ++this.readerIndex;
            this.currentReader = this.readerIndex < this.readers.length ? this.readers[this.readerIndex] : null;
        }
    }
}

