/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest;

import com.gridnine.xtrip.common.json.IntrospectableEntityWrapper;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.rest.TypeDiscriminator;
import com.gridnine.xtrip.common.rest.TypeHandler;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.web.rest.UnmarshalException;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonMarshaller {
    private final List<TypeHandler> handlers = new ArrayList<TypeHandler>();
    private final List<TypeDiscriminator> typeDiscriminators = new ArrayList<TypeDiscriminator>();
    private static final Format DT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter TF = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter DF = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String VALUE_OWNER_DATA_PARAMETER = "VALUE_OWNER";
    public static final String VALUE_OWNER_PROPERTY_NAME_DATA_PARAMETER = "VALUE_OWNER_PROPERTY_NAME";
    private static final Map<String, Class<?>> primitives = new HashMap();

    public void addTypeHandler(TypeHandler value) {
        this.handlers.add(value);
    }

    public void addTypeDiscriminator(TypeDiscriminator value) {
        this.typeDiscriminators.add(value);
    }

    private TypeHandler getTypeHandler(Class<?> clazz) {
        for (TypeHandler handler : this.handlers) {
            if (!handler.isAwareOf(clazz)) continue;
            return handler;
        }
        return null;
    }

    private TypeDiscriminator getTypeDiscriminator(Class<?> clazz) {
        for (TypeDiscriminator discriminator : this.typeDiscriminators) {
            if (!discriminator.isAwareOf(clazz)) continue;
            return discriminator;
        }
        return null;
    }

    Object marshal(Object value, Map<String, Object> data, String valueId) throws Exception {
        boolean isValid;
        block2: {
            block1: {
                isValid = true;
                if (!(value instanceof Validatable)) break block1;
                isValid = ValidationHelper.noValidationMessages((Validatable)value);
                break block2;
            }
            if (!(value instanceof Collection)) break block2;
            for (Object item : (Collection)value) {
                if (item instanceof Validatable && !(isValid = ValidationHelper.noValidationMessages((Validatable)item))) break;
            }
        }
        return this.marshal(value, data, isValid, false, valueId, new ArrayList<Object>());
    }

    Object marshal(Object value, Map<String, Object> data, boolean isRootValid, boolean skipTypeHandlers, String valueId) throws JSONException {
        return this.marshal(value, data, isRootValid, skipTypeHandlers, valueId, new ArrayList<Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object marshal(Object value, Map<String, Object> data, boolean isRootValid, boolean skipTypeHandlers, String valueId, List<Object> parents) throws JSONException {
        TypeHandler typeHandler;
        if (!skipTypeHandlers && (typeHandler = this.getTypeHandler(value.getClass())) != null) {
            return typeHandler.marshal(null, value, data, isRootValid, parents);
        }
        try {
            Object object;
            JSONArray json;
            EntityReference ref;
            Object result;
            parents.add(value);
            if (value instanceof Boolean || value instanceof Double || value instanceof Integer || value instanceof Long || value instanceof Byte || value instanceof String) {
                result = isRootValid ? value : null;
            } else if (value instanceof org.joda.time.LocalDate) {
                result = isRootValid ? ISODateTimeFormat.date().print((ReadablePartial)((org.joda.time.LocalDate)value)) : null;
            } else if (value instanceof LocalTime) {
                result = isRootValid ? ISODateTimeFormat.timeNoMillis().print((ReadablePartial)((LocalTime)value)) : null;
            } else if (value instanceof org.joda.time.LocalDateTime) {
                result = isRootValid ? ISODateTimeFormat.dateTimeNoMillis().print((ReadablePartial)((org.joda.time.LocalDateTime)value)) : null;
            } else if (value instanceof DateTime) {
                result = isRootValid ? ISODateTimeFormat.dateTime().print((ReadableInstant)((DateTime)value)) : null;
            } else if (value instanceof LocalDateTime) {
                result = isRootValid ? DTF.format((LocalDateTime)value) : null;
            } else if (value instanceof LocalDate) {
                result = isRootValid ? DF.format((LocalDate)value) : null;
            } else if (value instanceof java.time.LocalTime) {
                result = isRootValid ? TF.format((java.time.LocalTime)value) : null;
            } else if (value instanceof Date) {
                result = isRootValid ? DT.format(value) : null;
            } else if (value instanceof BigDecimal) {
                result = isRootValid ? ((BigDecimal)value).toPlainString() : null;
            } else if (value instanceof EntityReference) {
                if (!isRootValid) {
                    result = null;
                } else {
                    ref = (EntityReference)value;
                    JSONObject json2 = new JSONObject();
                    json2.put("uid", (Object)ref.getUid());
                    json2.put("type", (Object)ref.getType().getName());
                    if (ref.getCaption() != null) {
                        json2.put("caption", (Object)ref.getCaption());
                    }
                    result = json2;
                }
            } else if (value instanceof DictionaryReference) {
                if (!isRootValid) {
                    result = null;
                } else {
                    ref = (DictionaryReference)value;
                    JSONObject json3 = new JSONObject();
                    json3.put("code", (Object)ref.getCode());
                    json3.put("type", (Object)ref.getType().getName());
                    if (ref.getCaption() != null) {
                        json3.put("caption", (Object)ref.getCaption());
                    }
                    result = json3;
                }
            } else if (value instanceof Collection) {
                json = new JSONArray();
                for (Object item : (Collection)value) {
                    if (item == null) {
                        throw new NullPointerException(String.format("null object in rest collection={%1$s}", valueId));
                    }
                    Object marshalledItem = this.marshal(item, data, isRootValid, skipTypeHandlers, null, parents);
                    if (marshalledItem == null) continue;
                    json.put(marshalledItem);
                }
                result = json;
            } else if (value instanceof Map) {
                json = new JSONObject();
                for (Map.Entry item : ((Map)value).entrySet()) {
                    if (item == null) {
                        throw new NullPointerException(String.format("null object in rest map={%1$s}", valueId));
                    }
                    if (item.getKey() == null) {
                        throw new NullPointerException(String.format("null key in rest map={%1$s}", valueId));
                    }
                    Object val = item.getValue() == null ? "null" : this.marshal(item.getValue(), data, isRootValid, skipTypeHandlers, null, parents);
                    if (val == null) continue;
                    if (item.getKey() instanceof Enum) {
                        json.put(((Enum)item.getKey()).name(), val);
                        continue;
                    }
                    if (item.getKey() instanceof DictionaryReference) {
                        json.put(((DictionaryReference)item.getKey()).getCode(), val);
                        continue;
                    }
                    json.put(String.valueOf(item.getKey()), val);
                }
                result = json;
            } else if (value instanceof Introspectable) {
                boolean emptyArray;
                Object marshalledPropertyValue;
                boolean jsonEmpty;
                JSONObject validationJson;
                Object propertyValue;
                Validatable validatableValue;
                Collection validationMessages;
                boolean generateEmptyArray;
                Object marshalledPropertyValue2;
                Object propertyValue2;
                Object validationMessages2;
                String name;
                json = new JSONObject();
                boolean empty = true;
                IntrospectableEntityWrapper ew = IntrospectableEntityWrapper.create((String)value.getClass().getName());
                Map<String, Object> newData = JsonMarshaller.getNewData(data);
                newData.put(VALUE_OWNER_DATA_PARAMETER, value);
                for (IntrospectableEntityWrapper.IntrospectableEntityPropertyWrapper property : ew.properties) {
                    name = property.id;
                    newData.put(VALUE_OWNER_PROPERTY_NAME_DATA_PARAMETER, name);
                    boolean valueSet = false;
                    if (!isRootValid && ew.validatable && !(validationMessages2 = ((Validatable)value).getValidationContext().getValidationMessages(name)).isEmpty()) {
                        json.put(name, this.marshal(validationMessages2, newData, true, skipTypeHandlers, name, parents));
                        empty = false;
                        valueSet = true;
                    }
                    if (valueSet || (propertyValue2 = ((Introspectable)value).getValue(name)) == null || (marshalledPropertyValue2 = this.marshal(propertyValue2, newData, isRootValid, skipTypeHandlers, name, parents)) == null) continue;
                    json.put(name, marshalledPropertyValue2);
                    empty = false;
                }
                for (IntrospectableEntityWrapper.IntrospectableEntityCollectionWrapper collection : ew.collections) {
                    name = collection.id;
                    newData.put(VALUE_OWNER_PROPERTY_NAME_DATA_PARAMETER, name);
                    generateEmptyArray = false;
                    if (collection.nullable && Boolean.FALSE.equals(propertyValue2 = (Boolean)((Introspectable)value).getValue(RestMetaRegistryHelper.getNullableCollectionPropName((String)collection.id))) && isRootValid) {
                        generateEmptyArray = true;
                    }
                    if (!isRootValid && ew.validatable) {
                        if (collection.synthetic) continue;
                        validationMessages2 = ((Validatable)value).getValidationContext().getValidationMessagesForSimpleCollection(name);
                        if (!validationMessages2.isEmpty()) {
                            json.put(name, this.marshal(validationMessages2, newData, true, skipTypeHandlers, name, parents));
                            empty = false;
                        }
                        if (!(validationMessages = (validatableValue = (Validatable)value).getValidationContext().getValidationMessages(name)).isEmpty()) {
                            json.put(name, this.marshal(validationMessages, newData, true, skipTypeHandlers, name, parents));
                            empty = false;
                            continue;
                        }
                        if (!ValidationHelper.noValidationMessages(validatableValue)) {
                            propertyValue = (Collection)((Introspectable)value).getValue(name);
                            if (propertyValue == null || propertyValue.isEmpty()) continue;
                            validationJson = new JSONObject();
                            jsonEmpty = true;
                            int i = 0;
                            Iterator iterator = propertyValue.iterator();
                            while (iterator.hasNext()) {
                                Object item = iterator.next();
                                Object marshalledItem = this.marshal(item, newData, isRootValid, skipTypeHandlers, name, parents);
                                if (marshalledItem != null) {
                                    validationJson.put(Integer.toString(i), marshalledItem);
                                    jsonEmpty = false;
                                }
                                ++i;
                            }
                            if (jsonEmpty) continue;
                            json.put(name, (Object)validationJson);
                            empty = false;
                            continue;
                        }
                        propertyValue = (Collection)((Introspectable)value).getValue(name);
                        if ((propertyValue == null || propertyValue.isEmpty()) && !generateEmptyArray || (marshalledPropertyValue = this.marshal(propertyValue, newData, isRootValid, skipTypeHandlers, name, parents)) == null) continue;
                        emptyArray = false;
                        if (marshalledPropertyValue instanceof JSONArray) {
                            boolean bl = emptyArray = ((JSONArray)marshalledPropertyValue).length() == 0;
                        }
                        if (emptyArray && !generateEmptyArray) continue;
                        json.put(name, marshalledPropertyValue);
                        empty = false;
                        continue;
                    }
                    propertyValue2 = (Collection)((Introspectable)value).getValue(name);
                    if (propertyValue2 == null && !generateEmptyArray || (marshalledPropertyValue2 = this.marshal(propertyValue2, newData, isRootValid, skipTypeHandlers, name, parents)) == null) continue;
                    json.put(name, marshalledPropertyValue2);
                    empty = false;
                }
                for (IntrospectableEntityWrapper.IntrospectableEntityMapWrapper map : ew.maps) {
                    name = map.id;
                    generateEmptyArray = false;
                    if (map.nullable && Boolean.FALSE.equals(propertyValue2 = (Boolean)((Introspectable)value).getValue(RestMetaRegistryHelper.getNullableCollectionPropName((String)map.id))) && isRootValid) {
                        generateEmptyArray = true;
                    }
                    if (!isRootValid && ew.validatable) {
                        validationMessages2 = ((Validatable)value).getValidationContext().getValidationMessagesForSimpleCollection(name);
                        if (!validationMessages2.isEmpty()) {
                            json.put(name, this.marshal(validationMessages2, data, true, skipTypeHandlers, name, parents));
                            empty = false;
                        }
                        if (!(validationMessages = (validatableValue = (Validatable)value).getValidationContext().getValidationMessages(name)).isEmpty()) {
                            json.put(name, this.marshal(validationMessages, data, true, skipTypeHandlers, name, parents));
                            empty = false;
                            continue;
                        }
                        if (!ValidationHelper.noValidationMessages(validatableValue)) {
                            propertyValue = (Map)((Introspectable)value).getValue(name);
                            if (propertyValue == null || propertyValue.isEmpty()) continue;
                            validationJson = new JSONObject();
                            jsonEmpty = true;
                            for (Map.Entry entry : propertyValue.entrySet()) {
                                String marshalledKey;
                                Object key = entry.getKey();
                                String string = marshalledKey = key instanceof Enum ? ((Enum)key).name() : String.valueOf(key);
                                Object marshalledItem = this.marshal(entry.getValue(), data, isRootValid, skipTypeHandlers, name, parents);
                                if (marshalledItem == null) continue;
                                validationJson.put(marshalledKey, marshalledItem);
                                jsonEmpty = false;
                            }
                            if (jsonEmpty) continue;
                            validationJson.put(name, (Object)validationJson);
                            empty = false;
                            continue;
                        }
                        propertyValue = (Map)((Introspectable)value).getValue(name);
                        if ((propertyValue == null || propertyValue.isEmpty()) && !generateEmptyArray || (marshalledPropertyValue = this.marshal(propertyValue, data, isRootValid, skipTypeHandlers, name, parents)) == null) continue;
                        emptyArray = false;
                        if (marshalledPropertyValue instanceof JSONObject) {
                            boolean bl = emptyArray = ((JSONObject)marshalledPropertyValue).length() == 0;
                        }
                        if (emptyArray && !generateEmptyArray) continue;
                        json.put(name, marshalledPropertyValue);
                        empty = false;
                        continue;
                    }
                    propertyValue2 = (Map)((Introspectable)value).getValue(name);
                    if ((propertyValue2 == null || propertyValue2.isEmpty()) && !generateEmptyArray || (marshalledPropertyValue2 = this.marshal(propertyValue2, data, isRootValid, skipTypeHandlers, name, parents)) == null) continue;
                    json.put(name, marshalledPropertyValue2);
                    empty = false;
                }
                result = empty ? null : json;
            } else if (value instanceof Enum) {
                result = isRootValid ? ((Enum)value).name() : null;
            } else if (value instanceof InformationMessage) {
                InformationMessage im = (InformationMessage)value;
                JSONObject json4 = new JSONObject();
                json4.put("code", (Object)im.getCode());
                json4.put("text", (Object)im.getText());
                json4.put("severity", im.getSeverity() == null ? null : im.getSeverity().name());
                result = json4;
            } else if (value instanceof ValidationMessage) {
                ValidationMessage vm = (ValidationMessage)value;
                JSONObject json5 = new JSONObject();
                json5.put("code", (Object)vm.getCode());
                json5.put("text", (Object)vm.getText());
                result = json5;
            } else if (value instanceof byte[]) {
                result = isRootValid ? Base64.encode((byte[])((byte[])value)) : null;
            } else {
                if (value instanceof JSONObject) {
                    object = value;
                    return object;
                }
                throw new IllegalArgumentException("unsupported value type " + value.getClass().getName());
            }
            object = result;
            return object;
        }
        finally {
            parents.remove(value);
        }
    }

    <E> Collection<E> unmarshalCollection(JSONArray jsonArray, Class<E> elementType, Class<?> originalType, String method) throws UnmarshalException {
        ArrayList<String> path = new ArrayList<String>();
        try {
            return this.unmarshalCollection(jsonArray, elementType, originalType, method, path);
        }
        catch (Exception e) {
            throw new UnmarshalException(e, path);
        }
    }

    private <E> Collection<E> unmarshalCollection(JSONArray jsonArray, Class<E> elementType, Class<?> originalType, String method, List<String> path) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            path.add(Integer.toString(i));
            result.add(this.unmarshal(jsonArray.get(i), elementType, originalType, method, path));
            path.remove(path.size() - 1);
        }
        return result;
    }

    public Object unmarshal(Object object, Class<?> cls, Class<?> originalType, String method) throws UnmarshalException {
        ArrayList<String> path = new ArrayList<String>();
        try {
            return this.unmarshal(object, cls, originalType, method, path);
        }
        catch (Exception e) {
            throw new UnmarshalException(e, path);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object unmarshal(Object object, Class<?> cls, Class<?> originalType, String method, List<String> path) throws Exception {
        void var10_48;
        TypeDiscriminator typeDiscriminator = this.getTypeDiscriminator(cls);
        Class objectType = typeDiscriminator != null ? typeDiscriminator.determineEntityType(object, cls) : cls;
        TypeHandler typeHandler = this.getTypeHandler(objectType);
        Object src = "GET".equals(method) && typeHandler != null ? typeHandler.adjustGetParameter(object, objectType, originalType) : object;
        Object var10_10 = null;
        if (typeHandler != null) {
            if (!(src instanceof JSONArray)) return typeHandler.unmarshal(src, objectType, originalType);
            JSONArray srcArray = (JSONArray)src;
            ArrayList<Object> resultList = new ArrayList<Object>(srcArray.length());
            for (int i = 0; i < srcArray.length(); ++i) {
                resultList.add(typeHandler.unmarshal(srcArray.get(i), objectType, originalType));
            }
            return resultList;
        }
        if (Introspectable.class.isAssignableFrom(objectType)) {
            Introspectable introspectable = (Introspectable)objectType.newInstance();
            if (src != null && !src.equals(JSONObject.NULL)) {
                String name;
                JSONObject json = (JSONObject)src;
                IntrospectableEntityWrapper ew = IntrospectableEntityWrapper.create((String)objectType.getName());
                for (IntrospectableEntityWrapper.IntrospectableEntityPropertyWrapper property : ew.properties) {
                    name = property.id;
                    path.add(name);
                    Object jsonChild = json.opt(name);
                    if (jsonChild != null && !jsonChild.equals(JSONObject.NULL)) {
                        introspectable.setValue(name, this.unmarshal(jsonChild, JsonMarshaller.getClass(property.typeForIntrospection), property.originalType != null ? JsonMarshaller.getClass(property.originalType) : null, method, path));
                    }
                    path.remove(path.size() - 1);
                }
                for (IntrospectableEntityWrapper.IntrospectableEntityCollectionWrapper collection : ew.collections) {
                    JSONArray jsonArray;
                    if (collection.synthetic) continue;
                    name = collection.id;
                    path.add(name);
                    Object tmpJsonArray = json.opt(name);
                    if (!(tmpJsonArray instanceof JSONArray) && "GET".equals(method) && tmpJsonArray != null) {
                        jsonArray = new JSONArray();
                        jsonArray.put(tmpJsonArray);
                    } else {
                        jsonArray = (JSONArray)json.opt(name);
                    }
                    if (jsonArray != null) {
                        Collection resultCol = (Collection)introspectable.getValue(name);
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            path.add(Integer.toString(i));
                            resultCol.add(this.unmarshal(jsonArray.get(i), JsonMarshaller.getClass(collection.elementType), collection.originalType != null ? JsonMarshaller.getClass(collection.originalType) : null, method, path));
                            path.remove(path.size() - 1);
                        }
                    } else if (collection.nullable) {
                        introspectable.setValue(RestMetaRegistryHelper.getNullableCollectionPropName((String)collection.id), (Object)true);
                    }
                    path.remove(path.size() - 1);
                }
                for (IntrospectableEntityWrapper.IntrospectableEntityMapWrapper map : ew.maps) {
                    name = map.id;
                    path.add(name);
                    JSONObject jsonObject = (JSONObject)json.opt(name);
                    if (jsonObject != null) {
                        Map resultMap = (Map)introspectable.getValue(name);
                        Class keyEnumClass = map.isKeyEnum ? XHelper.getClass((String)map.keyType) : null;
                        HashSet jsonFields = new HashSet(jsonObject.keySet());
                        for (String itemKey : jsonFields) {
                            void var23_73;
                            path.add(itemKey);
                            if (map.isKeyEnum) {
                                String string = keyEnumClass != null ? Enum.valueOf(keyEnumClass, itemKey) : itemKey;
                            } else if (map.isKeyDict) {
                                Class<?> clazz = Class.forName(map.keyType);
                                BaseDictionary dict = DictionaryCache.get().findByCode(clazz, itemKey);
                                if (Objects.nonNull(dict)) {
                                    DictionaryReference dictionaryReference = dict.toReference();
                                } else {
                                    Class dictRefCls = XHelper.getClass((String)(map.keyOriginalType + "Reference"));
                                    Constructor constructor = dictRefCls.getConstructor(String.class, String.class);
                                    String caption = null;
                                    if (json.has("caption")) {
                                        caption = json.getString("caption");
                                    }
                                    Object t = constructor.newInstance(itemKey, caption);
                                }
                            } else {
                                String string = itemKey;
                            }
                            resultMap.put(var23_73, this.unmarshal(jsonObject.get(itemKey), JsonMarshaller.getClass(map.elementType), map.elementOriginalType != null ? JsonMarshaller.getClass(map.elementOriginalType) : null, method, path));
                            path.remove(path.size() - 1);
                        }
                    } else if (map.nullable) {
                        introspectable.setValue(RestMetaRegistryHelper.getNullableCollectionPropName((String)map.id), (Object)true);
                    }
                    path.remove(path.size() - 1);
                }
            }
            Introspectable introspectable2 = introspectable;
            return var10_48;
        } else if (Enum.class.isAssignableFrom(objectType)) {
            Object t = Enum.valueOf(objectType, (String)src);
            return var10_48;
        } else if (EntityReference.class.isAssignableFrom(objectType)) {
            JSONObject json = (JSONObject)src;
            EntityReference entityReference = new EntityReference(json.getString("uid"), XHelper.getClass((String)json.getString("type")), json.optString("caption"));
            return var10_48;
        } else if (DictionaryReference.class.isAssignableFrom(objectType)) {
            JSONObject json = (JSONObject)src;
            String code = json.getString("code");
            Class originalType2 = XHelper.getClass((String)json.getString("type"));
            BaseDictionary dict = DictionaryCache.get().findByCode(originalType2, code);
            if (null == dict) {
                throw Xeption.forDeveloper((String)("no dictionary found, code " + String.valueOf(code) + ", type " + originalType2), (Object[])new Object[0]);
            }
            Object object2 = dict.getClass().getMethod("toReference", new Class[0]).invoke((Object)dict, new Object[0]);
            return var10_48;
        } else if (BigDecimal.class.isAssignableFrom(objectType)) {
            if (src instanceof Integer) {
                BigDecimal bigDecimal = new BigDecimal((Integer)src);
                return var10_48;
            } else if (src instanceof BigDecimal) {
                Object object3 = src;
                return var10_48;
            } else if (src instanceof Number) {
                BigDecimal bigDecimal = BigDecimal.valueOf(((Number)src).doubleValue());
                return var10_48;
            } else {
                if (!(src instanceof String)) throw Xeption.forDeveloper((String)("Unable to parse BigInteger from type: " + src.getClass()), (Object[])new Object[0]);
                if (method.equals("GET")) {
                    String str = (String)src;
                    str = TextUtil.isBlank((String)str) ? null : str.trim().replaceAll(" ", "");
                    BigDecimal bigDecimal = TextUtil.isBlank((String)str) ? null : new BigDecimal(str);
                    return var10_48;
                } else {
                    BigDecimal bigDecimal = new BigDecimal((String)src);
                }
            }
            return var10_48;
        } else if (Date.class.isAssignableFrom(objectType)) {
            Object object4 = DT.parseObject((String)src);
            return var10_48;
        } else if (org.joda.time.LocalDate.class.isAssignableFrom(objectType)) {
            org.joda.time.LocalDate localDate = ISODateTimeFormat.dateParser().parseLocalDate((String)src);
            return var10_48;
        } else if (org.joda.time.LocalDateTime.class.isAssignableFrom(objectType)) {
            org.joda.time.LocalDateTime localDateTime = ISODateTimeFormat.dateTimeParser().parseLocalDateTime((String)src);
            return var10_48;
        } else if (LocalTime.class.isAssignableFrom(objectType)) {
            LocalTime localTime = ISODateTimeFormat.timeParser().parseLocalTime((String)src);
            return var10_48;
        } else if (DateTime.class.isAssignableFrom(objectType)) {
            DateTime dateTime = ISODateTimeFormat.dateTimeParser().parseDateTime((String)src);
            return var10_48;
        } else if (LocalDateTime.class.isAssignableFrom(objectType)) {
            String text = (String)src;
            if (text.endsWith("Z")) {
                LocalDateTime localDateTime = Instant.parse(text).atZone(ZoneId.systemDefault()).toLocalDateTime();
                return var10_48;
            } else {
                LocalDateTime localDateTime = LocalDateTime.parse(text, DateTimeFormatter.ISO_DATE_TIME);
            }
            return var10_48;
        } else if (LocalDate.class.isAssignableFrom(objectType)) {
            LocalDate localDate = LocalDate.parse((String)src);
            return var10_48;
        } else if (java.time.LocalTime.class.isAssignableFrom(objectType)) {
            java.time.LocalTime localTime = java.time.LocalTime.parse((String)src);
            return var10_48;
        } else if (String.class.isAssignableFrom(objectType) && src.getClass().isAssignableFrom(objectType)) {
            Object object5 = src;
            return var10_48;
        } else if (Boolean.class.isAssignableFrom(objectType)) {
            if (src instanceof String) {
                Boolean bl = Boolean.parseBoolean((String)src);
                return var10_48;
            } else {
                if (!(src instanceof Boolean)) throw Xeption.forDeveloper((String)("Unable to parse Boolean from type: " + src.getClass()), (Object[])new Object[0]);
                Object object6 = src;
            }
            return var10_48;
        } else if (Double.class.isAssignableFrom(objectType)) {
            if (null == src) {
                return var10_48;
            }
            if (src instanceof String) {
                Double d = Double.parseDouble((String)src);
                return var10_48;
            } else {
                if (!(src instanceof Number)) throw Xeption.forDeveloper((String)("Unable to parse Double from type: " + src.getClass()), (Object[])new Object[0]);
                Double d = ((Number)src).doubleValue();
            }
            return var10_48;
        } else if (Integer.class.isAssignableFrom(objectType)) {
            if (null == src) {
                return var10_48;
            }
            if (src instanceof String) {
                Integer n = Integer.parseInt((String)src);
                return var10_48;
            } else {
                if (!(src instanceof Number)) throw Xeption.forDeveloper((String)("Unable to parse Integer from type: " + src.getClass()), (Object[])new Object[0]);
                Integer n = ((Number)src).intValue();
            }
            return var10_48;
        } else if (Byte.class.isAssignableFrom(objectType)) {
            if (null == src) {
                return var10_48;
            }
            if (src instanceof String) {
                Byte by = Byte.parseByte((String)src);
                return var10_48;
            } else {
                if (!(src instanceof Number)) throw Xeption.forDeveloper((String)("Unable to parse Byte from type: " + src.getClass()), (Object[])new Object[0]);
                Byte by = ((Number)src).byteValue();
            }
            return var10_48;
        } else if (BigInteger.class.isAssignableFrom(objectType)) {
            if (src instanceof BigInteger) {
                Object object7 = src;
                return var10_48;
            } else if (src instanceof Number) {
                BigInteger bigInteger = BigInteger.valueOf(((Number)src).longValue());
                return var10_48;
            } else {
                if (!(src instanceof String)) throw Xeption.forDeveloper((String)("Unable to parse BigInteger from type: " + src.getClass()), (Object[])new Object[0]);
                BigInteger bigInteger = new BigInteger((String)src);
            }
            return var10_48;
        } else if (byte[].class.isAssignableFrom(objectType)) {
            byte[] byArray = Base64.decode((String)((String)src));
            return var10_48;
        } else {
            if (InformationMessage.class.isAssignableFrom(objectType)) {
                return var10_48;
            }
            if (!JSONObject.class.isAssignableFrom(objectType)) throw Xeption.forDeveloper((String)("Unsupported conversion. Unable to parse " + objectType.getName() + " from json object " + src.toString() + " of type " + src.getClass()), (Object[])new Object[0]);
            Object object8 = src;
        }
        return var10_48;
    }

    public static JSONObject createJSONObject(Map<String, String[]> parameterMap) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, String[]> param : parameterMap.entrySet()) {
            String[] paramValues = param.getValue();
            if (paramValues.length == 0) {
                json.put(param.getKey(), JSONObject.NULL);
                continue;
            }
            if (paramValues.length == 1) {
                String paramValue;
                json.put(param.getKey(), (paramValue = paramValues[0]) != null && !"".equals(paramValue) ? paramValue : JSONObject.NULL);
                continue;
            }
            JSONArray values = new JSONArray();
            for (String value : paramValues) {
                values.put(!"".equals(value) ? value : JSONObject.NULL);
            }
            json.put(param.getKey(), (Object)values);
        }
        return json;
    }

    private static Class<?> getClass(String name) throws ClassNotFoundException {
        String className = name;
        if (name.indexOf(46) == -1) {
            if (name.charAt(0) >= 'A' && name.charAt(0) <= 'Z') {
                className = "java.lang." + name;
            } else {
                Class<?> clazz = primitives.get(name);
                if (null != clazz) {
                    return clazz;
                }
            }
        } else if (name.startsWith(EntityReference.class.getName())) {
            className = EntityReference.class.getName();
        }
        return Class.forName(className);
    }

    private static Map<String, Object> getNewData(Map<String, Object> currentData) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (currentData != null) {
            result.putAll(currentData);
        }
        return result;
    }

    public String marshal(Object value) throws JSONException {
        return ObjectUtils.toString((Object)this.marshal(value, Collections.emptyMap(), true, false, "", new ArrayList<Object>()));
    }

    public <T> T unmarshal(String text, Class<T> cls) throws Exception {
        return (T)this.unmarshal(new JSONObject(text), cls, null, "POST");
    }

    static {
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("byte[]", byte[].class);
    }
}

