/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.XeptionHelper;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.threadactivity.ThreadActivityLog;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.http.HttpUtils;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.locale.WebLocaleHelper;
import com.gridnine.xtrip.server.web.rest.RestServiceProvider;
import com.gridnine.xtrip.server.web.rest.ServletHelper;
import com.gridnine.xtrip.server.web.rest.UnmarshalException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MultipartConfig(fileSizeThreshold=0x20000000)
public class RestServlet
extends HttpServlet {
    private static final long serialVersionUID = -2621757769732458810L;
    private static final Collection<String> ACCESS_CONTROL_ALLOW_HEADERS = Arrays.asList("AuthorizationKey", "Authorization", "Content-Type", "Accept", "Origin", "User-Agent", "Cache-Control", "Keep-Alive", "X-Requested-With", "If-Modified-Since", "X-Application-Locale");
    private static final String COOKIE_PARAMETER_OPERATION_ID = "X-ClientOperationId";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RestServiceProvider serviceProvider;

    public RestServlet(RestServiceProvider rsp) throws Exception {
        this.serviceProvider = rsp;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.handle("GET", req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.handle("POST", req, res);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.handle("PUT", req, res);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.handle("DELETE", req, res);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.handle("HEAD", req, res);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) {
        TreeSet<String> supportedMethods;
        String path = req.getPathInfo();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((supportedMethods = new TreeSet<String>(this.serviceProvider.getServletOperationsByPath(path).stream().map(opKey -> this.serviceProvider.getServiceOperation((RestServiceProvider.OperationKey)opKey, RestServiceProvider.OperationType.SERVLET)).filter(Objects::nonNull).filter(RestServiceProvider.Operation::isCorsSupported).map(RestServiceProvider.Operation::getMethod).collect(Collectors.toSet()))).isEmpty()) {
            res.setStatus(404);
            return;
        }
        supportedMethods.add("OPTIONS");
        ServletHelper.customizeHeaders(req, res);
        res.setHeader("Access-Control-Allow-Methods", TextUtil.join((String)",", supportedMethods));
        res.setHeader("Access-Control-Allow-Headers", TextUtil.join((String)",", ACCESS_CONTROL_ALLOW_HEADERS));
        res.setHeader("Access-Control-Max-Age", "60");
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.sendError(405);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(String method, HttpServletRequest req, HttpServletResponse res) throws IOException {
        long startTiming = System.currentTimeMillis();
        WebLocaleHelper.of().setupRequestLocaleContext(req, res);
        JSONObject responseJSON = null;
        Object binaryResponse = null;
        RestContext restContext = new RestContext(req, res);
        HashMap<String, Object> data = new HashMap<String, Object>();
        RestServiceProvider.OperationKey operationKey = null;
        try {
            String path;
            if (req.getCharacterEncoding() == null) {
                req.setCharacterEncoding("UTF-8");
            }
            if (Objects.isNull(path = req.getPathInfo())) {
                restContext.setStatus(404);
                throw Xeption.forEndUser((String)"REST_SERVLET_NOT_FOUND_HTTP_RESOURCE", (Object[])new Object[0]);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            operationKey = new RestServiceProvider.OperationKey(path, method);
            ThreadActivityLog.beginRequest((String)"rest", (String)(operationKey.getMethod().toUpperCase() + " " + operationKey.getPath()));
            RestServiceProvider.Operation operation = this.serviceProvider.getServiceOperation(operationKey, RestServiceProvider.OperationType.SERVLET);
            if (operation == null) {
                String forward = this.serviceProvider.getService().getForward();
                if (!TextUtil.isBlank((String)forward)) {
                    String url;
                    RequestDispatcher dispatcher;
                    if (!forward.startsWith("/")) {
                        forward = "/" + forward;
                    }
                    if (forward.endsWith("/")) {
                        forward = forward.substring(0, path.length() - 1);
                    }
                    if ((dispatcher = req.getRequestDispatcher(url = forward + path)) != null) {
                        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
                        return;
                    }
                }
                restContext.setStatus(404);
                throw Xeption.forEndUser((String)"REST_SERVLET_NOT_FOUND_HTTP_RESOURCE_BY_METHOD_AND_PATH", (Object[])new Object[]{method, path});
            }
            RestServiceProvider.InvocationResult invocationResult = this.serviceProvider.invokeService(operation, data, restContext);
            if (!invocationResult.hasValidation() && invocationResult.getResult() != null && (BinaryData.class.isInstance(invocationResult.getResult()) || DownloadableData.class.isInstance(invocationResult.getResult()))) {
                binaryResponse = invocationResult.getResult();
            } else {
                responseJSON = this.serviceProvider.generateResponseJSON(invocationResult);
            }
        }
        catch (Throwable t) {
            this.modifyStackTrace(t, this.serviceProvider, operationKey, restContext);
            RestServiceProvider.OperationKey operationKeyFinal = operationKey;
            Consumer<BiConsumer> loggingLogic = logger -> {
                if (t instanceof UnmarshalException && operationKeyFinal != null) {
                    logger.accept(String.format("error while process rest request. Operation: %s %s; Error in path: [%s]", operationKeyFinal.getMethod().toUpperCase(), operationKeyFinal.getPath(), String.join((CharSequence)".", ((UnmarshalException)t).getPath())), t);
                } else {
                    String message = operationKeyFinal != null ? String.format("error while process rest request. Operation: %s %s", operationKeyFinal.getMethod().toUpperCase(), operationKeyFinal.getPath()) : "error while process rest request. Operation key is null";
                    logger.accept(message, t);
                }
            };
            loggingLogic.accept((arg_0, arg_1) -> ((Logger)this.log).error(arg_0, arg_1));
            if (!this.handleUnfixableExceptions(t)) {
                loggingLogic.accept(IncidentsLog::reportException);
            }
            responseJSON = this.serviceProvider.handleInvocationError(data, restContext, t);
        }
        finally {
            if (operationKey != null) {
                ThreadActivityLog.endRequest((String)"rest", (String)(operationKey.getMethod().toUpperCase() + " " + operationKey.getPath()));
            }
        }
        long elapsed = System.currentTimeMillis() - startTiming;
        res.setStatus(restContext.getStatus());
        res.setHeader("Cache-Control", "no-store");
        res.setHeader("Pragma", "no-cache");
        res.setHeader("X-ServerExecutionTime", Long.toString(elapsed));
        String timeThresholdString = System.getProperty("debug.longRequestThreshold");
        if (timeThresholdString != null) {
            long timeThreshold = Long.parseLong(timeThresholdString);
            try {
                if (elapsed > timeThreshold) {
                    throw new Exception("long request");
                }
            }
            catch (Exception e) {
                this.modifyStackTrace(e, this.serviceProvider, operationKey, restContext);
                IncidentsLog.reportException((String)String.format("rest long request (%d ms)", elapsed), (Throwable)e);
            }
        }
        if (responseJSON != null) {
            if (responseJSON.length() != 0) {
                res.setContentType("application/json");
                res.setCharacterEncoding("UTF-8");
                responseJSON.write((Writer)res.getWriter());
            }
        } else if (binaryResponse != null) {
            byte[] bytes;
            if (binaryResponse instanceof BinaryData) {
                BinaryData binaryData = (BinaryData)binaryResponse;
                String contentType = HttpHelper.getMimeType((ContentType)binaryData.getContentType());
                if (contentType != null) {
                    res.setContentType(contentType);
                }
                bytes = binaryData.getData();
            } else if (binaryResponse instanceof DownloadableData) {
                BinaryData binaryData;
                DownloadableData downloadableData = (DownloadableData)binaryResponse;
                String contentType = null;
                boolean inline = downloadableData.isInline();
                if (inline) {
                    if (downloadableData.getContent() != null) {
                        contentType = HttpHelper.getMimeType((ContentType)downloadableData.getContent().getContentType());
                    }
                } else {
                    contentType = "application/force-download";
                }
                res.setContentType(contentType);
                String fileName = downloadableData.getFileName();
                if (!inline && fileName != null) {
                    String encoded = URLEncoder.encode(fileName, "UTF-8").replace("+", "%20");
                    if (encoded.equals(fileName)) {
                        res.addHeader("Content-Disposition", "attachment; filename=" + fileName);
                    } else {
                        res.addHeader("Content-Disposition", "attachment; filename*=utf-8''" + encoded + "; filename=" + encoded);
                    }
                }
                bytes = (binaryData = downloadableData.getContent()) != null ? binaryData.getData() : null;
            } else {
                throw Xeption.forDeveloper((String)("invalid binary type " + binaryResponse.getClass().getName()), (Object[])new Object[0]);
            }
            if (bytes != null) {
                res.getOutputStream().write(bytes);
            }
        }
    }

    private void modifyStackTrace(Throwable throwable, RestServiceProvider restServiceProvider, RestServiceProvider.OperationKey operationKey, RestContext restContext) {
        Xeption xe;
        ArrayList<StackTraceElement> newStackTraceElements = new ArrayList<StackTraceElement>();
        Optional.ofNullable(restServiceProvider).map(RestServiceProvider::getService).ifPresent(restService -> newStackTraceElements.add(IncidentsHelper.getContextStackTraceElement((String)"RestService", (String)("serviceId=" + restService.getId()))));
        if (Objects.nonNull(operationKey)) {
            newStackTraceElements.add(IncidentsHelper.getContextStackTraceElement((String)"RestOperationKey", (String)(operationKey.getMethod() + " " + operationKey.getPath())));
        }
        Optional.ofNullable(operationKey).map(RestServiceProvider.OperationKey::getMethod).filter(method -> method.equalsIgnoreCase("GET")).ifPresent(method -> newStackTraceElements.add(IncidentsHelper.getContextStackTraceElement((String)"RestGetBody", (String)ServletHelper.parameterMap(restContext.getRequest()))));
        HttpServletRequest request = restContext.getRequest();
        Stream.of("X-Reference", "X-Reference-History", "User-Agent").map(headerName -> {
            String header = request.getHeader(headerName);
            if (TextUtil.isBlank((String)header)) {
                return null;
            }
            return IncidentsHelper.getContextStackTraceElement((String)"RestHeader", (String)(headerName + "=" + header));
        }).filter(Objects::nonNull).forEach(newStackTraceElements::add);
        newStackTraceElements.add(IncidentsHelper.getContextStackTraceElement((String)"Node", (String)Environment.getApplicationId()));
        newStackTraceElements.add(IncidentsHelper.getContextStackTraceElement((String)"Date", (String)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(new Date())));
        Optional.ofNullable(HttpUtils.find(request, COOKIE_PARAMETER_OPERATION_ID)).map(Cookie::getValue).filter(TextUtil::nonBlank).map(cookieValue -> IncidentsHelper.getContextStackTraceElement((String)COOKIE_PARAMETER_OPERATION_ID, (String)cookieValue)).ifPresent(newStackTraceElements::add);
        JSONObject requestJson = restContext.getRequestJsonObject();
        if (requestJson != null && ((xe = XeptionHelper.findXeption((Throwable)throwable)) == null || xe.getEndUserMessage() == null && xe.getAdminMessage() == null)) {
            newStackTraceElements.add(IncidentsHelper.getContextStackTraceElement((String)"RequestJsonString", (String)requestJson.toString()));
        }
        IncidentsHelper.addStackTraceElement((Throwable)throwable, (StackTraceElement[])newStackTraceElements.toArray(new StackTraceElement[0]));
    }

    private boolean handleUnfixableExceptions(Throwable t) {
        if (t instanceof JSONException && t.getCause() != null && t.getCause() instanceof SocketTimeoutException) {
            this.log.warn("socket timeout", t);
            return true;
        }
        if (t instanceof EOFException) {
            this.log.warn("eof", t);
            return true;
        }
        return false;
    }
}

