/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest;

import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ServletHelper {
    public static String parameterMap(HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        return request.getParameterMap().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), Arrays.toString((Object[])entry.getValue()))).collect(Collectors.joining(","));
    }

    public static Map<String, String[]> getDecodedParameterMap(HttpServletRequest request) {
        if (request.getParameterMap() == null) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        request.getParameterMap().forEach((k, values) -> {
            String[] cfr_ignored_0 = result.put((String)k, values == null ? null : (String[])Stream.of(values).map(ExceptionUtil.wrapFunction(v -> v == null ? null : URLDecoder.decode(v, "UTF-8"))).toArray(String[]::new));
        });
        return result;
    }

    public static void customizeHeaders(HttpServletRequest request, HttpServletResponse response) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(response);
        String origin = request.getHeader("Origin");
        origin = TextUtil.nonBlank((String)origin) ? origin.split("\\r|\\n|\\r\\n")[0] : "*";
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials", "true");
    }
}

