/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.ibus.rest.RestContextAsync;
import com.gridnine.xtrip.server.web.locale.WebLocaleHelper;
import com.gridnine.xtrip.server.web.rest.HandshakeRequestAdapter;
import com.gridnine.xtrip.server.web.rest.RestServiceProvider;
import com.gridnine.xtrip.server.web.rest.UnmarshalException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketEndpoint
extends Endpoint {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketEndpoint.class);
    private static final String KEY_REST_CONTEXT = WebSocketEndpoint.class.getName() + ":KEY_REST_CONTEXT";
    private static final String KEY_WRITE_LOCK = WebSocketEndpoint.class.getName() + ":KEY_WRITE_LOCK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session session, EndpointConfig config) {
        Map userProperties = session.getUserProperties();
        HandshakeRequestAdapter req = (HandshakeRequestAdapter)userProperties.get("KEY_HTTP_REQUEST");
        HttpServletResponse res = (HttpServletResponse)session.getUserProperties().get("KEY_HTTP_RESPONSE");
        RestServiceProvider serviceProvider = (RestServiceProvider)session.getUserProperties().get("KEY_SERVICE_PROVIDER");
        session.getUserProperties().put(KEY_WRITE_LOCK, new Object());
        HashMap<String, Object> data = new HashMap<String, Object>();
        RestContextAsync restContext = new RestContextAsync(req, res, (ctx, response) -> {
            try {
                this.writeData(session, serviceProvider.generateResponseJSON((RestServiceProvider.InvocationResult)response), (RestContext)ctx);
            }
            catch (Exception e) {
                try {
                    JSONObject responseJSON = serviceProvider.handleInvocationError((Map<String, Object>)data, (RestContext)ctx, e);
                    this.writeData(session, responseJSON, (RestContext)ctx);
                    ctx.close();
                }
                finally {
                    this.closeSession(session);
                }
            }
        }, (ctx, e) -> {
            try {
                JSONObject responseJSON = serviceProvider.handleInvocationError((Map<String, Object>)data, (RestContext)ctx, (Throwable)e);
                this.writeData(session, responseJSON, (RestContext)ctx);
            }
            finally {
                this.closeSession(session);
            }
        }, ctx -> this.closeSession(session));
        session.getUserProperties().put(KEY_REST_CONTEXT, restContext);
        RestServiceProvider.OperationKey operationKey = null;
        try {
            RestServiceProvider.Operation operation;
            String path = req.getParameter("REQUEST_PARAM_PATH");
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (TextUtil.nonBlank((String)(operation = Objects.requireNonNull(serviceProvider.getServiceOperation(operationKey = new RestServiceProvider.OperationKey(path, "GET"), RestServiceProvider.OperationType.WEBSOCKET))).getOpenRouteId())) {
                serviceProvider.invokeService(new RestServiceProvider.Operation(operation), data, restContext);
            }
            Pipe dataPipe = Pipe.open();
            req.setInputStream(Channels.newInputStream(dataPipe.source()));
            MessageCallback messageCallback = () -> {
                if (restContext.isClosed()) {
                    return;
                }
                try {
                    req.readHeadersFromInputStream();
                    if (TextUtil.nonBlank((String)operation.getRouteId())) {
                        WebLocaleHelper.of().setupRequestLocaleContext(req, res);
                        RestServiceProvider.InvocationResult invocationResult = serviceProvider.invokeService(operation, data, restContext);
                        JSONObject responseJSON = serviceProvider.generateResponseJSON(invocationResult);
                        if (responseJSON != null) {
                            this.writeData(session, responseJSON, restContext);
                        }
                    }
                }
                catch (Exception e) {
                    JSONObject responseJSON = serviceProvider.handleInvocationError(data, restContext, e);
                    this.writeData(session, responseJSON, restContext);
                }
                finally {
                    if (!restContext.isStayOpen()) {
                        restContext.close();
                        this.closeSession(session);
                    }
                }
            };
            session.addMessageHandler(ByteBuffer.class, (MessageHandler.Partial)new MessageHandlerBinary(dataPipe, messageCallback));
            session.addMessageHandler(String.class, (MessageHandler.Partial)new MessageHandlerText(dataPipe, messageCallback));
        }
        catch (Throwable t) {
            try {
                if (t instanceof UnmarshalException && operationKey != null) {
                    LOG.error(String.format("error while process websocket request. Operation: %s %s; Error in path: [%s]", operationKey.getMethod().toUpperCase(), operationKey.getPath(), String.join((CharSequence)".", ((UnmarshalException)t).getPath())), t);
                } else {
                    LOG.error("error while process websocket request", t);
                }
                JSONObject responseJSON = serviceProvider.handleInvocationError(data, restContext, t);
                this.writeData(session, responseJSON, restContext);
                restContext.close();
            }
            finally {
                this.closeSession(session);
            }
        }
    }

    public void onClose(Session session, CloseReason reason) {
        WebSocketEndpoint.closeAsyncContext(session);
    }

    public void onError(Session session, Throwable t) {
        LOG.error("Websocket error", t);
        WebSocketEndpoint.closeAsyncContext(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(Session session, JSONObject data, RestContext context) {
        JSONObject response = new JSONObject();
        response.put("status", context.getStatus());
        response.put("response", (Object)data);
        HandshakeRequestAdapter req = (HandshakeRequestAdapter)session.getUserProperties().get("KEY_HTTP_REQUEST");
        boolean manualDeflate = Boolean.parseBoolean(req.getHeader("manualDeflate"));
        Object v = session.getUserProperties().get(KEY_WRITE_LOCK);
        synchronized (v) {
            if (!manualDeflate) {
                try (Writer out = session.getBasicRemote().getSendWriter();){
                    response.write(out);
                }
                catch (IOException e) {
                    LOG.error("Error writing to websocket", (Throwable)e);
                }
            } else {
                try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new DeflaterOutputStream(session.getBasicRemote().getSendStream()), StandardCharsets.UTF_8);){
                    response.write((Writer)out);
                }
                catch (IOException e) {
                    LOG.error("Error writing to websocket", (Throwable)e);
                }
            }
        }
    }

    private static void closeAsyncContext(Session session) {
        ((RestContextAsync)session.getUserProperties().get(KEY_REST_CONTEXT)).close();
    }

    private void closeSession(Session session) {
        try {
            session.close();
        }
        catch (IOException e) {
            LOG.error("Error closing websocket session", (Throwable)e);
        }
    }

    private static class MessageHandlerText
    extends MessageHandlerBase
    implements MessageHandler.Partial<String> {
        MessageHandlerText(Pipe dataPipe, MessageCallback messageReceivedHandler) throws Exception {
            super(dataPipe, messageReceivedHandler);
        }

        public void onMessage(String messagePart, boolean last) {
            super.onMessage(() -> ByteBuffer.wrap(messagePart.getBytes(StandardCharsets.UTF_8)), last);
        }
    }

    private static class MessageHandlerBinary
    extends MessageHandlerBase
    implements MessageHandler.Partial<ByteBuffer> {
        MessageHandlerBinary(Pipe dataPipe, MessageCallback messageReceivedHandler) throws Exception {
            super(dataPipe, messageReceivedHandler);
        }

        public void onMessage(ByteBuffer messagePart, boolean last) {
            super.onMessage(() -> messagePart, last);
        }
    }

    private static abstract class MessageHandlerBase {
        private final Pipe dataPipe;
        private final MessageCallback messageReceivedHandler;
        private boolean completed = false;

        MessageHandlerBase(Pipe dataPipe, MessageCallback messageReceivedHandler) throws Exception {
            this.dataPipe = dataPipe;
            this.messageReceivedHandler = messageReceivedHandler;
            if (this.dataPipe == null) {
                this.completed = true;
                this.messageReceivedHandler.call();
            }
        }

        public void onMessage(Supplier<ByteBuffer> messageSupplier, boolean last) {
            if (this.completed) {
                throw new IllegalStateException("More than one incoming message not supported");
            }
            try {
                this.dataPipe.sink().write(messageSupplier.get());
                if (last) {
                    this.dataPipe.sink().close();
                    this.messageReceivedHandler.call();
                    this.completed = true;
                }
            }
            catch (Exception e) {
                try {
                    this.dataPipe.sink().close();
                }
                catch (IOException e1) {
                    throw new IllegalStateException("Error closing data pipe after error", e1);
                }
                throw new RuntimeException("Error writing websocket request", e);
            }
        }
    }

    @FunctionalInterface
    private static interface MessageCallback {
        public void call() throws Exception;
    }
}

