/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.getInfo;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.rest.TypeHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.web.rest.JsonHelper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonTypeHandler
implements TypeHandler {
    private final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public boolean isAwareOf(Class<?> type) {
        return Enum.class.isAssignableFrom(type) || LocalDate.class.isAssignableFrom(type) || String.class.isAssignableFrom(type);
    }

    public Object unmarshal(Object object, Class<?> type, Class<?> originalType) throws Exception {
        if (Objects.isNull(object) || object.equals(JSONObject.NULL)) {
            return null;
        }
        if (Enum.class.isAssignableFrom(type)) {
            String uid = null;
            if (object instanceof JSONObject) {
                if (object != null) {
                    uid = ((JSONObject)object).getString("uid");
                }
            } else {
                uid = (String)object;
            }
            if (Enum.class.isAssignableFrom(type)) {
                if (!TextUtil.isBlank((String)uid)) {
                    try {
                        return Enum.valueOf(type, uid);
                    }
                    catch (IllegalArgumentException e) {
                        throw Xeption.forDeveloper((String)String.format("Invalid value of type %s", type.getSimpleName()), (Object[])new Object[0]);
                    }
                }
                return null;
            }
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            try {
                return LocalDate.parse((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalDate [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        if (String.class.isAssignableFrom(type)) {
            try {
                return object.toString();
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalTime [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        throw Xeption.forDeveloper((String)String.format("Invalid type [%s]", type.getSimpleName()), (Object[])new Object[0]);
    }

    public Object marshal(Object result, Object value, Map<String, Object> data, boolean isValid, List<Object> parents) throws JSONException {
        if (!isValid || Objects.isNull(value)) {
            return null;
        }
        try {
            parents.add(value);
            if (Enum.class.isInstance(value)) {
                String string = ((Enum)value).name();
                return string;
            }
            if (LocalDate.class.isInstance(value)) {
                String string = ((LocalDate)value).toString();
                return string;
            }
            if (String.class.isInstance(value)) {
                String string = value.toString();
                return string;
            }
            throw Xeption.forDeveloper((String)String.format("Invalid value [%s]", String.valueOf(value)), (Object[])new Object[0]);
        }
        finally {
            parents.remove(value);
        }
    }

    public void validate(Object o, Class<?> cls) {
        JSONObject json = (JSONObject)o;
        if (Enum.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson(json, cls, (String)o);
        }
        if (DictionaryReference.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson(json, cls, (String)o);
        }
        if (EntityReference.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson(json, cls, (String)o);
        }
        throw Xeption.forDeveloper((String)"Invalid value [%s]", (Object[])new Object[]{String.valueOf(cls)});
    }
}

