/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.intercept;

import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.rest.BaseRestEntity;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptorAdapter;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestActualizationInterceptor
extends GenericRestInterceptorAdapter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void after(RestContext context, Map<String, Object> data) throws Exception {
        Object entity = data.get(IBusRestContextKeys.REST_RESULT.name());
        if (Objects.isNull(entity)) {
            return;
        }
        if (BaseRestEntity.class.isInstance(entity)) {
            this.actualize(entity);
            return;
        }
        if (BaseEntity.class.isInstance(entity)) {
            this.actualize(entity);
            return;
        }
        if (Collection.class.isInstance(entity)) {
            Collection collection = (Collection)entity;
            collection.forEach(this::actualize);
            return;
        }
        String errorMessage = "Object type " + entity.getClass().getName() + " is unsupported for actualization.";
        String restDebugProperty = System.getProperty("debug.rest");
        if (Boolean.parseBoolean(restDebugProperty)) {
            throw Xeption.forDeveloper((String)errorMessage, (Object[])new Object[0]);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(errorMessage);
        }
    }

    private void actualize(Object entity) {
        EntityType entityType;
        Object memberValue;
        Object memberValue2;
        String className = entity.getClass().getName();
        RestEntityType restEntityType = RestMetaRegistryHelper.getEntityType((String)className);
        if (restEntityType != null) {
            Object collection2;
            BaseRestEntity bre = (BaseRestEntity)entity;
            Collection properties = RestMetaRegistryHelper.getAllProperties((RestEntityType)restEntityType).values();
            for (Object property : properties) {
                Object memberValue3 = bre.getValue(property.getId());
                if (memberValue3 == null) continue;
                this.actualizeInternal(memberValue3);
            }
            Collection collections = RestMetaRegistryHelper.getAllCollections((RestEntityType)restEntityType).values();
            for (Object collection2 : collections) {
                memberValue2 = (Collection)bre.getValue(collection2.getId());
                if (memberValue2 == null) continue;
                memberValue2.forEach(this::actualizeInternal);
            }
            Collection maps = RestMetaRegistryHelper.getAllMaps((RestEntityType)restEntityType).values();
            collection2 = maps.iterator();
            while (collection2.hasNext()) {
                RestMap map = (RestMap)collection2.next();
                memberValue = (Map)bre.getValue(map.getId());
                if (memberValue == null) continue;
                memberValue.keySet().forEach(this::actualizeInternal);
                memberValue.values().forEach(this::actualizeInternal);
            }
        }
        if ((entityType = MetaRegistryHelper.getEntityType((String)className)) != null) {
            BaseEntity be = (BaseEntity)entity;
            Collection properties = MetaRegistryHelper.getAllProperties((EntityType)entityType).values();
            for (Property property : properties) {
                memberValue2 = be.getValue(property.getId());
                if (memberValue2 == null) continue;
                this.actualizeInternal(memberValue2);
            }
            Collection collections = MetaRegistryHelper.getAllCollections((BaseClassType)entityType).values();
            for (EntityCollection collection : collections) {
                memberValue = (Collection)be.getValue(collection.getId());
                if (memberValue == null) continue;
                memberValue.forEach(this::actualizeInternal);
            }
        }
    }

    private void actualizeInternal(Object entity) {
        if (entity == null) {
            return;
        }
        if (BaseRestEntity.class.isAssignableFrom(entity.getClass())) {
            this.actualize(entity);
        } else if (BaseEntity.class.isAssignableFrom(entity.getClass())) {
            this.actualize(entity);
        } else {
            if (NestedEntityReference.class.isAssignableFrom(entity.getClass())) {
                return;
            }
            if (EntityReference.class.isAssignableFrom(entity.getClass())) {
                EntityReference reference = (EntityReference)entity;
                if (reference.getType() == null || TextUtil.isBlank((String)reference.getUid())) {
                    return;
                }
                EntityType et = MetaRegistryHelper.getEntityType((String)reference.getType().getName());
                if (et != null && MetaRegistryHelper.isCachedEntity((EntityType)et)) {
                    EntityStorage.get().actualize(reference, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
                }
            }
        }
    }
}

