/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CompressingFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String acceptEncoding = ((HttpServletRequest)request).getHeader("Accept-Encoding");
        if (null == acceptEncoding || acceptEncoding.indexOf("gzip") == -1) {
            chain.doFilter(request, response);
            return;
        }
        try (GZipServletResponse gzipResponce = new GZipServletResponse((HttpServletResponse)response);){
            chain.doFilter(request, (ServletResponse)gzipResponce);
        }
    }

    public void destroy() {
    }

    private static class GZipServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream out;
        private final GZIPOutputStream gzout;

        public GZipServletOutputStream(ServletOutputStream out) throws IOException {
            this.out = out;
            this.gzout = new GZIPOutputStream((OutputStream)out);
        }

        public void write(byte[] b) throws IOException {
            this.gzout.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.gzout.write(b, off, len);
        }

        public void flush() throws IOException {
            this.gzout.flush();
        }

        public void close() throws IOException {
            this.gzout.close();
        }

        public void write(int b) throws IOException {
            this.gzout.write(b);
        }

        public boolean isReady() {
            return this.out.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.out.setWriteListener(writeListener);
        }
    }

    private static class GZipServletResponse
    extends HttpServletResponseWrapper {
        private final GZipServletOutputStream out;
        private PrintWriter writer;

        public GZipServletResponse(HttpServletResponse response) throws IOException {
            super(response);
            this.out = new GZipServletOutputStream(response.getOutputStream());
            response.addHeader("Content-Encoding", "gzip");
        }

        public void close() throws IOException {
            this.out.close();
        }

        public ServletOutputStream getOutputStream() {
            return this.out;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer != null) {
                return this.writer;
            }
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.out), this.getResponse().getCharacterEncoding()));
            return this.writer;
        }

        public void flushBuffer() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
            this.out.flush();
            super.flushBuffer();
        }

        public void setContentLength(int len) {
        }
    }
}

