/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rpc;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rpc.logging.ServiceInvocationLoggingHelper;
import com.gridnine.xtrip.common.threadactivity.ThreadActivityLog;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.java.plugin.registry.Extension;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.invocation.RemoteInvocation;
import org.jboss.remoting.transport.servlet.ServletServerInvoker;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;
import org.jboss.remoting.transport.servlet.web.ServerInvokerServlet;
import org.jboss.remoting.transporter.TransporterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCServlet
extends ServerInvokerServlet {
    private static final String INVOKER_PARAM_PREFIX = "invoker.";
    private static final long serialVersionUID = -7737236363836803649L;
    private final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private transient ServletServerInvoker invoker;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        LogicalStorage.reset();
        try {
            super.processRequest(request, response);
        }
        catch (InvalidClassException ex) {
            throw Xeption.forEndUser((String)L10n.get((String)Messages.BaseSecureServiceImpl_clientVersionDiffersFromTheServer), (Object[])new Object[0]);
        }
        finally {
            LogicalStorage.reset();
        }
    }

    protected ServletServerInvokerMBean getInvokerFromInvokerUrl(ServletConfig config) throws ServletException {
        return this.getInvoker(config);
    }

    protected ServletServerInvokerMBean getInvokerFromInvokerName(ServletConfig config) throws ServletException {
        return this.getInvoker(config);
    }

    public void destroy() {
        if (this.invoker != null) {
            this.invoker.destroy();
        }
        super.destroy();
    }

    private ServletServerInvokerMBean getInvoker(ServletConfig config) throws ServletException {
        if (this.invoker != null) {
            return this.invoker;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration enm = config.getInitParameterNames();
            while (enm.hasMoreElements()) {
                String name = (String)enm.nextElement();
                if (!name.startsWith(INVOKER_PARAM_PREFIX)) continue;
                params.put(name.substring(INVOKER_PARAM_PREFIX.length()), config.getInitParameter(name));
            }
            this.invoker = new ServletServerInvoker(new InvokerLocator("servlet://localhost"), params);
            this.publishRemoteServices();
            this.invoker.start();
        }
        catch (Exception e) {
            throw new ServletException("failed creating invoker", (Throwable)e);
        }
        return this.invoker;
    }

    private void publishRemoteServices() {
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"RpcServiceImplementations")) {
            Collection parameters = ext.getParameters("class");
            for (Extension.Parameter param : parameters) {
                try {
                    Object serviceImpl = JpfUtil.getClass((Extension.Parameter)param).newInstance();
                    for (Extension.Parameter service : param.getSubParameters("service")) {
                        this.publishService(serviceImpl, JpfUtil.getClass((Extension.Parameter)service));
                    }
                }
                catch (Exception e) {
                    this.log.error("failed publishing remote services from " + param, (Throwable)e);
                }
            }
        }
    }

    private void publishService(Object serviceImpl, Class<?> service) {
        String implName = serviceImpl.getClass().getName();
        this.invoker.addInvocationHandler(service.getName(), (ServerInvocationHandler)new RpcServletInvocationHandler(implName, serviceImpl));
        this.log.debug(String.format("published remote service %s from %s", service.getName(), serviceImpl));
    }

    class RpcServletInvocationHandler
    extends TransporterHandler {
        String implName;

        RpcServletInvocationHandler(String implName, Object serviceImpl) {
            super(serviceImpl);
            this.implName = implName;
        }

        public Object invoke(InvocationRequest req) throws Throwable {
            ServiceInvocationLoggingHelper.clearThreadLocalClientStacktrace();
            RemoteInvocation invocation = (RemoteInvocation)req.getParameter();
            ThreadActivityLog.beginRequest((String)"rpc", (String)(this.implName + '.' + invocation.getMethodName()));
            return EntityStorageThreadContext.callWithThrowable(() -> {
                this.checkOldClient(invocation);
                EntityStorageThreadContext.setActionSource((EntityStorageThreadContext.ActionSource)EntityStorageThreadContext.ActionSource.MIDOFFICE_CLIENT_FX);
                try {
                    long timeThreshold;
                    boolean contextFound = false;
                    Object[] params = invocation.getParameters();
                    if (params != null) {
                        for (Object param : params) {
                            if (!(param instanceof ServiceInvocationContext)) continue;
                            ServiceInvocationContext sic = (ServiceInvocationContext)param;
                            ServiceInvocationLoggingHelper.setThreadLocalClientStacktrace((String)sic.getClientStacktrace());
                            contextFound = true;
                            if (!RPCServlet.this.log.isDebugEnabled()) break;
                            RPCServlet.this.log.debug(TextUtil.concat((String[])new String[]{this.implName, ".", invocation.getMethodName(), ", user=", sic.getUser() == null ? "null" : sic.getUser()}));
                            break;
                        }
                    }
                    if (!contextFound) {
                        switch (this.implName + '.' + invocation.getMethodName()) {
                            case "com.gridnine.xtrip.server.fx.rpc.service.MiscServiceImpl.getServerTimezone": {
                                break;
                            }
                            case "com.gridnine.xtrip.server.fx.rpc.EntityServiceImpl.toString": {
                                throw Xeption.forDeveloper((String)"com.gridnine.xtrip.server.fx.rpc.EntityServiceImpl.toString", (Object[])new Object[0]);
                            }
                            default: {
                                IncidentsLog.reportStackTrace((String)("missing invocation context\n" + this.getInvocationInfo(invocation)));
                            }
                        }
                    }
                    long timing = System.currentTimeMillis();
                    Object result = RpcServletInvocationHandler.super.invoke(req);
                    long elapsed = System.currentTimeMillis() - timing;
                    String timeThresholdString = System.getProperty("debug.longRequestThreshold");
                    if (timeThresholdString != null && elapsed > (timeThreshold = Long.parseLong(timeThresholdString))) {
                        IncidentsLog.reportStackTrace((String)(String.format("rpc long request (%d ms) ", elapsed) + this.getInvocationInfo(invocation)));
                    }
                    ServiceInvocationLoggingHelper.clearThreadLocalClientStacktrace();
                    Object object = result;
                    return object;
                }
                finally {
                    ThreadActivityLog.endRequest((String)"rpc", (String)(this.implName + '.' + invocation.getMethodName()));
                }
            });
        }

        private void checkOldClient(RemoteInvocation invocation) {
            if (invocation.getParameters() == null) {
                return;
            }
            if (invocation.getParameters().length == 0) {
                return;
            }
            Object param0 = invocation.getParameters()[0];
            if (param0 == null) {
                return;
            }
            if (!(param0 instanceof ServiceInvocationContext)) {
                return;
            }
            ServiceInvocationContext ctx = (ServiceInvocationContext)param0;
            if (ActionSource.MIDOFFICE_CLIENT == ctx.getActionSource()) {
                throw new RuntimeException("the server does not support the old client");
            }
        }

        private String getInvocationInfo(RemoteInvocation invocation) {
            StringBuilder result = new StringBuilder();
            result.append(this.implName).append('.').append(invocation.getMethodName()).append("()");
            Object[] params = invocation.getParameters();
            if (params != null) {
                result.append(" parameters: ");
                result.append(Arrays.stream(params).map(String::valueOf).collect(Collectors.joining(", ")));
            }
            return result.toString();
        }
    }
}

