/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.servlet;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ScheduledTasksMonitor;
import java.awt.Color;
import java.text.ParseException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minidev.json.annotate.JsonIgnore;
import org.quartz.CronExpression;

public final class ScheduledTasksCalendar {
    private static final String pattern = "yyyy-MM-dd'T'HH:mm:ss";
    private static final Random random = new Random();
    private static final Gson gson;

    public static String getEvents(String startDate, String endDate) {
        if (TextUtil.isBlank((String)startDate) || TextUtil.isBlank((String)endDate)) {
            return "";
        }
        Date start = DateUtils.beginningOf((Date)org.apache.http.client.utils.DateUtils.parseDate((String)startDate, (String[])new String[]{pattern}));
        Date end = DateUtils.beginningOf((Date)org.apache.http.client.utils.DateUtils.parseDate((String)endDate, (String[])new String[]{pattern}));
        List tasksInfo = ScheduledTasksMonitor.getTasksInfo();
        List<Event> events = tasksInfo.stream().map(e -> {
            Event event = new Event();
            event.setEnable(e.getSettings().isEnabled());
            event.setCron(e.getCron());
            event.setPeriod(e.getPeriod());
            event.setResourceId(e.getSettingsUid());
            event.setTitle(e.getName());
            event.setStart(e.getScheduled());
            event.setWorkTime(ScheduledTasksCalendar.calculateTaskExecution(e.getLastExecutionStarted(), e.getLastExecutionFinished()));
            return event;
        }).collect(Collectors.toList());
        List<Event> result = ScheduledTasksCalendar.createSchedules(start, end, events);
        ScheduledTasksCalendar.addWarningColor(result);
        return gson.toJson(result);
    }

    private static void addWarningColor(List<Event> events) {
        events.stream().collect(Collectors.groupingBy(Event::getStart)).forEach((key, value) -> {
            ScheduledTasksCalendar.setColor(value, e -> e.size() >= 3 && e.size() < 5, "#ff6600");
            ScheduledTasksCalendar.setColor(value, e -> e.size() >= 5, "#ff0000");
        });
    }

    private static void setColor(List<Event> events, Predicate<List<Event>> predicate, String color) {
        if (predicate.test(events)) {
            events.forEach(e -> e.setColor(color));
        }
    }

    private static String buildNameCheckDisable(ScheduledTasksMonitor.ScheduledTaskInfo taskInfo) {
        return (taskInfo.getSettings().isEnabled() ? "(ON) " : "(OFF) ") + taskInfo.getName();
    }

    private static String getRandomHexColor() {
        float hue = random.nextFloat();
        float saturation = (float)(random.nextInt(2000) + 1000) / 10000.0f;
        float luminance = 0.9f;
        Color color = Color.getHSBColor(hue, saturation, luminance);
        return '#' + Integer.toHexString(color.getRGB() & 0xFFFFFF | 0x1000000).substring(1);
    }

    public static String getResources() {
        List tasksInfo = ScheduledTasksMonitor.getTasksInfo();
        List resources = tasksInfo.stream().map(s -> new Resources(ScheduledTasksCalendar.buildNameCheckDisable(s), s.getName(), ScheduledTasksCalendar.getRandomHexColor())).collect(Collectors.toList());
        return gson.toJson(resources);
    }

    private static List<Event> createSchedules(Date start, Date end, List<Event> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : events) {
            if (event.getPeriod() != null) {
                result.addAll(ScheduledTasksCalendar.createSchedulesByPeriod(event, start, end));
                continue;
            }
            if (TextUtil.isBlank((String)event.getCron())) continue;
            result.addAll(ScheduledTasksCalendar.createSchedulesByCron(event, start, end));
        }
        return result;
    }

    private static List<Event> createSchedulesByCron(Event event, Date start, Date end) {
        CronExpression cronExpression;
        ArrayList<Event> events = new ArrayList<Event>();
        try {
            cronExpression = new CronExpression(event.getCron());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        Date date = start;
        while (date.before(end)) {
            date = cronExpression.getNextValidTimeAfter(date);
            events.add(new Event(event, date));
        }
        return events;
    }

    private static List<Event> createSchedulesByPeriod(Event event, Date start, Date end) {
        ArrayList<Event> events = new ArrayList<Event>();
        Date date = event.getStart();
        while (end.after(date)) {
            if (!start.before(date = ScheduledTasksCalendar.calculateDate(date, event.getPeriod()))) continue;
            events.add(new Event(event, date));
        }
        date = event.getStart();
        while (start.before(date)) {
            if (!end.after(date = ScheduledTasksCalendar.calculateDate(date, -event.getPeriod().longValue()))) continue;
            events.add(new Event(event, date));
        }
        events.add(event);
        return events;
    }

    private static long calculateTaskExecution(Date start, Date end) {
        long seconds;
        if (start != null && end != null && (seconds = Duration.between(start.toInstant(), end.toInstant()).getSeconds()) > 60L) {
            return TimeUnit.SECONDS.toMillis(seconds);
        }
        return -1L;
    }

    private static Date calculateDate(Date date, long second) {
        return second != -1L ? new Date(date.getTime() + second) : null;
    }

    static {
        ExclusionStrategy strategy = new ExclusionStrategy(){

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }

            public boolean shouldSkipField(FieldAttributes field) {
                return field.getAnnotation(JsonIgnore.class) != null;
            }
        };
        gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{strategy}).setDateFormat(pattern).create();
    }

    private static class Resources {
        @SerializedName(value="title")
        private String title;
        @SerializedName(value="id")
        private String id;
        @SerializedName(value="eventColor")
        private String eventColor;

        public Resources(String title, String id, String eventColor) {
            this.title = title;
            this.id = id;
            this.eventColor = eventColor;
        }
    }

    private static class Event {
        @JsonIgnore
        private String cron;
        @JsonIgnore
        private Long period;
        @JsonIgnore
        private String resourceId;
        @SerializedName(value="resourceId")
        private String title;
        @SerializedName(value="start")
        private Date start;
        @SerializedName(value="end")
        private Date end;
        @JsonIgnore
        private long workTime;
        @JsonIgnore
        private boolean enable;
        private String color;

        public Event() {
        }

        public Event(Event event, Date start) {
            this.resourceId = event.resourceId;
            this.title = event.title;
            this.start = start;
            this.workTime = event.workTime;
            this.cron = event.cron;
            this.period = event.period;
            this.color = event.color;
            this.enable = event.enable;
            this.end = ScheduledTasksCalendar.calculateDate(this.start, this.workTime);
        }

        public String getCron() {
            return this.cron;
        }

        public void setCron(String cron) {
            this.cron = cron;
        }

        public Long getPeriod() {
            return this.period;
        }

        public void setPeriod(Long period) {
            this.period = period;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Date getStart() {
            return this.start;
        }

        public void setStart(Date start) {
            this.start = start;
        }

        public Date getEnd() {
            return this.end;
        }

        public void setEnd(Date end) {
            this.end = end;
        }

        public long getWorkTime() {
            return this.workTime;
        }

        public void setWorkTime(long workTimeSecond) {
            this.workTime = workTimeSecond;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }
    }
}

