/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.servlet;

import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionGroupResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import com.gridnine.xtrip.server.web.servlet.AuthFilterExtender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAuthFilter
implements Filter {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private String loginPage;
    private boolean adminOnly;
    private AuthFilterExtender extender;

    public void init(FilterConfig config) throws ServletException {
        this.log.info("initialized");
        this.adminOnly = "true".equalsIgnoreCase(config.getInitParameter("adminOnly"));
        this.extender = this.getExtender();
        if (this.extender != null) {
            this.extender.init(config);
        }
    }

    public void destroy() {
        this.loginPage = null;
        this.log.info("destroyed");
        if (this.extender != null) {
            this.extender.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.extender != null && this.extender.doFilter(req, res, chain)) {
            return;
        }
        LogicalStorage.reset();
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpRes = (HttpServletResponse)res;
        httpReq.setCharacterEncoding("utf-8");
        HttpSession ss = httpReq.getSession();
        try {
            if (req.getParameter("auth.login") != null) {
                char[] p;
                String l;
                block19: {
                    l = req.getParameter("auth.l");
                    p = req.getParameter("auth.p").toCharArray();
                    try {
                        boolean granted;
                        if (p.length == 0) {
                            throw new IllegalStateException("Empty password");
                        }
                        LogicalStorage.get().authorize(l, p);
                        if (!this.adminOnly || (granted = AclHelper.isGranted(null, (String)StandardRestrictionGroupResources.GROUP_ADMINISTRATION.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.USE.getId(), Collections.emptyList()))) break block19;
                        this.renderLoginPage(httpReq, httpRes, String.format("Permission denied for %s.", l));
                        return;
                    }
                    catch (Exception e) {
                        this.log.warn(String.format("authorization failed, l=%s", l), (Throwable)e);
                        this.renderLoginPage(httpReq, httpRes, "Authorization failed.");
                        LogicalStorage.reset();
                        return;
                    }
                }
                if (ss == null) {
                    ss = httpReq.getSession(true);
                }
                ss.setAttribute("auth.l", (Object)l);
                ss.setAttribute("auth.p", (Object)p);
            }
            if (ss == null) {
                this.renderLoginPage(httpReq, httpRes, "");
                return;
            }
            String l = (String)ss.getAttribute("auth.l");
            char[] p = (char[])ss.getAttribute("auth.p");
            if (l == null || p == null) {
                this.renderLoginPage(httpReq, httpRes, "");
                return;
            }
            try {
                LogicalStorage.get().authorize(l, p);
            }
            catch (Exception e) {
                ss.removeAttribute("auth.l");
                ss.removeAttribute("auth.p");
                this.renderLoginPage(httpReq, httpRes, "");
                LogicalStorage.reset();
                return;
            }
            chain.doFilter(req, res);
        }
        finally {
            LogicalStorage.reset();
        }
    }

    private void renderLoginPage(HttpServletRequest req, HttpServletResponse res, String message) throws IOException {
        res.setContentType("text/html");
        res.setCharacterEncoding("utf-8");
        res.getWriter().write(this.getLoginPage().replace("${message}", message).replace("${action}", req.getRequestURI()));
        res.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLoginPage() throws IOException {
        if (this.loginPage == null) {
            StorageAuthFilter storageAuthFilter = this;
            synchronized (storageAuthFilter) {
                if (this.loginPage == null) {
                    try (InputStream strm = this.getClass().getResourceAsStream("login.html");){
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
                        this.loginPage = new String(baos.toByteArray(), "utf-8");
                    }
                }
            }
        }
        return this.loginPage;
    }

    private AuthFilterExtender getExtender() {
        String className = System.getProperty(this.getClass().getName() + ".className");
        try {
            return !TextUtil.isBlank((String)className) ? (AuthFilterExtender)Class.forName(className).newInstance() : null;
        }
        catch (Throwable t) {
            this.log.error("can't instantiate auth storage filter extender.", t);
            return null;
        }
    }
}

