/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.util;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.XeptionHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.server.ibus.IBusMailContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class RestUtil {
    public static String handleException(Logger log, Throwable cause) {
        String uid = UUIDUtil.toString((UUID)UUID.randomUUID()) + "/" + RestUtil.messageHash(cause);
        String applicationId = Environment.getApplicationId();
        String errorId = String.format("ERROR:%s@%s", uid, applicationId);
        String result = L10nResourcesManager.createL10nMessage((String)"REPORT_ERROR_ID", (Object[])new Object[]{errorId}).toString();
        log.error(errorId, cause);
        if (RestUtil.isEmailAllowed(cause)) {
            RestUtil.sendEmail(cause, uid, applicationId);
        }
        return result;
    }

    private static String messageHash(Throwable cause) {
        String text;
        Xeption xe = XeptionHelper.findXeption((Throwable)cause);
        if (xe != null) {
            text = xe.getMessage();
            text = StringUtils.isBlank((String)text) ? RestUtil.toString(xe.getAdminMessage()) : text;
            text = StringUtils.isBlank((String)text) ? RestUtil.toString(xe.getEndUserMessage()) : text;
        } else {
            text = cause.getMessage();
        }
        return text != null ? DigestUtils.md5Hex((String)text) : "";
    }

    private static String toString(L10nMessage message) {
        return message != null ? message.toString() : null;
    }

    private static void sendEmail(Throwable cause, String errorId, String applicationId) {
        List emails = ConfigUtil.getAsList((String)"errors.addresses");
        if (emails.isEmpty()) {
            return;
        }
        String node = String.format("@%s@", applicationId);
        String nl = System.getProperty("line.separator");
        StringBuilder body = new StringBuilder();
        body.append(node).append(nl).append(TextUtil.getExceptionStackTrace((Throwable)cause));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusMailContextKeys.MAIL_TO.name(), emails);
        data.put(IBusMailContextKeys.MAIL_SUBJ.name(), errorId + node);
        data.put(IBusMailContextKeys.MAIL_BODY.name(), body.toString());
        IntegrationBusFacade.get().sendRouteAsync("standard-model:send-email", data);
    }

    private static boolean isEmailAllowed(Throwable cause) {
        boolean result = true;
        Xeption xe = XeptionHelper.findXeption((Throwable)cause);
        if (xe != null) {
            L10nMessage endUserMessage = xe.getEndUserMessage();
            String key = endUserMessage != null ? endUserMessage.getKey() : null;
            result = key == null || !"USER_NOT_LOGGED_IN".equals(key) && !"OUTDATED_AUTH_TOKEN".equals(key);
        }
        return result;
    }
}

