<%@ page
	language="java"
	contentType="text/html; charset=utf-8"
	errorPage="../error.jsp"
	import="java.util.*"
	import="java.text.*"
	import="com.gridnine.xtrip.common.*"
	import="com.gridnine.xtrip.common.meta.*"
	import="com.gridnine.xtrip.common.util.*"
	import="com.gridnine.xtrip.server.db.*"
	import="com.gridnine.xtrip.server.storage.*"
%><%!
static final Comparator<BaseType> COMPARATOR = new Comparator<BaseType>() {
    public int compare(BaseType o1, BaseType o2) {
        return TextUtil.compare(o1.getDisplayName(), o2.getDisplayName(), true, true);
    }
};
%><%
if (request.getParameter("schedule") != null) {
    if (request.getParameterValues("ett") != null) {
	    StringBuilder buf = new StringBuilder();
	    for (String id : request.getParameterValues("ett")) {
	        if ("ALL".equals(id)) {
	            buf.setLength(0);
	            buf.append("true");
	            break;
	        }
	        if (buf.length() > 0) {
	            buf.append(',');
	        }
	        buf.append(id);
	    }
	    if (buf.length() > 0) {
	        Environment.getPublished(DbProperties.class).put("reindex",
	            buf.toString());
	    }
    }
    response.sendRedirect("reindex.jsp");
    return;
}
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<title>Re-index Tool - <%= application.getServletContextName() %></title>
	<link rel="StyleSheet" type="text/css" href="../resources/base.css">
</head>

<body>

<%
String reindexPropValue =
    Environment.getPublished(DbProperties.class).getValue("reindex");
if (reindexPropValue != null) {
    if ("true".equals(reindexPropValue)) {
%>
<h3>Scheduled reindexing of all entities.</h3>
<%
    } else {
%>
<h3>Scheduled reindexing of the following entities:</h3>
<p><%= reindexPropValue %></p>
<%
	}
} else {
    List<EntityType> list = new ArrayList<EntityType>(
            Environment.getPublished(MetaRegistry.class).getEntities().values());
    for (Iterator<EntityType> it = list.iterator(); it.hasNext();) {
        EntityType ett = it.next();
	    if (!ett.isRoot() || ett.isAbstract()) {
	        it.remove();
	    }
    }
    Collections.sort(list, COMPARATOR);
%>
<h3>Select entities for re-indexing:</h3>
<form action="reindex.jsp" method="post">
<select name="ett" multiple="multiple" size="10">
	<option value="ALL">All Entities</option>
	<% for (EntityType ett : list) { %>
	<option value="<%= ett.getId() %>"><%= ett.getDisplayName() %></option>
	<% } %>
</select><br />
<input type="submit" name="schedule" value="Schedule for Re-indexing" />
</form>
<%
}
if (Environment.isPublished(IndexBuilderStatus.class)) {
    IndexBuilderStatus status = Environment.getPublished(IndexBuilderStatus.class);
    DateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
%>
<h3>Index Builder Status</h3>
<p>
	<strong>Started: </strong><%= dtf.format(status.getBegin()) %><br />
	<strong>Finished: </strong><%= status.getEnd() == null ? "work in progress" : dtf.format(status.getEnd()) %><br />
	<table border="1" cellspacing="0" cellpadding="5">
		<tr>
			<th>Entity</th>
			<th>Progress</th>
		</tr>
		<% for (Map.Entry<String, String> entry : status.getProgress()) { %>
		<tr>
			<td><%= entry.getKey() %></td>
			<td><%= entry.getValue() %></td>
		</tr>
		<% } %>
	</table>
</p>
<%
	}
%>

</body>
</html>
