/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.rest.BaseAuthRestRequest;
import com.gridnine.xtrip.common.model.rest.redapp.RedAppResponse;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.AuthContext;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;

public class RedAppAuthProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BaseAuthRestRequest request = (BaseAuthRestRequest)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_REQUEST);
        EntityContainer<Person> agent = this.decodeAuth(request.getAuth(), ctx);
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_AGENT, agent);
    }

    private EntityContainer<Person> decodeAuth(String auth, MessageContext ctx) throws Exception {
        RedAppResponse response = (RedAppResponse)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESPONSE);
        if (auth != null) {
            String data = new String(Base64.decode((String)auth), "UTF-8");
            AuthContext authContext = new AuthContext();
            XUtil.fromString((String)data, (XSerializable)authContext);
            ctx.putObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_LOGIN, (Object)authContext.getLogin());
            EntityStorage entityStorage = EntityStorage.get();
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)authContext.getLogin()));
            SearchResult searchResult = entityStorage.search(PersonIndex.class, searchQuery);
            if (searchResult.getData().size() == 0) {
                String msg = String.format("NO PROFILE FOUND IN MOM WITH LOGIN %s", RedAppAuthProcessor.quotes(authContext.getLogin()));
                response.getUserResponses().add(msg);
                throw Xeption.forEndUser((String)msg, (Object[])new Object[0]);
            }
            PersonIndex personIndex = (PersonIndex)searchResult.getData().get(0);
            EntityContainer personContainer = entityStorage.resolve(personIndex.getSource());
            if (personContainer == null) {
                String msg = String.format("PERSON PROFILE NOT RESOLVED FOR LOGIN %s", RedAppAuthProcessor.quotes(authContext.getLogin()));
                response.getUserResponses().add(msg);
                throw Xeption.forEndUser((String)msg, (Object[])new Object[0]);
            }
            UserAccount userAccount = (UserAccount)AssetsStorage.get().find(UserAccount.class, "loginName", (Object)authContext.getLogin());
            if (userAccount == null) {
                String msg = String.format("NO USER ACCOUNT FOUND FOR %s", RedAppAuthProcessor.quotes(authContext.getLogin()));
                response.getUserResponses().add(msg);
                throw Xeption.forEndUser((String)msg, (Object[])new Object[0]);
            }
            if (!MiscUtil.equals((Object)authContext.getPassword(), (Object)userAccount.getPasswordDigest())) {
                String msg = String.format("PASSWORD INVALID FOR LOGIN %s", RedAppAuthProcessor.quotes(authContext.getLogin()));
                response.getUserResponses().add(msg);
                throw Xeption.forEndUser((String)msg, (Object[])new Object[0]);
            }
            try {
                LogicalStorage.get().authorize(authContext.getLogin(), authContext.getPassword());
            }
            catch (Exception e) {
                String msg = String.format("AUTHORIZATION FAILED FOR LOGIN %s", RedAppAuthProcessor.quotes(authContext.getLogin()));
                response.getUserResponses().add(msg);
                throw Xeption.forEndUser((String)msg, (Object[])new Object[0]);
            }
            return personContainer;
        }
        return null;
    }

    public static Object quotes(String str) {
        return !TextUtil.isBlank((String)str) ? "'" + str + "'" : "";
    }
}

