/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.redapp.sws.AirSegment;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.redapp.sws.PriceQuote;
import com.gridnine.xtrip.common.model.redapp.sws.RemarkType;
import com.gridnine.xtrip.common.model.rules.standard.BasicAirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappButton;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessage;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessageType;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RedAppUtils {
    public static final Set<RemarkType> remarkTypes = new HashSet<RemarkType>();

    public static RedappMessage buildMessage(RedappMessageType type, String key, Object ... parameters) {
        RedappMessage message = new RedappMessage();
        message.setMsgType(type);
        message.setText(L10nResourcesManager.getStr((String)key, (Object[])parameters));
        return message;
    }

    public static RedappMessage buildMessage(RedappMessageType type, String text, String title, String ruleUid, Collection<RedappButton> buttons) {
        RedappMessage message = new RedappMessage();
        message.setMsgType(type);
        message.setText(text);
        message.setTitle(title);
        message.setRuleUid(ruleUid);
        if (buttons != null) {
            message.getButtons().addAll(buttons);
        }
        return message;
    }

    public static String getEndpointUrl(Target target) {
        switch (target) {
            case CERT: {
                return "https://webservices.cert.platform.sabre.com";
            }
            case RES: {
                return "https://webservices.platform.sabre.com";
            }
        }
        return null;
    }

    public static String getPrefix(RemarkType type) {
        switch (type) {
            case General: {
                return "";
            }
            case Invoice: {
                return ".";
            }
            case Itinerary: {
                return String.valueOf('\u00a5');
            }
            case Interface: {
                return "X/-";
            }
            case Historical: {
                return "H-";
            }
            case Hidden: {
                return "HR-";
            }
        }
        return null;
    }

    public static MiscUtil.Pair<RemarkType, String> getRemarkTypeTextPair(String remark) {
        if (TextUtil.isBlank((String)remark)) {
            return null;
        }
        if (remark.startsWith(".")) {
            return new MiscUtil.Pair((Object)RemarkType.Invoice, (Object)remark.substring(1));
        }
        if (remark.startsWith(String.valueOf('\u00a5'))) {
            return new MiscUtil.Pair((Object)RemarkType.Itinerary, (Object)remark.substring(1));
        }
        if (remark.startsWith("X/-")) {
            return new MiscUtil.Pair((Object)RemarkType.Interface, (Object)remark.substring(3));
        }
        if (remark.startsWith("H-")) {
            return new MiscUtil.Pair((Object)RemarkType.Historical, (Object)remark.substring(2));
        }
        if (remark.startsWith("HR-")) {
            return new MiscUtil.Pair((Object)RemarkType.Hidden, (Object)remark.substring(3));
        }
        return new MiscUtil.Pair((Object)RemarkType.General, (Object)remark);
    }

    public static Set<String> getBypassAckRemarks(Itinerary itinerary) {
        return itinerary.getRemarks().stream().filter(r -> remarkTypes.contains(r.getType())).map(r -> RedAppUtils.getPrefix(r.getType()) + r.getText()).collect(Collectors.toSet());
    }

    public static Set<String> getValidatingCarriers(Itinerary itinerary) {
        return itinerary.getPriceQuotes().stream().map(PriceQuote::getValidatingCarrier).collect(Collectors.toSet());
    }

    public static Set<String> getOperatingCarriers(Itinerary itinerary) {
        return itinerary.getAirSegments().stream().map(AirSegment::getOperatingAirline).collect(Collectors.toSet());
    }

    public static Set<String> getMarketingCarriers(Itinerary itinerary) {
        return itinerary.getAirSegments().stream().map(AirSegment::getMarketingAirline).collect(Collectors.toSet());
    }

    public static Set<String> getBookingClasses(Itinerary itinerary) {
        return itinerary.getAirSegments().stream().map(AirSegment::getClassOfServiceCode).collect(Collectors.toSet());
    }

    public static void initLocations(BasicAirTicketPropertiesProvider set, Itinerary itinerary) {
        ArrayList visitedCodes = new ArrayList();
        HashSet visitedCityCodes = new HashSet();
        HashSet departureCodes = new HashSet();
        itinerary.getAirSegments().stream().map(AirSegment::getDepartureLocation).forEach(l -> {
            departureCodes.add(l);
            Set codes = RulesHelper.collectGeoCodes((Set)departureCodes, (boolean)true);
            departureCodes.addAll(codes);
            visitedCodes.add(codes);
            Optional.ofNullable(DictHelper.findCityByAirport((String)l)).ifPresent(c -> {
                visitedCityCodes.add(c.getCode());
                departureCodes.add(c.getCode());
            });
        });
        HashSet arrivalCodes = new HashSet();
        itinerary.getAirSegments().stream().map(AirSegment::getArrivalLocation).forEach(l -> {
            arrivalCodes.add(l);
            Set codes = RulesHelper.collectGeoCodes((Set)arrivalCodes, (boolean)true);
            arrivalCodes.addAll(codes);
            visitedCodes.add(codes);
            Optional.ofNullable(DictHelper.findCityByAirport((String)l)).ifPresent(c -> {
                visitedCityCodes.add(c.getCode());
                arrivalCodes.add(c.getCode());
            });
        });
        HashSet allCodes = new HashSet(departureCodes);
        allCodes.addAll(arrivalCodes);
        set.getDepartureLocations().addAll(departureCodes);
        set.getArrivalLocations().addAll(arrivalCodes);
        set.getAllLocations().addAll(allCodes);
        set.getVisitedGeolocations().addAll(RulesHelper.fillVisitedGeolocations(visitedCodes));
        for (String city : visitedCityCodes) {
            HashSet<String> geoCodes = new HashSet<String>();
            if (!TextUtil.isBlank((String)city)) {
                geoCodes.add(city);
                geoCodes.addAll(RulesHelper.collectGeoCodes(geoCodes, (boolean)true));
            }
            set.getVisitedCities().add(geoCodes.toArray(new String[0]));
        }
        ArrayList<String[]> lst = new ArrayList<String[]>();
        lst.add(departureCodes.toArray(new String[0]));
        lst.add(arrivalCodes.toArray(new String[0]));
        set.getFlightSegments().add(lst);
    }

    static {
        remarkTypes.add(RemarkType.General);
        remarkTypes.add(RemarkType.Invoice);
        remarkTypes.add(RemarkType.Itinerary);
        remarkTypes.add(RemarkType.Interface);
        remarkTypes.add(RemarkType.Historical);
        remarkTypes.add(RemarkType.Hidden);
    }
}

