/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.rest.TypeHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.web.rest.JsonHelper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonTypeHandler
implements TypeHandler {
    public boolean isAwareOf(Class<?> type) {
        return Enum.class.isAssignableFrom(type) || DictionaryReference.class.isAssignableFrom(type) || EntityReference.class.isAssignableFrom(type) || LocalDate.class.isAssignableFrom(type) || LocalDateTime.class.isAssignableFrom(type) || DateTime.class.isAssignableFrom(type) || LocalTime.class.isAssignableFrom(type);
    }

    public Object unmarshal(Object object, Class<?> type, Class<?> originalType) throws Exception {
        if (Objects.isNull(object) || object.equals(JSONObject.NULL)) {
            return null;
        }
        if (Enum.class.isAssignableFrom(type) || DictionaryReference.class.isAssignableFrom(type) || EntityReference.class.isAssignableFrom(type)) {
            String uid = null;
            if (object instanceof JSONObject) {
                if (object != null) {
                    uid = ((JSONObject)object).getString("uid");
                }
            } else {
                uid = (String)object;
            }
            if (Enum.class.isAssignableFrom(type)) {
                if (!TextUtil.isBlank((String)uid)) {
                    try {
                        return Enum.valueOf(type, uid);
                    }
                    catch (IllegalArgumentException e) {
                        throw Xeption.forDeveloper((String)String.format("Invalid value of type %s", type.getSimpleName()), (Object[])new Object[0]);
                    }
                }
                return null;
            }
            if (DictionaryReference.class.isAssignableFrom(type)) {
                Class<?> dictionaryType = originalType;
                BaseDictionary dict = DictionaryCache.get().findByCode(dictionaryType, uid);
                return Objects.nonNull(dict) ? dict.toReference() : null;
            }
            if (EntityReference.class.isAssignableFrom(type)) {
                return new EntityReference(uid, originalType, null);
            }
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            try {
                return ISODateTimeFormat.dateParser().parseLocalDate((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalDate [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        if (LocalDateTime.class.isAssignableFrom(type)) {
            try {
                return ISODateTimeFormat.dateTimeParser().parseLocalDateTime((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalDateTime [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        if (DateTime.class.isAssignableFrom(type)) {
            try {
                return ISODateTimeFormat.dateTimeParser().parseDateTime((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse DateTime [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        if (LocalTime.class.isAssignableFrom(type)) {
            try {
                return ISODateTimeFormat.timeParser().parseLocalTime((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalTime [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        throw Xeption.forDeveloper((String)String.format("Invalid type [%s]", type.getSimpleName()), (Object[])new Object[0]);
    }

    public Object marshal(Object result, Object value, Map<String, Object> data, boolean isValid, List<Object> parents) throws JSONException {
        if (!isValid || Objects.isNull(value)) {
            return null;
        }
        try {
            parents.add(value);
            if (Enum.class.isInstance(value)) {
                String string = ((Enum)value).name();
                return string;
            }
            if (DictionaryReference.class.isInstance(value)) {
                JSONObject json = new JSONObject();
                json.put("uid", (Object)((DictionaryReference)value).getCode());
                json.put("caption", (Object)value.toString());
                JSONObject jSONObject = json;
                return jSONObject;
            }
            if (EntityReference.class.isInstance(value)) {
                JSONObject json = new JSONObject();
                json.put("uid", (Object)((EntityReference)value).getUid());
                json.put("caption", (Object)((EntityReference)value).getCaption());
                JSONObject jSONObject = json;
                return jSONObject;
            }
            if (LocalDate.class.isInstance(value)) {
                String string = ISODateTimeFormat.date().print((ReadablePartial)((LocalDate)value));
                return string;
            }
            if (LocalDateTime.class.isInstance(value)) {
                String string = ISODateTimeFormat.dateTimeNoMillis().print((ReadablePartial)((LocalDateTime)value));
                return string;
            }
            if (DateTime.class.isInstance(value)) {
                String string = ISODateTimeFormat.dateTime().print((ReadableInstant)((DateTime)value));
                return string;
            }
            if (LocalTime.class.isInstance(value)) {
                String string = ISODateTimeFormat.timeNoMillis().print((ReadablePartial)((LocalTime)value));
                return string;
            }
            throw Xeption.forDeveloper((String)String.format("Invalid value [%s]", String.valueOf(value)), (Object[])new Object[0]);
        }
        finally {
            parents.remove(value);
        }
    }

    public void validate(Object o, Class<?> cls) {
        JSONObject json = (JSONObject)o;
        if (Enum.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson((JSONObject)json, cls, (String[])new String[]{(String)o});
        }
        if (DictionaryReference.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson((JSONObject)json, cls, (String[])new String[]{(String)o});
        }
        if (EntityReference.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson((JSONObject)json, cls, (String[])new String[]{(String)o});
        }
        throw Xeption.forDeveloper((String)"Invalid value [%s]", (Object[])new Object[]{String.valueOf(cls)});
    }
}

