/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.CwtOrganizationData;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.util.Optional;

public class CwtSchemeHelper {
    private CwtSchemeHelper() {
    }

    public static boolean isCwtBooking(BookingFile bookingFile) {
        EntityReference client = bookingFile.getCustomerProfile();
        return CwtSchemeHelper.isUseCwtPassiveScheme((EntityReference<Organization>)client) || CwtSchemeHelper.isUseCwtPassiveScheme(CwtSchemeHelper.getParent((EntityReference<Organization>)client)) || bookingFile.getReservations().stream().flatMap(r -> r.getProducts().stream()).anyMatch(CwtSchemeHelper::isProductUseCwtPassiveScheme);
    }

    private static boolean isProductUseCwtPassiveScheme(BaseProduct product) {
        EntityReference subagency = GeneralProductHelper.getSubagency((BaseProduct)product);
        if (!CwtSchemeHelper.isUseCwtPassiveScheme((EntityReference<Organization>)subagency) && !CwtSchemeHelper.isUseCwtPassiveScheme(CwtSchemeHelper.getParent((EntityReference<Organization>)subagency))) {
            EntityReference agency = GeneralProductHelper.getAgency((BaseProduct)product);
            return CwtSchemeHelper.isUseCwtPassiveScheme((EntityReference<Organization>)agency) || CwtSchemeHelper.isUseCwtPassiveScheme(CwtSchemeHelper.getParent((EntityReference<Organization>)agency));
        }
        return true;
    }

    private static boolean isUseCwtPassiveScheme(EntityReference<Organization> ref) {
        return Optional.ofNullable(ref).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).map(EntityContainer::getEntity).map(Organization::getCwtProfileData).map(CwtOrganizationData::isUseCwtPassiveSegmentScheme).orElse(false);
    }

    private static EntityReference<Organization> getParent(EntityReference<Organization> ref) {
        return Optional.ofNullable(ref).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).map(EntityContainer::getEntity).map(Organization::getParent).orElse(null);
    }
}

