/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppUtils;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessageType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FindRelevantOrganizations
extends BaseProcessor {
    private boolean validateClient = false;
    private boolean validateAgency = false;

    public void configure(Map<String, String> parameters) {
        if (parameters.containsKey("validate-client")) {
            this.validateClient = Boolean.parseBoolean(parameters.get("validate-client"));
        }
        if (parameters.containsKey("validate-agency")) {
            this.validateAgency = Boolean.parseBoolean(parameters.get("validate-agency"));
        }
    }

    public void process(MessageContext ctx) throws Exception {
        EntityContainer agent;
        Itinerary itinerary = (Itinerary)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.ITINERARY);
        String login = (String)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_LOGIN);
        List messages = (List)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_MESSAGES);
        EntityContainer clientCtr = null;
        EntityContainer agencyCtr = null;
        ArrayList dkNumbersFromRemarks = new ArrayList();
        if (!TextUtil.isBlank((String)itinerary.getDkNumber())) {
            clientCtr = this.byDk(itinerary.getDkNumber());
        }
        if ((agent = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)login)) != null) {
            List mains = ((Person)agent.getEntity()).getEmployments().stream().filter(PersonEmployment::isMainEmployment).filter(emp -> !(emp.getClosed() != null && !new Date().before(emp.getClosed()) || emp.getOpened() != null && !new Date().after(emp.getOpened()))).map(emp -> EntityStorage.get().resolve(emp.getOrganization())).filter(orgCtr -> orgCtr != null && ((Organization)orgCtr.getEntity()).getTypes().contains(OrganizationType.AGENCY)).collect(Collectors.toList());
            if (mains.size() == 1) {
                agencyCtr = (EntityContainer)mains.get(0);
            } else if (mains.isEmpty()) {
                List notMains = ((Person)agent.getEntity()).getEmployments().stream().filter(emp -> !(emp.getClosed() != null && !new Date().before(emp.getClosed()) || emp.getOpened() != null && !new Date().after(emp.getOpened()))).map(emp -> EntityStorage.get().resolve(emp.getOrganization())).filter(orgCtr -> orgCtr != null && ((Organization)orgCtr.getEntity()).getTypes().contains(OrganizationType.AGENCY)).collect(Collectors.toList());
                if (notMains.size() == 1) {
                    agencyCtr = (EntityContainer)notMains.get(0);
                } else if (this.validateAgency && !notMains.isEmpty()) {
                    throw Xeption.forEndUser((String)L10n.get((String)"NO_MAIN_EMPLOYMENT_FOUND"), (Object[])new Object[0]);
                }
            } else if (this.validateAgency) {
                throw Xeption.forEndUser((String)L10n.get((String)"SEVERAL_MAIN_EMPLOYMENTS_FOUND"), (Object[])new Object[0]);
            }
            if (this.validateAgency && agencyCtr == null) {
                throw Xeption.forEndUser((String)L10n.get((String)"NO_EMPLOYMENT_FOUND"), (Object[])new Object[0]);
            }
            if (agencyCtr != null && clientCtr == null && TextUtil.isBlank((String)itinerary.getDkNumber())) {
                for (String rt : ((Organization)agencyCtr.getEntity()).getRedappSettings().getCustomerIDRemarkTemplates()) {
                    List numbers = itinerary.getRemarks().stream().filter(r -> RedAppUtils.remarkTypes.contains(r.getType())).map(r -> Pattern.compile(rt.replaceAll("\\.", "\\\\.") + "(.+)").matcher(RedAppUtils.getPrefix(r.getType()) + r.getText())).filter(Matcher::matches).map(m -> m.group(1).trim()).filter(TextUtil::nonBlank).peek(dkNumbersFromRemarks::add).collect(Collectors.toList());
                    clientCtr = numbers.stream().map(this::byDk).filter(Objects::nonNull).findFirst().orElse(null);
                    if (clientCtr == null) continue;
                    break;
                }
            }
        }
        if (this.validateClient && clientCtr == null) {
            if (TextUtil.isBlank((String)itinerary.getDkNumber())) {
                if (!dkNumbersFromRemarks.isEmpty()) {
                    for (String dkNumber : dkNumbersFromRemarks) {
                        messages.add(RedAppUtils.buildMessage(RedappMessageType.Error, "NOT_FOUND_ORGANIZATION_WITH_CUSTOMER_NUMBER", dkNumber));
                    }
                } else {
                    messages.add(RedAppUtils.buildMessage(RedappMessageType.Warning, "DK_NOT_FOUND_IN_PNR", new Object[0]));
                }
            } else {
                messages.add(RedAppUtils.buildMessage(RedappMessageType.Error, "NOT_FOUND_ORGANIZATION_WITH_CUSTOMER_NUMBER", itinerary.getDkNumber()));
            }
        }
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_CLIENT_ORGANIZATION, clientCtr);
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_AGENCY_CLIENT, agencyCtr);
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_AGENT, (Object)agent);
    }

    private EntityContainer<Organization> byDk(String dk) {
        EntityContainer org = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)dk);
        if (org != null) {
            return org;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)OrganizationIndex.Property.code.name(), (String)dk));
        for (OrganizationIndex index : EntityStorage.get().search(OrganizationIndex.class, query).getData()) {
            org = EntityStorage.get().resolve(index.getSource());
            if (org == null || !TextUtil.isSame((String)dk, (String)((Organization)org.getEntity()).getCode(), (boolean)true)) continue;
            return org;
        }
        return null;
    }
}

