/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.web.rest.redapp.service.RestHelper;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestRailTravellerData;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestTravellerData;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class GetSegmentsData {
    private BookingFile bookingFile;
    private List<Product> airProducts;
    private List<RailwayProduct> railProducts;
    private Map<String, Map<String, RestTravellerData>> travellerAirSegmentsData = new HashMap<String, Map<String, RestTravellerData>>();
    private Map<String, Map<String, RestRailTravellerData>> travellerRailSegmentsData = new HashMap<String, Map<String, RestRailTravellerData>>();
    private Map<Reservation, Map<Segment, String>> reservationAirSegments = new HashMap<Reservation, Map<Segment, String>>();
    private Map<String, Map<RailwaySegment, String>> reservationRailSegments = new HashMap<String, Map<RailwaySegment, String>>();

    public GetSegmentsData(BookingFile bookingFile) {
        this.bookingFile = bookingFile;
        this.parseAirData();
        this.parseRailData();
    }

    private static int compareAirSegments(Segment s1, Segment s2) {
        int result = s1.getStartDate().compareTo(s2.getStartDate());
        if (result == 0 && (result = s1.getDepartureLocation().getCode().compareTo(s2.getDepartureLocation().getCode())) == 0 && (result = s1.getArriveLocation().getCode().compareTo(s2.getArriveLocation().getCode())) == 0 && (result = s1.getAirline().getCode().compareTo(s2.getAirline().getCode())) == 0 && (result = s1.getClassOfSvcCode().compareToIgnoreCase(s2.getClassOfSvcCode())) == 0 && (result = s1.getFlightNo().compareTo(s2.getFlightNo())) == 0) {
            result = TextUtil.compare((String)s1.getAirlineLocator(), (String)s2.getAirlineLocator(), (boolean)true, (boolean)true);
        }
        return result;
    }

    private static int compareRailSegments(RailwaySegment s1, RailwaySegment s2) {
        int result = s1.getDepartureDate().compareTo(s2.getDepartureDate());
        if (result == 0 && (result = s1.getDepartureStation().getCode().compareTo(s2.getDepartureStation().getCode())) == 0 && (result = s1.getArriveStation().getCode().compareTo(s2.getArriveStation().getCode())) == 0 && (result = TextUtil.compare((String)s1.getTrainNumber(), (String)s2.getTrainNumber(), (boolean)true, (boolean)true)) == 0 && (result = TextUtil.compare((String)s1.getSlot(), (String)s2.getSlot(), (boolean)true, (boolean)true)) == 0) {
            result = MiscUtil.compare((Date)s1.getArriveDate(), (Date)s2.getArriveDate(), (boolean)true);
        }
        return result;
    }

    private void parseAirData() {
        this.airProducts = this.bookingFile.getReservations().stream().filter(RestHelper::isApplicableReservation).peek(r -> {
            Map cfr_ignored_0 = this.reservationAirSegments.put((Reservation)r, new TreeMap(GetSegmentsData::compareAirSegments));
        }).flatMap(AirProductHelper::getAirProductsStream).filter(RestHelper::isApplicableAirProduct).collect(Collectors.toList());
        this.airProducts.forEach(p -> {
            Map<Segment, String> airSegments = this.reservationAirSegments.get(p.getReservation());
            Traveller traveller = p.getTraveller();
            AirProductHelper.getProductSegmentsStream((Product)p).filter(RestHelper::isApplicableAirSegment).forEach(s -> {
                String segmentUid = airSegments.computeIfAbsent((Segment)s, BaseIdentity::getUid);
                Map segmentData = this.travellerAirSegmentsData.computeIfAbsent(segmentUid, key -> new HashMap());
                RestTravellerData data = new RestTravellerData();
                data.setSeat(s.getSeatNo());
                data.setFarebasis(s.getFareBasis());
                data.setBaggage(this.convertLuggageInfo2Rest(s.getLuggageInfo()));
                segmentData.putIfAbsent(traveller.getUid(), data);
            });
        });
    }

    private void parseRailData() {
        this.railProducts = this.bookingFile.getReservations().stream().filter(RestHelper::isApplicableReservation).peek(r -> {
            Map cfr_ignored_0 = this.reservationRailSegments.put(r.getUid(), new TreeMap(GetSegmentsData::compareRailSegments));
        }).flatMap(r -> r.getProducts().stream()).filter(RestHelper::isRailwayProduct).map(p -> (RailwayProduct)p).filter(RestHelper::isApplicableRailProduct).collect(Collectors.toList());
        this.railProducts.forEach(p -> p.getSegments().stream().filter(RestHelper::isApplicableRailSegment).forEach(railSegment -> {
            Map<RailwaySegment, String> railSegments = this.reservationRailSegments.get(p.getReservation().getUid());
            String segmentUid = railSegments.computeIfAbsent((RailwaySegment)railSegment, BaseIdentity::getUid);
            Map segmentData = this.travellerRailSegmentsData.computeIfAbsent(segmentUid, key -> new HashMap());
            p.getPassengers().forEach(passenger -> {
                RestRailTravellerData data = new RestRailTravellerData();
                data.setCar(railSegment.getCarriageNumber());
                data.setSeat(railSegment.getPlaces().stream().collect(Collectors.joining(", ")));
                segmentData.putIfAbsent(passenger.getUid(), data);
            });
        }));
    }

    private String convertLuggageInfo2Rest(LuggageInfo luggageInfo) {
        if (luggageInfo == null) {
            return null;
        }
        if (luggageInfo.isNil()) {
            return "NIL";
        }
        Optional<String> optQuantity = Optional.ofNullable(luggageInfo.getQuantity()).map(Object::toString);
        Optional<String> optUnit = Optional.ofNullable(luggageInfo.getUnit()).map(DictionaryReference::getCode);
        String baggage = optQuantity.orElse("") + optUnit.orElse("");
        return baggage.isEmpty() ? null : baggage;
    }

    public List<Product> getAirProducts() {
        return this.airProducts;
    }

    public Map<String, Map<String, RestTravellerData>> getTravellerAirSegmentsData() {
        return this.travellerAirSegmentsData;
    }

    public List<RailwayProduct> getRailProducts() {
        return this.railProducts;
    }

    public Map<String, Map<String, RestRailTravellerData>> getTravellerRailSegmentsData() {
        return this.travellerRailSegmentsData;
    }

    public Map<Reservation, Map<Segment, String>> getReservationAirSegments() {
        return this.reservationAirSegments;
    }

    public Map<String, Map<RailwaySegment, String>> getReservationRailSegments() {
        return this.reservationRailSegments;
    }
}

